<?php
/* -----------------------------------------------------------------------------------------
   $Id: specials.php,v 1.19 2016/06/13 07:14:43 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(specials.php,v 1.47 2003/05/27); www.oscommerce.com 
   (c) 2003	 nextcommerce (specials.php,v 1.12 2003/08/17); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/
include( 'includes/application_top.php');
$sp_yes_get_subcategories_counter = 0;
function sp_yes_get_subcategories(&$categories,$id){
    global $sp_yes_get_subcategories_counter;
    $csql = yes_query(
        "SELECT categories_id, parent_id,categories_status FROM categories WHERE parent_id=:parent_id order by sort_order",
        ['parent_id'=>$id]
    );
    foreach($csql as $row){
        if($sp_yes_get_subcategories_counter > 500){
            continue;
        }
        $sp_yes_get_subcategories_counter++;
        if($row['categories_status'] == 0) {
            continue;
        }
        $categories[] = $row['categories_id'];
        sp_yes_get_subcategories($categories,$row['categories_id']);
    }
}

$smarty = new yesSmarty;
// include boxes
$YesBoxes->load( $smarty, basename(__FILE__) );

require_once(DIR_FS_INC . 'xtc_get_short_description.inc.php');
require_once(DIR_FS_INC . 'yes_get_subcategories.inc.php');
require_once(DIR_FS_INC . 'xtc_get_category_path.inc.php');
require_once(DIR_WS_CLASSES . 'product.php');
require_once(DIR_FS_INC . 'xtc_get_vpe_name.inc.php');
require_once('admin/includes/classes/class.storagequantity.php');
if(!function_exists('xtc_get_manufacturers')){
    require_once(DIR_FS_INC.'xtc_get_manufacturers.inc.php');
}
$languages_id = intval($_SESSION['languages_id']??2);

$breadcrumb->add(NAVBAR_TITLE_SPECIALS, xtc_href_link(FILENAME_SPECIALS));

//fsk18 lock
$fsk_lock='';
if ($_SESSION['customers_status']['customers_fsk18_display']=='0') {
	$fsk_lock=' and p.products_fsk18!=1';
}
if (GROUP_CHECK=='true') {
	$group_check="and p.group_ids LIKE '%c_".$_SESSION['customers_status']['customers_status_id']."_group%'";
}

$from_sql = TABLE_PRODUCTS . " p LEFT JOIN " .
	TABLE_PRODUCTS_DESCRIPTION . " pd USING(products_id), " .
	TABLE_SPECIALS . " s ";

$specials_default_category_query_raw = "SELECT DISTINCT(p.default_category) as dc FROM ".$from_sql;
$specials_query_raw = "select p.products_id,
	pd.products_name,
	pd.products_extra_text,
	p.products_price,
	p.products_fsk18,
	p.products_image,
	s.specials_new_products_price from ".$from_sql;

$category_title_path = '';
$categories_array = array();
$categories_path_title = array();
if(isset($_REQUEST['cPath']) and $_REQUEST['cPath'] != ''){
    $cID = (int)xtc_db_input(current(array_reverse(explode('_',$_REQUEST['cPath']))));
    if($cID > 0){
	$check = yes_query(
            "SELECT categories_status FROM categories WHERE categories_id=:categories_id",
            ['categories_id'=>$cID],
            true
	);
	if(isset($check['categories_status']) and $check['categories_status'] == 1){
	    $categories_array[] = $cID;
	    sp_yes_get_subcategories($path,$cID);
	    foreach($path as $cID){
		$categories_array[] = $cID;
	    }
	    $add_sql = " LEFT JOIN products_to_categories p2c USING(products_id) ";
	    $specials_query_raw .= $add_sql;
	    $specials_default_category_query_raw .= $add_sql;
	}
	$category_path = xtc_get_category_path($cID, $_SESSION['languages_id']);
	$category_path_array = explode('_',$category_path);
	foreach($category_path_array as $cID){
            $cache_key = 'shop.categories-c'.$cID.'-l'.$languages_id;
            $cache_group = 'categories';
            $key = \yescache_helper::cache_key($InstanceCache, $cache_group, $cache_key);

            $CachedString = $InstanceCache->getItem($key); // cache group
            if (!$CachedString->isHit()) {
                $catd = \YES4Trade\Model\categories_description::get_by_categories_id_and_language_id(
                    $cID, $languages_id,
                    ['categories_name']
                );
                $categories_data = [
                    'categories_id'=>intval($cID),
                    'categories_name'=>$catd->categories_name??''
                ];
                $CachedString->set($categories_data)->expiresAfter(YES_CACHE_LIFETIME_LONG); // cat
                $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
            }else{
                $categories_data = $CachedString->get();
            }
            
	    $categories_path_title[] = $categories_data['categories_name'];
	}
	$category_title_path = implode(' &raquo; ',$categories_path_title);
    }
}

$parameters = [];
$where_sql = " where p.products_status = '1'
	and s.products_id = p.products_id ".$fsk_lock."
	".$group_check."
	and pd.language_id = '" . (int)$_SESSION['languages_id'] . "'
	and s.status = '1' ";
if(sizeOf($categories_array)){
    $parameters['categories'] = implode(',',$categories_array);
    $where_sql .= " and p2c.categories_id IN(:categories) ";
}
if(isset($_REQUEST['manufacturers_id']) and $_REQUEST['manufacturers_id'] > 0){
    $parameters['manufacturers_id'] = (int)$_REQUEST['manufacturers_id'];
    $where_sql .= " and p.manufacturers_id=:manufacturers_id ";
}
if(isset($_REQUEST['default_category']) and $_REQUEST['default_category'] > 0){
    $parameters['default_category'] = (int)$_REQUEST['default_category'];
    $where_sql .= " and p.default_category=:default_category";
}
$specials_query_raw .= $where_sql;
$specials_default_category_query_raw .= $where_sql.' and p.default_category > 0';

/**
 * BOF - DEFAULT CATEGORY PATH ARRAY
 */
$default_category_array = array(array('id'=>'','text'=>PULL_DOWN_DEFAULT));
$dc_query = yes_query($specials_default_category_query_raw, $parameters);
foreach($dc_query as $dc_record){
    $categories_path_title = array();
    $category_path = xtc_get_category_path($dc_record['dc'], $_SESSION['languages_id']);
    $category_path_array = explode('_',$category_path);
    foreach($category_path_array as $cID){
        $cache_key = 'shop.categories-c'.$cID.'-l'.$languages_id;
        $cache_group = 'categories';
        $key = \yescache_helper::cache_key($InstanceCache, $cache_group, $cache_key);

        $CachedString = $InstanceCache->getItem($key); // cache group
        if (!$CachedString->isHit()) {
            $catd = \YES4Trade\Model\categories_description::get_by_categories_id_and_language_id(
                intval($cID), $languages_id,
                ['categories_name']
            );
            $categories_data = [
                'categories_id'=>$cID,
                'categories_name'=>$catd->categories_name??''
            ];
            $CachedString->set($categories_data)->expiresAfter(YES_CACHE_LIFETIME_LONG); // cat
            $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
        }else{
            $categories_data = $CachedString->get();
        }
	$categories_path_title[] = $categories_data['categories_name'];
    }
    $category_title_path = implode(' &raquo; ',$categories_path_title);
    $default_category_array[] = array(
	'id'=>$dc_record['dc'],
	'text'=>$category_title_path
    );
}
if(sizeOf($default_category_array)>1){
    $smarty->assign('INPUT_CATEGORIES',  xtc_draw_pull_down_menu('default_category', $default_category_array, ((isset($_REQUEST['default_category']))?(int)xtc_db_input($_REQUEST['default_category']):'' )));
}
/**
 * EOF - DEFAULT CATEGORY PATH ARRAY
 */

$filter = $_REQUEST['usersort'] ?? '';
$userfilter_array = array(
    array('id'=>'','text'=>TEXT_USERFILTER_NONE),
    array('id'=>'products_date_added ASC','text'=>TEXT_USERFILTER_DATE.' '.TEXT_USERFILTER_ASC),
    array('id'=>'products_date_added DESC','text'=>TEXT_USERFILTER_DATE.' '.TEXT_USERFILTER_DESC),
    array('id'=>'products_ordered ASC','text'=>TEXT_USERFILTER_BESTSELLER.' '.TEXT_USERFILTER_ASC),
    array('id'=>'products_ordered DESC','text'=>TEXT_USERFILTER_BESTSELLER.' '.TEXT_USERFILTER_DESC),
    array('id'=>'products_price ASC','text'=>TEXT_USERFILTER_PRICE.' '.TEXT_USERFILTER_ASC),
    array('id'=>'products_price DESC','text'=>TEXT_USERFILTER_PRICE.' '.TEXT_USERFILTER_DESC),
    array('id'=>'pd.products_name ASC','text'=>TEXT_USERFILTER_NAME.' '.TEXT_USERFILTER_ASC),
    array('id'=>'pd.products_name DESC','text'=>TEXT_USERFILTER_NAME.' '.TEXT_USERFILTER_DESC),
);
$exists = in_array($filter, array_column($userfilter_array, 'id'));
if(!$exists){
    $filter = 's.specials_date_added DESC';
}
$smarty->assign('FILTER_DROPDOWN',xtc_draw_pull_down_menu('usersort',$userfilter_array,$filter));
if($filter != ''){
    $specials_query_raw .= "order by ".$filter;
}else{
    $specials_query_raw .= "order by s.specials_date_added DESC";
}
$page = max(1,yes_getIntFromRequest('page') ?? 1);
$specials_split = new splitPageResults($specials_query_raw, $page, MAX_DISPLAY_SPECIAL_PRODUCTS, 'p.products_id',false,$parameters);

// RAUSNEHMEN ERSTMAL - 2016/01/28 mario
//if ($specials_split->number_of_rows==0)
//	xtc_redirect(xtc_href_link(FILENAME_DEFAULT));
require(DIR_WS_INCLUDES . 'header.php');

$module_content=array();
$row = 0;
$specials_query = yes_db_query($specials_split->sql_query,true);
foreach($specials_query as $specials) {
	$row++;
	$product = new product($specials['products_id']);
	$product_info = $product->data;
	$info_array = $product->buildDataArray($product_info);
	$PRODUCTS_VPE = '';
	if ($info_array['PRODUCTS_VPE_STATUS'] == 1 && $info_array['PRODUCTS_VPE_VALUE'] != 0.0){
		$PRODUCTS_VPE = $xtPrice->xtcFormat( ((float)str_replace(',','.',$info_array['PRODUCTS_PRICE_CLEAN'])) * (1 / $info_array['PRODUCTS_VPE_VALUE']), true).TXT_PER.xtc_get_vpe_name($info_array['PRODUCTS_VPE']);
	}

	$products_price = $xtPrice->xtcGetPrice($specials['products_id'],$format=true,1,$info_array['PRODUCTS_TAX_CLASS_ID'],$specials['products_price']);
	$image='';
	if ($specials['products_image']!='') {
            $image=DIR_WS_THUMBNAIL_IMAGES . $specials['products_image'];
	}
	if ($_SESSION['customers_status']['customers_status_show_price'] != '0') {
		if ($_SESSION['customers_status']['customers_fsk18']=='1') {
			if ($specials['products_fsk18']=='0')
				$buy_now=xtc_href_link(basename($PHP_SELF), xtc_get_all_get_params(array('action')) . 'action=buy_now&BUYproducts_id=' . $specials['products_id'], 'NONSSL');
		} else {
			$buy_now=xtc_href_link(basename($PHP_SELF), xtc_get_all_get_params(array('action')) . 'action=buy_now&BUYproducts_id=' . $specials['products_id'], 'NONSSL');
		}
	}
        
	$tax_info = $main->getTaxInfo(xtc_get_tax_rate($info_array['PRODUCTS_TAX_CLASS_ID'],
            yes_get_store_country_id(), yes_get_store_zone_id()
        ));
	$module_content[]=array(
		'INFO'=>$info_array,
		'MANUFACTURER_INFO'=>$product->getManufacturersData(),
		'PRODUCTS_ID' => $specials['products_id'],
		'PRODUCTS_NAME' => $specials['products_name'],
		'PRODUCTS_EXTRA_TEXT' => $specials['products_extra_text'],
		'PRODUCTS_PRICE' => $products_price,
		'PRODUCTS_LINK' => xtc_href_link(FILENAME_PRODUCT_INFO, 'products_id=' . $specials['products_id']),
		'PRODUCTS_TAX_INFO' => $tax_info,
		'PRODUCTS_IMAGE'=> $image,
		'PRODUCTS_ADD_TO_CART_LINK'=>$buy_now,
		'PRODUCTS_SHORT_DESCRIPTION' => xtc_get_short_description($specials['products_id']),
		'PRODUCTS_VPE'=>$PRODUCTS_VPE
	);

}

if (($specials_split->number_of_rows > 0)) {
	$smarty->assign('NAVBAR','
<table border="0" width="100%" cellspacing="0" cellpadding="2">
	<tr>
		<td class="smallText">'.$specials_split->display_count(TEXT_DISPLAY_NUMBER_OF_SPECIALS).'</td>
		<td align="right" class="smallText">'.TEXT_RESULT_PAGE . ' ' . $specials_split->display_links(MAX_DISPLAY_PAGE_LINKS, xtc_get_all_get_params(array('page', 'info', 'x', 'y'))).'</td>
	</tr>
</table>
	');
}
$manufacturers_id = (isset($_REQUEST['manufacturers_id'])) ? (int)xtc_db_input($_REQUEST['manufacturers_id']) : '';
$cPath = (isset($_REQUEST['cPath'])) ? xtc_db_input($_REQUEST['cPath']) : '';
$page = (isset($_REQUEST['page'])) ? max(0,yes_getIntFromRequest('page')):0;
$smarty->assign(array(
    'language' => $_SESSION['language'],
    'CATEGORIES_TITLE_PATH'=>$category_title_path,
    'INPUT_MANUFACTURERS'=>xtc_draw_pull_down_menu('manufacturers_id',xtc_get_manufacturers(),$manufacturers_id),
    'FILTER_FORM'=>xtc_draw_form('specials_filter_form',basename(__FILE__),'GET').
	xtc_draw_hidden_field('cPath',$cPath).
	xtc_draw_hidden_field('page',$page),
    'FORM_END'=>'</form>'
));
$smarty->assign('module_content',$module_content);
$smarty->caching = 0;
$main_content= $smarty->fetch(CURRENT_TEMPLATE.'/module/specials.html');


$smarty->assign('language', $_SESSION['language']);
$smarty->assign('main_content',$main_content);
$smarty->caching = 0;
if (!defined('RM')) {
    $smarty->load_filter('output', 'note');
}
$smarty->display(CURRENT_TEMPLATE . '/index.html');
include ('includes/application_bottom.php');
