<?php
/* paypal_ppp_ajax_requests.php
.---------------------------------------------------------------------------.
|    Software: Papyal-Plus-Module                                           |
|     Version: 0.5beta                                                      |
|        Date: 2015-11-05                                                   |
| Description: handle ajax-request from the paypal-plus module              |
|     Contact: info@andreas-guder.de                                        |
| ------------------------------------------------------------------------- |
|      Author: Andreas Guder                                                |
|     Contact: info@andreas-guder.de                                        |
| Copyright (c) 2015, Andreas Guder.                                        |
| ------------------------------------------------------------------------- |
|     License:  GNU Public License V2.0                                     |
|               http://www.gnu.org/licenses/gpl-2.0.html                    |
'--------------------------------------------------------------------------�'
*/

include('includes/application_top.php');
if (!empty($_GET['ppp_action']) and $_GET['ppp_action'] == 'set_shipping'){
    if (isset($_POST['ppp_state']) and !empty($_SESSION['sendto']) and (!isset($_SESSION['agi_ppp']['express_checkout']) or (isset($_SESSION['agi_ppp']['express_checkout']) and $_SESSION['agi_ppp']['express_checkout'] == false))  ){
        if (!preg_match('/(select|[\+#=\*]+)/',$_POST['ppp_state'])){
            $state = xtc_db_prepare_input($_POST['ppp_state']);
            $parameters = [
                'country'=>(int)$_SESSION['agi_ppp']['ppp_delivery_country'],
                'zone_name'=>$state.'%',
                'zone_code'=>'%'.$state.'%'
            ];
            $zone_query_raw = sprintf(
                "SELECT DISTINCT `zone_id` FROM %s WHERE `zone_country_id` =:country AND (`zone_name` LIKE :zone_name OR `zone_code` LIKE :zone_code)",
                TABLE_ZONES
            );
            $zone_query = yes_query($zone_query_raw, $parameters);
            if (sizeOf($zone_query) == 1) {
                $zone = current($zone_query);
                $upd = new \YES4Trade\Model\address_book([
                    'address_book_id'=>(int)$_SESSION['sendto'],
                    'entry_zone_id'=>$zone['zone_id']
                ]);
                $upd->update();
            }
        }
    }
  
    if (!empty($_POST['shipping'])){
        if (!defined('CHECK_CHEAPEST_SHIPPING_MODUL')) {
            define ('CHECK_CHEAPEST_SHIPPING_MODUL', false); //true, false - default false
        }
        if (isset($_SESSION['allow_checkout']) && $_SESSION['allow_checkout'] == 'false') {
            echo 'PPP Ajax: checkout not allowed';
        }
        if (!isset($_SESSION['agi_ppp']['ppp_patch_address']) || $_SESSION['agi_ppp']['ppp_patch_address'] == false){
            if (!isset ($_SESSION['sendto'])){
                $_SESSION['sendto'] = $_SESSION['customer_default_address_id'];
            } else {
                $anz = \YES4Trade\Model\address_book::count_by_customers_id_and_address_book_id(
                    (int) $_SESSION['customer_id'],(int) $_SESSION['sendto']
                );
                if ($anz != 1) {
                    $_SESSION['sendto'] = $_SESSION['customer_default_address_id'];
                    if (isset ($_SESSION['shipping'])){
                        unset ($_SESSION['shipping']);
                    }
                }
            }
        }
        if (isset($_POST['comments']) && !empty($_POST['comments'])){
            if ($_SESSION['language_charset'] != 'utf-8'){
                $_POST['comments'] = utf8_decode($_POST['comments']);
            }
            $_SESSION['comments'] = xtc_db_prepare_input($_POST['comments']);
        }
        if (!isset($_POST['thrdprty']) || (isset($_POST['thrdprty']) && $_POST['thrdprty'] == 0)){
            $_SESSION['payment'] = 'paypal_ppp';
        }else{
            if ($_SESSION['payment'] == 'paypal_ppp'){
                $_SESSION['payment'] = 'no_payment';
            }
            die('ok');
        }
    
        require_once DIR_WS_CLASSES.'order.php';
        $order = new order();
        if(empty($order->delivery['country']['id'])){
            $order->delivery['country']['id'] = STORE_COUNTRY;
        }
        if(empty($order->delivery['country']['iso_code_2'])){
            $order->delivery['country']['iso_code_2'] = $_SESSION['delivery_zone'];
        }
        if(empty($order->delivery['country_id'])){
            $order->delivery['country_id'] = STORE_COUNTRY;
        }

        //BOF - DokuMan - 2010-08-30 - check for cartID also in checkout_shipping
        // avoid hack attempts during the checkout procedure by checking the internal cartID
        if (isset ($_SESSION['cart']->cartID) && isset ($_SESSION['cartID'])) {
            if ($_SESSION['cart']->cartID !== $_SESSION['cartID']) {
                unset($_SESSION['shipping']);
                unset($_SESSION['payment']);
            }
        }
        //EOF - DokuMan - 2010-08-30 - check for cartID also in checkout_shipping
    
        $total_weight = $_SESSION['cart']->show_weight();
        $total_count = $_SESSION['cart']->count_contents();
    
        // load all enabled shipping modules
        require_once DIR_FS_INC.'xtc_count_shipping_modules.inc.php';
        require_once DIR_WS_CLASSES.'shipping.php';
        include_once DIR_WS_LANGUAGES.$_SESSION['language'].'/modules/order_total/ot_shipping.php';
        require_once DIR_WS_MODULES.'order_total/ot_shipping.php';
        require_once DIR_FS_INC . 'xtc_calculate_tax.inc.php';
        require_once DIR_FS_INC . 'xtc_display_tax_value.inc.php';
        $shipping_modules = new shipping;

        $ot_shipping = new ot_shipping;
        $ot_shipping->process();

        if ((xtc_count_shipping_modules() > 0) || ($free_shipping == true)) {
            $_SESSION['shipping'] = $_POST['shipping'];

            list ($module, $method) = explode('_', $_SESSION['shipping']);
            if ((isset($$module) && is_object($$module) ) || ($_SESSION['shipping'] == 'free_free')){
                if ($_SESSION['shipping'] == 'free_free') {
                    $quote[0]['methods'][0]['title'] = FREE_SHIPPING_TITLE;
                    $quote[0]['methods'][0]['cost'] = '0';
                }else{
                    $quote = $shipping_modules->quote($method, $module);
                }
                if (isset ($quote['error'])){
                    unset ($_SESSION['shipping']);
                    echo 'PPP Ajax: '.$quote['error'];
                }else{
                    if ((isset ($quote[0]['methods'][0]['title'])) && (isset ($quote[0]['methods'][0]['cost']))){
                        $_SESSION['shipping'] = array (
                            'id' => $_SESSION['shipping'], 
                            'title' => (($free_shipping == true) ? $quote[0]['methods'][0]['title'] : $quote[0]['module'].' ('.$quote[0]['methods'][0]['title'].')'), 
                            'cost' => $quote[0]['methods'][0]['cost']
                        );
                    }

                    $order = new order();
                    if(empty($order->delivery['country']['id'])){
                        $order->delivery['country']['id'] = STORE_COUNTRY;
                    }
                    if(empty($order->delivery['country']['iso_code_2'])){
                        $order->delivery['country']['iso_code_2'] = $_SESSION['delivery_zone'];
                    }
                    if(empty($order->delivery['country_id'])){
                        $order->delivery['country_id'] = STORE_COUNTRY;
                    }
                    require_once DIR_WS_CLASSES . 'order_total.php';

                    $order_total_modules = new order_total();
                    $order_total = $order_total_modules->process();
          
                    if ($_SESSION['shipping']['id'] != 'free_free'){
                        $module = substr($_SESSION['shipping']['id'], 0, strpos($_SESSION['shipping']['id'], '_'));
                        if(!isset($GLOBALS[$module]) || !is_object($GLOBALS[$module])){
                            require_once DIR_WS_CLASSES.'shipping.php';
                            $shipping_modules = new shipping;
                            $ot_shipping = new ot_shipping;
                            $ot_shipping->process();
                        }
                    }
          
                    include_once DIR_WS_LANGUAGES . $_SESSION['language'] . '/modules/payment/paypal_ppp.php';
                    require_once DIR_FS_CATALOG.'includes/modules/payment/paypal_ppp.php';
                    $paypal_ppp = new paypal_ppp();
                    // recalculate transaction_amount_data
                    $aTData = $paypal_ppp->get_transaction_data_from_ot_total($order, $order_total);
                    $paymentpatch_amount = $aTData['amount'];

                    $ppp_rest = new PAYPAL_PPP_REST();
                    if (!$ppp_rest){
                      die('Keine Verbindung zu PayPal Plus');
                    }
          
                    $data = array();
                    $data[] = array(
                      'op'    => 'replace',
                      'path'  => '/transactions/0/amount',
                      'value' => $paymentpatch_amount
                    );
                    if (isset($_SESSION['agi_ppp']['ppp_patch_address']) && $_SESSION['agi_ppp']['ppp_patch_address']){
                        if (!isset($_SESSION['agi_ppp']['express_checkout']) || (isset($_SESSION['agi_ppp']['express_checkout']) && $_SESSION['agi_ppp']['express_checkout'] != true)){
                            $_SESSION['agi_ppp']['ppp_patch_address'] = false;
                            $data[] = array(
                                'op'    => 'add',
                                'path'  => '/transactions/0/item_list/shipping_address',
                                'value' => array(
                                  'recipient_name'  => empty($order->delivery['firstname']) ? $order->delivery['lastname'] : $order->delivery['firstname'].' '.$order->delivery['lastname'],
                                  'line1'           => $order->delivery['street_address'],
                                  'city'            => $order->delivery['city'],
                                  'postal_code'     => $order->delivery['postcode'],
                                  'country_code'    => $ppp_rest->get_store_country_code($order->delivery['country_id']),
                                  'state'           => empty($order->delivery['state']) ? '' : $order->delivery['state']
                                )
                            );
                        }
                    }
          
                    $ppp_rest->prepare_request('v1/payments/payment/'.$_SESSION['agi_ppp']['ppp_payment_id'], 'PATCH', $data);
                    $ppp_rest->add_custom_header('Authorization: Bearer '.$ppp_rest->get_api_access_token());
                    $result = $ppp_rest->execute();
          
                    if (is_array($result)){
                        if ((int)$result['info']['http_code'] == 204 || (int)$result['info']['http_code'] == 200){
                            echo 'ok';
                        }elseif((int)$result['info']['http_code'] == 500){
                            print_r($result);
                            print_r($data);
                            print_r($_SESSION);
                        }else{
                            die('PPP Ajax: '.$result['info']['http_code'].': '.$ppp_rest->parse_error_response_body($result['body']));
                        }
                    }else{
                        die('PPP Ajax-Request: not executable');
                    }
                }
            }else {
                echo 'PPP Ajax: Shipping-method not supported';
            }
        } else {
            $_SESSION['shipping'] = false;
            echo 'PPP Ajax: '.ERROR_CHECKOUT_SHIPPING_NO_MODULE;
        }
    }else{
        echo 'PPP Ajax: shipping-method required';
    }
}else{
  echo 'PPP Ajax: method not accepted';
}
