<?php
/**
 * Copyright 2019 Klarna AB
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Update a checkout order.
 */

require_once dirname(__DIR__) . '/../../vendor/autoload.php';

/**
 * Follow the link to get your credentials: https://github.com/klarna/kco_rest_php/#api-credentials
 *
 * Make sure that your credentials belong to the right endpoint. If you have credentials for the US Playground,
 * such credentials will not work for the EU Playground and you will get 401 Unauthorized exception.
 */
$merchantId = getenv('USERNAME') ?: 'K123456_abcd12345';
$sharedSecret = getenv('PASSWORD') ?: 'sharedSecret';
$orderId = getenv('ORDER_ID') ?: '12345';

/*
EU_BASE_URL = 'https://api.klarna.com'
EU_TEST_BASE_URL = 'https://api.playground.klarna.com'
NA_BASE_URL = 'https://api-na.klarna.com'
NA_TEST_BASE_URL = 'https://api-na.playground.klarna.com'
*/
$apiEndpoint = Klarna\Rest\Transport\ConnectorInterface::EU_TEST_BASE_URL;

$connector = Klarna\Rest\Transport\Connector::create(
    $merchantId,
    $sharedSecret,
    $apiEndpoint
);

$updatedOrder = [
    "order_amount" => 11000,
    "order_tax_amount" => 2200,
    "order_lines" => [
        [
            "type" => "physical",
            "reference" => "123050",
            "name" => "Tomatoes",
            "quantity" => 10,
            "quantity_unit" => "kg",
            "unit_price" => 600,
            "tax_rate" => 2500,
            "total_amount" => 6000,
            "total_tax_amount" => 1200
        ],
        [
            "type" => "physical",
            "reference" => "543670",
            "name" => "Bananas",
            "quantity" => 1,
            "quantity_unit" => "bag",
            "unit_price" => 5000,
            "tax_rate" => 2500,
            "total_amount" => 4000,
            "total_discount_amount" => 1000,
            "total_tax_amount" => 800
        ],
        [
            "type" => "shipping_fee",
            "name" => "Express delivery",
            "quantity" => 1,
            "unit_price" => 1000,
            "tax_rate" => 2500,
            "total_amount" => 1000,
            "total_tax_amount" => 200
        ]
    ]
];

try {
    $checkout = new Klarna\Rest\Checkout\Order($connector, $orderId);
    $checkout->update($updatedOrder);

    // Get some data if needed
    echo <<<ORDER
    Order has been successfully updated

             OrderID: $checkout[order_id]
    New Order Amount: $checkout[order_amount]
       New Order Tax: $checkout[order_tax_amount]
ORDER;

} catch (Exception $e) {
    echo 'Caught exception: ' . $e->getMessage() . "\n";
}
