<?php
/* -----------------------------------------------------------------------------------------
   $Id: write_customers_status.php,v 1.22 2013/08/16 06:01:40 cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2003	 nextcommerce (write_customers_status.php,v 1.8 2003/08/1); www.nextcommerce.org
   
   Released under the GNU General Public License
   --------------------------------------------------------------------------------------- 
   
   based on Third Party contribution:
   Customers Status v3.x  (c) 2002-2003 Copyright Elari elari@free.fr | www.unlockgsm.com/dload-osc/ | CVS : http://cvs.sourceforge.net/cgi-bin/viewcvs.cgi/elari/?sortby=date#dirlist

   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/

// write customers status in session
if(!function_exists('xtc_get_customers_statuses')){
    require_once(DIR_FS_INC.'xtc_get_customers_statuses.inc.php');
}

$cs_array = xtc_get_customers_statuses();
$status = [];

if (isset($_SESSION['customer_id'])) {
    $cust = \YES4Trade\Model\customers::get_by_customers_id($_SESSION['customer_id'],[
        'customers_status'
    ]);
    foreach($cs_array as $cs){
        if(!sizeOf($cs)){
            continue;
        }
        if(intval($cs['id']) == intval($cust->customers_status)){
            $status = $cs;
        }
    }
} else {
    if(!defined('DEFAULT_CUSTOMERS_STATUS_ID_GUEST') or intval(constant('DEFAULT_CUSTOMERS_STATUS_ID_GUEST')) < 1){
        throw new Exception('Please configure DEFAULT_CUSTOMERS_STATUS_ID_GUEST');
    }
    foreach($cs_array as $cs){
        if(intval($cs['id']) == intval(constant('DEFAULT_CUSTOMERS_STATUS_ID_GUEST'))){
            $status = $cs;
        }
    }
}
$_SESSION['customers_status']= array(
    'customers_status_id' => $status['id'],
    'customers_status_name' => $status['text'],
    'customers_status_image' => $status['csa_image'],
    'customers_status_public' => $status['csa_public'],
    'customers_status_discount' => $status['csa_discount'],
    'customers_status_ot_discount_flag' => $status['csa_ot_discount_flag'],
    'customers_status_ot_discount' => $status['csa_ot_discount'],
    'customers_status_graduated_prices' => $status['csa_graduated_prices'],
    'customers_status_show_price' => $status['csa_show_price'],
    'customers_status_show_price_tax' => $status['csa_show_price_tax'],
    'customers_status_add_tax_ot' => $status['csa_add_tax_ot'],
    'customers_status_payment_unallowed' => $status['csa_payment_unallowed'],
    'customers_status_shipping_unallowed' => $status['csa_shipping_unallowed'],
    'customers_status_discount_attributes' => $status['csa_discount_attributes'],
    'customers_fsk18' => $status['customers_fsk18'],
    'customers_fsk18_display' => $status['customers_fsk18_display']
);
