<?php
function smarty_function_yes_draw_shipping_item_additional_params($params, &$smarty){
    $html = array();
    if($params['shipping_configuration']['versender'] == 'DHL'){
        $dhl_vars = $smarty->getConfigVars();
        if($params['shipping_configuration']['additional_params'] != ''){
            $arr = (array)json_decode($params['shipping_configuration']['additional_params']);
            $teilnahme_conf = (array)json_decode(MODULE_SHIPPING_DHLGKAPI_TEILNAHME);
            
            $check_product_id = $arr['product'];
            foreach($teilnahme_conf as $tc_id=>$tc){
                if(substr($tc,0,-4) == $arr['product']){
                    $from_saved_shipping = true;
                    $check_product_id = $tc_id;
                }
            }
            $title = $check_product_id;
            $name = $title;
            foreach(DHL_Paket_DE_Versenden_REST_API::PRODUKTE as $p){
                if($p['id'] == $check_product_id){
                    $title = $p['description'];
                    $name = $p['SHORT_TITLE'];
                    break;
                }
            }
            $html[] = sprintf('<div class="additional_parameter_value" title="%s"><b>%s:</b> %s</div>',
                    $title,'Produkt',$name.' ('.$teilnahme_conf[ $check_product_id ].')'
            );
            foreach($arr['services'] as $k=>$v){
                switch(gettype($v)){
                    case 'object':
                        $value = YES;
                        break;
                    case 'boolean':
                        $value = ($v === true)?YES:NO;
                        break;
                    default:
                        $value = $v;
                        break;
                }
                $key = (isset($dhl_vars[$k]))?$dhl_vars[$k]:$k;
                $html[] = sprintf('<div class="additional_parameter_value">%s: %s</div>',
                        $key,$value
                );
            }
        }
    }else{
        $configurations = explode('|',$params['shipping_configuration']['additional_params']);
        foreach($configurations as $configuration){
            $configuration_parts = explode('::',$configuration);
            $html[] = sprintf('<div class="additional_parameter_value"><b>%s:</b> %s</div>',
                    $configuration_parts[0],$configuration_parts[1]
            );
        }
    }
    return implode('',$html);
}
