<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                              Author M. ASPELEITER <dazze@gmx.de
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/

class staffel extends shipping_default_class {
    var $code, $title, $description, $icon, $enabled,$group_id;

    function __construct() {
        global $order;

        $this->code = 'staffel';
        $this->title = MODULE_SHIPPING_STAFFEL_TEXT_TITLE;
        $this->description = MODULE_SHIPPING_STAFFEL_TEXT_DESCRIPTION;
        $this->sort_order = (defined('MODULE_SHIPPING_STAFFEL_SORT_ORDER'))?MODULE_SHIPPING_STAFFEL_SORT_ORDER:0;
        $this->icon = '';
        $this->tax_class = (defined('MODULE_SHIPPING_STAFFEL_TAX_CLASS')) ? MODULE_SHIPPING_STAFFEL_TAX_CLASS : 0;
        $this->enabled = ((defined('MODULE_SHIPPING_STAFFEL_STATUS') and MODULE_SHIPPING_STAFFEL_STATUS == 'True') ? true : false);

        if ( ($this->enabled == true) ) {
            $check_flag = false;
	
            $grid_query = xtc_db_query("SELECT shipping_graduation_groups_id FROM shipping_graduation_countries WHERE country_id='".$order->delivery['country']['id']."'");
            if(xtc_db_num_rows($grid_query) and xtc_db_num_rows($grid_query)>0){
		$grid_res = xtc_db_fetch_array($grid_query);
		$grID = $grid_res['shipping_graduation_groups_id'];
		if($grID < 1){
                    $grid_query = xtc_db_query("SELECT shipping_graduation_groups_id FROM shipping_graduation_countries  ORDER BY shipping_graduation_groups_id LIMIT 1");
                    $grid_res = xtc_db_fetch_array($grid_query);
                    $grID = $grid_res['shipping_graduation_groups_id'];
		}
		$this->group_id = $grID;
		$check_flag = true;
            }
	
            if ($check_flag == false) {
                $this->enabled = false;
            }
        }
    }


    function quote($method = '') {
        global $order,$gesamt;
      
        $this->quotes = array('id' => $this->code,
            'module' => MODULE_SHIPPING_STAFFEL_TEXT_TITLE,
            'methods' => array(array('id' => $this->code,
                'title' => MODULE_SHIPPING_STAFFEL_TEXT_WAY,
                'cost' => (int)$gesamt
            ))
        );

        if(in_array('get_shipping_tax_class',get_class_methods('order'))){
            $tax_class_id = $order->get_shipping_tax_class();
        }else{
            $tax_class_id = $this->get_shipping_tax_class($order);
        }
        if ($tax_class_id > 0) {
            $country_id = $order->delivery['country_id'];
            $zone_id = $order->delivery['zone_id'];
            $this->quotes['tax'] = xtc_get_tax_rate($tax_class_id, $country_id, $zone_id);
        }

        if (xtc_not_null($this->icon)){
            $this->quotes['icon'] = xtc_image($this->icon, $this->title);
        }
        return $this->quotes;
    }

    function check() {
        if (!isset($this->_check)) {
            $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_SHIPPING_STAFFEL_STATUS'");
            $this->_check = xtc_db_num_rows($check_query);
        }
        return $this->_check;
    }

    function install() {
      /*
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_SHIPPING_FLAT_STATUS', 'True', '6', '0', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_FLAT_ALLOWED', '', '6', '0', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_FLAT_COST', '5.00', '6', '0', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, use_function, set_function, date_added) values ('MODULE_SHIPPING_FLAT_TAX_CLASS', '0', '6', '0', 'xtc_get_tax_class_title', 'xtc_cfg_pull_down_tax_classes(', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, use_function, set_function, date_added) values ('MODULE_SHIPPING_FLAT_ZONE', '0', '6', '0', 'xtc_get_zone_class_title', 'xtc_cfg_pull_down_zone_classes(', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_FLAT_SORT_ORDER', '0', '6', '0', now())");
      */
    }

    function remove() {
        xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_SHIPPING_STAFFEL_STATUS', 'MODULE_SHIPPING_STAFFEL_COST','MODULE_SHIPPING_STAFFEL_ALLOWED', 'MODULE_SHIPPING_STAFFEL_TAX_CLASS', 'MODULE_SHIPPING_STAFFEL_SORT_ORDER');
    }
}
