<?php
/* -----------------------------------------------------------------------------------------
   $Id: products_in_category.php,v 1.40 2019/06/17 07:16:12 re511548 Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(new_products.php,v 1.33 2003/02/12); www.oscommerce.com
   (c) 2003	 nextcommerce (new_products.php,v 1.9 2003/08/17); www.nextcommerce.org

   Released under the GNU General Public License 
   -----------------------------------------------------------------------------------------
   Third Party contributions:
   Enable_Disable_Categories 1.3        	Autor: Mikel Williams | mikel@ladykatcostumes.com

   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/

$module_smarty= new yesSmarty;
$module_smarty->assign('tpl_path','templates/'.CURRENT_TEMPLATE.'/');
require_once(DIR_FS_INC . 'xtc_get_products_name.inc.php');
require_once(DIR_FS_INC . 'xtc_get_short_description.inc.php');
require_once(DIR_FS_INC . 'xtc_image_button.inc.php');
require_once(DIR_FS_INC . 'xtc_collis.inc.php');
require_once(DIR_FS_INC . 'yes_get_subcategories.inc.php');
require_once(DIR_FS_INC . 'xtc_get_category_path.inc.php');
require_once('admin/includes/classes/class.storagequantity.php');
if(!function_exists('xtc_get_manufacturers')){
    require_once(DIR_FS_INC.'xtc_get_manufacturers.inc.php');
}
$userfilter_array = array(
	array('id'=>'','text'=>TEXT_USERFILTER_NONE),
	array('id'=>'products_date_added ASC','text'=>TEXT_USERFILTER_DATE.' '.TEXT_USERFILTER_ASC),
	array('id'=>'products_date_added DESC','text'=>TEXT_USERFILTER_DATE.' '.TEXT_USERFILTER_DESC),
	array('id'=>'products_ordered ASC','text'=>TEXT_USERFILTER_BESTSELLER.' '.TEXT_USERFILTER_ASC),
	array('id'=>'products_ordered DESC','text'=>TEXT_USERFILTER_BESTSELLER.' '.TEXT_USERFILTER_DESC),
	array('id'=>'products_price ASC','text'=>TEXT_USERFILTER_PRICE.' '.TEXT_USERFILTER_ASC),
	array('id'=>'products_price DESC','text'=>TEXT_USERFILTER_PRICE.' '.TEXT_USERFILTER_DESC),
	array('id'=>'pd.products_name ASC','text'=>TEXT_USERFILTER_NAME.' '.TEXT_USERFILTER_ASC),
	array('id'=>'pd.products_name DESC','text'=>TEXT_USERFILTER_NAME.' '.TEXT_USERFILTER_DESC),
);
  //fsk18 lock
$fsk_lock='';
if ($_SESSION['customers_status']['customers_fsk18_display']=='0') {
    $fsk_lock=' and p.products_fsk18!=1';
}
if (GROUP_CHECK=='true') {
    $group_check="and p.group_ids LIKE '%c_".$_SESSION['customers_status']['customers_status_id']."_group%'";
}
  
class recursion
{
    var $categories_array;
    function buildCATTree($catID){
	$query_raw = "SELECT categories_id FROM categories WHERE parent_id=:parent_id AND categories_status=1";
	$visible_child_categories_query = yes_query( $query_raw,
            ['parent_id'=>(int)$catID]
        );
	if(sizeOf($visible_child_categories_query)){
		foreach($visible_child_categories_query as $visible_child_categories){
			$childcatID = $visible_child_categories['categories_id'];
                        $this->categories_array[] = $childcatID;
			$this->buildCATTree($childcatID);
		}
	}
    }
}
$parameters = [
    'language_id'=>(int)$_SESSION['languages_id']
];
$RC = new recursion;
$RC->buildCATTree($new_products_category_id);

if( is_countable($RC->categories_array) and sizeOf( $RC->categories_array ) ){
      $categories_sql_params = implode(',',$RC->categories_array);
      $categories_sql = ' AND p2c.categories_id IN(:cat_filter) ';
      $parameters['cat_filter'] = $categories_sql_params;
}else{
    if(!empty($new_products_category_id)){
        $parameters['cat_filter'] = $new_products_category_id;
        $categories_sql = ' AND ( p2c.categories_id=:cat_filter) ';
    }
}
$page = (isset($_GET['page'])) ? max(0,yes_getIntFromRequest('page')) : 0;
$manufacturers_id = intval($_REQUEST['manufacturers_id'] ?? 0);
if($manufacturers_id > 0){
    $parameters['manufacturers_id'] = $manufacturers_id;
}
$listing_sql = "select distinct p.products_id";
$listing_sql_default_categories = "select distinct p.default_category as dc";
$rest_sql = " from " . TABLE_PRODUCTS . " p left join ".TABLE_PRODUCTS_DESCRIPTION." pd using(products_id) left join ".
    TABLE_PRODUCTS_TO_CATEGORIES . " p2c using(products_id), " . TABLE_CATEGORIES . " c
    where c.categories_status='1'
    and p2c.categories_id = c.categories_id
    ".$group_check."
    ".$fsk_lock."
    ".$categories_sql."
    and p.products_status = '1' and products_listing_status='1' 
    and pd.language_id=:language_id ".
    ((defined('PRODUCTS_LISTING_NO_SLAVES') and PRODUCTS_LISTING_NO_SLAVES == 'True') ? ' and p.products_master=0 ' : ''.
    (($manufacturers_id>0)?" and p.manufacturers_id=:manufacturers_id":'')
);
$default_sort = 'products_date_added DESC';
if(defined('PRODUCTS_IN_CATEGORY_DEFAULT_SORT_KEY') and PRODUCTS_IN_CATEGORY_DEFAULT_SORT_KEY != ''){
    $default_sort = PRODUCTS_IN_CATEGORY_DEFAULT_SORT_KEY;
    if(strtolower($default_sort) == 'rand'){
        $default_sort = 'RAND()';
    }
}
$filter = $_REQUEST['usersort'] ?? $default_sort;

$listing_sql .= $rest_sql;
$listing_sql_default_categories .= $rest_sql.' and p.default_category>0';
if($filter != ''){
    $exists = in_array($filter, array_column($userfilter_array, 'id'));
    if(!$exists){
        $filter = $default_sort;
    }
    $listing_sql .= " order by ".$filter;
}
$listing_split = new splitPageResults($listing_sql, $page, MAX_DISPLAY_SEARCH_RESULTS,'p.products_id',true,$parameters);
try{
    $listing_query = yes_query($listing_split->sql_query,$parameters);
}catch(Exception $e){
    yes_mail_debug($e->getMessage()."\n\n\n".print_r($_GET,true),false,'Hack Versuch');
    $listing_query = [];
}
$row = 0;
$module_content = array();





if(sizeOf($listing_query)){
    foreach($listing_query as $products_in_category) {
		  $product = new product($products_in_category['products_id']);
                  // in diesem Listing keine XY Preise abfragen und generell
                  // keine preise/bestaende/steuersachen
                  // performance probleme
                  // der letzte parameter true bewirkt, das nur geprueft wird ob der artikel xy preise hat
                  $xy = \YES4Trade\Model\product_properties_xy_prices::get_from_products_id($products_in_category['products_id'], true);
                  if($xy !== false){
                    $product_info = $product->buildDataArrayDesc($product->data,'thumbnail');
                  }else{
                    $product_info = $product->buildDataArray($product->data,'thumbnail');
                  }
		  $info_array = $product_info;
		  $SQ = new products_quantity($products_in_category['products_id']);
		  if ($_SESSION['customers_status']['customers_status_show_price']!='0') {
		    $module_content[]=array(
			'INFO'=>$info_array,
			'MANUFACTURER_INFO'=>$product->getManufacturersData(),
			'PRODUCTS_NAME' => $product_info['PRODUCTS_NAME'],
			'PRODUCTS_ID'=>$products_in_category['products_id'],
			'PRODUCTS_DESCRIPTION' => $product_info['PRODUCTS_SHORT_DESCRIPTION'],
			'PRODUCTS_EXTRA_TEXT' => $product_info['PRODUCTS_EXTRA_TEXT'],
			'PRODUCTS_PRICE' => $product_info['PRODUCTS_PRICE'],
			'PRODUCTS_LINK' => xtc_href_link(FILENAME_PRODUCT_INFO, 'products_id=' . $products_in_category['products_id']),
			'PRODUCTS_IMAGE' => $product_info['PRODUCTS_IMAGE'],
			'PRODUCTS_TAX_VALUE'=>$product_info['PRODUCTS_TAX_RATE'],
			'PRODUCTS_TAX_INFO'=>$product_info['PRODUCTS_TAX_INFO'],
			'BUTTON_BUY_NOW'=>$product_info['PRODUCTS_BUTTON_BUY_NOW'],
			'DESCRIPTION'=>$product_info['PRODUCTS_DESCRIPTION'],
			'VERFUEGBARER_BESTAND1'=>$SQ->get_available1_qty()
		    );
		  } else {
		    $module_content[]=array(
			'INFO'=>$info_array,
			'PRODUCTS_NAME' => $product_info['PRODUCTS_NAME'],
			'PRODUCTS_ID'=>$products_in_category['products_id'],
			'PRODUCTS_DESCRIPTION' => $product_info['PRODUCTS_SHORT_DESCRIPTION'],
			'PRODUCTS_EXTRA_TEXT' => $product_info['PRODUCTS_EXTRA_TEXT'],
			'PRODUCTS_PRICE' => $product_info['PRODUCTS_PRICE'],
			'PRODUCTS_LINK' => xtc_href_link(FILENAME_PRODUCT_INFO, 'products_id=' . $products_in_category['products_id']),
			'PRODUCTS_TAX_VALUE'=>$product_info['PRODUCTS_TAX_RATE'],
			'PRODUCTS_TAX_INFO'=>$product_info['PRODUCTS_TAX_INFO'],
			'PRODUCTS_IMAGE' => $product_info['PRODUCTS_IMAGE'],
			'DESCRIPTION'=>$product_info['PRODUCTS_DESCRIPTION'],
			'VERFUEGBARER_BESTAND1'=>$SQ->get_available1_qty()
		    );
		}
		$row ++;
    }
}
/**
 * BOF - DEFAULT CATEGORY PATH ARRAY
 */
$default_category_array = array(array('id'=>'','text'=>PULL_DOWN_DEFAULT));
$dc_query = yes_query($listing_sql_default_categories,$parameters);
foreach($dc_query as $dc_record){
    $categories_path_title = array();
    $category_path = xtc_get_category_path($dc_record['dc'], $_SESSION['languages_id']);
    $category_path_array = explode('_',$category_path);
    foreach($category_path_array as $cID){
        $categories_name = '';
        $cd = \YES4Trade\Model\categories_description::get_by_categories_id_and_language_id(
                (int)$cID,intval($_SESSION['languages_id']??2),[
                    'categories_name'
                ]
        );
        if($cd !== null){
            $categories_name = $cd->categories_name;
        }
	$categories_path_title[] = $categories_name;
    }
    $category_title_path = implode(' &raquo; ',$categories_path_title);
    $default_category_array[] = array(
	'id'=>$dc_record['dc'],
	'text'=>$category_title_path
    );
}
if(sizeOf($default_category_array)>1){
    $module_smarty->assign('INPUT_CATEGORIES',  xtc_draw_pull_down_menu('default_category', $default_category_array, ((isset($_REQUEST['default_category']))?(int)xtc_db_input($_REQUEST['default_category']):'' )));
}
/**
 * EOF - DEFAULT CATEGORY PATH ARRAY
 */

$module_smarty->assign(array(
    'FILTER_FORM'=>xtc_draw_form('products_in_category_form','index.php','','GET').
	xtc_draw_hidden_field('page',$page).
	xtc_draw_hidden_field('cPath',$cPath),
    'MANUFACTURERS_DROPDOWN'=>xtc_draw_pull_down_menu('manufacturers_id',array_merge(array(array('id'=>'','text'=>PULL_DOWN_DEFAULT)),xtc_get_manufacturers()),$manufacturers_id),
    'FORM_END'=>'</form>',
    'NAVIGATION_COUNT'=>$listing_split->display_count(TEXT_DISPLAY_NUMBER_OF_PRODUCTS),
    'NAVIGATION_LINKS'=>TEXT_RESULT_PAGE . ' ' . $listing_split->display_links(MAX_DISPLAY_PAGE_LINKS, xtc_get_all_get_params(array('page', 'info', 'x', 'y'))),
    'FILTER_DROPDOWN'=>xtc_draw_pull_down_menu('usersort',$userfilter_array,$filter)
));
if (sizeof($module_content)>=1){
	$module_smarty->assign(array(
	    'CATEGORIES_ID'=>$new_products_category_id,
	    'language'=>$_SESSION['language'],
	    'module_content'=>$module_content,
	));
  	// set cache ID
  	if (USE_CACHE=='false') {
  		$module_smarty->caching = 0;
  		try{
			$module= $module_smarty->fetch(CURRENT_TEMPLATE.'/module/products_in_category.html');
		}catch(Exception $e){
			echo $e->getMessage();
		}
  	} else {
  		$module_smarty->caching = 1;
  		$module_smarty->cache_lifetime=CACHE_LIFETIME;
  		$module_smarty->cache_modified_check=CACHE_CHECK;
  		$cache_id = $new_products_category_id.$_SESSION['language'].$_SESSION['customers_status']['customers_status_name'].$_SESSION['currency'].$_REQUEST['usersort'];
  		try{
			$module= $module_smarty->fetch(CURRENT_TEMPLATE.'/module/products_in_category.html',$cache_id);
		}catch(Exception $e){
			echo $e->getMessage();
		}
	}
	if($default_smarty)
		$default_smarty->assign('MODULE_products_in_category',$module);
	else
		$smarty->assign('MODULE_products_in_category',$module);
}

