<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of yes_tags
 *
 * @author mario
 */
class yes_tags {
    const TAGS_TABLE = 'tags';
    const TAGS_PRODUCTS_TABLE = 'tags_products';
    var $type;
    var $debug = false;
	    
    function __construct( $target = 'product' ){
	$this->type = $target;
    }
    public function get_tags_id($tag){
	$query_raw = sprintf(
            "SELECT tags_id FROM %s WHERE BINARY tag=:tag AND type=:type",
            self::TAGS_TABLE
	);
	$this->debug(sprintf('get_tags_id (%s): %s',$_REQUEST['action'],$query_raw));
	$query = yes_query($query_raw,[
            'tag'=>$tag,
            'type'=>$this->type
        ]);
	if(!sizeOf($query)){
	    return 0;
        }
	$record = current($query);
	return $record['tags_id'];
    }
    
    public function create_tag($tag){
	$this->debug(sprintf('create_tag (%s): %s',$_REQUEST['action'],$tag));
        $tag = yes_decode_string(xtc_db_prepare_input($tag));
	$insert_sql_array = array(
	    'tag'=>$tag,
	    'editor_id'=>(int)$_SESSION['customer_id'],
	    'date_added'=>'now()',
	    'type'=>$this->type
	);
	yes_db_perform(self::TAGS_TABLE,$insert_sql_array);
	return xtc_db_insert_id();
    }
    
    public function get_available_tag_list(){
	$array = array();
	$query = yes_query(sprintf(
            "SELECT tag FROM %s WHERE type=:type",
		self::TAGS_TABLE
            ),['type'=>$this->type]
        );
	foreach($query as $record){
            $tag = yes_encode_string($record['tag']);
	    $array[] = $tag;
	}
	return $array;
    }
    
    public function get_tag_list( $id ){
	$where_key = $this->get_where_key();
	$array = array();
	$query = yes_query(sprintf(
            "SELECT tag FROM %s t LEFT JOIN %s tp USING(tags_id) WHERE type=:type AND %s=:id",
		self::TAGS_TABLE,$this->get_allocation_table(),$where_key
            ),['type'=>$this->type,'id'=>$id]
        );
	foreach($query as $record){
            $tag = yes_encode_string($record['tag']);
	    $array[] = $tag;
	}
	return $array;
    }
    
    public function allocate($tags_id,$id){
	$this->debug(sprintf('allocate (%s): tags_id %s for pID %s',$_REQUEST['action'],$tags_id,$id));
	$insert_sql_array = array(
	    'tags_id'=>$tags_id,
	    $this->get_where_key() => $id
	);
	yes_db_perform($this->get_allocation_table(),$insert_sql_array);
    }
    
    public function unallocate($tag,$id){
	$this->debug(sprintf('unallocate (%s): Tag %s for pID %s',$_REQUEST['action'],$tag,$id));
	$tags_id = $this->get_tags_id($tag);
	yes_query(sprintf(
            "DELETE FROM %s WHERE %s=:id AND tags_id=:tag_id",
		$this->get_allocation_table(),$this->get_where_key()
            ),['id'=>$id,'tag_id'=>$tags_id]
        );
	if($this->get_tags_allocations_num($tags_id) == 0){
	    $this->delete_tag($tags_id);
	}
    }

    private function delete_tag($tags_id){
	yes_query(sprintf(
            "DELETE FROM %s WHERE tags_id=:tag_id",
		self::TAGS_TABLE
            ),['tag_id'=>$tags_id]
        );
    }
    
    private function get_tags_allocations_num($tags_id){
	$query_raw = sprintf(
            "SELECT %s FROM %s WHERE tags_id=:tag_id",
		$this->get_where_key(),$this->get_allocation_table()
        );
	$this->debug(sprintf('get_tags_allocation_num (%s): %s',$_REQUEST['action'],$query_raw));
	$query = yes_query($query_raw,[
            'tag_id'=>$tags_id]
        );
	return sizeOf($query);
    }
    private function get_where_key(){
	switch($this->type){
	    case 'product':
		return 'products_id';
		break;
	}
    }
    private function get_allocation_table(){
	switch($this->type){
	    case 'product':
		return self::TAGS_PRODUCTS_TABLE;
		break;
	}
    }
    
    public function update_list($pID,$submitted){
		$assigned_tags = $this->get_tag_list($pID);
		// NEUE TAGS EINFUEGEN UND ZUWEISEN
		foreach($submitted as $tag){
			//$tag = utf8_decode($tag);
			if(in_array($tag,$assigned_tags)){
			// tag-zuweisung existiert
			$this->debug(
				sprintf('update_list (%s): %s (CS: %s) in %s',$_REQUEST['action'],$tag,  mb_detect_encoding($tag),implode(', ',$assigned_tags))
			);
			continue;
			}
			$this->debug(
				sprintf('update_list (%s): %s (CS: %s) not in %s',$_REQUEST['action'],$tag,  mb_detect_encoding($tag),implode(', ',$assigned_tags))
			);
			$tags_id = $this->get_tags_id($tag);
			if($tags_id == 0){
				$tags_id = $this->create_tag($tag);
			}
			$this->allocate($tags_id,$pID);
		}
		// ENTFERNTE TAGS VERARBEITEN
		foreach($assigned_tags as $astag){
	    	//$astag = utf8_encode($astag);
	    	if(!is_countable($submitted) or !in_array($astag,$submitted)){
				$this->debug(
					sprintf('update_list (%s) UNALLOCATE: %s (CS: %s) not in %s',$_REQUEST['action'],$astag,  mb_detect_encoding($astag),
						(is_countable($submitted)) ? implode(', ',$submitted) : ''
					)
				);
            	$astag = yes_decode_string($astag);
				$this->unallocate($astag,$pID);
	    	}
		}
    }
    
    private function debug($str){
	if(!$this->debug){
	    return true;
	}
	$logfile = \main::get_importdata_path().'YES_TAGS.log';
	if(!is_file($logfile)){
	    touch($logfile);
	}
	$current = file_get_contents($logfile);
	$current .= date('ymd H:i:s').' '.$str."\r\n";
	file_put_contents($logfile,$current);
    }
}

