<?php
/**
 * PrepaidItemsApiTest
 * PHP version 5
 *
 * @category Class
 * @package  Secuconnect\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Secuconnect API
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2.0.0
 *
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Please update the test case below to test the endpoint.
 */

namespace Secuconnect\Client\Api;

use PHPUnit\Framework\TestCase;
use Secuconnect\Client\ApiException;
use Secuconnect\Client\Model\PrepaidItemsList;
use Secuconnect\Client\Model\PrepaidItemsProductModel;

/**
 * PrepaidItemsApiTest Class Doc Comment
 *
 * @category Class
 * @package  Secuconnect\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class PrepaidItemsApiTest extends TestCase
{
    /**
     * @var PrepaidItemsApi
     */
    private static $api;

    /**
     * @var SecuconnectObjects
     */
    private static $secuconnectObjects;

    /**
     * @var PrepaidItemsList
     */
    private static $prepaidItemsList;

    /**
     * Setup before running any test cases
     * @throws ApiException
     */
    public static function setUpBeforeClass(): void
    {
        parent::setUpBeforeClass();
        self::$secuconnectObjects = SecuconnectObjects::getInstance();
        self::$secuconnectObjects->authenticateByApplicationUser();
        self::$api = new PrepaidItemsApi();
    }

    /**
     * Test case for getAll
     *
     * GET Prepaid/Items.
     *
     * @throws ApiException
     */
    public function testGetAll()
    {
        try {
            $response = self::$api->getAll();
        } catch (ApiException $e) {
            print_r($e->getResponseBody());
            throw $e;
        }

        self::assertNotNull($response);
        self::assertNotEmpty($response);
        self::assertInstanceOf(PrepaidItemsList::class, $response);

        foreach ($response->getData() as $item) {
            self::assertInstanceOf(PrepaidItemsProductModel::class, $item);
            self::assertEquals("prepaid.items", $item->getObject());
            self::assertNotNull($item->getId());
            self::assertNotEmpty($item->getId());
        }

        //save this list for future tests
        self::$prepaidItemsList = $response;
    }

    /**
     * Test case for getOne
     *
     * GET Prepaid/Items/{prepaidItemId}.
     *
     * @throws ApiException
     */
    public function testGetOne()
    {
        try {
            $response = self::$api->getOne(self::$prepaidItemsList->getData()[0]->getId());
        } catch (ApiException $e) {
            print_r($e->getResponseBody());
            throw $e;
        }

        self::assertInstanceOf(PrepaidItemsProductModel::class, $response);
        self::assertEquals("prepaid.items", $response->getObject());
        self::assertNotNull($response->getId());
        self::assertNotEmpty($response->getId());
    }
}
