<?php
/* -----------------------------------------------------------------------------------------
   $Id: split_page_results2.php,v 1.1 2014/05/14 15:00:37 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(split_page_results.php,v 1.14 2003/05/27); www.oscommerce.com 
   (c) 2003	 nextcommerce (split_page_results.php,v 1.6 2003/08/13); www.nextcommerce.org

   Released under the GNU General Public License 
   -----------------------------------------------------------------------------------------
   06.2007 k.koch 4 imedes.de
   ---------------------------------------------------------------------------------------*/

  // works like splitPageResults but with Resultarray instead of sql-queries
  class splitPageResults2 extends splitPageResults{
    var $data_array_part, $data_array;

    // class constructor
    function __construct($data_array, $page, $max_rows, $count_key = '*') {
      $this->data_array = $data_array;

      if (empty($page) or (is_numeric($page) == false) or $page < 1) {
        $page = 1;
      }
      $this->current_page_number = $page;

      $this->number_of_rows_per_page = $max_rows;

      $count = (is_countable($data_array)) ? sizeof($data_array) : 0;

      $this->number_of_rows = $count;
      $this->number_of_pages = ceil($this->number_of_rows / $this->number_of_rows_per_page);

      if ($this->current_page_number > $this->number_of_pages) {
        $this->current_page_number = $this->number_of_pages;
      }

      $offset = ($this->number_of_rows_per_page * ($this->current_page_number - 1));
      $this->data_array_part = array_slice($this->data_array, $offset, $this->number_of_rows_per_page);
    }

    // class functions


    // display number of total products found
    function display_count($text_output) {
      $to_num = ($this->number_of_rows_per_page * $this->current_page_number);
      if ($to_num > $this->number_of_rows) $to_num = $this->number_of_rows;

      $from_num = ($this->number_of_rows_per_page * ($this->current_page_number - 1));

      if ($to_num == 0) {
        $from_num = 0;
      } else {
        $from_num++;
      }

      return sprintf($text_output, $from_num, $to_num, $this->number_of_rows);
    }
  }
?>