<?php
/* includes/classes/paypal_ppp_rest.class.php
.---------------------------------------------------------------------------.
|    Software: PayPal-Plus-REST-Class                                       |
|     Version: 0.6beta                                                      |
|        Date: 2015-11-05                                                   |
| Description: prepare, send and recieve paypal-REST-requests               |
|     Contact: info@andreas-guder.de                                        |
| ------------------------------------------------------------------------- |
|      Author: Andreas Guder                                                |
|     Contact: info@andreas-guder.de                                        |
| Copyright (c) 2015, Andreas Guder.                                        |
| ------------------------------------------------------------------------- |
|     License:  GNU Public License V2.0                                     |
|               http://www.gnu.org/licenses/gpl-2.0.html                    |
'--------------------------------------------------------------------------ö'
*/

class PAYPAL_PPP_REST
{
  private $url            = '';  
  private $method         = 'GET';  
  private $request_body   = null;  
  private $accept_type    = 'application/json';
  private $response_body  = null;  
  private $response_info  = null;  
  private $custom_header  = array();
  private $custom_opts    = array();
  private $ch             = null;
  private $ppp_address_fields = array('recipient_name','type','line1','line2','city','country_code','zip','postal_code','state','phone','email','salutation','first_name','middle_name','last_name','tax_id');
  
  private $logging = false;
  
  private $paypal_mode    = 'sandbox';
  private $api_endpoint   = '';
  private $api_auth       = array('client_id'=>'','secret'=>'');
  private $api_access_token  = '';
  private $api_access_tokentime = '';
  private $experience_profile_id = '';
  private $webhook_id = '';
  private $api_force_expirence_update = false;

  public function __construct($mode = '')
  {
    if (empty($mode))
      $this->set_paypal_mode(MODULE_PAYMENT_PAYPAL_PPP_MODE);
    else
      $this->set_paypal_mode($mode);
    if ($this->get_paypal_mode() == 'live')
    {
      $this->set_api_endpoint('https://api.paypal.com/');
      $this->set_api_auth(MODULE_PAYMENT_PAYPAL_PPP_APICLIENTID, MODULE_PAYMENT_PAYPAL_PPP_APISECRET);
      $this->set_api_access_token(MODULE_PAYMENT_PAYPAL_PPP_API_ACCESS_TOKEN);
      $this->set_api_access_tokentime(MODULE_PAYMENT_PAYPAL_PPP_API_ACCESS_TOKENTIME);
      $this->set_experience_profile_id(MODULE_PAYMENT_PAYPAL_PPP_EXPERIENCE_PROFILE_ID);
      $this->set_webhook_id(MODULE_PAYMENT_PAYPAL_PPP_WEBHOOK_ID);
    }
    else
    {
      $this->set_api_endpoint('https://api.sandbox.paypal.com/');
      $this->set_api_auth(MODULE_PAYMENT_PAYPAL_PPP_APICLIENTID_SANDBOX, MODULE_PAYMENT_PAYPAL_PPP_APISECRET_SANDBOX);
      $this->set_api_access_token(MODULE_PAYMENT_PAYPAL_PPP_SB_API_ACCESS_TOKEN);
      $this->set_api_access_tokentime(MODULE_PAYMENT_PAYPAL_PPP_SB_API_ACCESS_TOKENTIME);
      $this->set_experience_profile_id(MODULE_PAYMENT_PAYPAL_PPP_SB_EXPERIENCE_PROFILE_ID);
      $this->set_webhook_id(MODULE_PAYMENT_PAYPAL_PPP_SB_WEBHOOK_ID);
    }
    $this->api_force_expirence_update = MODULE_PAYMENT_PAYPAL_PPP_REFRESH_EXPERIENCE == 'False' ? false : true;
    
    if ($this->api_access_tokentime < time())
    {
      if (!$this->get_ppp_access_token())
      {
        trigger_error('PAYPAL_PPP_REST: not able to recreate PPP Access-Token',E_USER_WARNING);
        return false;
      }
      else
      {
        $this->get_expirence_id();
        $this->get_webhook_id();
      }
    }
    elseif($this->api_force_expirence_update)
    {
      $this->prepare_request('v1/payment-experience/web-profiles/'.$this->experience_profile_id, 'PUT', $this->get_expirence_data_array());
      $this->add_custom_header('Authorization: Bearer '.$this->get_api_access_token());
      $result = $this->execute();
      xtc_db_query("UPDATE `".TABLE_CONFIGURATION."` SET `configuration_value`='False' WHERE `configuration_key`='MODULE_PAYMENT_PAYPAL_PPP_REFRESH_EXPERIENCE'");
      $this->api_force_expirence_update = false;
      $this->get_expirence_id();
      $this->get_webhook_id();
    }
    elseif (empty($this->webhook_id))
    {
      $this->get_expirence_id();
      $this->get_webhook_id();
    }
    elseif(empty($this->experience_profile_id))
      $this->get_expirence_id();
  }
  
  private function get_ppp_access_token()
  {
    if(empty($this->api_endpoint))
      return false;
    $this->prepare_request('v1/oauth2/token', 'POST', array('grant_type' => 'client_credentials'), false);
    $this->add_basic_auth_header();
    $result = $this->execute();
    
    if (is_array($result) && (int)$result['info']['http_code'] == 200)
    {
      $body = json_decode($result['body']);
      $this->set_api_access_token($body->access_token);
      $ac_time = time()+$body->expires_in-200;
      $this->set_api_access_tokentime($ac_time);
    
      $key = $this->get_paypal_mode() == 'live' ? 'MODULE_PAYMENT_PAYPAL_PPP_API_ACCESS_TOKEN' : 'MODULE_PAYMENT_PAYPAL_PPP_SB_API_ACCESS_TOKEN';
      xtc_db_query("UPDATE `".TABLE_CONFIGURATION."` SET `configuration_value`='".$this->get_api_access_token()."' WHERE `configuration_key`='".$key."'");
      $key = $this->get_paypal_mode() == 'live' ? 'MODULE_PAYMENT_PAYPAL_PPP_API_ACCESS_TOKENTIME' : 'MODULE_PAYMENT_PAYPAL_PPP_SB_API_ACCESS_TOKENTIME';
      xtc_db_query("UPDATE `".TABLE_CONFIGURATION."` SET `configuration_value`='".$ac_time."' WHERE `configuration_key`='".$key."'");
      return true;
    }
    elseif(is_array($result) && (int)$result['info']['http_code'] == 401)
    {
      $body = json_decode($result['body']);
      die('PayPal-REST-API: '.$body->error_description.' : check PayPal-APP-Access-Data');
    }
    return false;
  }
  
  private function clean_store_name_for_id()
  {
    $s = preg_replace('/\W/','',STORE_NAME);
    return substr($s,0,30);
  }
  
  private function get_expirence_data_array()
  {
    $expirence_name = 'ppp-modified: '.$this->clean_store_name_for_id(); // modifizieren, MODIFIED.SHOP-Name
    $data = array(
      'name'  => $expirence_name,
      'presentation'  => array(
        'brand_name'  => STORE_NAME,
        'logo_image'  => MODULE_PAYMENT_PAYPAL_PPP_IMAGE,
        'locale_code' => $this->get_store_country_code()
      ),
      'input_fields'  => array(
        'allow_note'  => 1,
        'no_shipping' => 0,
        'address_override' => 1
      )
    );
    return $data;
  }
  
  private function get_webhook_data_array($url = false)
  {
    $data = array(
      'url' => HTTPS_SERVER . DIR_WS_CATALOG . 'callback/paypal_ppp/paypal_ppp.php?ppp_confirm=1',
      'event_types' => array()
    );
    $data['event_types'][] = array('name'=>'PAYMENT.SALE.COMPLETED');
    $data['event_types'][] = array('name'=>'PAYMENT.SALE.PENDING');
    $data['event_types'][] = array('name'=>'PAYMENT.SALE.REFUNDED');
    $data['event_types'][] = array('name'=>'PAYMENT.SALE.REVERSED');
    return $url ? $data['url'] : $data;
  }
  
  private function get_expirence_id()
  {
    if(empty($this->api_endpoint))
      return false;
    $expirence_name = 'ppp-modified: '.$this->clean_store_name_for_id(); // modifizieren, MODIFIED.SHOP-Name
    if (empty($this->experience_profile_id))
    {
      $key_found = false;
      $this->prepare_request('v1/payment-experience/web-profiles', 'GET');
      $this->add_custom_header('Authorization: Bearer '.$this->get_api_access_token());
      $result = $this->execute();
      if (is_array($result) && (int)$result['info']['http_code'] == 200)
      {
        $list = json_decode($result['body']);
        foreach ($list as $row)
        {
          if ($row->name == $expirence_name)
          {
            $this->set_experience_profile_id($row->id);
            $key_found = true;
            break;
          }
        }
      }
      
      if (!$key_found)
      {
        $this->prepare_request('v1/payment-experience/web-profiles', 'POST', $this->get_expirence_data_array());
        $this->add_custom_header('Authorization: Bearer '.$this->get_api_access_token());
        $result = $this->execute();
       
        if (is_array($result) && ((int)$result['info']['http_code'] == 200 || (int)$result['info']['http_code'] == 201))
        {
          $body = json_decode($result['body']);
          $this->set_experience_profile_id($body->id);
        }
        else
          die('ppp could not create experience-id http-code: '.$result['info']['http_code'].': '.$result['body']);
      }
      elseif($key_found)
      {
        $this->prepare_request('v1/payment-experience/web-profiles/'.$this->experience_profile_id, 'PUT', $this->get_expirence_data_array());
        $this->add_custom_header('Authorization: Bearer '.$this->get_api_access_token());
        $result = $this->execute();
        if (is_array($result) && ((int)$result['info']['http_code'] == 200 || (int)$result['info']['http_code'] == 204))
        {
          $body = json_decode($result['body']);
          $this->set_experience_profile_id($body->id);
        }
        else
          die('ppp could not patch experience-id http-code: '.$result['info']['http_code'].': '.$result['body']);
      }
      $key = $this->get_paypal_mode() == 'live' ? 'MODULE_PAYMENT_PAYPAL_PPP_EXPERIENCE_PROFILE_ID' : 'MODULE_PAYMENT_PAYPAL_PPP_SB_EXPERIENCE_PROFILE_ID';
      xtc_db_query("UPDATE `".TABLE_CONFIGURATION."` SET `configuration_value`='".$this->experience_profile_id."' WHERE `configuration_key`='".$key."'");
    }
    else
    {
      $this->prepare_request('v1/payment-experience/web-profiles/'.$this->experience_profile_id, 'PUT', $this->get_expirence_data_array());
      $this->add_custom_header('Authorization: Bearer '.$this->get_api_access_token());
      $result = $this->execute();
    }
    return true;
  }
  
  private function get_webhook_id()
  {
    if(empty($this->api_endpoint))
      return false;
    $must_create = true;
    if (!empty($this->webhook_id))
    {
      $this->prepare_request('v1/notifications/webhooks/'.$this->webhook_id, 'GET');
      $this->add_custom_header('Authorization: Bearer '.$this->get_api_access_token());
      $result = $this->execute();
      if (is_array($result) && (int)$result['info']['http_code'] == 200)
        $must_create = false;
    }
    if ($must_create)
    {
      // Hole eine Liste aller Webhooks und lösche die auf die webhook-url des Shops zeigenden
      $this->prepare_request('v1/notifications/webhooks', 'GET');
      $this->add_custom_header('Authorization: Bearer '.$this->get_api_access_token());
      $result = $this->execute();
      if (is_array($result) && ((int)$result['info']['http_code'] == 200))
      {
        $body = json_decode($result['body']);
        foreach ($body->webhooks as $webhooks)
        {
          if ($webhooks->url == $this->get_webhook_data_array(true))
          {
            $this->prepare_request('v1/notifications/webhooks/'.$webhooks->id, 'DELETE');
            $this->add_custom_header('Authorization: Bearer '.$this->get_api_access_token());
            $this->execute();
          }
        }
      }
      
      $this->prepare_request('v1/notifications/webhooks', 'POST', $this->get_webhook_data_array());
      $this->add_custom_header('Authorization: Bearer '.$this->get_api_access_token());
      $result = $this->execute();
      if (is_array($result) && ((int)$result['info']['http_code'] == 200 || (int)$result['info']['http_code'] == 201))
      {
        $body = json_decode($result['body']);
        $this->set_webhook_id($body->id);
        $key = $this->get_paypal_mode() == 'live' ? 'MODULE_PAYMENT_PAYPAL_PPP_WEBHOOK_ID' : 'MODULE_PAYMENT_PAYPAL_PPP_SB_WEBHOOK_ID';
        xtc_db_query("UPDATE `".TABLE_CONFIGURATION."` SET `configuration_value`='".$this->webhook_id."' WHERE `configuration_key`='".$key."'");
      }
      else
        die('ppp could not create webhook http-code: '.$result['info']['http_code'].': '.$result['body']);
    }
    return true;
  }
  
  /**
   * add curl get-Options
   */
  private function execute_get()  
  {         
    $this->do_execute($this->ch);
  }  
  
  /**
   * add curl post-Options
   */
  private function execute_post()  
  {  
    curl_setopt($this->ch, CURLOPT_POSTFIELDS, $this->request_body);  
    curl_setopt($this->ch, CURLOPT_POST, 1);  
    $this->do_execute();
  }  
  
  /**
   * add curl put-Options
   */
  private function execute_put()  
  {
    $request_length = strlen($this->request_body); 
    $fh = fopen('php://temp', 'r+');  
    fwrite($fh, $this->request_body);  
    rewind($fh);  
    
    curl_setopt($this->ch, CURLOPT_INFILE, $fh);  
    curl_setopt($this->ch, CURLOPT_INFILESIZE, $request_length);  
    curl_setopt($this->ch, CURLOPT_PUT, true);  
    
    $this->do_execute();
    fclose($fh);
  }  
  
  /**
   * add curl patch-Options
   */
  private function execute_patch()
  {
    curl_setopt($this->ch, CURLOPT_CUSTOMREQUEST, 'PATCH');
    curl_setopt($this->ch, CURLOPT_POSTFIELDS, $this->request_body);
    $this->do_execute(); 
  }
  
  /**
   * add curl delete-Options
   */
  private function execute_delete()  
  {  
    curl_setopt($this->ch, CURLOPT_CUSTOMREQUEST, 'DELETE');
    $this->do_execute();
  }  
  
  /**
   * add curl options-Options
   */
  private function execute_options()  
  {  
    curl_setopt($this->ch, CURLOPT_CUSTOMREQUEST, 'OPTIONS');
    $this->do_execute();
  }  
  
  /**
   * execute curl and save response
   */
  private function do_execute()  
  {  
    $this->set_curl_opts();
    if ($this->logging)
    {
      $f = fopen(DIR_FS_CATALOG.'export/ppp_curl.txt', 'a');
      fwrite($f, 'REQUEST '.date('Y-m-d H:i:s').':'.chr(10));
      fwrite($f, $this->api_endpoint.$this->url.chr(10));
      fwrite($f, chr(10).'----REQUEST_DATA------'.chr(10).$this->request_body.chr(10));
      
    }
    $this->response_body = curl_exec($this->ch);
    $this->response_info = curl_getinfo($this->ch);
    if (curl_errno($this->ch))
      echo curl_error($this->ch);
    curl_close($this->ch);
    if ($this->logging)
    {
      fwrite($f, chr(10).'----RESPONSE_INFO------'.chr(10).serialize($this->response_info));
      fwrite($f, chr(10).'----RESPONSE_BODY------'.chr(10).serialize($this->response_body));
      fwrite($f, chr(10).'----------------END-----------------'.chr(10).chr(10).chr(10));
      fclose($f);
    }
  }
 
  /**
   * set generally CURL-Options
   */
  private function set_curl_opts()  
  {
    curl_setopt($this->ch, CURLOPT_TIMEOUT, 10);  
    curl_setopt($this->ch, CURLOPT_URL, $this->api_endpoint.$this->url);  
    curl_setopt($this->ch, CURLOPT_RETURNTRANSFER, true); 
    $this->custom_header[] = 'Accept: '.$this->accept_type;
    $this->custom_header[] = 'Accept-Language: en_US';
    $this->custom_header[] = 'Accept-Charset: '.$_SESSION['language_charset'];
    curl_setopt($this->ch, CURLOPT_HTTPHEADER, $this->custom_header);
    foreach ($this->custom_opts as $key => $value)
      curl_setopt($this->ch, $key, $value);
    /* für demo-Anwendung */
    curl_setopt($this->ch, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($this->ch, CURLOPT_SSL_VERIFYHOST, 0);
    /* für demo-Anwendung */
  } 
  
  /**
   * generate query-string from array
   * @var curl-Handle
   */
  private function build_post_body($data = null)  
  {  
    $data = ($data !== null) ? $data : '';
    if (!is_array($data))  
    {  
      trigger_error('Invalid data input for postBody.  Array expected',E_USER_WARNING );
    }
    $this->add_custom_header('Content-type: application/x-www-form-urlencoded');
    $data = http_build_query($data, '', '&');  
    $this->request_body = $data;
  } 

  protected function set_paypal_mode($s)
  {
    $this->paypal_mode = $s == 'live' ? 'live' : 'sandbox';
  }
  protected function set_api_endpoint($s)
  {
    $this->api_endpoint = $s;
  }
  protected function set_api_auth($client_id, $secret)
  {
    $this->api_auth = array(
      'client_id' => $client_id,
      'secret'    => $secret
    );
  }
  protected function set_api_access_token($s)
  {
    $this->api_access_token = $s;
  }
  protected function set_api_access_tokentime($i)
  {
    $this->api_access_tokentime = $i;
  }
  protected function set_experience_profile_id($s)
  {
    $this->experience_profile_id = $s;
  }
  protected function set_webhook_id($s)
  {
    $this->webhook_id = $s;
  }
  
  public function clear()  
  {  
    $this->request_body     = null;  
    $this->method           = 'GET';  
    $this->response_body    = null;  
    $this->response_info    = null; 
    $this->ch               = null;
    $this->custom_header    = array();
    $this->custom_opts      = array();
  }
  
  public function add_custom_header($header_string)
  {
    if (!empty($header_string))
      $this->custom_header[] = $header_string;
  }
  
  public function add_custom_option($opt_code, $opt_value)
  {
    if (!empty($opt_code))
      $this->custom_opts[$opt_code] = $opt_value;
  }
  public function add_basic_auth_header()
  {
    $this->add_custom_option(CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
    $this->add_custom_option(CURLOPT_USERPWD, $this->api_auth['client_id'].':'.$this->api_auth['secret']);
  }
  
  public function prepare_for_json($data)
  {
    if (is_array($data))
    {
      foreach ($data as $key => $value)
        $data[$key] = $this->prepare_for_json($value);
    }
    elseif (is_string($data))
    {
      $data = utf8_encode($data);
    }
    
    return $data;
  }
  
  public function prepare_request($url = null, $method = 'GET', $request_body = null, $json = true)  
  {
    if(empty($this->api_endpoint))
      return false;
    $this->clear();
    
    $this->url            = $url;  
    $this->method         = $method;  

    if ($request_body !== null)  
    {  
      if (!$json && is_array($request_body))
        $this->build_post_body($request_body);
      elseif($json)
      {
        $request_body = $this->prepare_for_json($request_body);
        $this->request_body = json_encode($request_body);  
        $this->add_custom_header('Content-Type: application/json');
      }
      else
        $this->request_body = $request_body;
    }
    return true;
  }
  
  /**
   * execute curl
   */
  public function execute()  
  {  
    if(empty($this->api_endpoint))
      return false;
    $this->ch = curl_init(); 
    try  
    {  
      switch (strtoupper($this->method))  
      {  
        case 'GET':  
          $this->execute_get();  
          break;  
        case 'POST':  
          $this->execute_post();  
          break;  
        case 'PUT':  
          $this->execute_put();  
          break;  
        case 'PATCH':  
          $this->execute_patch();  
          break;  
        case 'DELETE':  
          $this->execute_delete();  
          break;  
        case 'OPTIONS':  
          $this->execute_options();  
          break;
        default:
          curl_close($this->ch);
          trigger_error('Current method ('.$this->method.') is an invalid REST method.',E_USER_WARNING);
          return false;
      }
      return array('info'=>$this->response_info, 'body'=>$this->response_body);
    }  
    catch (Exception $e)  
    {  
      curl_close($this->ch);  
      throw $e;  
    }
    return false;
  }
  
  
  public function delete_paypal_payment_ressource($resource_id)
  {
    if(empty($this->api_endpoint))
      return false;
    $this->prepare_request('v1/payments/payment/'.$resource_id, 'DELETE');
    $this->add_custom_header('Authorization: Bearer '.$this->get_api_access_token());
    $result = $this->execute();
    return $result;
  }
  public function get_store_country_code($code = null)
  {
    if (empty($code))
      $code = STORE_COUNTRY;
    $query = xtc_db_query("SELECT `countries_iso_code_2` FROM `".TABLE_COUNTRIES."` WHERE `countries_id`=".(int)$code." LIMIT 0,1");
    $tmp = xtc_db_fetch_array($query);
    return $tmp['countries_iso_code_2'];
  }
  public function parse_error_response_body($body)
  {
    if (substr($body, 0,1) == '{')
    {
      // it seems to be json
      $response = json_decode($body);
      if ($response !== NULL && is_object($response))
      {
        if (isset($response->name) && $response->name == 'VALIDATION_ERROR')
        {
          $address_error = array();
          $other_error = array();
          foreach ($response->details as $row)
          {
            if (in_array($row->field, $this->ppp_address_fields))
              $address_error[$row->field] = $row->issue;
            else
              $other_error[$row->field] = $row->issue;
          }
          
          $parsed = '';
          if (!empty($address_error))
          {
            $parsed .= 'Bitte pruefen Sie Ihre Kontaktdaten, Liefer- und Rechnungsanschrift:';
            foreach ($address_error as $field => $value)
              $parsed .= ' '.$this->translate($field).' '.$this->translate($value).';';
          }
          if (!empty($other_error))
          {
            $parsed .= ' ---- Fehlerhafte Daten, bitte informieren Sie den Anbieter:';
            foreach ($other_error as $field => $value)
              $parsed .= ' '.$this->translate($field).' - '.$this->translate($value).';';
          }
          return $parsed;
        }
        else
          return $body;
      }
      else
        return $body;
    }
    else
      return $body;
  }
  public function get_paypal_mode()
  {
    return $this->paypal_mode;
  }
  public function get_experience_profile_id()
  {
    return $this->experience_profile_id;
  }
  public function get_api_access_token()
  {
    return $this->api_access_token;
  }
  
  public function translate($field)
  {
    if ($_SESSION['language'] != 'german')
      return $field;
    $t = '';
    switch($field)
    {
      case 'recipient_name': $t = 'Empfaenger'; break;
      case 'type': $t = 'Adress-Typ'; break;
      case 'line1':  $t = 'Strasse 1'; break;
      case 'line2': $t = 'Strasse 2'; break;
      case 'city': $t = 'Ort'; break;
      case 'country_code': $t = 'Land'; break;
      case 'postal_code': $t = 'Plz'; break;
      case 'zip': $t = 'Plz'; break;
      case 'state': $t = 'Bundesland'; break;
      case 'phone': $t = 'Telefon'; break;
      case 'email': $t = 'E-Mail'; break;
      case 'salutation': $t = 'Anrede'; break;
      case 'first_name': $t = 'Vorname'; break;
      case 'middle_name': $t = 'mittlerer Name'; break;
      case 'last_name': $t = 'Nachname'; break;
      case 'tax_id': $t = 'Steuernummer'; break;
      case 'Required field missing': $t = ' fehlt'; break;
      case 'Value is invalid': $t = ' fehlerhaft'; break;
    }
    
    return empty($t) ? $field : $t.' ['.$field.']';
  }
}
?>