<?php

function _yes_get_current_products_in_auction_quantity(int $products_id){
    $record = yes_query(
        "SELECT in_auction FROM products WHERE products_id=:products_id",
        ['products_id'=>$products_id],
        true
    );
    return (int)$record['in_auction'];
}

/**
 * Artikel in_auction Aktualisierung
 * 
 * Aktualisiert zu einem Artikel den products.in_auction Wert
 * 
 * @param int $products_id
 * @param int $qty
 * @param string $comments
 */
function yes_update_products_in_auction_quantity(int $products_id,int $qty, string $comments, $overwrite = false){
    $collies = xtc_get_product_collies($products_id);
    if(is_countable($collies) and sizeOf($collies)){
        foreach($collies as $colli){
            $curr_in_auction = _yes_get_current_products_in_auction_quantity($colli['collie_products_id']);
            if(!$overwrite){
                xtc_db_query(sprintf(
                    "UPDATE products SET in_auction=in_auction+%d WHERE products_id=%d",
                    $qty*$colli['quantity'],
                    $colli['collie_products_id']
                ));
            }else{
                xtc_db_query(sprintf(
                    "UPDATE products SET in_auction=%d WHERE products_id=%d",
                    $qty*$colli['quantity'],
                    $colli['collie_products_id']
                ));
            }
            product::add_history_static(intval($colli['collie_products_id']),
                "COLLIBUCHUNG SET ".$products_id." (".$colli['quantity']."x / alt in_auction=".$curr_in_auction."): ".$comments
            );
        }
        product::add_history_static(intval($products_id),
            "SET (Buchung in Collies) ".$comments
        );
    }else{
        $curr_in_auction = _yes_get_current_products_in_auction_quantity($products_id);
        if(!$overwrite){
            yes_query(
                "UPDATE products SET in_auction=in_auction+:qty WHERE products_id=:products_id",
                ['qty'=>$qty,'products_id'=>$products_id]
            );
        }else{
            yes_query(
                "UPDATE products SET in_auction=:qty WHERE products_id=:products_id",
                ['qty'=>$qty,'products_id'=>$products_id]
            );
        }
        product::add_history_static($products_id,
            '[alt in_auction: '.$curr_in_auction.'] '.$comments
        );
    }
}