<?php
function xtc_get_packingslip_html_for_pdf($order,$smarty,$template,$lagerplaetze=false,$comments=false,$shippings_id=0){
    // FIBUNUMBER ADDON
    $fibu_number = $order->get_fibunumber();
    if(!empty($fibu_number) and strlen($fibu_number)>1){
            $smarty->assign('FIBU_NUMBER',$fibu_number);
    }
    // AMAZON VALUES
    if($order->has_amazon_items()){
            $smarty->assign('amazon_info', $order->get_amazon_items());
    }
    $smarty->assign('TITLE_ORDER',$order->get_title($fibu_number));

    $smarty->assign('address_label_customer',xtc_address_format($order->customer['format_id'], $order->customer, 1, '', '<br>'));
    $smarty->assign('address_label_shipping',xtc_address_format($order->delivery['format_id'], $order->delivery, 1, '', '<br>'));
    $smarty->assign('address_label_payment',xtc_address_format($order->billing['format_id'], $order->billing, 1, '', '<br>'));

    $order->info = xtc_db_prepare_input($order->info);
    $order->customer = xtc_db_prepare_input($order->customer);
    $order->products = xtc_db_prepare_input($order->products);

    $smarty->assign('csID',$order->customer['csID']);
    $smarty->assign('YESORDER',xtc_db_prepare_input($order->get_order_positions( null,$shippings_id ) ));
    $smarty->assign(array(
        'cID'=>$order->customer['ID'],
        'cgroup'=>  xtc_get_customers_status_name($order->info['status']),
        'SOURCE'=>$order->get_source()
    ));
		
    // ALLE TELEFONDATEN
    $tel_query = xtc_db_query("SELECT c.mobile,c.customers_telephone,c.customers_fax FROM customers c, orders o WHERE c.customers_id='".$order->customer['ID']."'");
    $tel = xtc_db_fetch_array($tel_query);
    if($tel['mobile'] != '')
            $smarty->assign('C_MOBILE',$tel['mobile']);
    if($tel['customers_telephone'] != '')
            $smarty->assign('C_TEL',$tel['customers_telephone']);
    if($tel['customers_fax'] != '')
            $smarty->assign('C_FAX',$tel['customers_fax']);
    if($order->customer['telephone'] != '')
            $smarty->assign('O_TEL',$order->customer['telephone']);
    if($order->customer['mobile'] != '')
            $smarty->assign('O_MOBILE',$order->customer['mobile']);
		
    $smarty->assign('COMMENTS_VISIBLE',$order->info['comments_visible']);
    if($comments){
        $shipping_comments_query = xtc_db_query(sprintf(
            "SELECT comments FROM shippings WHERE orders_id='%s'",
            $order->info['id']
        ));
        if(xtc_db_num_rows($shipping_comments_query)){
            $shipping_comments = xtc_db_prepare_input(xtc_db_fetch_array($shipping_comments_query));
            $smarty->assign('COMMENTS',$shipping_comments['comments']);
        }
    }
    if(BARCODE_PACKINGSLIP_ACTIVE == 'True'){
        $img_path = xtc_generate_packingslip_barcode($order->info['id'],\main::get_exportdata_path());
        $smarty->assign('BARCODE','<img src="'.HTTP_SERVER.'admin/exportdata/BARCODE_'.$img_path.'" border="0">');
    }
    $has_teillieferung = false;
    $has_not_ship = false;

    $shippings_products = ($shippings_id > 0) ? yes_get_shippings_products($shippings_id) : [];
		
    foreach($order->products as $order_data_values) {
        if($order_data_values['quantity_shipped'] > 0){
            $has_teillieferung = true;
        }
        if($order_data_values['not_ship'] > 0){
            $has_not_ship = true;
        }
        if(sizeOf($shippings_products)){
            $product_to_send = 0;
            foreach($shippings_products as $shp){
                if($shp['source_products_id'] == $order_data_values['opID']){
                    $pqty = $shp['quantity'];
                    // BUGFIX - IM VERSANDABSCHLUSS DIESEN WERT VERWENDEN
                    $product_to_send = $pqty;
                }
            }
	}else{
            $product_to_send = $order_data_values['qty']-$order_data_values['quantity_shipped'];
            if($order_data_values['not_ship'] > 0){
                $pqty = $order_data_values['qty'] - $order_data_values['quantity_shipped'];
            }else{
                $pqty = $order_data_values['qty'] - $order_data_values['quantity_shipped'] - $order_data_values['not_ship'];
            }
        }
        if($product_to_send < 1){
            continue;
        }
        $collies = xtc_get_product_collies($order_data_values['id']);
        // show product collis
        $product_colli_array = false;
        if(sizeOf($collies)>0){
            $product_colli_array = array();
            foreach($collies as $ck=>$cv){
                $cpID = $cv['collie_products_id'];
                $storage_str = '';
                if($lagerplaetze){
                    // LAGERPLAETZE
                    //if( in_array($order->info['orders_status'],array(ORDERS_STATUS_VERSENDET, ORDERS_STATUS_ABGESCHLOSSEN))) {
                    $transfer_places = $order->get_transferred_places($cpID,'Versand');
                    $transfer_places_otc = $order->get_transferred_places($cpID,'Warenausgabe');
                    if(sizeOf($transfer_places)){
                        foreach($transfer_places as $tp){
                            $tp = xtc_db_prepare_input($tp);
                            $storage_str .= sprintf('<br />Lager &raquo;%s&laquo; / Lagerplatz &raquo;%s&laquo;: %s Stk.',
                                    $tp['name'],$tp['storage_place'],$tp['quantity']
                            );
                        }
                    }else if(sizeOf($transfer_places_otc)){
                        foreach($transfer_places_otc as $tp){
                            $tp = xtc_db_prepare_input($tp);
                            $storage_str .= sprintf('<br />Lager &raquo;%s&laquo; / Lagerplatz &raquo;%s&laquo;: %s Stk.',
                                $tp['name'],$tp['storage_place'],$tp['quantity']
                            );
                        }
                    }
                    //}else{
                    if($storage_str == ''){
                    $query = xtc_db_query('SELECT DISTINCT(sp.storage_id) FROM storage_products sp WHERE sp.products_id='.$cpID);
                    $products_storages_array = array();
                    while($defaults = xtc_db_fetch_array($query)){
                        $products_storages_array[] = $defaults['storage_id'];
                    }
                    if(sizeOf($products_storages_array)>0){
                        for($i=0;$i<count($products_storages_array);$i++){
                            $numbers_str = '';
                            $query = xtc_db_query("SELECT * FROM storage_numbers WHERE storage_id='".$products_storages_array[$i]."' && products_id='".$cpID."'");
                            while($numberdata = xtc_db_prepare_input(xtc_db_fetch_array($query))){
                                $places_query = xtc_db_query("SELECT stp.title FROM storage_products sp LEFT JOIN storage_places stp USING(storage_places_id) WHERE products_id='".$cpID."' and sp.storage_id='".$products_storages_array[$i]."'");
                                $places_array = array();
                                while($places_res = xtc_db_fetch_array($places_query)){
                                    $places_array[] = xtc_db_prepare_input($places_res['title']);
				}
				$numbers_str .= sprintf('%s: %s<br />',
                                    $numberdata['nummer'],implode(', ',$places_array)
				);
                            }
                            $storage_str .= sprintf('<br />Lager: <b>&raquo;%s&laquo;</b><br />Lager-Nr: Lager-Platz<br /><b>%s</b><br />',
                                xtc_db_prepare_input(xtc_get_storage_name($products_storages_array[$i])),$numbers_str
                            );
			}
                    }
		}
            }
            $weight = xtc_get_ext_products_weight($cpID);
            $weight_total = $weight*$pqty*$cv['quantity'];
            $product_colli_array[] = array( 'pID'=>$cv['collie_products_id'],
                'qty'=>($cv['quantity']*$pqty),
                'name'=>xtc_db_prepare_input(xtc_get_products_name( $cv['collie_products_id'] )),
                'DISTRIBUTOR_NUMBER'=>xtc_db_prepare_input(yes_get_products_distributor_number($cv['collie_products_id'])),
                'PRODUCTS_STORAGES'=>$storage_str,
                'PRODUCTS_WEIGHT'=>number_format($weight,4,',','.').'kg',
                'PRODUCTS_WEIGHT_SUM'=>number_format($weight_total,4,',','.').'kg'
            );
        }
    }
    $storage_str = '';
    $create_unallocated_lp = false;
    if($lagerplaetze){
        // LAGERPLAETZE
        //if( in_array($order->info['orders_status'],array(ORDERS_STATUS_VERSENDET, ORDERS_STATUS_ABGESCHLOSSEN))) {
        $transfer_places = $order->get_transferred_places($order_data_values['id'],'Versand');
        $transfer_places_otc = $order->get_transferred_places($order_data_values['id'],'Warenausgabe');
        if(sizeOf($transfer_places)){
            foreach($transfer_places as $tp){
                $tp = xtc_db_prepare_input($tp);
                $storage_str .= sprintf('<br />Lager &raquo;%s&laquo; / Lagerplatz &raquo;%s&laquo;: %s Stk.',
                    $tp['name'],$tp['storage_place'],$tp['quantity']
                );
            }
        }else if(sizeOf($transfer_places_otc)){
            foreach($transfer_places_otc as $tp){
                $tp = xtc_db_prepare_input($tp);
                $storage_str .= sprintf('<br />[OTC] Lager &raquo;%s&laquo; / Lagerplatz &raquo;%s&laquo;: %s Stk.',
                    $tp['name'],$tp['storage_place'],$tp['quantity']
                );
            }
        }else{
            $create_unallocated_lp = true;
        }
        if($storage_str == ''){
                $create_unallocated_lp = true;
        }
    }
    if($create_unallocated_lp){
        $pID = $order_data_values['id'];
        $query = xtc_db_query('SELECT DISTINCT(sp.storage_id) FROM storage_products sp WHERE sp.products_id='.$pID);
        $products_storages_array = array();
        while($defaults = xtc_db_fetch_array($query)){
            $products_storages_array[] = $defaults['storage_id'];
        }
        if(sizeOf($products_storages_array)>0){
            for($i=0;$i<count($products_storages_array);$i++){
                $numbers_str = '';
                $query = xtc_db_query("SELECT * FROM storage_numbers WHERE storage_id='".$products_storages_array[$i]."' && products_id='".$pID."'");
                while($numberdata = xtc_db_prepare_input(xtc_db_fetch_array($query))){
                    $places_query = xtc_db_query("SELECT title FROM storage_products sp LEFT JOIN storage_places stp USING(storage_places_id) WHERE products_id='".$pID."' and sp.storage_id='".$products_storages_array[$i]."'");
                    $places_array = array();
                    while($places_res = xtc_db_fetch_array($places_query)){
                            $places_array[] = xtc_db_prepare_input($places_res['title']);
                    }
                    $numbers_str .= sprintf('%s: %s<br />',
                            $numberdata['nummer'],implode(', ',$places_array)
                    );
                }
                $storage_str .= sprintf('<br />Lager: <b>&raquo;%s&laquo;</b><br />Lager-Nr: Lager-Platz<br /><b>%s</b><br />',
                    xtc_db_prepare_input(xtc_get_storage_name($products_storages_array[$i])),$numbers_str
                );
            }
	}
    }

    $distributor_numbers = array();
    $dnumbers_query = xtc_db_query("SELECT pd.is_default,pd.comments,pd.distributor_products_number,d.name FROM products_distributors pd LEFT join distributors d ON d.id=pd.distributor_id WHERE pd.products_id='".$order_data_values['id']."'");
    $num = xtc_db_num_rows($dnumbers_query);
    if($num == 1){
        $dnumbers = xtc_db_prepare_input(xtc_db_fetch_array($dnumbers_query));
        $distributor_numbers[] = array(
            'number'=>$dnumbers['distributor_products_number'],
            'distributor'=>$dnumbers['name'],
            'comments'=>$dnumbers['comments']
        );
    }else{
        while($dnumbers = xtc_db_prepare_input(xtc_db_fetch_array($dnumbers_query))){
            if($dnumbers['is_default'] == 1)
                $distributor_numbers[] = array(
                    'number'=>$dnumbers['distributor_products_number'],
                    'distributor'=>$dnumbers['name'],
                    'comments'=>$dnumbers['comments']
                );
            }
	}
			
        $thumbnail_image = '';
        $picture_query = yes_db_query(sprintf("SELECT products_image FROM products WHERE products_id='%s'",
            $order_data_values['opID']
        ),true);
        if($picture_query){
            $picture = current($picture_query);
            $thumbnail_image = HTTP_SERVER.'images/product_images/thumbnail_images/'.$picture['products_image'];
        }
        $weight = xtc_get_ext_products_weight($order_data_values['id']);
        $weight_total = $weight*$pqty;

        $properties = array();
        $query = xtc_db_query(sprintf(
            "SELECT property_title,property_value FROM orders_products_properties WHERE orders_products_id='%s'",
            $order_data_values['opID']
        ));
        while($record = xtc_db_prepare_input(xtc_db_fetch_array($query))){
            $properties[] = $record;
        }

        $order_data[]=array(
            'COLLIES'=>$product_colli_array,
            'DISTRIBUTOR_NUMBERS'=>$distributor_numbers,
            'PRODUCTS_STORAGES'=>$storage_str,
            'PRODUCTS_ID'=>$order_data_values['id'],
            'PRODUCTS_MODEL' => $order_data_values['model'],
            'PRODUCTS_NAME' => $order_data_values['name'],
            'PRODUCTS_PRICE' =>  xtc_format_price_order($order_data_values['final_price'],1,$order->info['currency']),
            'PRODUCTS_QTY' => $pqty,
            'THUMBNAIL_IMAGE' => $thumbnail_image,
            'PRODUCTS_WEIGHT'=>number_format($weight,4,',','.').'kg',
            'PRODUCTS_WEIGHT_SUM'=>number_format($weight_total,4,',','.').'kg',
            'DISTRIBUTOR_NUMBER'=>xtc_db_prepare_input(yes_get_products_distributor_number($order_data_values['id'])),
            'DISTRIBUTOR_NUMBER_COMMENTS'=>xtc_db_prepare_input(yes_get_products_distributor_comment($order_data_values['id'])),
            'PROPERTIES'=>$properties,
            'QUANTITY_SHIPPED'=>$order_data_values['quantity_shipped'],
            'NOT_SHIP'=>$order_data_values['not_ship']
	);
    } // end foreach products
    if($order->has_part_delivery()){
        $smarty->assign('PART_ORDER',1);
    }
    if($has_not_ship){
	$smarty->assign('NOT_SHIP_PRODUCTS',1);
    }
		
    // assign language to template for caching
    $smarty->assign('STORE', nl2br(STORE_NAME_ADDRESS));
    $smarty->assign('BANK', MODULE_PAYMENT_MONEYORDER_PAYTO);
    $smarty->assign('language', $_SESSION['language']);
    $smarty->assign('logo_path',HTTP_SERVER  . 'templates/'.CURRENT_TEMPLATE.'/img/');
    $smarty->assign('oID',$order->info['id']);

    $ebay_seller = xtc_get_orders_ebay_seller($order->info['id']);
    if($ebay_seller != ''){
        $smarty->assign(array(
            'EBAY_SELLER_DATA'=>xtc_get_ebay_seller_data($ebay_seller),
            'EBAY_ID'=>$order->info['ebay_id'],
            'EBAY_PLUS'=>$order->info['ebay_plus']
        ));
    }

    if ($order->info['payment_method']!='' && $order->info['payment_method']!='no_payment') {
        if(is_file(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/payment/'.$order->info['payment_method'].'.php')){
            if(!defined(strtoupper('MODULE_PAYMENT_'.$order->info['payment_method'].'_TEXT_TITLE'))){
                require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/payment/'.$order->info['payment_method'].'.php');
            }
            $payment_method=constant(strtoupper('MODULE_PAYMENT_'.$order->info['payment_method'].'_TEXT_TITLE'));
        }else{
            $payment_method = $order->info['payment_method'];
        }
        $smarty->assign('PAYMENT_METHOD',$payment_method);
    }
    $smarty->assign(array(
        'DATE'=>xtc_date_short($order->info['date_purchased']),
        'SHIPPING_COMMENTS'=>  xtc_db_prepare_input($order->info['shipping_comments'])
    ));
    if($order->info['date_shipping'] > 0)
            $smarty->assign('DATE_SHIPPING',xtc_date_short($order->info['date_shipping']));
    $smarty->assign('order_data', $order_data);
    if(defined('MODULE_OTHER_FIBUNUMBERS_STATUS') and MODULE_OTHER_FIBUNUMBERS_STATUS == 'True'){
        $fibu_date_query = yes_db_query(sprintf(
            "SELECT date_added FROM orders_fibunumbers WHERE orders_id='%s'",
            $order->info['id']
        ));
        if(yes_db_num_rows($fibu_date_query)){
            $date = current($fibu_date_query);
            $smarty->assign('fibu_date',$date['date_added']);
        }
    }
                
    if(defined('MODULE_OTHER_YES_HITMEISTER_API_STATUS') and MODULE_OTHER_YES_HITMEISTER_API_STATUS == 'True'){
        if(!class_exists('yes_hitmeister')){
            require_once(DIR_WS_CLASSES.'yes_hitmeister.php');
        }
        $hio = yes_hitmeister::get_hitmeister_id_order_from_orders_id($order->info['id']);
        if($hio != ''){
            $smarty->assign('HITMEISTER_ID_ORDER',$hio);
        }
    }
    $pdf_html=$smarty->fetch($template);
    return $pdf_html;
}
