<?php
/* -----------------------------------------------------------------------------------------
   $Id: xtc_format_price_order.inc.php,v 1.1 2006/05/03 07:11:49 web2 Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   by Mario Zanier for XTcommerce
   
   based on:
   (c) 2003	 nextcommerce (xtc_format_price.inc.php,v 1.7 2003/08/19); www.nextcommerce.org

   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/
// include needed functions
require_once(DIR_FS_INC . 'xtc_precision.inc.php');
require_once(DIR_FS_INC . 'xtc_get_currencies_values.inc.php');
function xtc_format_price_order ($price_string,$price_special,$currency,$show_currencies=1){
    $currencies_value= xtc_get_currencies_values((string)$currency);
    $currencies_data = [
        'SYMBOL_LEFT'=>$currencies_value['symbol_left'] ,
        'SYMBOL_RIGHT'=>$currencies_value['symbol_right'] ,
        'DECIMAL_PLACES'=>$currencies_value['decimal_places'] ,
        'DECIMAL_POINT'=>$currencies_value['decimal_point'],
        'VALUE'=> $currencies_value['value'],
        'THOUSANDS_POINT'=>$currencies_value['thousands_point'],
    ];
    $price_string=xtc_precision($price_string,$currencies_data['DECIMAL_PLACES']);
    if ($price_special=='1') {
        $price_string = number_format($price_string,
            $currencies_data['DECIMAL_PLACES'], 
            $currencies_data['DECIMAL_POINT'], 
            $currencies_data['THOUSANDS_POINT']
        );
        if ($show_currencies == 1) {
            $price_string = $currencies_data['SYMBOL_LEFT']. ' '.$price_string.' '.$currencies_data['SYMBOL_RIGHT'];
        }
    }
    return $price_string;
}
