<?php
chdir('../');
include('includes/application_top.php');
require_once(DIR_WS_CLASSES.'order.php');
ob_start();
$post = file_get_contents('php://input');
$post_dec = json_decode($post);
$msg = json_decode($post_dec->Message);
echo "\r\nmsg #".$post_dec->MessageId.': '.$msg->ReleaseEnvironment."\r\n";
$sxe = new SimpleXMLElement($msg->NotificationData);
switch($msg->NotificationType){
	case 'PaymentCapture':
		$CD = $sxe->CaptureDetails;
		$AmazonCaptureId = "".$CD->AmazonCaptureId;
		$CaptureReferenceId = "".$CD->CaptureReferenceId;
		$CaptureAmount = (float)$CD->CaptureAmount->Amount;
		$CurrencyCode = "".$CD->CaptureAmount->CurrencyCode;
		$CaptureFee = (float)$CD->CaptureFee->Amount;
		$SoftDescriptor = "".$CD->SoftDescriptor;
		$CaptureStatus = "".$CD->CaptureStatus->State;

		$query = xtc_db_query(sprintf(
			"SELECT orders_id FROM orders WHERE yes_amazon_pay_reference='%s'",
			$CaptureReferenceId
		));
		if(empty($CaptureReferenceId) or $CaptureReferenceId == '' or !xtc_db_num_rows($query)){
			mail('m.aspeleiter@yes-websolutions.de','unknown amz payment for CaptureReference '.$CaptureReferenceId, HTTP_SERVER."\r\n".STORE_NAME."\r\n".$CD->asXML());
			die('Unknown IPN');
		}
		$record = xtc_db_fetch_array($query);
		$order = new order($record['orders_id'],$xtPrice);
		$comments = sprintf('Amazon Capture Status %s: %s %s (Fee: %s) %s',
				$CaptureStatus,
				$CaptureAmount,
				$CurrencyCode,
				$CaptureFee,
				$SoftDescriptor
		);

		switch($CaptureStatus){
			case 'Completed':
				$target_status = ORDERS_STATUS_BEZAHLT;
				break;
			case 'Closed':
				$target_status = $order->info['orders_status'];
				break;
			default:
				$target_status = MODULE_PAYMENT_YES_AMAZON_PAY_ORDERS_STATUS_FAILURE;
				break;
		}
		$order->add_history($target_status,false,$comments);
		if($order->info['orders_status'] != $target_status){
			$update_sql_array = array(
				'orders_status'=>$target_status,
				'last_modified'=>'now()'
			);
			xtc_db_perform(TABLE_ORDERS,$update_sql_array,'update',"orders_id='".$order->info['id']."'");
		}
		
		print_r($sxe->CaptureDetails);
		break;
	case 'PaymentAuthorize':
		$AD = $sxe->AuthorizationDetails;
		$sql_array = array(
			'AuthorizationAmount_CurrencyCode'=>$AD->AuthorizationAmount->CurrencyCode,
			'AuthorizationAmount_Amount'=>$AD->AuthorizationAmount->Amount,
			'CapturedAmount_CurrencyCode'=>$AD->CapturedAmount->CurrencyCode,
			'CapturedAmount_Amount'=>$AD->CapturedAmount->Amount,
			'SoftDescriptor'=>$AD->SoftDescriptor,
			'IdList_member'=>$AD->IdList->member,
			'SoftDecline'=>($AD->SoftDecline == 'false') ? false : true,
			'LastUpdateTimestamp'=>$AD->AuthorizationStatus->LastUpdateTimestamp,
			'State'=>$AD->AuthorizationStatus->State,
			'AuthorizationFee_CurrencyCode'=>$AD->AuthorizationFee->CurrencyCode,
			'AuthorizationFee_Amount'=>$AD->AuthorizationFee->Amount,
			'AmazonAuthorizationId'=>$AD->AmazonAuthorizationId,
			'AuthorizationReferenceId'=>$AD->AuthorizationReferenceId,
		);
		$query = xtc_db_query(sprintf(
			"SELECT yes_amazon_pay_authorization_id FROM yes_amazon_pay_authorization WHERE AmazonAuthorizationId='%s' AND AuthorizationReferenceId='%s'",
			$sql_array['AmazonAuthorizationId'],$sql_array['AuthorizationReferenceId']
		));
		if(!xtc_db_num_rows($query)){
			// WARUM AUCH IMMER? NEUER DATENSATZ
			xtc_db_perform('yes_amazon_pay_authorization',$insert_sql_array);
			mail('m.aspeleiter@yes-websolutions.de','unknown amz Authorize for AuthorizationID '.$sql_array['AmazonAuthorizationId'], HTTP_SERVER."\r\n".STORE_NAME."\r\n".$AD->asXML());
		
		}else{
			$record = xtc_db_fetch_array($query);
			$update_sql_array = array(
				'LastUpdateTimestamp'=>$AD->AuthorizationStatus->LastUpdateTimestamp,
				'State'=>$AD->AuthorizationStatus->State,
				'AuthorizationFee_Amount'=>$AD->AuthorizationFee->Amount
			);
			xtc_db_perform('yes_amazon_pay_authorization',$update_sql_array,'update',"yes_amazon_pay_authorization_id='".$record['yes_amazon_pay_authorization_id']."'");
		}
		break;
	case 'PaymentRefund':
		$RD = $sxe->RefundDetails;

		$insert_sql_array = array(
			'AmazonRefundId'=>$RD->AmazonRefundId,
			'RefundReferenceId'=>$RD->RefundReferenceId,
			'RefundType'=>$RD->RefundType,
			'SellerRefundNote'=>(isset($RD->SellerRefundNote)) ? $RD->SellerRefundNote : '',
			'Currency'=>$RD->RefundAmount->CurrencyCode,
			'RefundedAmount'=>$RD->RefundAmount->Amount,
			'FeeRefunded'=>$RD->FeeRefunded->Amount,
			'RefundStatus'=>$RD->RefundStatus->State,
			'date_created'=>$RD->CreationTimestamp,
		);
		$query = xtc_db_query(sprintf(
			"SELECT yes_amazon_pay_refunds_id,yes_amazon_pay_reference_id FROM yes_amazon_pay_refunds WHERE AmazonRefundId='%s'",
			$RD->AmazonRefundId
		));
		if(!xtc_db_num_rows($query)){
			// WARUM AUCH IMMER? NEUER DATENSATZ
			xtc_db_perform('yes_amazon_pay_refunds',$insert_sql_array);
			mail('m.aspeleiter@yes-websolutions.de','unknown amz Authorize for AuthorizationID '.$insert_sql_array['AmazonAuthorizationId'], HTTP_SERVER."\r\n".STORE_NAME."\r\n".$RD->asXML());
		}else{
			$record = xtc_db_fetch_array($query);
			$update_sql_array = array(
				'RefundedAmount'=>$RD->RefundAmount->Amount,
				'FeeRefunded'=>$RD->FeeRefunded->Amount,
				'RefundStatus'=>$RD->RefundStatus->State,
			);
			xtc_db_perform('yes_amazon_pay_refunds',$update_sql_array,'update',"yes_amazon_pay_refunds_id='".$record['yes_amazon_pay_refunds_id']."'");
			$query = xtc_db_query(sprintf(
				"SELECT orders_id FROM orders WHERE yes_amazon_pay_reference_id='%s'",
				$record['yes_amazon_pay_reference_id']
			));
			$record = xtc_db_fetch_array($query);
			$order = new order($record['orders_id']);
			$comments = sprintf(TEXT_ORDERS_STATUS_COMMENT_UPDATE_REFUND_STATUS,$RD->AmazonRefundId,$RD->RefundStatus->State);
			$order->add_history($order->info['orders_status_id'],false,$comments);
		}
		exit;
		break;
	default:
		print_r($post_dec);
		echo "\r\n\r\nsxe\r\n\r\n";
		print_r($sxe->asXML());
		break;
}
$mesg = ob_get_contents();
ob_end_clean();
mail('m.aspeleiter@yes-websolutions.de',basename(__FILE__).': '.$msg->NotificationType,$mesg);
