<?php
/* --------------------------------------------------------------
   $Id: stats_stock_warning.php,v 1.39 2017/01/09 08:58:04 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(stats_products_viewed.php,v 1.27 2003/01/29); www.oscommerce.com 
   (c) 2003	 nextcommerce (stats_stock_warning.php,v 1.9 2003/08/18); www.nextcommerce.org

   Released under the GNU General Public License 
   --------------------------------------------------------------*/

require('includes/application_top.php');
$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');

$branches_array = array();
$branches_query = xtc_db_query("SELECT branches_id,title,stammlager FROM branches");
$nr = 1;
while($branches = xtc_db_fetch_array($branches_query)){
	$branches['nr'] = $nr;
	$branches_array[] = $branches;
	$nr++;
}
if(is_countable($branches) and sizeOf($branches)){
	$smarty->assign('branches',$branches_array);
}
$smarty->assign('colspan',sizeOf($branches_array)+5);




$WHERE_SEARCH = '';
if(isset($_REQUEST['search']) and !empty($_REQUEST['search'])){
	$search = xtc_db_input($_REQUEST['search']);
	switch($_REQUEST['mode']){
		case 'name':
			$WHERE_SEARCH = sprintf(" and pd.products_name LIKE '%%%s%%' ",$search);
			break;
		case 'model':
			$WHERE_SEARCH = sprintf(" and p.products_model LIKE '%%%s%%' ",$search);
			break;
		case 'ean':
			$WHERE_SEARCH = sprintf(" and p.products_ean LIKE '%%%s%%' ",$search);
			break;
		case 'pid':
			$WHERE_SEARCH = sprintf(" and p.products_id=%s ",(int)$search);
			break;
		case 'condition':
			$WHERE_SEARCH = sprintf(" and p.products_conditions_id = '%s' ",$search);
			break;
	}
}
if(isset($_REQUEST['storage_id']) and $_REQUEST['storage_id'] > 0){
    if(isset($_REQUEST['only_default'])){
	$WHERE_SEARCH = sprintf(" and p.default_storage=%s ",
		(int)xtc_db_input($_REQUEST['storage_id'])
	);
        $query_raw = sprintf("SELECT p.products_id, p.products_model,p.products_conditions_id, pd.products_name from %s p LEFT JOIN products_collies pc USING(products_id), %s pd where pd.language_id = '%s' and pd.products_id = p.products_id and pc.products_id is null %s order by products_quantity",
	    TABLE_PRODUCTS,TABLE_PRODUCTS_DESCRIPTION,$_SESSION['languages_id'],$WHERE_SEARCH
	);
    }else{
	$WHERE_SEARCH = sprintf(" and sp.storage_id=%s and sp.products_id=p.products_id ",
		(int)xtc_db_input($_REQUEST['storage_id'])
	);
        $query_raw = sprintf("SELECT p.products_id, p.products_model,p.products_conditions_id, pd.products_name from %s p LEFT JOIN products_collies pc USING(products_id), %s pd, storage_products sp where pd.language_id = '%s' and pd.products_id = p.products_id and pc.products_id is null %s order by products_quantity",
	    TABLE_PRODUCTS,TABLE_PRODUCTS_DESCRIPTION,$_SESSION['languages_id'],$WHERE_SEARCH
	);
    }
}else{
    $query_raw = sprintf("SELECT p.products_id,p.products_model, p.products_conditions_id, pd.products_name from %s p LEFT JOIN products_collies pc USING(products_id), %s pd where pd.language_id = '%s' and pd.products_id = p.products_id and pc.products_id is null %s order by products_quantity",
	    TABLE_PRODUCTS,TABLE_PRODUCTS_DESCRIPTION,$_SESSION['languages_id'],$WHERE_SEARCH
    );
}
if(!isset($_REQUEST['csv'])){
    $products_split = new splitPageResults($_GET['page'], MAX_DISPLAY_SEARCH_RESULTS, $query_raw, $query_numrows);
}
$query = xtc_db_query($query_raw);
$products = array();
while($products_values = xtc_db_fetch_array($query)) {
	$products_values['link'] = xtc_href_link(FILENAME_CATEGORIES, 'pID=' . $products_values['products_id'] . '&action=new_product');
	$products_values['name'] = $products_values['products_name'];
        $products_values['products_condition'] = \YES4Trade\Model\products_conditions::get_condition_title($products_values['products_conditions_id'],$_SESSION['languages_id']);
	$SQ = new products_quantity($products_values['products_id']);
    if ($SQ->get_products_total_qty() <='0' and !isset($_REQUEST['csv'])) {
		$products_values['qty_phys'] = '<font color="ff0000"><b>'.$SQ->get_products_total_qty().'</b></font>';
    } else {
		$products_values['qty_phys'] = $SQ->get_products_total_qty();
    }
    $products_values['qty_av1'] = $SQ->get_available1_qty();
    $products_values['qty_av2'] = $SQ->get_available2_qty();
    if(sizeOf($branches_array)){
	    foreach($branches_array as $b){
		    $products_values['qty_F'][$b['nr']] = $SQ->get_branch_qty($b['branches_id']);
	    }
    }
    $products[] = $products_values;
}

if(isset($_REQUEST['csv'])){
	require(DIR_WS_CLASSES.'class.csv.php');
	$filename = sprintf('lagerbestand.csv');
	$fh = fopen(\main::get_exportdata_path().$filename,'a+') or die("Kann ".$filename." nicht anlegen.");
	fclose($fh);
	$CSV = new CSVfile(\main::get_exportdata_path().$filename);
	$CSV->delimiter = "\t";
	$CSV->open('w');
	$csv_header = array(
	    TEXT_PRODUCTS_ID,
	    'Art-Nr.',
	    'Zustand',
	    'Artikel',
	    'Link',
		'Phys. Bestand',
		'V1',
		'V2'
	);
	if(sizeOf($branches_array)){
		foreach($branches_array as $b){
		    $csv_header[] = 'Filiale '.str_replace(';','',$b['title']);
		}
	}
	$CSV->addRow($csv_header);
	foreach($products as $product){
	    unset($product['name']);
	    $data = array();
	    foreach($product as $pv){
		if(!is_array($pv)){
		    $data[] = str_replace(array('"',"'"),' ',$pv);
		}else{
		    foreach($pv as $pv_branch_qty){
			$data[] = $pv_branch_qty;
		    }
		}
	    }
	    $CSV->addRow($data);
	}
	$CSV->close();
	$content = file_get_contents(\main::get_exportdata_path().$filename);
	unlink(\main::get_exportdata_path().$filename);
	$len = strlen($content);
	header("Content-type: text/csv");
	header("Content-Disposition: attachment; filename=".$filename);
	header("Content-Length: ".$len);
	echo $content;
	exit;
}
yes_draw_pre_header();
yes_draw_header(TITLE);
?>
<script type="text/javascript" src="minify_js.php?file=includes/general.js"></script>
<!-- header_eof //-->
<?php
$storages = xtc_get_storages();
$export_params = '';
if(isset($_REQUEST['storage_id'])){
    $export_params .= '&storage_id='.$_REQUEST['storage_id'];
}else if(isset($_REQUEST['search'])){
    $export_params .= '&search='.$_REQUEST['search'].'&mode='.$_REQUEST['mode'];
}
$smarty->assign(array(
    'FORM_END'=>'</form>',
    'TEXT_STORAGE_FILTER'=>TEXT_STORAGE_FILTER,
    'STORAGE_FILTER_FORM'=>xtc_draw_form('storage_form','stats_stock_warning.php'),
    'INPUT_STORAGE_FILTER'=>  xtc_draw_pull_down_menu('storage_id', $storages,@$_REQUEST['storage_id']),
    'TEXT_ONLY_DEFAULT_PRODUCTS'=>TEXT_ONLY_DEFAULT_PRODUCTS,
    'INPUT_ONLY_DEFAULT_PRODUCTS'=>xtc_draw_checkbox_field('only_default','1',@$_REQUEST['only_default'])
));

$branches_array = array();
$branches_query = xtc_db_query("SELECT branches_id,title,stammlager FROM branches");
$nr = 1;
while($branches = xtc_db_fetch_array($branches_query)){
	$branches['nr'] = $nr;
	$branches_array[] = $branches;
	$nr++;
}
if(is_countable($branches) and sizeOf($branches)){
	$smarty->assign('branches',$branches_array);
}
$smarty->assign('colspan',sizeOf($branches_array)+5);

$smarty->assign('products',$products);
$conditions = \YES4Trade\Model\products_conditions::get_list($_SESSION['languages_id']);
$conditions_array = [];
foreach($conditions as $cond){
    $conditions_array[] = array(
		'id'=>$cond['products_conditions_id'],
		'text'=>$cond['title']
    );
}
if(!sizeOf($conditions_array)){
	$conditions_array = [['id'=>'','text'=>TEXT_SELECT]];
}
$smarty->assign('INPUT_CONDITIONS',xtc_draw_pull_down_menu('products_conditions_id',$conditions_array,''));
$search_mode_array = array(
    0=>array('id'=>'name','text'=>LABEL_INPUT_MODE_NAME),
    1=>array('id'=>'model','text'=>LABEL_INPUT_MODE_MODEL),
    2=>array('id'=>'ean','text'=>LABEL_INPUT_MODE_EAN),
    3=>array('id'=>'pid','text'=>'pID')
    /*4=>array('id'=>'condition','text'=>TEXT_CONDITION)*/
);
$buttons = array();
if(sizeOf($products)){
    $buttons[] = array('text'=>IMAGE_EXPORT,
	'link'=>xtc_href_link('stats_stock_warning.php',xtc_get_all_get_params(array('page','csv')).'csv=1'.$export_params),
	'lbOn'=>false,
	'auth'=>true
    );
}

$smarty->assign(array(
	'SEARCH_LEGEND'=>SEARCH_LEGEND,
	'LABEL_INPUT_SEARCH'=>LABEL_INPUT_SEARCH,
	'LABEL_INPUT_MODE'=>LABEL_INPUT_MODE,
	'IMAGE_SEARCH'=>IMAGE_SEARCH,
	'INPUT_SEARCH'=>xtc_draw_input_field('search',((isset($_REQUEST['search']))?$_REQUEST['search']:''),'size="20" maxlength="32"'),
	'INPUT_MODE'=>xtc_draw_pull_down_menu('mode',$search_mode_array,((isset($_REQUEST['mode']))?$_REQUEST['mode']:'')),
    'HEADING_TITLE'=>HEADING_TITLE,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons
));
$smarty->assign('split',$products_split->display_count($query_numrows, MAX_DISPLAY_SEARCH_RESULTS, $_GET['page'], TEXT_DISPLAY_NUMBER_OF_ITEMS,xtc_get_all_get_params(array('action','page'))).'<br>'.
$products_split->display_links($query_numrows, MAX_DISPLAY_SEARCH_RESULTS, MAX_DISPLAY_PAGE_LINKS, $_GET['page'], xtc_get_all_get_params(array('action','page'))));
$smarty->display('stats_stock_warning.html');
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');
