<?php
/* --------------------------------------------------------------
   $Id: specials.php,v 1.91 2020/08/03 08:34:03 ssh-511548-cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(specials.php,v 1.38 2002/05/16); www.oscommerce.com 
   (c) 2003	 nextcommerce (specials.php,v 1.9 2003/08/18); www.nextcommerce.org

   Released under the GNU General Public License 
   --------------------------------------------------------------*/

require('includes/application_top.php');
require_once(DIR_FS_CATALOG.DIR_WS_CLASSES . 'xtcPrice.php');
require_once(DIR_WS_CLASSES . 'product.php');
require_once(DIR_WS_CLASSES . 'class.ebay.php');
require_once(DIR_WS_CLASSES.'specials_ebay_revise.php');
$xtPrice = new xtcPrice(DEFAULT_CURRENCY,$_SESSION['customers_status']['customers_status_id']);
require_once(DIR_FS_INC .'xtc_get_tax_rate.inc.php');
require_once(DIR_FS_INC .'xtc_get_category_path.inc.php');
require_once(DIR_FS_INC .'xtc_get_parent_categories.inc.php');
require_once(DIR_FS_INC .'xtc_db_affected_rows.inc.php');
require_once(DIR_FS_INC .'yes_remove_price_revise_for_products_auctions.inc.php');
require_once(DIR_FS_INC .'yes_write_notice.inc.php');
require_once(DIR_FS_INC .'xtc_set_specials_status.inc.php');

function unzip($zipfile){
	$unzip = exec(sprintf("gunzip %s",$zipfile));
	return true;
}
function statusResponseErrorMessages($Errors, &$dbg_messages){
	foreach($Errors as $resp_err){
		$dbg_message = array(
			$resp_err->SeverityCode.': '.$resp_err->ShortMessage.' '.$resp_err->LongMessage
		);
		foreach($resp_err->ErrorParameters as $errPar){
			foreach($errPar->attributes() as $v){
				$dbg_message[] = $v.': '.$errPar->Value;
			}
		}
		$dbg_messages[] = '<br />'.implode('<br />',$dbg_message);
	}
}

$recipients = main::get_notice_recipients('specials');

$basics = new basics;
// initiate template engine for mail
$smarty = new yesSmarty;
$smarty->assign(array(
    'language_path'=>DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
    'GET_PRICE_FROM_PID'=>(defined('TEXT_GET_PRICE_FROM_PID'))?TEXT_GET_PRICE_FROM_PID:'',
    'ADDITIONAL_TITLE'=>'',
));
//$smarty->plugins_dir[] = DIR_FS_CATALOG.'includes/smarty_plugins/';

$action = (isset($_REQUEST['action'])) ? $_REQUEST['action'] : '';
switch ($action) {
    case 'get_cpath_from_categories_id':
        $id = intval($_GET['id']);
        $cpath = xtc_get_category_path($id);
        die($cpath);
    case 'get_product_info':
		$pID = (int)xtc_db_input($_REQUEST['products_id']);
		$name = xtc_get_products_name($pID);
		$SQ = new products_quantity($pID);
		$query = xtc_db_query(sprintf(
			"SELECT products_price FROM products WHERE products_id='%s'",
			$pID
		));
		$record = xtc_db_fetch_array($query);
                $products_tax_class_id = yes_eu_oss_get_products_tax_class_id($pID, STORE_COUNTRY);
		$tax_rate = xtc_get_tax_rate($products_tax_class_id,STORE_COUNTRY);
		$price = number_format( $record['products_price']*(($tax_rate+100)/100) ,2,',','.');
		header('Content-Type: text/html; charset='.CHARSET);
		printf("%s\r\nPhys. %s Stk., V1: %s Stk., V2: %s Stk.\r\nBrutto Preis (%s): %s",
				$name,
				$SQ->get_products_total_qty(),
				$SQ->get_available1_qty(),
				$SQ->get_available2_qty(),
				xtc_get_country_name(STORE_COUNTRY),
				$price
		);
		exit;
		break;
	case 'search_product':
		$smarty->assign(array(
			'action'=>$action
		));
		$smarty->display('specials.html');
		exit;
		break;
	case 'check_special_exists':
		$pID = (int)xtc_db_input($_REQUEST['products_id']);
		$query = xtc_db_query(sprintf(
			"SELECT specials_id FROM %s WHERE products_id='%s'",
			TABLE_SPECIALS,$pID
		));
		if(xtc_db_num_rows($query))
			die('1');
		die('0');
		break;
	case 'multi_delete':
		if(!isset($_REQUEST['pID']) or !is_array($_REQUEST['pID'])){
			$messageStack->add_session(MSG_ERROR_NO_ITEMS,'error');
			xtc_redirect(xtc_href_link(FILENAME_SPECIALS));
		}
		foreach($_REQUEST['pID'] as $pID){
			$pID = (int)xtc_db_input($pID);
			$specials = array();
			$query = xtc_db_query(sprintf(
				"SELECT specials_id FROM %s WHERE products_id='%s'",
				TABLE_SPECIALS,$pID
			));
			while($record = xtc_db_fetch_array($query)){
				$specials[] = $record['specials_id'];
			}
			foreach($specials as $spID){
                            foreach(specials_ebay_revise::get_specials_ebay_revise_id_from_specials_id($spID) as $serID){
                                $ser = new specials_ebay_revise($serID);
                                if($ser->getIs_revised() == 1){
                                    $ser->update_status(1);
                                }else{
                                    $ser->delete();
                                }
                            }
                            
			}
			xtc_db_query(sprintf("DELETE FROM specials WHERE products_id=%s",$pID));
			$product = new product($pID);
			$product->add_history(HISTORY_SPECIAL_DELETED);
			
			$price = $xtPrice->xtcGetPrice($pID, $format = false, 1, $product->info['products_tax_class_id'], $product->info['products_price'],0,false);
		}
		$messageStack->add_session(sprintf(MSG_SUCCESS_MULTI_DELETE,sizeOf($_REQUEST['pID'])),'success');
		xtc_redirect(xtc_href_link(FILENAME_SPECIALS));
		break;
	  case 'add_multiple':
		if(!isset($_REQUEST['pID']) or !is_countable($_REQUEST['pID']) or !sizeOf($_REQUEST['pID'])){
			die(json_encode(array('message'=>JS_ERROR_NO_PRODUCTS,
                            'ERROR'=>1
                        )));
		}
		if(!isset($_REQUEST['specials_price']) or empty($_REQUEST['specials_price'])){
			die(json_encode(array(
				'message'=>JS_ERROR_NO_PRICE,
				'ERROR'=>1
			)));
		}
		//$sell_to_v1null = (isset($_REQUEST['sell_to_v1null']) and $_REQUEST['sell_to_v1null'] == 1) ? 1 : 0;
                // TICKET 2903 - FUNKTIONALITAET RAUS!
		$sell_to_v1null = 0;
		
		
		$ebay_price_revise = (isset($_REQUEST['ebay_price_revise']) and $_REQUEST['ebay_price_revise'] == 1) ? 1 : 0;
		//$ebay_price_revise = 0;
		
		
		
		if (isset($_REQUEST['specials_date'])) {
			$expires_date = xtc_db_input($_REQUEST['specials_date']);
		}
		if (isset($_REQUEST['specials_date_from'])) {
			$start_date = xtc_db_input($_REQUEST['specials_date_from']);
		}
		if($expires_date == '0000-00-00') $expires_date = '';
		if($start_date == '0000-00-00') $start_date = '';
		if( $start_date == '' and $expires_date == ''){
			die(json_encode(array(
				'message'=>JS_ERROR_DATE,
				'ERROR'=>1
			)));
		}
		if(!empty($start_date) and !isStringAValidDate($start_date)){
			die(json_encode(array(
				'message'=>JS_ERROR_DATE,
				'ERROR'=>1
			)));
		}
		if(!empty($expires_date) and !isStringAValidDate($expires_date)){
			die(json_encode(array(
				'message'=>JS_ERROR_DATE,
				'ERROR'=>1
			)));
		}
		if(!empty($expires_date)){
			$std = new DateTime($start_date);
			$end = new DateTime($expires_date);
			if($std->format('Y-m-d')>$end->format('Y-m-d')){
				die(json_encode(array(
					'message'=>JS_ERROR_DATE,
					'ERROR'=>1
				)));
			}
		}

		if($start_date != ''){
			$status = (strtotime($start_date) < time()) ? 1 : 0;
		}else{
			$status = 1;
		}
        $ebay_revise_error = '';
		foreach($_REQUEST['pID'] as $pID){
			xtc_db_query("DELETE FROM specials WHERE products_id=".(int)xtc_db_input($pID));
			// insert a product on special
			if (substr($_REQUEST['specials_price'], -1) == '%') {
				$new_special_insert_query = xtc_db_query("select products_id, products_price from " . TABLE_PRODUCTS . " where products_id = '" . (int)xtc_db_input($pID) . "'");
				$new_special_insert = xtc_db_fetch_array($new_special_insert_query);
				$_POST['products_price'] = $new_special_insert['products_price'];
				$new_specials_price = ($_POST['products_price'] - (($_REQUEST['specials_price'] / 100) * $_POST['products_price']));
			}  else {
                $_p = (float)str_replace(',','.',$_REQUEST['specials_price']);
				if (constant('PRICE_IS_BRUTTO')=='true'){
                                    $products_tax_class_id = yes_eu_oss_get_products_tax_class_id(
                                        xtc_db_input($pID), STORE_COUNTRY
                                    );
                                    $tax_rate = xtc_get_tax_rate($products_tax_class_id, STORE_COUNTRY);
                                    $new_specials_price = ($_p/($tax_rate+100)*100);
				}else{
                                    $new_specials_price = $_p;
				}
			}
			$product = new product((int)xtc_db_input($pID));
                        $current_ebay_price_revise = $ebay_price_revise;
                        // WENN ES NOCH EINTRAEGE IN specials_ebay_revise GIBT, DANN
                        // DARF KEIN NEUER EINTRAG ERZEUGT WERDEN. SOFERN DER USER ALSO
                        // ebay_revise SUBMITTED HAT, DARF K E I N DATENSATZ IN 
                        // specials_ebay_revise ERZEUGT WERDEN
                        if($current_ebay_price_revise == 1){
                            foreach($product->get_running_auctions_list() as $au){
                                $eaID = $au['id'];
				$serID_array = array();
				if($au['variation'] == 1){
				        $eaID = $au['id'];
					$ea = new ebay_auction($eaID);
					foreach($ea->getVariations() as $v){
						if($v->products_id == $pID){
					                $serID_array = specials_ebay_revise::get_specials_ebay_revise_ids_from_ebay_auction_id($eaID, $v->sku);
						}
					}
				}else{
			                $serID_array = specials_ebay_revise::get_specials_ebay_revise_ids_from_ebay_auction_id($eaID);
				}
                                if(sizeOf($serID_array)){
                                    $current_ebay_price_revise = 0;
                                }
                            }
                            if(!$current_ebay_price_revise){
                                $ebay_revise_error = TEXT_NOT_ALLOW_EBAY_REVISE;
                            }
                        }
			$insert_sql_array = array(
				'products_id'=>(int)xtc_db_input($pID), 
				/*'specials_quantity'=>xtc_db_input($_REQUEST['specials_quantity']), */
				'specials_new_products_price'=>xtc_db_input($new_specials_price), 
				'specials_date_added'=>'now()', 
				'expires_date'=>$expires_date, 
				'start_date'=>$start_date, 
				'status'=>$status,
				'sell_to_v1null'=>$sell_to_v1null,
				'ebay_price_revise'=>$current_ebay_price_revise
			);
			xtc_db_perform(TABLE_SPECIALS,$insert_sql_array);
            $spID = xtc_db_insert_id();
			$product->add_history(
				sprintf(HISTORY_SPECIAL_PRICE_ADDED,
						$_REQUEST['specials_price'],
						0
				)
			);
                        
			$revise_price_netto = $new_specials_price;
			$tax_rate = xtc_get_tax_rate($product->info['products_tax_class_id'],STORE_COUNTRY);
			$revise_price_brutto = ($revise_price_netto* ($tax_rate+100) /100);
                        
                        
			// BOF - EBAY REVISE
			if($status == 1 and $current_ebay_price_revise == 1){
                specials_ebay_revise::create_from_specials_id($spID, $revise_price_brutto);
			    $revise_products_id = (int)xtc_db_input($pID);
			}
			// EOF - EBAY REVISE
		}
		die(json_encode(array(
			'message'=>sprintf(JS_MESSAGE_MULTIPLE_SPECIALS_ADDED,sizeOf($_REQUEST['pID'])).$ebay_revise_error
		)));
		break;
	  case 'add_multiple_category_confirm':
?>
		<script type="text/javascript">
		$().ready(function(){
                    $('#add_button').click(function(){
                            $.ajax({
                                    url: $('form#add_multiple').attr('action'),
                                    dataType: 'json',
                                    data: $('form#add_multiple').serialize(),
                                    success: function(json_response){
										alert(json_response.message);
										if (json_response.hasOwnProperty('ERROR')) {
    									}else{
											window.location.href=window.location.href;
										}
                                    }
                            });
                    });
		});
		</script>
<?php
		$cID = (int)xtc_db_input($_REQUEST['cID']);
		$categories = array($cID);
		@yes_get_subcategories($categories, $cID);
		$query = xtc_db_query(sprintf(
                    "SELECT DISTINCT products_id FROM products_to_categories WHERE categories_id IN(%s)",
                    implode(',',$categories)
		));
		$hidden = '';
		$num = xtc_db_num_rows($query);
		while($record = xtc_db_fetch_array($query)){
                    $hidden .= xtc_draw_hidden_field('pID[]',$record['products_id']);
		}
		echo xtc_draw_form('add_multiple','specials.php','action=add_multiple','POST','id="add_multiple"').$hidden;
		echo '<p class="main" style="text-align:left">';
		printf('<b>%s</b><br /><br /><i>%s</i><br /><br />',TEXT_ADD_MULTIPLE_CATEGORY,TEXT_ADD_MULTIPLE_INTRO);
		printf('%s %s<br /><br />',TEXT_SPECIALS_SPECIAL_PRICE,xtc_draw_input_field('specials_price', '0%'));
		//printf('%s %s<br /><br />',TEXT_SPECIALS_SPECIAL_QUANTITY,xtc_draw_input_field('specials_quantity', 1));
		printf('%s: %s<br /><br />', TEXT_SPECIALS_START_DATE,xtc_draw_input_field('specials_date_from', date('Y-m-d'),'id="specials_date_from"',true,'date'));
		printf('%s: %s<br /><br />', TEXT_SPECIALS_EXPIRES_DATE,xtc_draw_input_field('specials_date', date('Y-m-d'),'id="specials_date"',true,'date'));
		printf('%s: %s<br /><br />', TEXT_SELL_TO_V1NULL,xtc_draw_checkbox_field('sell_to_v1null', '1',false));
		printf('%s: %s<br /><br />', TEXT_EBAY_PRICEUPDATE,xtc_draw_checkbox_field('ebay_price_revise', '1',false));
		printf('<input type="button" value="%s" id="add_button" /></form></p>',IMAGE_SAVE);
		exit;
		break;
	  case 'add_multiple_confirm':
?>
			<script type="text/javascript">
			<!--
			$().ready(function(){
					var pids_selected = new Array();
					pid_length = dom.elements['pID[]'].length;
					for(i=0;i<pid_length;i++){
						if(dom.elements['pID[]'][i].checked){
							pids_selected.push(dom.elements['pID[]'][i].value);
						}
					}
					// WORKAROUND NUR 1 PRODUKT
					if(pids_selected == ''){
						if(dom.elements['pID[]'].value && dom.elements['pID[]'].checked){
							pids_selected.push(dom.elements['pID[]'].value);
						}
					}
					var hidden_fields = '';
					for(i=0;i<pids_selected.length;i++){
						hidden_fields += '<input type="hidden" name="pID[]" value="'+pids_selected[i]+'" />';
					}
					$('form#add_multiple').append(hidden_fields);
					$('#add_button').click(function(){
						$.ajax({
							url: $('form#add_multiple').attr('action'),
							dataType: 'json',
							data: $('form#add_multiple').serialize(),
							success: function(json_response){
								alert(json_response.message);
								if (json_response.hasOwnProperty('ERROR')) {
								}else{
									window.location.href=window.location.href;
								}
							}
						});
					});
			});
			//-->
			</script>
<?php
			echo xtc_draw_form('add_multiple','specials.php','action=add_multiple','POST','id="add_multiple"');
			echo '<p class="main">';
			printf('<b>%s</b><br /><br /><i>%s</i><br /><br />',TEXT_ADD_MULTIPLE,TEXT_ADD_MULTIPLE_INTRO);
			printf('%s %s<br /><br />',TEXT_SPECIALS_SPECIAL_PRICE,xtc_draw_input_field('specials_price', '0%'));
			//printf('%s %s<br /><br />',TEXT_SPECIALS_SPECIAL_QUANTITY,xtc_draw_input_field('specials_quantity', 1));
			printf('%s: %s<br /><br />', TEXT_SPECIALS_START_DATE,xtc_draw_input_field('specials_date_from', date('Y-m-d'),'id="specials_date_from" min="'.date('Y-m-d').'"',false,'date'));
			printf('%s: %s<br /><br />', TEXT_SPECIALS_EXPIRES_DATE,xtc_draw_input_field('specials_date', date('Y-m-d'),'id="specials_date"',false,'date'));
			printf('%s: %s<br /><br />', TEXT_SELL_TO_V1NULL,xtc_draw_checkbox_field('sell_to_v1null', '1',false));
			printf('%s: %s<br /><br />', TEXT_EBAY_PRICEUPDATE,xtc_draw_checkbox_field('ebay_price_revise', '1',false));
			printf('<input type="button" value="%s" id="add_button" /></form></p>',IMAGE_SAVE);
			exit;
		  break;
	    case 'setflag':
		  xtc_set_specials_status($_GET['id'], $_GET['flag']);
		  xtc_redirect(xtc_href_link(FILENAME_SPECIALS, '', 'NONSSL'));
		  break;
	    case 'insert':
		$pID = (int)xtc_db_input($_REQUEST['products_id']);
		$query = xtc_db_query(sprintf(
			"SELECT specials_id FROM %s WHERE products_id='%s'",
			TABLE_SPECIALS,$pID
		));
		if(xtc_db_num_rows($query)){
			$messageStack->add_session(sprintf(MSG_ERROR_SPECIAL_PRODUCT_EXISTS,$pID),'error');
			xtc_redirect(xtc_href_link(FILENAME_SPECIALS));
		}
                
                $ebay_price_revise = (isset($_REQUEST['ebay_price_revise']) and $_REQUEST['ebay_price_revise'] == 1) ? 1 : 0;
                // WENN ES NOCH EINTRAEGE IN specials_ebay_revise GIBT, DANN
                // DARF KEIN NEUER EINTRAG ERZEUGT WERDEN. SOFERN DER USER ALSO
                // ebay_revise SUBMITTED HAT, DARF K E I N DATENSATZ IN 
                // specials_ebay_revise ERZEUGT WERDEN
                if($ebay_price_revise == 1){
                    $P = new product($pID);
                    foreach($P->get_running_auctions_list() as $au){
                        $eaID = $au['id'];
			if($au['variation'] == 1){
		                $eaID = $au['id'];
				$ea = new ebay_auction($eaID);
				foreach($ea->getVariations() as $v){
					if($v->products_id == $pID){
			                        $serID_array = specials_ebay_revise::get_specials_ebay_revise_ids_from_ebay_auction_id($eaID, $v->sku);
					}
				}
			}else{
	                        $serID_array = specials_ebay_revise::get_specials_ebay_revise_ids_from_ebay_auction_id($eaID);
			}
                        if(sizeOf($serID_array)){
                            $ebay_price_revise = false;
                        }
                    }
                    if(!$ebay_price_revise){
                        $messageStack->add_session(TEXT_NOT_ALLOW_EBAY_REVISE,'error');
                    }
                }
		// insert a product on special
		$expires_date = $_POST['datum'] ?? '';
		$start_date = $_POST['start_datum'] ?? '';
		if (isset($_POST['specials_date'])) {
                    $expires_date = xtc_db_input($_POST['specials_date']);
		}
		if (isset($_POST['specials_date_from'])) {
                    $start_date = xtc_db_input($_POST['specials_date_from']);
		}
                if($expires_date == '0000-00-00') {
                    $expires_date = '';
                }
                if($start_date == '0000-00-00') {
                    $start_date = '';
                }
                if( ($start_date != '' and $expires_date == '') or ($start_date == '' and $expires_date != '')){
                    $messageStack->add_session(MSG_ERROR_PRICE_TIMINGS_MISSING_START_OR_END_DATE,'error');
                    xtc_redirect(xtc_href_link(FILENAME_SPECIALS, 'page=' . $_GET['page']));
                }
		if (substr($_POST['specials_price'], -1) == '%') {
		  $new_special_insert_query = xtc_db_query("select products_id, products_price from " . TABLE_PRODUCTS . " where products_id = '" . (int)xtc_db_input($_POST['products_id']) . "'");
		  $new_special_insert = xtc_db_fetch_array($new_special_insert_query);
		  $_POST['products_price'] = $new_special_insert['products_price'];
		  $_POST['specials_price'] = ($_POST['products_price'] - (($_POST['specials_price'] / 100) * $_POST['products_price']));
		}  else {
		    $_POST['specials_price'] = str_replace(',','.',$_POST['specials_price']);
		    if( (float)$_POST['specials_price'] < 0.01){
			$messageStack->add_session(sprintf(MSG_ERROR_SPECIAL_PRICE_MUST_GREATER_THEN_NULL,xtc_db_input($_POST['products_id'])),'error');
		    }
                    if (PRICE_IS_BRUTTO=='true'){
                        $products_tax_class_id = yes_eu_oss_get_products_tax_class_id(
                            xtc_db_input($_POST['products_id']),STORE_COUNTRY
                        );
                        $tax_rate = xtc_get_tax_rate($products_tax_class_id, STORE_COUNTRY);
                        $_POST['specials_price'] = ( $_POST['specials_price'] /($tax_rate+100)*100);
                    }
                }
	       if($start_date != ''){
		    $status = (strtotime($start_date) < time()) ? 1 : 0;
	       }else{
                    $status = 1;
	       }
	       $sell_to_v1null = (isset($_REQUEST['sell_to_v1null']) and $_REQUEST['sell_to_v1null'] == 1) ? 1 : 0;
	       xtc_db_query("insert into " . TABLE_SPECIALS . " (products_id, specials_new_products_price, specials_date_added, expires_date, start_date, status,sell_to_v1null,ebay_price_revise) values ('" . xtc_db_input($_POST['products_id']) . "', '" . (float)xtc_db_input($_POST['specials_price']) . "', now(), '" . $expires_date . "', '" . $start_date . "', ".$status.",".$sell_to_v1null.",".$ebay_price_revise.")");
               $spID = xtc_db_insert_id();
               $P = new product($pID);
               $P->add_history(sprintf(PRODUCTS_HISTORY_SPECIAL_PRICE_ADDED,
                       xtc_db_input($_POST['specials_price']),
                       $expires_date,
                       $start_date,
                       $ebay_price_revise
               ));
               
               
               $revise_price_netto = xtc_db_input($_POST['specials_price']);
               $tax_rate = xtc_get_tax_rate($P->info['products_tax_class_id'],STORE_COUNTRY);
               $revise_price_brutto = ($revise_price_netto* ($tax_rate+100) /100);
               
            // BOF - EBAY REVISE
            if($status == 1 and $ebay_price_revise == 1){
                    $revise_products_id = $pID;
                    specials_ebay_revise::create_from_specials_id($spID, $revise_price_brutto);
                    // veraltet
                    //yes_add_price_revise_for_products_auctions($revise_products_id,$revise_price_brutto,$is_special=1);
            }
            // EOF - EBAY REVISE
            
            
	    if(isset($_REQUEST['from'])){
		xtc_redirect($_REQUEST['from']);
		    exit;
	    }
	    xtc_redirect(xtc_href_link(FILENAME_SPECIALS, 'page=' . $_GET['page']));
	    break;
	case 'json_insert':
		$pID = (int)xtc_db_input($_REQUEST['products_id']);
                $ebay_price_revise = (isset($_REQUEST['ebay_price_revise']) and $_REQUEST['ebay_price_revise'] == 1) ? 1 : 0;
                // WENN ES NOCH EINTRAEGE IN specials_ebay_revise GIBT, DANN
                // DARF KEIN NEUER EINTRAG ERZEUGT WERDEN. SOFERN DER USER ALSO
                // ebay_revise SUBMITTED HAT, MUSS DIESES IGNORIERT WERDEN
                if($ebay_price_revise == 1){
                    $P = new product($pID);
                    foreach($P->get_running_auctions_list() as $au){
                        $eaID = $au['id'];
			$serID_array = array();
			if($au['variation'] == 1){
		                $eaID = $au['id'];
				$ea = new ebay_auction($eaID);
				foreach($ea->getVariations() as $v){
					if($v->products_id == $pID){
			                        $serID_array = specials_ebay_revise::get_specials_ebay_revise_ids_from_ebay_auction_id($eaID, $v->sku);
					}
				}
			}else{
	                        $serID_array = specials_ebay_revise::get_specials_ebay_revise_ids_from_ebay_auction_id($eaID);
			}
                        if(sizeOf($serID_array)){
                            $ebay_price_revise = 0;
                        }
                    }
                    if(!$ebay_price_revise){
			die(json_encode(array(
                            'ERROR'=>TEXT_NOT_ALLOW_EBAY_REVISE
			)));
                    }
                }
		$query = xtc_db_query(sprintf(
			"SELECT specials_id FROM %s WHERE products_id='%s'",
			TABLE_SPECIALS,$pID
		));
		if(xtc_db_num_rows($query)){
			die(json_encode(array(
					'ERROR'=>'Es existiert bereits ein Sonderangebot zu diesem Artikel'
			)));
		}
		
		$expires_date = '';
		$start_date = '';
		if (isset($_REQUEST['datum'])) {
                    $expires_date = xtc_db_input($_REQUEST['datum']);
		}
		if (isset($_REQUEST['start_datum'])) {
                    $start_date = xtc_db_input($_REQUEST['start_datum']);
		}
		if($expires_date == '0000-00-00') {
                    $expires_date = '';
                }
		if($start_date == '0000-00-00') {
                    $start_date = '';
                }
		if( ($start_date != '' and $expires_date == '') or ($start_date == '' and $expires_date != '')){
                    die(json_encode(array(
                        'ERROR'=>MSG_ERROR_PRICE_TIMINGS_MISSING_START_OR_END_DATE,
                    )));
		}
		// insert a product on special
		$_REQUEST['specials_price'] = str_replace(',','.',$_REQUEST['specials_price']);
		$sp_error = false;
		if (substr($_REQUEST['specials_price'], -1) == '%') {
                    $new_special_insert_query = xtc_db_query("select products_id, products_price from " . TABLE_PRODUCTS . " where products_id = '" . (int)xtc_db_input($_REQUEST['products_id']) . "'");
                    $new_special_insert = xtc_db_fetch_array($new_special_insert_query);
                    $_REQUEST['products_price'] = $new_special_insert['products_price'];
                    $_REQUEST['specials_price'] = ($_REQUEST['products_price'] - (($_REQUEST['products_price'] / 100) * str_replace('%','',$_REQUEST['specials_price']) ));
		}  else {
                    if (PRICE_IS_BRUTTO=='true'){
                        $products_tax_class_id = yes_eu_oss_get_products_tax_class_id(
                            (int)xtc_db_input($_REQUEST['products_id']),
                            STORE_COUNTRY
                        );
                        $tax_rate = xtc_get_tax_rate($products_tax_class_id, STORE_COUNTRY);
                        $_REQUEST['specials_price'] = ($_REQUEST['specials_price']/($tax_rate+100)*100);
                    }
                    if((float)$_REQUEST['specials_price'] < 0.01){
                        $sp_error = true;
                    }
		}
                
		if($start_date != ''){
                    $status = (strtotime($start_date) < time()) ? 1 : 0;
		}else{
                     $status = 1;
		}
		$sell_to_v1null = (isset($_REQUEST['sell_to_v1null']) and $_REQUEST['sell_to_v1null'] == 1) ? 1 : 0;
		$ebay_price_revise = (isset($_REQUEST['ebay_price_revise']) and $_REQUEST['ebay_price_revise'] == 1) ? 1 : 0;
		//$ebay_price_revise = 0;
		xtc_db_query("insert into " . TABLE_SPECIALS . " (products_id, specials_new_products_price, specials_date_added, expires_date, start_date, status,sell_to_v1null,ebay_price_revise) values ('" . xtc_db_input($_REQUEST['products_id']) . "', '" . (float)xtc_db_input($_REQUEST['specials_price']) . "', now(), '" . $expires_date . "', '" . $start_date . "', ".$status.", ".$sell_to_v1null.",".$ebay_price_revise.")");
		$spID = xtc_db_insert_id();
                $P = new product($pID);
                $P->add_history(sprintf(PRODUCTS_HISTORY_SPECIAL_PRICE_ADDED,
                    xtc_db_input($_REQUEST['specials_price']),
                    $expires_date,
                    $start_date,
                    $ebay_price_revise
                ));
               
                $tax_rate = xtc_get_tax_rate($P->info['products_tax_class_id'],STORE_COUNTRY);
                $revise_price_netto = xtc_db_input($_REQUEST['specials_price']);
                $revise_price_brutto = ($revise_price_netto* ($tax_rate+100) /100);
                
		// BOF - EBAY REVISE
		if($status == 1 and $ebay_price_revise == 1){
                    $revise_products_id = xtc_db_input($pID);
                    specials_ebay_revise::create_from_specials_id($spID,$revise_price_brutto);
		}
		// EOF - EBAY REVISE
                
		$msg = MSG_SUCCESS_SAVED;
		if($sp_error){
                    $msg .= " / ".sprintf(MSG_ERROR_SPECIAL_PRICE_MUST_GREATER_THEN_NULL,$pID);
		}
		die(json_encode(array(
                    'MSG'=>$msg
		)));
		break;
	    case 'update':
		// update a product on special
		$pID = (int)xtc_db_input($_REQUEST['products_id']);
                
                $ebay_price_revise = (isset($_REQUEST['ebay_price_revise']) and $_REQUEST['ebay_price_revise'] == 1) ? 1 : 0;
                // WENN ES NOCH EINTRAEGE IN specials_ebay_revise GIBT, DANN
                // DARF KEIN NEUER EINTRAG ERZEUGT WERDEN. SOFERN DER USER ALSO
                // ebay_revise SUBMITTED HAT, MUSS DIESES IGNORIERT WERDEN
                $P = new product($pID);
                if($ebay_price_revise == 1){
                    foreach($P->get_running_auctions_list() as $au){
			$serID_array = array();
			if($au['variation'] == 1){
		                $eaID = $au['id'];
				$ea = new ebay_auction($eaID);
				foreach($ea->getVariations() as $v){
					if($v->products_id == $pID){
			                        $serID_array = specials_ebay_revise::get_specials_ebay_revise_ids_from_ebay_auction_id($eaID, $v->sku);
					}
				}
			}else{
	                        $serID_array = specials_ebay_revise::get_specials_ebay_revise_ids_from_ebay_auction_id($eaID);
			}
                        if(sizeOf($serID_array)){
                            $ebay_price_revise = 0;
                        }
                    }
                    if(!$ebay_price_revise){
                        $messageStack->add_session(TEXT_NOT_ALLOW_EBAY_REVISE,'error');
                    }
                }
                
                
		$specials_price = str_replace(',','.',xtc_db_input($_POST['specials_price']));
                $error = false;
		if (PRICE_IS_BRUTTO=='true' && substr($specials_price, -1) != '%'){
		    if( $specials_price < 0.01){
			$messageStack->add_session(sprintf(MSG_ERROR_SPECIAL_PRICE_MUST_GREATER_THEN_NULL,xtc_db_input($_POST['products_id'])),'error');
                        $error = true;
		    }
                    $products_tax_class_id = yes_eu_oss_get_products_tax_class_id(
                        $pID, STORE_COUNTRY
                    );
                    $tax_rate = xtc_get_tax_rate($products_tax_class_id,STORE_COUNTRY);
		    $specials_price = ( $specials_price/($tax_rate+100)*100);
		}

		if (substr($specials_price, -1) == '%')  {
                        $specials_price_value = substr($specials_price,0,-1);
                        if( $specials_price_value < 0.01){
                            $messageStack->add_session(sprintf(MSG_ERROR_SPECIAL_PRICE_MUST_GREATER_THEN_NULL,xtc_db_input($_POST['products_id'])),'error');
                            $error = true;
                        }
			$special_update_query = xtc_db_query(sprintf(
                                "select products_id, products_price from %s where products_id = '%s'",
                                TABLE_PRODUCTS,
                                (int)xtc_db_input($_POST['products_id'])
                        ));
			$special_update = xtc_db_fetch_array($special_update_query);
			$_REQUEST['products_price'] = $special_update['products_price'];
			$_REQUEST['specials_price'] = ($_REQUEST['products_price'] - (($_REQUEST['products_price'] / 100) *  $specials_price_value));
                        $specials_price = $_REQUEST['specials_price'];
		}
		$expires_date = '';
		if (isset($_REQUEST['datum'])) {
			$expires_date = $_REQUEST['datum'];
		}
		$start_date = '';
		if (isset($_REQUEST['start_datum'])) {
                    $start_date = $_REQUEST['start_datum'];
		}
		if($expires_date == '0000-00-00') {
                    $expires_date = '';
                }
		if($start_date == '0000-00-00') {
                    $start_date = '';
                }
		if( ($start_date != '' and $expires_date == '') or ($start_date == '' and $expires_date != '')){
                    $messageStack->add_session(MSG_ERROR_PRICE_TIMINGS_MISSING_START_OR_END_DATE,'error');
                    xtc_redirect(xtc_href_link(FILENAME_SPECIALS, 'page=' . $_GET['page']));
		}
		$sell_to_v1null = (isset($_REQUEST['sell_to_v1null']) and $_REQUEST['sell_to_v1null'] == 1) ? 1 : 0;
		
		
		$original_data = xtc_db_query(sprintf(
                    "SELECT * FROM %s WHERE specials_id='%s'",
                    TABLE_SPECIALS,
                    xtc_db_input($_REQUEST['specials_id'])
		));
		$original = xtc_db_fetch_array($original_data);
                if(!$error){
                    $update_sql_array = array(
                        'specials_new_products_price'=>$specials_price, 
                        'specials_last_modified'=> 'now()', 
                        'expires_date' => $expires_date, 
                        'start_date' => $start_date,
                        'sell_to_v1null' => $sell_to_v1null,
                        'ebay_price_revise'=>$ebay_price_revise
                    );
                    xtc_db_perform(TABLE_SPECIALS,$update_sql_array,'update', "specials_id='" . (int)xtc_db_input($_REQUEST['specials_id']) . "'");

                    // BOF - EBAY REVISE
                    if($start_date != ''){
                        $status = (strtotime($start_date) < time()) ? 1 : 0;
                    }else{
                        $status = 1;
                    }
                    
                    if($status == 1){
                        $revise_products_id = xtc_db_input($_REQUEST['products_id']);
                        $revise_price_netto = $specials_price;
                        $tax_rate = xtc_get_tax_rate($P->info['products_tax_class_id'],STORE_COUNTRY);
                        $revise_price_brutto = ($revise_price_netto* ($tax_rate+100) /100);
                    }
                    
                    if($original['ebay_price_revise'] == 1 and $ebay_price_revise == 0){
                        // VORHANDENE REVISES ENTFERNEN
                        // kommt nicht vor, da das bearbeiten gesperrt ist
                    }else if($original['ebay_price_revise'] == 0 and $ebay_price_revise == 1){
                            // einfuegen -> sofern datum etc
                            if($status == 1){
                                    specials_ebay_revise::create_from_specials_id((int)xtc_db_input($_REQUEST['specials_id']), $revise_price_brutto);
                                    // veraltet
                                    //yes_add_price_revise_for_products_auctions($revise_products_id,$revise_price_brutto,1);
                            }

                    }else if($original['ebay_price_revise'] == 1 and $ebay_price_revise == 1){
                    }
                    // EOF - EBAY REVISE
                } // end if no error
		
		if(isset($_REQUEST['from'])){
			xtc_redirect($_REQUEST['from']);
		}
		xtc_redirect(xtc_href_link(FILENAME_SPECIALS, xtc_get_all_get_params(array('action'))));
		break;
	    case 'deleteconfirm':
		$specials_id = (int)xtc_db_input($_GET['sID']);
                // BOF specials_ebay_revise
                foreach(specials_ebay_revise::get_specials_ebay_revise_id_from_specials_id($specials_id) as $serID){
                    $ser = new specials_ebay_revise($serID);
                    if($ser->getIs_revised() == 1){
                        // VOM CRONJOB AUF ALTEN PREIS SETZEN LASSEN
                        $ser->update_status(1);
                    }else{
                        $ser->delete();
                    }
                }
                // EOF specials_ebay_revise
		$query = xtc_db_query(sprintf(
			"SELECT products_id FROM specials WHERE specials_id='%s'",
			$specials_id
		));
		$record = xtc_db_fetch_array($query);
		$pID = $record['products_id'];
		xtc_db_query(sprintf("UPDATE specials_ebay_revise SET status=1 WHERE specials_id='%s'",
			$specials_id
		));
		xtc_db_query("delete from " . TABLE_SPECIALS . " where specials_id = '" . $specials_id . "'");
		if($pID > 0){
			$products_query = xtc_db_query(sprintf(
				"SELECT products_price FROM products WHERE products_id='%d'",
				$pID
			));
			$products_record = xtc_db_fetch_array($products_query);
                        $products_tax_class_id = yes_eu_oss_get_products_tax_class_id(
                            $pID, STORE_COUNTRY
                        );
			$price = $xtPrice->xtcGetPrice($pID, $format = false, 1, $products_tax_class_id, $products_record['products_price'],0,false);
                        // VORHANDENE specials_ebay_revise EINTRAEGE LOESCHEN                        
                        foreach(specials_ebay_revise::get_reviseable_auctions($specials_id) as $ra){
                            if($ra['variation'] == 1){ //id, type, ebay_id,eav.quantity,title,1 as variation
                                specials_ebay_revise::delete_entry($ra['ebay_id'], $sku);
                            }else{
                                specials_ebay_revise::delete_entry($ra['ebay_id'], '');
                            }
                        }
//veraltet                        
//			yes_remove_price_revise_for_products_auctions($pID, $price);
		}
		xtc_redirect(xtc_href_link(FILENAME_SPECIALS, 'page=' . $_GET['page']));
		break;
	case 'json_delete':
            // HIER DAS SELBE specials_ebay_revise HANDLING WIE BEI deleteconfirm            
            $pID = (int)xtc_db_prepare_input($_REQUEST['products_id']??0);
            if($pID < 1){
                die(json_encode([
                    'ERROR'=>'missing parameter for specials json_delete',
                    'MSG'=>''
                ]));
            }
            $specials = array();
            $query = xtc_db_query(sprintf(
                "SELECT specials_id FROM %s WHERE products_id='%d'",
                TABLE_SPECIALS, $pID
            ));
            while($record = xtc_db_fetch_array($query)){
                $specials[] = $record['specials_id'];
            }
            foreach($specials as $spID){
                // BOF specials_ebay_revise
                foreach(specials_ebay_revise::get_specials_ebay_revise_id_from_specials_id($specials_id) as $serID){
                    $ser = new specials_ebay_revise($serID);
                    if($ser->getIs_revised() == 1){
                        // VOM CRONJOB AUF ALTEN PREIS SETZEN LASSEN
                        $ser->update_status(1);
                    }else{
                        $ser->delete();
                    }
                }
                // EOF specials_ebay_revise
            }
            xtc_db_query(sprintf(
                "DELETE FROM %s WHERE products_id = '%d'",
                TABLE_SPECIALS, $pID
            ));
            die(json_encode(array(
                'MSG'=>MSG_SUCCESS_DELETED
            )));
            break;
}
$smarty->assign(array(
	'JS_REALLY_DELETE_ITEMS'=>JS_REALLY_DELETE_ITEMS,
	'FORM_END'=>'</form>'
));
yes_draw_pre_header();
yes_draw_header(TITLE);
?>
<script type="text/javascript" src="minify_js.php?file=includes/general.js"></script>

<script type="text/javascript">
<!--
function multi_actionhandler(select_element){
	switch(select_element.value){
		case 'multi_delete':
			yes = confirm('<?php echo JS_REALLY_DELETE_ITEMS; ?>');
			if(yes){
				document.forms['specials'].submit();
			}
			break;
	}
	select_element.value = '';
}
//-->
</script>
<!-- header //-->
<?php 
if (!isset($_GET['action'])) {
    $buttons[] = array('text'=>IMAGE_NEW_PRODUCT,
	'link'=>xtc_href_link(FILENAME_SPECIALS, 'page=' . ((isset($_GET['page']))?$_GET['page']:1) . '&action=new'),
	'lbOn'=>false,
	'auth'=>true
    );
    $buttons[] = array(
        'text'=>BUTTON_PRICE_TIMINGS,
        'link'=>xtc_href_link('products.php', 'action=price_timings'),
        'lbOn'=>false,
        'auth'=>true
    );
}
$smarty->assign(array(
    'HEADING_TITLE'=>HEADING_TITLE,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons
));
switch($action){
    case 'new':
	$smarty->assign('ADDITIONAL_TITLE',TEXT_ADD_SPECIAL);
	break;
}
$smarty->assign('action','show_header');
$smarty->display('specials.html');
$smarty->assign('action',$action);

?>
<style type="text/css">
#ebay_revise_sync_refresh a{
	border: 1px solid #000;
	display: inline-block;
	text-decoration: none;
	padding: 2px;
	margin: 0;
}
#ebay_revise_sync_refresh{
	padding: 5px;
	border: 1px dashed #777;
	color: #777;
}
.category_select_div{
	display: inline-block;
}
</style>
<br clear="all" />
<script>
var IS_ADMIN = '<?php if($_SESSION['customer_id'] == 1){ echo '1'; }else{ echo '0'; } ?>';
function toggle_category_select_div(){
	$('.category_select_div').toggle();
}
$(function(){
    $('table#specials_listing tbody tr').each(function(){
        var currentSID = $(this).attr('id').replace('sltr-','');
        $(this).children('td.clickable').on('click',function(){
            window.location.href = '<?php echo xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('sID')).'sID='); ?>'+currentSID;
        });
    });
    $('img.no_special_ebay_revise').css('opacity',0.5).css('filter','alpha(opacity=50)');
    $('#convert_path').on('click',function(){
        var id = $('form[name="jump"] input[name="categories_id"]').val();
        $.ajax({
            url:'specials.php?action=get_cpath_from_categories_id&id='+id,
            success: function(response){
                window.location.href='specials.php?cPath='+response;
            }
        });
    });
});
</script>
<?php if (!isset($_GET['action'])) {?>
            <div style="display:flex;">
                <div>
                    <?php echo xtc_draw_form('search','specials.php','','GET','class="yesForm"'); ?>
                    <fieldset>
                    <legend><?php echo TEXT_STATS_STATUS_FILTER; ?></legend>
                        Suchbegriff</b>&nbsp;
                        <?php echo xtc_draw_input_field('searchword',((isset($_GET['searchword']))?$_GET['searchword']:''),'maxlength="32"'); ?>
                        <?php echo xtc_draw_radio_field('mode','pname',((!isset($_GET['mode']) or $_GET['mode'] == 'pname')?true:false)); ?> Produktname oder 
                        <?php echo xtc_draw_radio_field('mode','pid',((isset($_GET['mode']) and $_GET['mode'] == 'pid')?true:false)); ?> pID 
                        <input type="submit" class="ui-button ui-corner-all ui-state-default" value="<?php echo IMAGE_SEARCH; ?>" title="<?php echo IMAGE_SEARCH; ?>" />
                    </fieldset>
                    <?php echo '</form>'; ?>

                    <?php
                    $selected_categories_id = '';
                    if(isset($_REQUEST['cPath'])){
                            echo '<div class="main">'.TEXT_SELECTED_CATEGORY.' ';
                            $parts = explode('_',$_REQUEST['cPath']);
                            foreach($parts as $nr => $cID){
                                    echo xtc_get_categories_name($cID);
                                    if($nr < sizeOf($parts)-1){
                                            echo ' &raquo; ';
                                    }
                                    $selected_categories_id = $cID; // so haben wir am ende die gewaehlte cID
                            }
                            printf('&nbsp;<a href="%s"><img src="images/minus.gif" border="0" alt="%s" title="%s"></a>',
                                            xtc_href_link('specials.php',xtc_get_all_get_params(array('cPath'))),
                                            LINK_TITLE_REMOVE_CPATH,LINK_TITLE_REMOVE_CPATH
                            );
                            echo '</div>';
                    }
                    ?>
                </div>
                <div>
                    <?php echo xtc_draw_form('jump','specials.php','','GET'); ?>
                    <fieldset>
                    <legend><?php echo LINK_TITLE_SELECT_CATEGORY; ?></legend>
					<a href="javascript:toggle_category_select_div()"><?php echo TEXT_VIEW.'/Verbergen'; ?></a>
					<div class="category_select_div" style="display: none;">
                    <?php 
					$cat_select = \YES4Trade\Model\category::get_categories_tree_select([
						'return_function'=>sprintf('$(\'input[name="categories_id"]\').val(id);'),
						'ALL_ITEMS_SELECTABLE'=>'false'
					], new \yesSmarty());

					echo $cat_select
						. '<br />Category ID'
						. xtc_draw_input_field('categories_id',$_GET['categories_id']??'','size="8"',false,'number');
					?>
					</div>
                    <input id="convert_path" type="button" value="Auswahl" class="ui-button ui-corner-all ui-state-default" />
                    </form>
                </div>
            </div>
<?php } ?>

<table border="0" width="100%" cellspacing="2" cellpadding="2">
<?php
if ( isset($_GET['action']) and (($_GET['action'] == 'new') || ($_GET['action'] == 'edit') )) {
	$form_action = 'insert';
	if ( ($_GET['action'] == 'edit') && isset($_GET['sID']) ) {
            $specials_id = (isset($_GET['sID'])) ? (int)xtc_db_input($_GET['sID']) : -1;
            $form_action = 'update';
            $product_query = xtc_db_query("select p.products_id,
                pd.products_name,
                p.products_tax_class_id,
                p.products_price,
                s.specials_quantity,
                s.specials_new_products_price,
                s.ebay_price_revise,
                s.expires_date,s.start_date,s.sell_to_v1null from
                " . TABLE_PRODUCTS . " p,
                " . TABLE_PRODUCTS_DESCRIPTION . " pd,
                " . TABLE_SPECIALS . "
                s where p.products_id = pd.products_id
                and pd.language_id = '" . (int)$_SESSION['languages_id'] . "'
                and p.products_id = s.products_id
                and s.specials_id = '" . $specials_id . "' LIMIT 500");
            $product = xtc_db_fetch_array($product_query);
            $product['price'] = $xtPrice->xtcFormat($product['products_price'],true);
            if (PRICE_IS_BRUTTO=='true'){
                $products_tax_class_id = yes_eu_oss_get_products_tax_class_id(
                    $product['products_id'],
                    STORE_COUNTRY
                );
                $tax_rate = xtc_get_tax_rate($products_tax_class_id,STORE_COUNTRY);
                $price_netto=xtc_round($product['price'],PRICE_PRECISION);
                $new_price_netto=xtc_round($product['specials_new_products_price'],PRICE_PRECISION);
                $product['price'] = $xtPrice->xtcFormat( $product['products_price']*($tax_rate+100)/100,true);
                $new_price= ($new_price_netto*($tax_rate+100)/100);
            }
            $new_price=xtc_round($new_price,PRICE_PRECISION);
            $smarty->assign('new_price',$new_price);
            $sInfo = (object)$product;
            $smarty->assign('sInfo',$product);
	} else {
		$new_price = '0.00';
		$smarty->assign('new_price',$new_price);
		$sInfo = array(
			/*'specials_quantity'=>'0',*/
			'start_date'=>'',
			'expires_date'=>'',
			'sell_to_v1null'=>false,
			'ebay_price_revise'=>false
		);
		$smarty->assign('sInfo',$sInfo);
		$sInfo = (object)$sInfo;
	}
	$smarty->assign(array(
		'FORM'=>xtc_draw_form('new_special',FILENAME_SPECIALS, xtc_get_all_get_params(array('action', 'info', 'sID')) . 'action=' . $form_action,'POST','id="new_special"'),
		'INPUT_SID'=>(($form_action == 'update')?xtc_draw_hidden_field('specials_id', $_GET['sID']):''),
		'TEXT_SPECIALS_PRODUCT'=>TEXT_SPECIALS_PRODUCT,
		'INPUT_PID'=>((isset($sInfo->products_id)) ? xtc_draw_hidden_field('products_id',$sInfo->products_id) : ''),
		'TEXT_SPECIALS_SPECIAL_PRICE'=>TEXT_SPECIALS_SPECIAL_PRICE,
		'INPUT_SPECIALS_PRICE'=>xtc_draw_input_field('specials_price', $new_price),
		'TEXT_SPECIALS_SPECIAL_QUANTITY'=>TEXT_SPECIALS_SPECIAL_QUANTITY,
		/*'INPUT_SPECIALS_SPECIAL_QUANTITY'=>xtc_draw_input_field('specials_quantity', $sInfo->specials_quantity),*/
		'TEXT_SPECIALS_START_DATE'=>TEXT_SPECIALS_START_DATE,
		'INPUT_SPECIALS_START_DATE'=>xtc_draw_input_field('start_datum', substr($sInfo->start_date,0,10),'id="start_datum"',false,'date'),
		'TEXT_SPECIALS_EXPIRES_DATE'=>TEXT_SPECIALS_EXPIRES_DATE,
		'INPUT_SPECIALS_EXPIRES_DATE'=>xtc_draw_input_field('datum', substr($sInfo->expires_date,0,10),'id="datum"',false,'date'),
		/*'TEXT_SELL_TO_V1NULL'=>TEXT_SELL_TO_V1NULL,
		'INPUT_SELL_TO_V1NULL'=>xtc_draw_checkbox_field('sell_to_v1null', '1', $sInfo->sell_to_v1null),*/
		'TEXT_SPECIALS_PRICE_TIP'=>TEXT_SPECIALS_PRICE_TIP,
		'INPUT_SAVE'=>yes_draw_href_button( ($form_action == 'insert') ? IMAGE_INSERT : IMAGE_UPDATE,'javascript:check_special()'),
		'INPUT_CANCEL'=>yes_draw_href_button(IMAGE_CANCEL,xtc_href_link(FILENAME_SPECIALS, 'page=' . $_GET['page'] . '&sID=' . ((isset($_GET['sID']))?$_GET['sID']:''))),
		'JS_ERROR_PRODUCTS_HAS_SPECIAL'=>JS_ERROR_PRODUCTS_HAS_SPECIAL,
		'LINK_SEARCH_PRODUCT'=>xtc_href_link(FILENAME_SPECIALS,'action=search_product'),
		'TEXT_EBAY_PRICEUPDATE'=>TEXT_EBAY_PRICEUPDATE,
		'INPUT_EBAY_PRICEUPDATE'=>xtc_draw_checkbox_field('ebay_price_revise',1,$sInfo->ebay_price_revise),
		'TEXT_STATS_STATUS_FILTER'=>TEXT_STATS_STATUS_FILTER,
	));
	$smarty->display('specials.html');
} else { // end if edit or new
	$categories = array();
	if($selected_categories_id != ''){
		$categories[] = $selected_categories_id;
		@yes_get_subcategories($categories, $selected_categories_id);
	}
	$from_sql = sprintf(
		' %s s,%s p, %s pd',
		TABLE_SPECIALS,TABLE_PRODUCTS,TABLE_PRODUCTS_DESCRIPTION
	);
	
	if(sizeOf($categories)){
		$from_sql .= sprintf(', %s p2c ',TABLE_PRODUCTS_TO_CATEGORIES);
	}
	
	$where_sql = sprintf(
		"p.products_id=s.products_id and pd.products_id=p.products_id and pd.language_id = %s",
		$_SESSION['languages_id']
	);
	if(sizeOf($categories)){
		$where_sql .= sprintf(' and p2c.products_id=p.products_id and p2c.categories_id IN(%s) ',
			implode(',',$categories)
		);
	}
    if(isset($_GET['searchword']) and xtc_not_null($_GET['searchword'])){
    	$specials_query_raw = "select p.products_id, pd.products_name, p.products_price, s.specials_id, s.specials_new_products_price, s.specials_date_added, s.specials_last_modified, s.expires_date, s.start_date, s.date_status_change, s.status,s.sell_to_v1null,s.ebay_price_revise from $from_sql where $where_sql ";
		if(isset($_REQUEST['mode'])){
			switch($_GET['mode']){
				case 'pid':
					$specials_query_raw .= " and p.products_id='".xtc_db_input($_GET['searchword'])."' ";
					break;
				default:
					$specials_query_raw .= " and (p.products_model LIKE '%".xtc_db_input($_GET['searchword'])."%' or pd.products_name LIKE '%".xtc_db_input($_GET['searchword'])."%') ";
					break;
			}
		}
		$specials_query_raw .= " order by pd.products_name";
    }else{
	    $specials_query_raw = "select p.products_id, pd.products_name, p.products_price, s.specials_id, s.specials_new_products_price, s.specials_date_added, s.specials_last_modified, s.expires_date, s.start_date, s.date_status_change, s.status,s.sell_to_v1null,s.ebay_price_revise from $from_sql where $where_sql order by pd.products_name";
    }

    $specials_split = new splitPageResults($_GET['page'], MAX_DISPLAY_SEARCH_RESULTS, $specials_query_raw, $specials_query_numrows);
?>

<tr>
	<td>
		<form name="specials" id="specials" action="<?php echo xtc_href_link(FILENAME_SPECIALS); ?>" method="post">
		<table border="0" width="100%" cellspacing="2" cellpadding="0">
		<tr>
			<td valign="top" class="ui-widget-content">
				<table class="yes-ui-table" id="specials_listing">
					<thead>
						<tr class="ui-widget-header">
							<th>pID</th>
							<th><?php echo TABLE_HEADING_PRODUCTS; ?></th>
							<th align="right"><?php echo TABLE_HEADING_PRODUCTS_PRICE; ?></th>
							<th align="right"><?php echo TABLE_HEADING_STATUS; ?></th>
						</tr>
					</thead>
					<tfoot>
						<tr>
							<td colspan="5" align="left">
								<a href="javascript:checkbox_check('specials','pID[]',true)"><?php echo TEXT_SELECT_ALL; ?></a>
								&nbsp;
								<a href="javascript:checkbox_check('specials','pID[]',false)"><?php echo TEXT_UNSELECT_ALL; ?></a>
								&nbsp;
								<select name="action" onchange="multi_actionhandler(this)">
								<option value=""><?php echo TEXT_SELECT; ?></option>
								<option value="multi_delete"><?php echo IMAGE_DELETE; ?></option>
								</select>
							</td>
							</tr>
							<tr>
								<td colspan="5" align="center">
								<?php echo $specials_split->display_count($specials_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, $_GET['page'], TEXT_DISPLAY_NUMBER_OF_SPECIALS); ?></td>
							</tr><tr>
								<td colspan="5" align="center">
								<?php echo $specials_split->display_links($specials_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, MAX_DISPLAY_PAGE_LINKS, $_GET['page']); ?>
								</td>
							</tr>
					</tfoot>
					<tbody>
<?php
    $specials_query = xtc_db_query($specials_query_raw);
    while ($specials = xtc_db_fetch_array($specials_query)) {
        $products_tax_class_id = yes_eu_oss_get_products_tax_class_id(
            $specials['products_id'], STORE_COUNTRY
        );
        $tax_rate = xtc_get_tax_rate($products_tax_class_id, STORE_COUNTRY);
	if(PRICE_IS_BRUTTO == 'true'){
	    $specials['products_price'] = $xtPrice->xtcAddTax($specials['products_price'], $tax_rate);
	    $specials['specials_new_products_price'] = $xtPrice->xtcAddTax($specials['specials_new_products_price'], $tax_rate);
	}
      if ( ((!isset($_GET['sID'])) || (isset($_GET['sID']) and $_GET['sID'] == $specials['specials_id'])) && (!isset($sInfo)) ) {
        $products_query = xtc_db_query("select products_image from " . TABLE_PRODUCTS . " where products_id = '" . $specials['products_id'] . "'");
        $products = xtc_db_fetch_array($products_query);
        $sInfo_array = xtc_array_merge($specials, $products);
        $sInfo = new objectInfo($sInfo_array);
	$selected = true;
        
        // WENN ES SYNCHRONISIERTE EBAY AUKTIONEN GIBT, ZU DIESEM specials
        // EINTRAG, DANN KEINE BEARBEITUNG ZULASSEN
        $sInfo->allow_edit = true;
        if($specials['ebay_price_revise'] == 1){
            $ser_array = specials_ebay_revise::get_specials_ebay_revise_id_from_specials_id($specials['specials_id']);
            if(sizeOf($ser_array)){
                $sInfo->allow_edit = false;
            }
        }
        
        
        
      }else{
	  $selected = false;
      }
      
?>
				<tr<?php echo ($selected) ? ' class="ui-state-highlight"' : ''; ?> id="sltr-<?php echo $specials['specials_id']; ?>">
					<td  ><input type="checkbox" name="pID[]" value="<?php echo $specials['products_id']; ?>" /><?php echo $specials['products_id']; ?></td>
					<td class="clickable">
						<?php if($specials['ebay_price_revise'] == 1){
							$ser_array = specials_ebay_revise::get_specials_ebay_revise_id_from_specials_id($specials['specials_id']);
							if(sizeOf($ser_array)){
								$ser_variations = 0;
								$ser_auctions = 0;
								foreach($ser_array as $serID){
									$ser = new specials_ebay_revise($serID);
									if($ser->getSku() != ''){
										$ser_variations++;
									}else{
										$ser_auctions++;
									}
								}
								$ebay_img = xtc_image("images/ebay_category.gif", sprintf(TEXT_EBAY_PRICEUPATE,
									$ser_auctions,
									$ser_variations
								));
							}else{
								$ebay_img = xtc_image("images/ebay_category.gif", TEXT_EBAY_PRICEUPATE_NO_SPECIAL_EBAY_REVISE, '','','class="no_special_ebay_revise"');
							}
							echo $ebay_img;
						} 
						?>
						<?php echo $specials['products_name']; ?>
					</td>
					<td class="clickable" align="right"><span class="oldPrice"><?php echo $xtPrice->xtcFormat($specials['products_price'],true); ?></span> <span class="specialPrice"><?php echo $xtPrice->xtcFormat($specials['specials_new_products_price'],true); ?></span></td>
					<td class="clickable" align="right">
<?php
      if ($specials['status'] == '1') {
        echo xtc_image(DIR_WS_IMAGES . 'icon_status_green.gif', IMAGE_ICON_STATUS_GREEN, 10, 10) . '&nbsp;&nbsp;<a href="' . xtc_href_link(FILENAME_SPECIALS, 'action=setflag&flag=0&id=' . $specials['specials_id'], 'NONSSL') . '">' . xtc_image(DIR_WS_IMAGES . 'icon_status_red_light.gif', IMAGE_ICON_STATUS_RED_LIGHT, 10, 10) . '</a>';
      } else {
        echo '<a href="' . xtc_href_link(FILENAME_SPECIALS, 'action=setflag&flag=1&id=' . $specials['specials_id'], 'NONSSL') . '">' . xtc_image(DIR_WS_IMAGES . 'icon_status_green_light.gif', IMAGE_ICON_STATUS_GREEN_LIGHT, 10, 10) . '</a>&nbsp;&nbsp;' . xtc_image(DIR_WS_IMAGES . 'icon_status_red.gif', IMAGE_ICON_STATUS_RED, 10, 10);
      }
?></td>
				</tr>
      </tr>
<?php
    }
?>
			</tbody>
        </table>
	</form>
	</td>
<?php
	$heading = array();
	$contents = array();
	$action = (isset($_GET['action'])) ? $_GET['action'] : '';
	switch ($action) {
		case 'delete':
			$heading[] = array('text' => '<b>' . TEXT_INFO_HEADING_DELETE_SPECIALS . '</b>');

			$contents = array('form' => xtc_draw_form('specials', FILENAME_SPECIALS, 'page=' . $_GET['page'] . '&sID=' . $sInfo->specials_id . '&action=deleteconfirm'));
			$contents[] = array('text' => TEXT_INFO_DELETE_INTRO);
			$contents[] = array('text' => '<br /><b>' . $sInfo->products_name . '</b>');
			$contents[] = array('align' => 'center', 'text' => '<br /><input type="submit" value="'.IMAGE_DELETE.'" class="ui-button ui-corner-all ui-state-error" style="width:120px;">&nbsp;<input type="button" onClick="window.location.href=\'' . xtc_href_link(FILENAME_SPECIALS, 'page=' . $_GET['page'] . '&sID=' . $sInfo->specials_id) . '\';" style="width:120px;" title="'.IMAGE_CANCEL.'" value="'.IMAGE_CANCEL.'" class="ui-button ui-corner-all ui-state-default">');
			break;
		default:
			if (isset($sInfo) and is_object($sInfo)) {
				$heading[] = array('text' => '<b>' . $sInfo->products_name . '</b>');
                                if($sInfo->allow_edit !== true){
					$contents[] = array('align' => 'center', 'text' => '<input value="'.IMAGE_EDIT.'" type="button" title="'.SPECIALS_EBAY_REVISE_NO_SPECIAL_EDIT.'" class="ui-button ui-corner-all ui-state-default" style="width:160px;" disabled="disabled" />');
				}else{
					$contents[] = array('align' => 'center', 'text' => '<input title="'.IMAGE_EDIT.'" value="'.IMAGE_EDIT.'" type="button" onClick="window.location.href=\'' . xtc_href_link(FILENAME_SPECIALS, 'page=' . $_GET['page'] . '&sID=' . $sInfo->specials_id . '&action=edit') . '\';" class="ui-button ui-corner-all ui-state-default" style="width:160px;">');
				}
                                
                                
				$contents[] = array('align' => 'center', 'text' => '<input type="button" onClick="javascript:window.location.href=\'' . xtc_href_link(FILENAME_SPECIALS, 'page=' . $_GET['page'] . '&sID=' . $sInfo->specials_id . '&action=delete') . '\';" class="ui-button ui-corner-all ui-state-error" value="'.IMAGE_DELETE.'" title="'.IMAGE_DELETE.'" style="width:160px;">');
				$contents[] = array('text' => '<br />' . TEXT_INFO_DATE_ADDED . ' ' . xtc_date_short($sInfo->specials_date_added));
				$contents[] = array('text' => '' . TEXT_INFO_LAST_MODIFIED . ' ' . xtc_date_short($sInfo->specials_last_modified));
				$contents[] = array('align' => 'center', 'text' => '<br />' . xtc_product_info_image($sInfo->products_image, $sInfo->products_name, '150', '150'));
				$contents[] = array('text' => '<br />' . TEXT_INFO_ORIGINAL_PRICE . ' ' . $xtPrice->xtcFormat($sInfo->products_price,true));
				$contents[] = array('text' => '' . TEXT_INFO_NEW_PRICE . ' ' . $xtPrice->xtcFormat($sInfo->specials_new_products_price,true));
				$contents[] = array('text' => '' . TEXT_INFO_PERCENTAGE . ' ' . number_format(100 - (($sInfo->specials_new_products_price / $sInfo->products_price) * 100),2,',','.') . '%');
				$contents[] = array('text' => '<br />' . TEXT_INFO_START_DATE . ' <b>' . xtc_date_short($sInfo->start_date) . '</b>');
				$contents[] = array('text' => TEXT_INFO_EXPIRES_DATE . ' <b>' . xtc_date_short($sInfo->expires_date) . '</b>');
//				$contents[] = array('text' => '<font color="#999" title="Deaktiviert">' . TEXT_SELL_TO_V1NULL . ' <b>' . (($sInfo->sell_to_v1null>0)?YES:NO) . '</b></font>');
				$contents[] = array('text' => TEXT_EBAY_PRICEUPDATE . ' <b>' . (($sInfo->ebay_price_revise>0)?YES:NO) . '</b>');
				
				
				$contents[] = array('text' => '' . TEXT_INFO_STATUS_CHANGE . ' ' . xtc_date_short($sInfo->date_status_change));
			}
		break;
	}
	if ( (xtc_not_null($heading)) && (xtc_not_null($contents)) ) {
		echo '            <td width="25%" valign="top" class="ui-widget-content">' . "\n";
		$box = new box;
		echo $box->infoBox($heading, $contents);
		echo '            </td>' . "\n";
	}
} // end if not edit or new
?>
	</tr>
	</table>
	</td>
</tr>
</table>
    
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
