<?php		
// WEIGHT_FROM_ORDER beruecksichtigt
// 
// WRITES MYDPD CSV
if(sizeOf($packages) > 0 && $versender == 'MYDPD'){
    $anzahl_sammelsendg = 1;
    $counter_sort = 0;
    $csv_data = [ ['Anrede',
        'Firma',
        'Vorname',
        'Nachname',
        'Land',
        'PLZ',
        'Ort',
        'Straße',
        'Hausnummer',
        'Sendungsreferenz 1',
        'Telefon',
        'E-Mail',
        'Adresszusatz',
        'Bundesstaat',
        'Wareninhalt',
        'Gewicht',
        'default',
        'Sendungsreferenz 2',
        'Versandprodukt',
        'Zusatzleistungen',
        'Anzahl Pakete Sendung',
        'Zollwert',
        'Währung',
        'Frankatur',
        'Pakettyp',
        'Rechnungsnummer',
        'Rechnungsdatum',
        'SPRN',
        'EORI-Nummer (Absender)',
        'UID (Empfänger)',
        'Bemerkung',
        'WTNR',
        'Anzahl Artikel',
        'Länge',
        'Breite',
        'Höhe',
        'Abstellort (Versender-ASG)',
        'Zustellinformation',
        'Artikel',
        'Herkunftsland',
        'Nettogewicht',
        'Bruttogewicht',
        'Warenwert',
        'Stück',
        'Rechnungspositionsnummer',
        'Warenwert (Höherversicherung)',
        'Warenart (Höherversicherung)',
        'Abteilung',
        'Gebäude',
        'Stockwerk',
        'Vollständiger Name gemäß Ausweis',
        'Telefon (ID-Check)',
        'Ausweisnummer',
        'Zielnetzwerk'
    ] ];
# ;;;Mark Fisse;DEU;45770;Marl;Wacholderstr., 44;;10536;;m4rk@m4rk.de;;;;1;;;1;2;1;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
# ;MS-Tronic;;Franz Mayer;DEU;93354;Siegenburg;Landshuter Str. 43;;10559;;ebay@ms-tronic.de;;;;1;;;1;2;1;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    function yes_address_find_first_of($haystack, $needlesAsString, $offset=0){
        $max = strlen($needlesAsString);
        $index = strlen($haystack)+1;
        for($ii=0; $ii<$max;$ii++){
            $result = strpos($haystack,$needlesAsString[$ii], $offset);
            if( $result !== FALSE  && $result < $index)
                $index = $result;
        }
        return ( $index > strlen($haystack)? FALSE: $index);
    }
    
    
    foreach( $packages as $k=>$loop_element ){
        // NEUES VERSANDMODUL (v2) - 2021/02
        // WENN UMGESTELLT KOENNEN ALLE !v2 BLOECKE ENTFERNT WERDEN
        $v2 = (gettype($loop_element) == 'object');
        $row = $v2 ? $loop_element->shipping_configuration : $loop_element;
        $ebay_id = $row['ebay_id'];
        $orig_ebay_id = $row['ebay_id'];	 // $ebay_id wird spaeter noch geaendert im script
        $cID = $row['customers_id'];

        if($row['orders_id']>0){
            $oID = $row['orders_id'];
            $rID = 0;
            if($ebay_id == ''){
                $size = strlen($oID);
                $rest = 6-$size;
                $ebay_id = date("m").date("d");
                for($r=0;$r<$rest;$r++){
                    $ebay_id .= '0';
                }
                $ebay_id .= $oID;
            }
        }else{
            $rID = $row['reclamations_id'];
            $oID = 0;
            $ebay_id = 'R'.$rID;
        }
        $order_string = ($oID > 0) ? $oID : 'R'.$rID;

        $weight = ($row['weight']>0)?($row['weight']/10):0;

        if(!WEIGHT_ACTIVE){
                $weight = $WEIGHT_NOWEIGHT;
        }
        $real_weight = $weight;
        if($row['reclamations_id'] > 0){
                $reclamation = new reclamation($row['reclamations_id']);
                $order = new order($reclamation->info['orders_id']);
                if(defined('WEIGHT_FROM_ORDER') and WEIGHT_FROM_ORDER == 'True'){
                    if($v2){
                        $real_weight = (int)$loop_element->get_calculated_shipping_weight(true);
                    }else{
                        $real_weight = (int)$reclamation->show_weight( $row['id'] );
                    }
                }
        }else{
                $order = new order($row['orders_id']);
                if(defined('WEIGHT_FROM_ORDER') and WEIGHT_FROM_ORDER == 'True'){
                    if($v2){
                        $real_weight = $loop_element->get_calculated_shipping_weight(true);
                    }else{
                        $real_weight = $order->show_weight($row['id']);
                    }
                }
        }
        $real_weight = round($real_weight); // auf int runden
        if($real_weight < 1){
            $real_weight = 1;
        }

        $country_query = xtc_db_query("SELECT countries_iso_code_3 FROM countries WHERE countries_name='".$row['country_name']."'");
        $country_res = xtc_db_fetch_array($country_query);
        $country_iso3 = $country_res['countries_iso_code_3'];

        if(DSGVO_ALLOW_SEND_CUSTOMER_EMAIL_ADDRESS_TO_SHIPPER == 'True'){
            $email_query = xtc_db_query("SELECT customers_email_address FROM customers WHERE customers_id='".$cID."'");
            $email_res = xtc_db_fetch_array($email_query);
            $email = $email_res['customers_email_address'];
        }else{
            $email = ''; // DATENSCHUTZ EMAIL RAUS
        }

        if($country_id == ''){
                switch($row['country_name']){
                        case 'Germany': case 'Deutschland': $country_iso3 = 'DEU'; break;
                        case 'United States': $country_id = 'US'; break;
                        default: 
                                // nix
                        break;
                }
        }

        if(ORDERS_STATUS_VERSENDET < 1)
                die('KONFIGURATIONSFEHLER - bitte kontaktieren Sie Y.E.S');

        $count = $row['packages'];
        
        $name_parts = explode(' ',$row['name1']);
        $last_name = array_pop($name_parts);
        $first_name = implode(' ',$name_parts);
        if($row['name2']!=''){
                $last_name .= '/'.$row['name2'];
        }

        //Strassenname und Hausnummer trennen
        $receiver_street_raw = str_replace('.', '. ',trim(substr($row['street1'],0,40)));
        $look_for="0123456789";
        $nrpos = yes_address_find_first_of($receiver_street_raw,$look_for,0);
        //neue Hausnummernermittlung
        if (preg_match("/[0-9\,]+[a-zA-Z]*[-,\/]*[0-9]*[a-zA-Z]*/", $receiver_street_raw, $matches)) {
            $receiver_streetnumber=$matches[0];
            $receiver_streetname=trim(str_replace($receiver_streetnumber,'', $receiver_street_raw));
            $receiver_streetnumber=trim($receiver_streetnumber,'.-, ');
        }else {  
            //alte Variante als Fallback
            $receiver_streetname = trim(substr($receiver_street_raw, 0, $nrpos));
            $receiver_streetnumber = trim(substr($receiver_street_raw, $nrpos));   
        }

        $conf_Versandprodukt = 1; // STATISCH
        $conf_Zusatzleistungen = 2; // STATISCH
        
        $csv_data[] = [
            '', // ANREDE
            $row['company'],
            $first_name,
            $last_name,
            $country_iso3,
            $row['postcode'],
            $row['city'],
            $receiver_streetname,
            $receiver_streetnumber,
            $order_string, // sendungsreferenz 1
            '', // TEL
            $email,
            $row['street2'],
            '', // Bundesstaat
            '', // Wareninhalt
            number_format($real_weight,2,',',''), // Gewicht
            '', // default
            '', // Sendungsreferenz 2
            $conf_Versandprodukt,
            $conf_Zusatzleistungen,
            $row['packages'],
            '', //Zollwert',
            '', //'Währung',
            '', //'Frankatur',
            '', //'Pakettyp',
            '', //'Rechnungsnummer',
            '', //'Rechnungsdatum',
            '', //'SPRN',
            '', //'EORI-Nummer (Absender)',
            '', //'UID (Empfänger)',
            '', //'Bemerkung',
            '', //'WTNR',
            '', //'Anzahl Artikel',
            '', //'Länge',
            '', //'Breite',
            '', //'Höhe',
            '', //'Abstellort (Versender-ASG)',
            '', //'Zustellinformation',
            '', //'Artikel',
            '', //'Herkunftsland',
            '', //'Nettogewicht',
            '', //'Bruttogewicht',
            '', //'Warenwert',
            '', //'Stück',
            '', //'Rechnungspositionsnummer',
            '', //'Warenwert (Höherversicherung)',
            '', //'Warenart (Höherversicherung)',
            '', //'Abteilung',
            '', //'Gebäude',
            '', //'Stockwerk',
            '', //'Vollständiger Name gemäß Ausweis',
            '', //'Telefon (ID-Check)',
            '', //'Ausweisnummer',
            '', //'Zielnetzwerk'
        ];
    }
        

    // write csv
    $save_as_name = 'mydpd'.yes_get_sha1_from_string(date('Y_m_d-H_i_s')).'.csv';
    $path = \main::get_exportdata_path().yes_get_sha1_from_string(date('Y-m-d'));
    if(!is_dir($path)){
            mkdir($path);
    }

    $filename = $path.'/'.$save_as_name;
    $fh = fopen($filename,'a+') or die("Kann ".$filename." nicht anlegen.");
    fclose($fh);
    $csv = new CSVfile($filename);
    $csv->open("w");
    foreach($csv_data as $data){
        $csv->addRow($data);
    }
    $csv->close();
}
