<?php
// WEIGHT_FROM_ORDER beruecksichtigt
// es wird "weight" und "real_weight" uebergeben

// TICKET 3283 -  Spalte 15 = weight muss real_weight werden
// WAS WIRD MIT DER LETZTEN SPALTE (WEIGHT_FROM_ORDER)?


// WRITES EASYLOG CSV
if(sizeOf($packages) > 0 && $versender == 'DHL'){
	if(ORDERS_STATUS_VERSENDET < 1)
   		die('KONFIGURATIONSFEHLER - bitte kontaktieren Sie Y.E.S');

	$reference_number_length = 20;
	$anzahl_sammelsendg = 1;
	$counter_sort = 0;
	foreach( $packages as $k=>$loop_element ){
            // NEUES VERSANDMODUL (v2) - 2021/02
            // WENN UMGESTELLT KOENNEN ALLE !v2 BLOECKE ENTFERNT WERDEN
            $v2 = (gettype($loop_element) == 'object');
            $row = $v2 ? $loop_element->shipping_configuration : $loop_element;
                
		$service = '';
		// COUNTRY DATA
		$country_query = yes_db_query("SELECT countries_id,countries_iso_code_2,countries_iso_code_3 FROM countries WHERE countries_name='".xtc_db_input($row['country_name'])."'",true);
		$country_data = current($country_query);
		$isocode2 = $country_data['countries_iso_code_2'];
		$isocode3 = $country_data['countries_iso_code_2'];
		if($country_data['countries_id'] == STORE_COUNTRY){
			$product = EASYLOG_NORMALVERSAND_PRODUKTNUMMER_NATIONAL;
			$verfahren = EASYLOG_NORMALVERSAND_VERFAHREN_NATIONAL;
		}else{
			$product = EASYLOG_NORMALVERSAND_PRODUKTNUMMER_INTERNATIONAL;
			$verfahren = EASYLOG_NORMALVERSAND_VERFAHREN_INTERNATIONAL;
		}
		if($country_data['countries_id'] == 14){
			$product = EASYLOG_NORMALVERSAND_PRODUKTNUMMER_AT;
		}

		// ORDER DATA
		if($row['orders_id']>0){
			$order_query = xtc_db_query(sprintf(
				"SELECT payment_method,currency,customers_telephone,customers_mobile FROM orders WHERE orders_id='%s'",
				$row['orders_id']
			));
			$order_data = xtc_db_fetch_array($order_query);
			$currency = $order_data['currency'];
			$payment_method = $order_data['payment_method'];
			$telephone = (!empty($order_data['customers_telephone'])) ? $order_data['customers_telephone'] : $order_data['customers_mobile'];
		}else{
			$reclamations_query = xtc_db_query(sprintf(
				"SELECT currency,customers_telephone FROM reclamations WHERE reclamations_id='%s'",
				$row['reclamations_id']
			));
			$reclamations_data = xtc_db_fetch_array($reclamations_query);
                        
			$currency = $reclamations_data['currency'];
			$telephone = $reclamations_data['customers_telephone'];
		}
		// RUECKSCHEIN HANDLING
		if(SHIPPING_ACTION_EASYLOG_RUECKSCHEIN == 'true'){
			if($country_data['countries_id'] == STORE_COUNTRY){
				// NATIONAL
				$service = EASYLOG_RUECKSCHEIN_PRODUKTNUMMER_NATIONAL;
			}else{
				// INTERNATIONAL
				$service = EASYLOG_RUECKSCHEIN_PRODUKTNUMMER_INTERNATIONAL;
			}
		}
		// NACHNAHME HANDLING
		if($row['orders_id']>0){
			if(stristr($payment_method,'cod')){
				// BESTELLUNG PER NACHNAHME
				$orders_total_query = xtc_db_query(sprintf(
					"SELECT value FROM orders_total WHERE orders_id='%s' AND class='ot_total'",
					$row['orders_id']
				));
				$orders_total = xtc_db_fetch_array($orders_total_query);
				$ot_value = number_format($orders_total['value'],2,',','');
				if($service != '') $service = $service.';';
				if($country_data['countries_id'] == STORE_COUNTRY){
					// NATIONAL + Bugfix no currency
					$service .= EASYLOG_NACHNAHME_PRODUKTNUMMER_NATIONAL.'='.$ot_value;
				}else{
					// INTERNATIONAL + Bugfix no currency
					$service .= EASYLOG_NACHNAHME_PRODUKTNUMMER_INTERNATIONAL.'='.$ot_value;
				}
			}
		}

		if($row['company'] != ''){
			$name1 = substr($row['company'],0,40);
			$name2 = substr($row['name1'],0,40);
			$name3 = substr($row['name2'],0,40);
		}else{
			$name1 = substr($row['name1'],0,40);
			$name2 = substr($row['name2'],0,40);
			$name3 = '';
		}

		if(SHIPPING_ACTION_EASYLOG_FIXED_WEIGHT>0){
			$weight = SHIPPING_ACTION_EASYLOG_FIXED_WEIGHT;
                }else{
                    // TICKET 2553 - wenn Gewicht kl. 100g dann 100g
                    if($row['weight']/10 < 0.1){
                        $weight = '0,10';
                    }else{
			$weight = number_format($row['weight']/10,2,',','');
                    }
                }
                $real_weight = $weight;

		$ebay_id_string = '';
		if($row['ebay_id'] != ''){
			$ebay_id_string = ' '.$row['ebay_id'];
		}
		for($count=0;$count<$row['packages'];$count++){

			// UNIQUE KEY
			if($row['orders_id']>0){
				$unique_key = $row['orders_id'];
			}else{
				$unique_key = 'R'.$row['reclamations_id'];
			}

			// CONTENT UND VERWENDUNGSZWECK
			if($row['orders_id']>0){
				$comment = 'Re-Nr: '.$row['orders_id'];
				$order = new order($row['orders_id']);
				if(!defined('SHIPPING_ACTION_EASYLOG2_NO_EBAYID') or SHIPPING_ACTION_EASYLOG2_NO_EBAYID != 'true'){
					$comment .= $ebay_id_string;
				}else{
                                    if($v2){
                                        if(sizeOf($loop_element->products_to_ship) == 1 and !defined(' SHIPPING_ACTION_EASYLOG2_NO_PRODUCTS_MODEL_FOR_SINGLE_PRODUCT_ORDER') and SHIPPING_ACTION_EASYLOG2_NO_PRODUCTS_MODEL_FOR_SINGLE_PRODUCT_ORDER != 'true'){
                                            if($loop_element->products_to_ship[0]->model != ''){
                                                $comment .= sprintf(' [%s]',$loop_element->products_to_ship[0]->model);
                                            }
                                        }
                                    }else{
					if(sizeOf($order->products) == 1 and !defined(' SHIPPING_ACTION_EASYLOG2_NO_PRODUCTS_MODEL_FOR_SINGLE_PRODUCT_ORDER') and SHIPPING_ACTION_EASYLOG2_NO_PRODUCTS_MODEL_FOR_SINGLE_PRODUCT_ORDER != 'true'){
                                            if($order->products[0]['model'] != ''){
                                                $comment .= sprintf(' [%s]',$order->products[0]['model']);
                                            }
					}
                                    }
				}
                                if($v2){
                                    if(sizeOf($loop_element->products_to_ship) == 1){
                                        $products_string = sprintf(' %s x [%s] %s',$loop_element->products_to_ship[0]->quantity,
                                            $loop_element->products_to_ship[0]->products_id,
                                            $loop_element->products_to_ship[0]->source_product['name']
                                        );
                                    }else{
                                            $products_string = ' Diverse';
                                    }
                                }else{
                                    if(sizeOf($order->products) == 1){
                                        $products_string = sprintf(' %s x [%s] %s',$order->products[0]['qty'],
                                            $order->products[0]['id'],
                                            $order->products[0]['name']
                                        );
                                    }else{
                                            $products_string = ' Diverse';
                                    }
                                }
                            if($row['weight'] == 0 and defined('WEIGHT_FROM_ORDER') and WEIGHT_FROM_ORDER == 'True'){
                                if($v2){
                                    $real_weight = $loop_element->get_calculated_shipping_weight(true);
                                }else{
                                    $real_weight = $order->show_weight($row['id']);
                                }
                            }
			}else{
				$comment = 'Rekl-Nr: '.$row['reclamations_id'].$ebay_id_string;
				$reclamation = new reclamation($row['reclamations_id']);
                                if($v2){
                                    if(sizeOf($loop_element->products_to_ship) == 1){
                                        $products_string = sprintf(' %s x [%s] %s',$loop_element->products_to_ship[0]->quantity,
                                            $loop_element->products_to_ship[0]->products_id,
                                            $loop_element->products_to_ship[0]->source_product['name']
                                        );
                                    }else{
                                            $products_string = ' Diverse';
                                    }
                                }else{
                                    if(sizeOf($reclamation->products) == 1){
                                            $products_string = sprintf(' %s x [%s] %s',$reclamation->products[0]['qty'],
                                                    $reclamation->products[0]['id'],
                                                    $reclamation->products[0]['name']);
                                    }else{
                                            $products_string = ' Diverse';
                                    }
                                }
                                if($row['weight'] == 0 and defined('WEIGHT_FROM_ORDER') and WEIGHT_FROM_ORDER == 'True'){
                                    if($v2){
                                        $real_weight = $loop_element->get_calculated_shipping_weight(true);
                                    }else{
                                        $real_weight = $reclamation->show_weight($row['id']);
                                    }
                                }
			}
                        
                        if($row['weight'] == 0 and defined('WEIGHT_FROM_ORDER') and WEIGHT_FROM_ORDER == 'True'){
                            $real_weight = (float) $real_weight;
                        }
                        
                        
			if($row['packages']>1){
				$comment .= sprintf(' SamS %s/%s',($count+1),$row['packages']);
			}else{
				$comment .= $products_string;
			}

			// 2010/05/12 AENDERUNG packages IMMER AUF 1
			$email = substr($row['email'],0,50);
			if(stristr($email,'marketplace.amazon')){
				$email = '';
			}
			$sql_insert_array = array(
				"reference_number"=>$unique_key,
				"sender_reference_number"=>SHIPPING_ACTION_EASYLOG_ABS_REFNR,
				"verfahren"=>$verfahren,
				"teilnahme"=>EASYLOG_TEILNEHMERNUMMER,
				"service"=>$service,
				"waehrung"=>$currency,
				"name1"=>$name1,
				"name2"=>$name2,
				"name3"=>$name3,
				"street"=>substr($row['street1'],0,30),
				"suburb"=>substr($row['street2'],0,40),
				"postcode"=>substr($row['postcode'],0,10),
				"city"=>substr($row['city'],0,40),
				"country"=>$isocode2,
				"email"=>$email,
				"weight"=>$real_weight,
				"packages"=>1,
				"package_type"=>4,
				"kommentar"=>$comment,
				"date_added"=>'now()',
				'sort_order'=>$counter_sort,
				'product'=>$product,
				'telephone'=>$telephone,
			);
                        if(defined('WEIGHT_FROM_ORDER') and WEIGHT_FROM_ORDER == 'True'){
                            $sql_insert_array['real_weight'] = $real_weight;
                        }
			xtc_db_perform('packages_calc_easylog',$sql_insert_array);
			$counter_sort++;
		} // END FOR PACKAGES_NR
	} // END FOREACH PACKAGES
	// write csv
	$save_as_name = 'dhl-'.yes_get_sha1_from_string(date('Y_m_d-H_i_s')).'.csv';
        
        $path = \main::get_exportdata_path().yes_get_sha1_from_string(date('Y-m-d'));
        if(!is_dir($path)){
                mkdir($path);
        }
        $filename = $path.'/'.$save_as_name;
        $fh = fopen($filename,'a+') or die("Kann ".$filename." nicht anlegen.");
        fclose($fh);
	$csv = new CSVfile($filename);
	$csv->open("w");
	$csv->delimiter = '|';
	$csvquery = xtc_db_query("select pc.* from packages_calc_easylog pc ORDER BY pc.sort_order ASC");
	while ($csvrow = xtc_db_fetch_array($csvquery)) {
		$csvrow = xtc_db_prepare_input($csvrow);
		$data = array();
		$data[] = $csvrow['reference_number'];
		$data[] = $csvrow['sender_reference_number'];
		$data[] = $csvrow['verfahren'];
		$data[] = $csvrow['teilnahme'];
		$data[] = $csvrow['service'];
		$data[] = $csvrow['waehrung'];
		$data[] = $csvrow['name1'];
		$data[] = $csvrow['name2'];
		$data[] = $csvrow['name3'];
		$data[] = $csvrow['street'];
		$data[] = $csvrow['suburb'];
		$data[] = $csvrow['postcode'];
		$data[] = $csvrow['city'];
		$data[] = $csvrow['country'];
		$data[] = $csvrow['email'];
		$data[] = $csvrow['weight'];
		$data[] = $csvrow['packages'];
		$data[] = $csvrow['package_type'];
		$data[] = $csvrow['kommentar'];
		$data[] = $csvrow['product'];
                if(defined('WEIGHT_FROM_ORDER') and WEIGHT_FROM_ORDER == 'True'){
                    if($csvrow['real_weight'] < 0.1){
                        $csvrow['real_weight'] = 0.1;
                    }
                    $data[] = number_format($csvrow['real_weight'],4,',','');
                }
		$data[] = $csvrow['telephone'];
                foreach($data as $kd=>$kv){
                    $data[$kd] = iconv('UTF-8','WINDOWS-1252',$kv);
                }
		$csv->addRow($data);
		xtc_db_query("DELETE FROM packages_calc_easylog WHERE packages_calc_easylog_id='".$csvrow['packages_calc_easylog_id']."'");
	}
	$csv->close();
        if(isset($shipping_daily_otc) and $shipping_daily_otc == 1){
            printf('<p class="smallText">'.TEXT_EASYLOG2_PARTICLE_UPLOAD_FILE_CREATED.'</p>',CURRENT_TEMPLATE,$save_as_name);
            if(EASYLOG2_PARTICLE_UPLOAD_FTP_ACCOUNT != ''){
                //$path = DIR_FS_CATALOG."templates/".CURRENT_TEMPLATE."/EASYLOG2";
                $server_string = str_replace('ftp://','',EASYLOG2_PARTICLE_UPLOAD_FTP_ACCOUNT);
                $server = current(array_reverse(explode('@',$server_string)));
                $server_userpart = substr($server_string,0,$server_string-strlen($server)-1);
                $server_user = substr($server_userpart,0, strpos($server_userpart,':'));
                $server_pass = substr($server_userpart,strpos($server_userpart,':')+1,strlen($server_userpart));

                $link = ftp_connect($server);
                if (!ftp_login($link,$server_user,$server_pass))
                echo '<p class="smallText">FTP Verbindung konnte nicht hergestellt werden.</p>';
                if (!ftp_put($link, $save_as_name, $path.'/'.$save_as_name, FTP_ASCII)) {
                    echo "<p>There was a problem while uploading $save_as_name</p>";
                }
                ftp_quit($link);
            }
        }
}
