<?php
/* --------------------------------------------------------------
   $Id: orders.php,v 1.415 2020/06/24 08:49:54 ssh-511548-cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(orders.php,v 1.109 2003/05/28); www.oscommerce.com
   (c) 2003	 nextcommerce (orders.php,v 1.19 2003/08/24); www.nextcommerce.org

   Released under the GNU General Public Licensekic
   --------------------------------------------------------------
   Third Party contribution:
   OSC German Banktransfer v0.85a       	Autor:	Dominik Guder <osc@guder.org>
   Customers Status v3.x  (c) 2002-2003 Copyright Elari elari@free.fr | www.unlockgsm.com/dload-osc/ | CVS : http://cvs.sourceforge.net/cgi-bin/viewcvs.cgi/elari/?sortby=date#dirlist

   credit card encryption functions for the catalog module
   BMC 2003 for the CC CVV Module

   Released under the GNU General Public License
   --------------------------------------------------------------*/

use YES4Trade\Model\ebay_order_reservation;

require('includes/application_top.php');

// wir brauchen den namen
require(DIR_FS_LANGUAGES.$_SESSION['language'].'/modules/order_total/ot_subtotal_no_tax.php');

require_once(DIR_FS_INC . 'xtc_is_shipping_before_payment.inc.php');
require_once(DIR_FS_INC . 'xtc_get_payment_method_title.inc.php');
require(DIR_FS_INC.'xtc_get_customers_status_export_note.inc.php');			
require(DIR_FS_INC.'xtc_get_ebay_link.inc.php');
require(DIR_FS_INC.'xtc_get_auction_site.inc.php');
require_once(DIR_FS_INC . 'xtc_get_orders_ebay_seller.inc.php');
require_once(DIR_FS_INC . 'xtc_get_ebay_seller_data.inc.php');

// MAIL BUGFIX - NEUE PHPMAILER VERSION
//require_once(DIR_FS_CATALOG.DIR_WS_CLASSES.'class.phpmailer.php');
require_once(DIR_FS_INC . 'xtc_php_mail.inc.php');

require_once(DIR_FS_INC . 'xtc_collis.inc.php');
require_once(DIR_FS_INC . 'xtc_serials.inc.php');
require_once(DIR_FS_INC . 'xtc_add_tax.inc.php');
require_once(DIR_FS_INC . 'changedataout.inc.php');
require_once(DIR_FS_INC . 'xtc_validate_vatid_status.inc.php');
require_once(DIR_FS_INC . 'xtc_get_parent_categories.inc.php');
require_once(DIR_FS_INC . 'xtc_get_product_path.inc.php');
require_once(DIR_FS_INC . 'xtc_format_price_order.inc.php');
require_once(DIR_FS_INC . 'xtc_get_short_description.inc.php');
require (DIR_FS_CATALOG.'includes/classes/shipping.php');
require (DIR_FS_CATALOG.'inc/xtc_count_shipping_modules.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_tax_rate.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_price_o_tax.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_customers_status.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_price_i_tax.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_allow_tax.inc.php');
require_once(DIR_FS_INC . 'yes_get_shop_content.inc.php');
require(DIR_FS_CATALOG.DIR_WS_CLASSES . 'xtcPrice.php');
if(!function_exists('yes_get_sha1_from_string')){
    require_once(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
}
if( !defined('USE_DOMPDF') or USE_DOMPDF != 'True'){
    require_once("includes/classes/class.html2pdf.php");
}
if(BARCODE_PACKINGSLIP_ACTIVE == 'True'){
	require_once(DIR_FS_INC . 'xtc_generate_packingslip_barcode.inc.php');
}
require_once(DIR_FS_INC . 'xtc_get_order_html_for_pdf.inc.php');
require_once(DIR_FS_INC . 'xtc_get_offer_html_for_pdf.inc.php');
require_once(DIR_FS_INC . 'xtc_get_order_confirm_html_for_pdf.inc.php');
require_once(DIR_FS_INC . 'yes_get_order_teaser_html_for_pdf.inc.php');
require_once(DIR_FS_INC . 'xtc_get_packingslip_html_for_pdf.inc.php');
require_once(DIR_FS_INC . 'yes_end_auction_add.inc.php');
require_once(DIR_FS_INC . 'xtc_get_vpe_name.inc.php');
require_once(DIR_FS_INC . 'xtc_get_country_data_from_name.inc.php');

function _get_images($products_id){
    $images = array();
    $query = xtc_db_query(sprintf(
        "SELECT products_image FROM products WHERE products_id='%d'",
        $products_id
    ));
    $image = xtc_db_fetch_array($query);
    if($image['products_image'] != ''){
        if(stristr($image['products_image'],'gif') === FALSE){
            $images[] = HTTP_SERVER.'images/product_images/thumbnail_images/'.$image['products_image'];
        }
    }
    return $images;
}

// yes accounting
$admin_access = main::get_admin_access();
// initiate template engine for mail
$smarty = new yesSmarty;
require_once(DIR_WS_CLASSES . 'currencies.php');
include_once('includes/classes/class.ebaymail.php');
require_once(DIR_WS_CLASSES . 'order.php');
if(isset($_GET['tab'])){
    if(!isset($_GET['action'])){
        //require('../includes/classes/paypal_checkout.php');
        require('includes/classes/class.paypal.php');
        include('orders_tab.php');
        exit;
    }
}

  if(isset($_GET['ajax_payment_filter']) and $_GET['ajax_payment_filter'] == 1){
	include('ajax_orders_payment_methods.php');
	exit;
  }
  if(isset($_GET['ajax_source_filter']) and $_GET['ajax_source_filter'] == 1){
	include('ajax_orders_sources.php');
	exit;
  }
  
  // yes accounting
if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['orders'] == '1')) {
}else{
  	$messageStack->add_session(MSG_AUTH_ORDERS,'error');
  	xtc_redirect(xtc_href_link('index.php',xtc_get_all_get_params(array('action'))));
}
  

$currencies = new currencies();
$orders_statuses = xtc_get_orders_status();

if( isset($_GET['oID']) ) {
    $oID = (int)xtc_db_prepare_input($_GET['oID']);

    $orders_query = xtc_db_query(sprintf(
        "select orders_id from %s where orders_id = '%d'",
        TABLE_ORDERS, $oID
    ));
    $order_exists = true;
    if (!xtc_db_num_rows($orders_query)) {
        $order_exists = false;
        $messageStack->add(sprintf(ERROR_ORDER_DOES_NOT_EXIST, $oID), 'error');
    }
}
$action = $_GET['action'] ?? '';
switch ($action) {
	case 'multi_import':
		include('orders.multi_import.php');
		break;
	case 'edit_pallets':
		include('orders.edit_pallets.php');
		exit;
		break;
	case 'update_op_own_volume':
		$oID = (int)xtc_db_input($_GET['oID']);
		if($oID < 1){
			$messageStack->add_session('Invalid orders_id','error');
			xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(['action']).'action=edit'));
		}
        $opID = (int)xtc_db_input($_GET['opID']);
		if($opID < 1){
			$messageStack->add_session('Invalid orders_products_id','error');
			xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(['action']).'action=edit'));
		}
		$volume = floatval($_GET['volume']??0);
		yes_db_perform(TABLE_ORDERS_PRODUCTS,
			[
				'volume'=>$volume
			],
			'update',
			['orders_products_id'=>$opID]
		);
		$order = new order($oID);
		$order->add_history($order->info['orders_status'],false,'Update order product volume (opID '.$opID.'): '.$volume);
		$messageStack->add_session('Update order product volume (opID '.$opID.'): '.$volume,'success');
		xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(['action']).'action=edit'));
		break;
	case 'update_op_own_weight':
		$oID = (int)xtc_db_input($_GET['oID']);
		if($oID < 1){
			$messageStack->add_session('Invalid orders_id','error');
			xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(['action']).'action=edit'));
		}
        $opID = (int)xtc_db_input($_GET['opID']);
		if($opID < 1){
			$messageStack->add_session('Invalid orders_products_id','error');
			xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(['action']).'action=edit'));
		}
		$weight = floatval($_GET['weight']??0);
		yes_db_perform(TABLE_ORDERS_PRODUCTS,
			[
				'weight'=>$weight
			],
			'update',
			['orders_products_id'=>$opID]
		);
		$order = new order($oID);
		$order->add_history($order->info['orders_status'],false,'Update order product weight (opID '.$opID.'): '.$weight);
		$messageStack->add_session('Update order product weight (opID '.$opID.'): '.$weight,'success');
		xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(['action']).'action=edit'));
		break;
	case 'set_distribution_warehouse_storage_id':
        $oID = (int)xtc_db_input($_GET['oID']);
		if($oID < 1){
			die(json_encode([
				'MSG'=>'Invalid orders_id'
			]));
		}
		$value = intval($_GET['value']??0);
		yes_db_perform(TABLE_ORDERS,
			[
				'distribution_warehouse_storage_id'=>$value
			],
			'update',
			['orders_id'=>$oID]
		);
		$order = new order($oID);
		$value_str = 'none';
		if($value > 0){
			$storage_info = yes_get_storage_info($value);
			$value_str = $storage_info['name'];
		}
		$order->add_history($order->info['orders_status'],false,'Update distribution warehouse: '.$value_str);
		die(json_encode([
			'MSG'=>''
		]));
		break;
	case 'set_commission_number':
        $oID = (int)xtc_db_input($_GET['oID']);
		if($oID < 1){
			die(json_encode([
				'MSG'=>'Invalid orders_id'
			]));
		}
		$value = substr(trim($_GET['value']??''),0,64);
		yes_db_perform(TABLE_ORDERS,
			[
				'commission_number'=>$value
			],
			'update',
			['orders_id'=>$oID]
		);
		$order = new order($oID);
		$order->add_history($order->info['orders_status'],false,'Update Commission Number: '.$value);
		die(json_encode([
			'MSG'=>''
		]));
		break;
	case 'convert':
		include('orders.convert.php');
		exit;
		break;
	case 'recreate':
		include('orders.recreate.php');
		exit;
		break;
    case 'save_marge':
        $oID = (int)xtc_db_input($_GET['oID']);
        $order = new order($oID);
        $order->save_marge();
        $order->save_real_shipping_cost();
        $messageStack->add_session('order marge updated','success');
        xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['action']).'action=edit'));
        break;
    case 'default_shipper_set':
        $oID = (int)xtc_db_input($_GET['oID']);
        $order = new order($oID);
        $default_shipper = $_GET['default_shipper'];
        $order->update_default_shipper( $default_shipper );
        die(json_encode([
            'MSG'=>'',
        ]));
        break;
    case 'default_shipper_select':
        $oID = (int)xtc_db_input($_GET['oID']);
        $order = new order($oID);
        echo xtc_draw_pull_down_menu('default_shipper', 
                \YES4Trade\Model\shipper_profiles::get_selection_list(),
                $order->info['versender'],
                'onchange="update_default_shipper()"'
        );
        echo '&nbsp;'.\YES4Trade\Model\shipper_profiles::get_crud_link();
        exit;
        break;
    case 'download_email_export_file':
        $file = basename($_GET['file']);
        if( is_file( main::get_secure_path().$file) ){
            $basics = new basics;
            $basics->download_file( main::get_secure_path().$file,true);
        }
        exit;
        break;
    case 'set_allow_shipping_ebay_1_hour_active':
        $oID = (int)xtc_db_input($_GET['oID']);
        $status = (int)xtc_db_input($_GET['status']);
        $order = new order( $oID );
        $order->update_allow_shipping_ebay_1_hour_active( $status );
        die(json_encode(array(
            'STATUS'=>$status,
        )));
        break;
    case 'marge_details':
        $opID = (int)xtc_db_input($_GET['opID']);
        $query = xtc_db_query(sprintf(
                "SELECT orders_id FROM %s WHERE orders_products_id='%d'",
                TABLE_ORDERS_PRODUCTS,
                $opID
        ));
        if(!xtc_db_num_rows($query)){
            die('unknown order item');
        }
        $record = xtc_db_fetch_array($query);
        $order = new order( $record['orders_id'] );
        foreach($order->products as $op){
            if($op['opID'] != $opID){
                continue;
            }
            $out = sprintf('<p>%dx <b>%s</b></p><div class="main" style="font-size: 0.8em;">',
                $op['qty'], $op['name']
            );
            $collies = xtc_get_product_collies($op['id']);
            if(sizeOf($collies)){
                foreach($collies as $colli){
                    $out .= sprintf('&nbsp;&nbsp;<i>%dx pID %d %s &raquo;%s&laquo;</i>',
                        $colli['quantity'],
                        $colli['collie_products_id'],
                        MARGE_COLLIES,
                        xtc_get_products_name($colli['collie_products_id']),
                    );
                    $marge = $order->get_product_marge($colli['collie_products_id'], $op['qty']*$colli['quantity'], true);
                    $selbstkosten_netto = ($marge['packaging_costs']+$marge['shipping_netto']+$marge['ek_netto'])*$marge['fixkosten_prozentwert'];
                    $tax_rate_percent = $marge['tax_prozentwert']*100-100;
                    $tax_rate_value = $selbstkosten_netto*$marge['tax_prozentwert']-$selbstkosten_netto;
                    $fixkosten_percent = $marge['fixkosten_prozentwert']*100-100;
                    $fixkosten_value = $selbstkosten_netto-$selbstkosten_netto/$marge['fixkosten_prozentwert'];
                    $ebay_percent = $marge['ebay_prozentwert']*100-100;
                    $ebay_value = $selbstkosten_netto*$marge['ebay_prozentwert']-$selbstkosten_netto;
                    $amazon_percent = $marge['amazon_prozentwert']*100-100;
                    $amazon_value = $selbstkosten_netto*$marge['amazon_prozentwert']-$selbstkosten_netto;
                    $out .= '<table border="0" width="100%" cellspacing="0" style="font-size: 0.8em;margin-bottom: 12px;">';
                    $out .= sprintf('<tr><td></td><td>%s</td><td align="right">%s</td></tr>',
                            MARGE_PRODUCTS_NETTO,
                            number_format($marge['ek_netto'],2,',','.')
                    );
                    $out .= sprintf('<tr><td>+</td><td>%s</td><td align="right">%s</td></tr>',
                            MARGE_SHIPPING_NETTO,
                            number_format($marge['shipping_netto'],2,',','.')
                    );
                    $out .= sprintf('<tr><td>+</td><td>%s</td><td align="right">%s</td></tr>',
                            MARGE_PACKAGING_NETTO,
                            number_format($marge['packaging_costs'],2,',','.')
                    );
                    $out .= sprintf('<tr><td>+</td><td>%s %s%%</td><td align="right">%s</td></tr>',
                            MARGE_FIXKOSTEN,
                            $fixkosten_percent, number_format($fixkosten_value,2,',','.')
                    );
                    $out .= sprintf('<tr style="font-weight: bold;"><td>=</td><td>%s</td><td align="right">%s</td></tr>',
                            MARGE_SELBSTKOSTEN_NETTO,
                            number_format($selbstkosten_netto,2,',','.')
                    );
                    $out .= sprintf('<tr><td>+</td><td>%s %s%%</td><td align="right">%s</td></tr>',
                            MARGE_TAX,
                            $tax_rate_percent, number_format($tax_rate_value,2,',','.')
                    );
                    $out .= sprintf('<tr><td>+</td><td>%s %s%%</td><td align="right">%s</td></tr>',
                            MARGE_EBAY_COSTS,
                            $ebay_percent, number_format($ebay_value,2,',','.')
                    );
                    $out .= sprintf('<tr><td>+</td><td>%s %s%%</td><td align="right">%s</td></tr>',
                            MARGE_AMAZON_COSTS,
                            $amazon_percent, number_format($amazon_value,2,',','.')
                    );
                    $out .= sprintf('<tr style="background-color: lightgreen;font-weight: bold;"><td>=</td><td>%s (%dx %s)</td><td align="right">%s</td></tr>',
                            MARGE_SELBSTKOSTEN_BRUTTO,
                            $colli['quantity'],
                            number_format($marge['vk_brutto'],2,',','.'),
                            number_format($colli['quantity']*$marge['vk_brutto'],2,',','.')
                    );
                    $out .= '</table>';
                }
            }else{
                $marge = $order->get_product_marge($op['id'], $op['qty'], true);
                $selbstkosten_netto = ($marge['packaging_costs']+$marge['shipping_netto']+$marge['ek_netto'])*$marge['fixkosten_prozentwert'];
                $tax_rate_percent = $marge['tax_prozentwert']*100-100;
                $tax_rate_value = $selbstkosten_netto*$marge['tax_prozentwert']-$selbstkosten_netto;
                $fixkosten_percent = $marge['fixkosten_prozentwert']*100-100;
                $fixkosten_value = $selbstkosten_netto-$selbstkosten_netto/$marge['fixkosten_prozentwert'];
                $ebay_percent = $marge['ebay_prozentwert']*100-100;
                if($order->info['source'] == 'ebay'){
                    $ebay_value = $selbstkosten_netto*$marge['ebay_prozentwert']-$selbstkosten_netto;
                }else{
                    $ebay_value = 0;
                }
                $amazon_percent = $marge['amazon_prozentwert']*100-100;
                if($order->info['source'] == 'amazon'){
                    $amazon_value = $selbstkosten_netto*$marge['amazon_prozentwert']-$selbstkosten_netto;
                }else{
                    $amazon_value = 0;
                }
                $hitmeister_percent = $marge['hitmeister_prozentwert']*100-100;
                if($order->info['source'] == 'hitmeist'){
                    $hitmeister_value = $selbstkosten_netto*$marge['hitmeister_prozentwert']-$selbstkosten_netto;
                }else{
                    $hitmeister_value = 0;
                }
                $out .= '<table border="0" width="100%" cellspacing="0" style="font-size: 0.8em;margin-bottom: 12px;">';
                $out .= sprintf('<tr><td></td><td>%s</td><td align="right">%s</td></tr>',
                        MARGE_PRODUCTS_NETTO,
                        number_format($marge['ek_netto'],2,',','.')
                );
                $out .= sprintf('<tr><td>+</td><td>%s</td><td align="right">%s</td></tr>',
                        MARGE_SHIPPING_NETTO,
                        number_format($marge['shipping_netto'],2,',','.')
                );
                $out .= sprintf('<tr><td>+</td><td>%s</td><td align="right">%s</td></tr>',
                        MARGE_PACKAGING_NETTO,
                        number_format($marge['packaging_costs'],2,',','.')
                );
                $out .= sprintf('<tr><td>+</td><td>%s %s%%</td><td align="right">%s</td></tr>',
                        MARGE_FIXKOSTEN,
                        $fixkosten_percent, number_format($fixkosten_value,2,',','.')
                );
                $out .= sprintf('<tr style="font-weight: bold;"><td>=</td><td>%s</td><td align="right">%s</td></tr>',
                        MARGE_SELBSTKOSTEN_NETTO,
                        number_format($selbstkosten_netto,2,',','.')
                );
                $out .= sprintf('<tr><td>+</td><td>%s %s%%</td><td align="right">%s</td></tr>',
                        MARGE_TAX,
                        $tax_rate_percent, number_format($tax_rate_value,2,',','.')
                );
                $out .= sprintf('<tr><td>+</td><td>%s %s%%</td><td align="right">%s</td></tr>',
                        MARGE_EBAY_COSTS,
                        $ebay_percent, number_format($ebay_value,2,',','.')
                );
                $out .= sprintf('<tr><td>+</td><td>%s %s%%</td><td align="right">%s</td></tr>',
                        MARGE_AMAZON_COSTS,
                        $amazon_percent, number_format($amazon_value,2,',','.')
                );
                $out .= sprintf('<tr><td>+</td><td>%s %s%%</td><td align="right">%s</td></tr>',
                        MARGE_HITMEISTER_COSTS,
                        $hitmeister_percent, number_format($hitmeister_value,2,',','.')
                );
                $out .= sprintf('<tr style="background-color: lightgreen;font-weight: bold;"><td>=</td><td>%s %dx %s</td><td align="right">%s</td></tr>',
                        MARGE_SELBSTKOSTEN_BRUTTO,
                        $op['qty'],
                        number_format($marge['vk_brutto'],2,',','.'),
                        number_format($op['qty']*$marge['vk_brutto'],2,',','.')
                );
                $out .= '</table>';
                
            }
            $out .= '</div>';
        }
        die($out);
        break;
    case 'check_secupay_status':
        
        $oID = (int)xtc_db_input($_GET['oID']);
        $query = xtc_db_query(sprintf(
                "SELECT hash FROM secupay_transaction_order WHERE ordernr='%d'",
                $oID
        ));
        if(!xtc_db_num_rows($query)){
            die(json_encode(array(
                'ERROR'=>'Not a secupay transaction'
            )));
        }
        $record = xtc_db_fetch_array($query);
        $url = HTTP_CATALOG_SERVER.'secupay_status_push.php';
        //$record['hash'] = 'dztgjjzyuabd4537048';
        //$url = 'https://agri.abcde.biz/yes/secupay_status_push.php';
        
        $ch = curl_init( $url );
        # Setup request to send json via POST.
        $payload = json_encode(array( 
                "hash"=> $record['hash'],
                'action'=>'check_status'
        ));
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
        $result = curl_exec($ch);
        curl_close($ch);
        $data = json_decode($result);
        $smarty->assign('DATA',$data);
        $smarty->display('secupay_transaction_status.tpl');
        exit;
        break;
    case 'delete_temp_tracking_number':
        $transaction_id = (int)xtc_db_input($_GET['transaction_id']);
        $oID = (int)xtc_db_input($_GET['oID']);
        $query = xtc_db_query(sprintf(
                "SELECT shippings_tracking_numbers_temp_id FROM shippings_tracking_numbers_temp WHERE target_type='order' AND target_type_id='%d' AND shippings_tracking_numbers_temp_id='%d'",
                $oID,$transaction_id
        ));
        if(!xtc_db_num_rows($query)){
            $messageStack->add_session(MSG_ERROR_DELETE_TEMP_TRACKING_NUMBER,'error');
        }else{
            xtc_db_query(sprintf(
                "DELETE FROM shippings_tracking_numbers_temp WHERE shippings_tracking_numbers_temp_id='%d'",
                $transaction_id
            ));
            $messageStack->add_session(MSG_SUCCESS_DELETE_TEMP_TRACKING_NUMBER,'success');
        }
        xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action','transaction_id')).'action=edit'));
        break;
    case 'update_dhl_wunschpaket':
	$oID = (int)xtc_db_input($_GET['oID']);
	if($oID < 1){
		$messageStack->add_session("Missing Orders ID",'error');
		xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action')).'action=edit'));
	}
        $update_sql_array = [];
        if(isset($_POST['preferredLocation']) and $_POST['preferredLocation'] == 1){
            $update_sql_array['preferredLocation'] = $_POST['preferredLocation_text'];
        }else{
            $update_sql_array['preferredLocation'] = '';
        }
        if(isset($_POST['neighbour'])){
            if($_POST['neighbour'] == 'noNeighbourDelivery'){
                $update_sql_array['noNeighbourDelivery'] = 1;
                $update_sql_array['preferredNeighbour'] = '';
            }else{
                $update_sql_array['noNeighbourDelivery'] = 0;
                $update_sql_array['preferredNeighbour'] = $_POST['preferredNeighbour_text'];
            }
        }else{
            $update_sql_array['noNeighbourDelivery'] = 0;
            $update_sql_array['preferredNeighbour'] = '';
        }
        if(isset($_POST['preferredDay_active']) and $_POST['preferredDay_active'] == 1){
            $update_sql_array['preferredDay'] = $_POST['preferredDay'];
        }else{
            $update_sql_array['preferredDay'] = '0000-00-00';
        }

        if(isset($_POST['preferredTime_active']) and $_POST['preferredTime_active'] == 1){
            $update_sql_array['preferredTime'] = $_POST['preferredTime'];
        }else{
            $update_sql_array['preferredTime'] = '';
        }

        if(isset($_POST['sameDayDelivery_active']) and $_POST['sameDayDelivery_active'] == 1){
            $update_sql_array['sameDayDelivery'] = $_POST['sameDayDelivery'];
        }else{
            $update_sql_array['sameDayDelivery'] = '';
        }
	$exists_query = xtc_db_query(sprintf(
		"SELECT orders_dhl_paketsteuerung_id FROM orders_dhl_paketsteuerung WHERE orders_id='%d'",
		$oID
	));
	if(!xtc_db_num_rows($exists_query)){
		$update_sql_array['orders_id'] = $oID;
		// INSERT
	        xtc_db_perform('orders_dhl_paketsteuerung',$update_sql_array);
	}else{
	        xtc_db_perform('orders_dhl_paketsteuerung',$update_sql_array,'update',"orders_id='".$oID."'");
	}
        xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action')).'action=edit'));
        break;
    case 'klarna_refund':
	die('AMZ: '.$_GET['refund_amount']);
	break;
    case 'klarna_refund_confirm':
        $oID = (int)xtc_db_input($_REQUEST['orders_id']);
        $order = new order($oID);
		$query = xtc_db_query(sprintf(
			"SELECT klarna_intern_orders_id, merchant_id FROM klarna_orders WHERE orders_id='%s'",
			$order->info['id']
		));
		$record = xtc_db_fetch_array($query);
		$data = array(
			'klarna_order_id'=>$record['klarna_intern_orders_id'],
			'klarna_merchant_id'=>$record['merchant_id'],
			'klarna_secret'=>constant('MODULE_PAYMENT_KLARNA_YES_PAY_LATER_SECRET'),
		);
		$data_string = json_encode($data);                                                                                   

		$api_url=(strstr(HTTP_CATALOG_SERVER, 'localhost'))?HTTP_CATALOG_SERVER.'klarna_api_caller.php':HTTPS_CATALOG_SERVER.'klarna_api_caller.php';
		$ch = curl_init($api_url);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
		curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, array(                                                                          
			'Content-Type: application/json',	                                                   
			'Content-Length: ' . strlen($data_string))
		);

		$result = curl_exec($ch);
		curl_close($ch);
		$result = json_decode($result,true);
		$smarty->assign([
			'KLARNA_ORDERS_ID'=>$record['klarna_intern_orders_id'],
			'REFUND_BASE_URL'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action','refund_amount')).'action=klarna_refund'),
			'REFUND_AMOUNT'=>number_format(floatval($result['order_amount'])/100,2,',','.'),
			'REFUND_AMOUNT_PROCEED'=>number_format(floatval($result['refunded_amount'])/100,2,',','.'),
			'REFUND_AMOUNT_MAX'=>number_format((floatval($result['order_amount']) - floatval($result['refunded_amount']))/100,2,',','.'),
			'REFUND_INPUT_VALUE'=>number_format((floatval($result['order_amount']) - floatval($result['refunded_amount']))/100,2,',','.'),
			'language_path'=>DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
		]);
		$smarty->display('klarna_refund_order.html');
		exit;
	break;
    case 'products_fake_set_export':
        require_once(DIR_WS_CLASSES.'class.basics.php');
        require_once(DIR_WS_CLASSES.'class.csv.php');
        require_once(DIR_FS_INC.'YES_PAYMODULE_products_fake_sets_csv_export.inc.php');
        $basics = new basics;
        $oID = (int)xtc_db_input($_REQUEST['oID']);
        $order = new order($oID);
        $filename = \main::get_exportdata_path().'FAKESET_EXPORT_ORDER_'.$oID.'.csv';
        $shippings_array = array('OTC'=>array(array('orders_id'=>$oID,'reclamations_id'=>0)));
        $fn = YES_PAYMODULE_products_fake_sets_csv_export($shippings_array,$filename,false);
        if($fn != ''){
            $basics->download_file($filename,true);
            exit;
        }
        $messageStack->add_session(ERROR_FAKESET_EXPORT,'error');
        xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action')).'action=edit'));
        exit;
        break;
    case 'display_address_part':
		//require_once(DIR_FS_INC.'xtc_address_label.inc.php');
		$oID = (int)xtc_db_input($_REQUEST['oID']);
		switch($_REQUEST['part']){
			case 'delivery':
			case 'billing':
			$part = $_REQUEST['part'];
			break;
			default:
			$part = 'customer';
			break;
		}
		$order = new order($oID);
		$address = $order->$part;
		echo xtc_address_format($address['format_id'], $address,true, '', '<br />');
		exit;
		break;
    case 'add_order_delivery_telephone':
		$telephone = $_REQUEST['telephone'];
		$oID = (int)xtc_db_input($_REQUEST['oID']);
		$order = new order($oID);
		$order->add_history($order->info['orders_status'], false, sprintf(TEXT_ORDER_DELIVERY_TELEPHONE_UPDATE,$order->delivery['telephone'],$telephone));
		$msg = '';
		$update_sql_array = array(
			'delivery_telephone'=>$telephone,
			'last_modified'=>'now()'
		);
		xtc_db_perform(TABLE_ORDERS,$update_sql_array,'update',"orders_id='".$oID."'");
		die(json_encode(array(
			'MSG'=>$msg
		)));
		break;
    case 'add_order_delivery_email_address':
		$email = $_REQUEST['email'];
		$oID = (int)xtc_db_input($_REQUEST['oID']);
		$msg = '';
		if($email != '' and !xtc_validate_email($email)){
			$msg = sprintf(MSG_ERROR_VALIDATE_DELIVERY_EMAIL_ADDRESS,$email);
		}
		if($msg == ''){
			$order = new order($oID);
			$order->add_history($order->info['orders_status'], false, sprintf(TEXT_ORDER_DELIVERY_EMAIL_ADDRESS_UPDATE,$order->delivery['email_address'],$email));
			$update_sql_array = array(
			'delivery_email_address'=>$email,
			'last_modified'=>'now()'
			);
			xtc_db_perform(TABLE_ORDERS,$update_sql_array,'update',"orders_id='".$oID."'");
		}
		die(json_encode(array(
			'MSG'=>$msg
		)));
		break;
    case 'edit_shipping_comments':
		$orders_id = (int)xtc_db_input($_REQUEST['orders_id']);
		$order = new order($orders_id);
		$smarty->assign(array(
		'FORM' => xtc_draw_form($action,FILENAME_ORDERS,'action=set_shipping_comments&orders_id='.$orders_id,'POST','onsubmit="return set_shipping_comments_check()"'),
			'FORM_END' => '</form>',
			'ORDERS_ID'=>$orders_id,
			'FROM'=>(isset($_REQUEST['from'])) ? xtc_db_input($_REQUEST['from']) : '',
			'INPUT_COMMENTS'=>  xtc_draw_textarea_field('shipping_comments', 'virtual', 50, 4,$order->info['shipping_comments']),
			'IMAGE_SAVE'=>IMAGE_SAVE,
			'language_path'=>DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf'
		));
		header('Content-Type: text/html; charset='.CHARSET);
		$smarty->display('orders_edit_shipping_comments.html');
		exit;
		break;
    case 'set_shipping_comments':
        if( strpos($_REQUEST['orders_id'],'_') > -1){
            $parts = explode('_',$_REQUEST['orders_id']);
            $orders_id = current(array_reverse($parts));
        }else{
            $orders_id = (int)xtc_db_input($_REQUEST['orders_id']);
        }
		$order = new order($orders_id);
		$shipping_comments = (isset($_REQUEST['shipping_comments'])) ? stripslashes(yes_decode_string($_REQUEST['shipping_comments'])) : '';
		$update_sql_array = array(
			'shipping_comments'=>$shipping_comments,
			'last_modified'=>'now()'
		);
		xtc_db_perform(TABLE_ORDERS,$update_sql_array,'update',"orders_id='".$orders_id."'");
		$order->add_history($order->info['orders_status'], false, 'ShippingComment: '.$shipping_comments);
		die(stripslashes($_REQUEST['shipping_comments']));
		break;
    case 'remove_coupon':
		require_once(DIR_FS_CATALOG.'lang/'.yes_get_language_folder().'/modules/order_total/ot_coupon.php');
		$coupon_id = (int)xtc_db_input($_REQUEST['cc_id']);
		$orders_id = (int)xtc_db_input($_REQUEST['orders_id']);
		$order = new order($orders_id);
		$cID = $order->customer['ID'];
		$xtPrice = new xtcPrice($order->info['currency'], xtc_get_customer_status($cID));
			$coupon = \YES4Trade\Model\coupons::get_by_coupon_id($coupon_id);
			if($coupon === null){
				throw new Exception('Invalid coupon_id for remove_coupon');
			}
		$cc_value = (float)$xtPrice->xtcFormat($coupon->coupon_amount,false);
		$sql_insert_array = array(
			'orders_id'=>$orders_id,
			'title'=>MODULE_ORDER_TOTAL_COUPON_DESCRIPTION.' '.$coupon->coupon_code,
			'text'=>number_format($cc_value,2,',','.').' '.$order->info['currency'],
			'value'=>$cc_value,
			'class'=>'ot_coupon',
			'sort_order'=>MODULE_ORDER_TOTAL_COUPON_SORT_ORDER,
		);
		xtc_db_perform(TABLE_ORDERS_TOTAL,$sql_insert_array);
			$new = new \YES4Trade\Model\coupon_redeem_track([
				'coupon_id'=>intval($coupon_id), 
				'redeem_date'=>date('Y-m-d H:i:s'), 
				'redeem_ip'=>'', 
				'customer_id'=>intval($cID), 
				'order_id'=>intval($orders_id)
			]);
			$new->create();
		
		$order = new order($orders_id);
		$order->recalc();
		$order->add_history($order->info['orders_status'], false, 'Coupon '.$coupon->coupon_code.': '.$sql_insert_array['text']);
		exit;
		break;
    case 'add_coupon':
		require_once(DIR_FS_CATALOG.'lang/'.yes_get_language_folder().'/modules/order_total/ot_coupon.php');
		$coupon_id = (int)xtc_db_input($_REQUEST['cc_id']);
		$orders_id = (int)xtc_db_input($_REQUEST['orders_id']);
		$order = new order($orders_id);
		$cID = $order->customer['ID'];
		$xtPrice = new xtcPrice($order->info['currency'], xtc_get_customer_status($cID));
			$coupon = \YES4Trade\Model\coupons::get_by_coupon_id($coupon_id);
			if($coupon === null){
				throw new Exception('Invalid coupon_id for add_coupon');
			}
			$proz = '';
			if($coupon->coupon_type == 'P'){
				$subtotal = 0;
				foreach($order->totals as $ot){
					switch($ot['class']){
						case 'ot_subtotal':
						case 'ot_subtotal_no_tax':
							$subtotal = $ot['value'];
							break;
					}
				}
				$multi = ($coupon->coupon_amount+100)/100;
				$proz .= sprintf(' (%s%%)',number_format($coupon->coupon_amount,2,',',''));
				$cc_value = $subtotal - ($subtotal * $multi);
				$cc_value = -$cc_value;
			}else{
				$cc_value = (float)$xtPrice->xtcFormat($coupon->coupon_amount,false);
			}
		$sql_insert_array = array(
			'orders_id'=>$orders_id,
			'title'=>MODULE_ORDER_TOTAL_COUPON_DESCRIPTION.' '.$coupon->coupon_code.$proz,
			'text'=>number_format($cc_value,2,',','.').' '.$order->info['currency'],
			'value'=>$cc_value,
			'class'=>'ot_coupon',
			'sort_order'=>MODULE_ORDER_TOTAL_COUPON_SORT_ORDER,
		);
		xtc_db_perform(TABLE_ORDERS_TOTAL,$sql_insert_array);
			$new = new \YES4Trade\Model\coupon_redeem_track([
				'coupon_id'=>intval($coupon_id), 
				'redeem_date'=>date('Y-m-d H:i:s'), 
				'redeem_ip'=>'', 
				'customer_id'=>intval($cID), 
				'order_id'=>intval($orders_id)
			]);
			$new->create();
		$order = new order($orders_id);
		$order->recalc();
		$order->add_history($order->info['orders_status'], false, 'Coupon '.$coupon->coupon_code.': '.$sql_insert_array['text']);
		exit;
		break;
    case 'set_block_shipping_confirm':
		$oID = xtc_db_input($_REQUEST['oID']);
		if($oID < 1){
			die('missing param');
		}
		$smarty->assign(array(
		'FORM' => xtc_draw_form($action,FILENAME_ORDERS,'action=set_block_shipping&oID='.$oID,'POST','onsubmit="return set_block_shipping_check()"'),
			'FORM_END' => '</form>',
			'INPUT_COMMENTS'=>  xtc_draw_textarea_field('text', 'virtual', 40, 3),
			'INPUT_USE_DATE' => xtc_draw_checkbox_field('block_shipping_use_end_date','1'),
			'INPUT_DATE' => xtc_draw_input_field('block_shipping_end_date',date('Y-m-d',time()+(60*60*24*7) ),'id="block_shipping_end_date"',false,'date' ),
			'IMAGE_SAVE'=>IMAGE_SAVE,
			'language_path'=>DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf'
		));
		$smarty->display('orders_set_block_shipping.html');
		exit;
		break;
    case 'delete_discount_process':
		$otID = (int)xtc_db_input($_REQUEST['otID']);
		$oID = (int)xtc_db_input($_REQUEST['oID']);
		xtc_db_query(sprintf(
			"DELETE FROM %s WHERE orders_id='%s' AND orders_total_id='%s' AND class='ot_discount'",
			TABLE_ORDERS_TOTAL,$oID,$otID
		));
		$order = new order($oID);
		$order->recalc();
		$comments = TEXT_DISCOUNT_DELETED;
		$order->add_history($order->info['orders_status'], false, $comments);
		$messageStack->add_session(TEXT_DISCOUNT_DELETED,'success');
		xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('otID','action')).'action=edit'));
		exit;
		break;
    case 'delete_coupon_process':
		$otID = (int)xtc_db_input($_REQUEST['otID']);
		$oID = (int)xtc_db_input($_REQUEST['oID']);
		xtc_db_query(sprintf(
			"DELETE FROM %s WHERE orders_id='%s' AND orders_total_id='%s' AND class='ot_coupon'",
			TABLE_ORDERS_TOTAL,$oID,$otID
		));
		$order = new order($oID);
		$order->recalc();
		$comments = TEXT_COUPON_DELETED;
		$order->add_history($order->info['orders_status'], false, $comments);
		$messageStack->add_session(TEXT_COUPON_DELETED,'success');
		xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('otID','action')).'action=edit'));
		exit;
		break;
    case 'delete_discount':
		$otID = (int)xtc_db_input($_REQUEST['otID']);
		$query = xtc_db_query(sprintf(
			"SELECT * FROM %s WHERE orders_total_id='%s'",
			TABLE_ORDERS_TOTAL,$otID
		));
		$record = xtc_db_fetch_array($query);
		printf('<div class="main"><p><b>%s</b></p>',sprintf(TEXT_REALLY_DELETE_ORDER_DISCOUNT,$record['orders_id'],$record['title'],$record['text']));
		echo yes_draw_href_button(IMAGE_DELETE, xtc_href_link(FILENAME_ORDERS,'action=delete_discount_process&oID='.$record['orders_id'].'&otID='.$otID),'','button','ui-button ui-corner-all ui-state-default');
		echo '&nbsp;&nbsp;';
		echo yes_draw_href_button(IMAGE_CANCEL, "javascript: $('#modal_window').dialog('destroy');",'','button','ui-button ui-corner-all ui-state-default');
		die('</div>');
		break;
	case 'delete_coupon':
		$otID = (int)xtc_db_input($_REQUEST['otID']);
		$query = xtc_db_query(sprintf(
			"SELECT * FROM %s WHERE orders_total_id='%s'",
			TABLE_ORDERS_TOTAL,$otID
		));
		$record = xtc_db_fetch_array($query);
		printf('<div class="main"><p><b>%s</b></p>',sprintf(TEXT_REALLY_DELETE_ORDER_COUPON,$record['orders_id'],$record['title'],$record['text']));
		echo yes_draw_href_button(IMAGE_DELETE, xtc_href_link(FILENAME_ORDERS,'action=delete_coupon_process&oID='.$record['orders_id'].'&otID='.$otID),'','button','ui-button ui-corner-all ui-state-default');
		echo '&nbsp;&nbsp;';
		echo yes_draw_href_button(IMAGE_CANCEL, "javascript: $('#modal_window').dialog('destroy');",'','button','ui-button ui-corner-all ui-state-default');
		die('</div>');
	break;
    case 'add_discount_process':
		if($oID > 0){
			$order = new order($oID);
			$xtPrice = $order->get_price_instance();
			$cs = xtc_get_customer_status($order->customer['ID']);
			$country_id = $order->delivery['country_id'];
			$zone_id = $order->delivery['zone_id'];
		}
			
		$tax_rate = xtc_get_tax_rate($order->get_shipping_tax_class(),$country_id, $zone_id);
		$discount = str_replace(',','.',xtc_db_input($_REQUEST['discount']));
		if($order->is_netto()) {
			$tax_rate = 0;
		}
		$discount_percent = 0;
		if(strpos($discount,'%')){
			$discount_percent = (float)substr($discount,0,strpos($discount,'%'));
		}else{
			$discount = (float)$discount;
			if(PRICE_IS_BRUTTO != 'true'){
				$discount = xtc_oe_get_price_i_tax($discount, $order->get_shipping_tax_class(), true);
			}
		}
		if($discount <= 0){
			$messageStack->add_session(MSG_ERROR_ADD_DISCOUNT_NULL,'error');
			xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action')).'action=edit'));
		}
		
		$value = 0;
		$tax_values = array();
		foreach($order->totals as $total){
			switch($total['class']){
				case 'ot_subtotal':
				case 'ot_subtotal_netto':
					if($_REQUEST['discount_at'] == 'products'){
					$value = $total['value'];
					}
					break;
				case 'ot_total':
					if($_REQUEST['discount_at'] == 'order'){
					$value = $total['value'];
					}
					break;
				case 'ot_tax':
					$tax_values[''.$total['tax_rate_percent']] = array(
					'value' => $total['value'],
					'tax_class_id'=>''.$total['tax_rate_percent'],
					'otid'=>$total['otid']
					);
					break;
			}
		}
		if($discount_percent > 0){
			$discount_price = $xtPrice->xtcFormat($value, false) / 100 * $discount_percent *-1;
			$comments = sprintf(TEXT_DISCOUNT_ADDED,$discount_percent.'%');
		}else{
			$discount_price = -$discount;
			$comments = sprintf(TEXT_DISCOUNT_ADDED,$discount);
		}
		$nebenleistung_value = $discount_price;
		$discount_tr = $order->get_tax_rates_for_nebenleistung($nebenleistung_value);
		$country_id = $order->delivery['country_id'];
		$zone_id = $order->delivery['zone_id'];		
			
		foreach($discount_tr as $tax_data){
			$tax = ''.xtc_get_tax_rate($tax_data['tax_class_id'],$country_id, $zone_id);
			$tax_values[ $tax ]['value'] = $tax_values[$tax]['value'] + $tax_data['amount'];
		}
		$insert_sql_array = array(
			'orders_id'=>$oID,
			'title'=>$_REQUEST['discount_title'].' '.$_REQUEST['discount'],
			'text'=>$xtPrice->xtcFormat($discount_price, true),
			'value'=>$discount_price,
			'class'=>'ot_discount',
			'sort_order'=>MODULE_ORDER_TOTAL_DISCOUNT_SORT_ORDER,
			'tax_rate_percent'=>0
		);
		xtc_db_perform(TABLE_ORDERS_TOTAL,$insert_sql_array);
		$order->recalc();
		
		$order->add_history($order->info['orders_status'], false, $comments);
		$messageStack->add_session(MSG_SUCCESS_ADD_DISCOUNT,'success');
		xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action')).'action=edit'));
		exit;
		break;
    case 'add_discount':
		echo xtc_draw_form('add_discount_form',FILENAME_ORDERS,xtc_get_all_get_params(array('action')).'action=add_discount_process');
		echo '<fieldset>';
		echo '<label for="discount_title">'.TEXT_ADD_DISCOUNT_TITLE.'</label><br />';
		if($oID > 0){
			$order = new order($oID);
			$cs = xtc_get_customer_status($order->customer['ID']);
		}
		$title = TEXT_ADD_DISCOUNT_TITLE_DEFAULT;
		echo xtc_draw_input_field('discount_title',$title,'id="discount_title" size="40" maxlength="64"').'<br />';
		echo '<label for="discount">'.TEXT_ADD_DISCOUNT.'</label><br />';
		echo xtc_draw_input_field('discount','0,00','id="discount" size="10" maxlength="10"');
		echo (PRICE_IS_BRUTTO=='false') ? ' <i>Netto</i>': ' <i>Brutto</i>';
		echo '<br />';
		echo '<label for="discount_at">'.TEXT_ADD_DISCOUNT_AT.'</label><br />';
		echo xtc_draw_pull_down_menu('discount_at',array(array('id'=>'order','text'=>TEXT_ADD_DISCOUNT_AT_ORDER),array('id'=>'products','text'=>TEXT_ADD_DISCOUNT_AT_PRODUCTS)),'id="discount_at"').'<br />';
		echo '<input type="submit" value="'.IMAGE_SAVE.'" class="ui-button ui-corner-all ui-state-default" />';
		echo '</fieldset>';
		echo '</form>';
		exit;
		break;
    case 'customers_status_update':
		require_once(DIR_WS_CLASSES.'order_customer_status_update.php');
		require_once(DIR_WS_CLASSES.'product.php');
		if (defined('MODULE_ORDER_TOTAL_INSTALLED') && xtc_not_null(MODULE_ORDER_TOTAL_INSTALLED)) {
			$modules = explode(';', MODULE_ORDER_TOTAL_INSTALLED);
			reset($modules);
				// php8 bugfix
			//while (list(, $value) = each($modules)) {
			foreach($modules as $egal => $value) {
					if(is_file(DIR_FS_CATALOG. 'lang/' . $_SESSION['language'] . '/modules/order_total/' . $value)){
						require_once(DIR_FS_CATALOG. 'lang/' . $_SESSION['language'] . '/modules/order_total/' . $value);
					}
					if(is_file(DIR_FS_CATALOG. 'includes/modules/order_total/' . $value)){
						require_once(DIR_FS_CATALOG. 'includes/modules/order_total/' . $value);
					}
			}
		}
		foreach($_REQUEST['orders_id'] as $orders_id){
			$oID = (int)xtc_db_input($orders_id);
			$ocu = new order_customer_status_update( new order($oID),$_SESSION['languages_id'] );
			$result = $ocu->update();
			$order = new order($oID);
			$order->recalc();
			$order->add_history($order->info['orders_status'],false,sprintf(TEXT_HISTORY_ORDER_CUSTOMERS_STATUS_CHANGE,$result['old_status_name'],$result['new_status_name']));
		}
		$messageStack->add_session(MSG_SUCCESS_CUSTOMERS_STATUS_CHANGED,'success');
		if(sizeOf($_REQUEST['orders_id']) == 1){
			xtc_redirect(xtc_href_link(FILENAME_ORDERS,'action=edit&oID='.current($_REQUEST['orders_id'])));
		}else{
			xtc_redirect(xtc_href_link(FILENAME_ORDERS));
		}
		break;
    case 'amazon_orders':
		require('orders_amazon.inc.php');
		break;
    case 'process_quick_edit_shipping_class':
		$order = new order((int)xtc_db_input($_REQUEST['oID']));
        require_once(DIR_FS_LANGUAGES.$_SESSION['language'].'/modules/shipping/'.$_REQUEST['shipping_class'].'.php');
		$update_sql_array = array(
			'shipping_method'=>constant('MODULE_SHIPPING_'.strtoupper($_REQUEST['shipping_class']).'_TEXT_TITLE'),
			'shipping_class'=>$_REQUEST['shipping_class'].'_'.$_REQUEST['shipping_class']
		);
		$comments = sprintf(TEXT_HISTORY_SHIPPING_CLASS_CHANGED,$order->info['shipping_class'],$_REQUEST['shipping_class'].'_'.$_REQUEST['shipping_class']);
		$order->add_history($order->info['orders_status'], false, $comments);
		xtc_db_perform(TABLE_ORDERS,$update_sql_array,'update',"orders_id='".(int)xtc_db_input($_REQUEST['oID'])."'");
		$messageStack->add_session($comments,'success');
		xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action')).'action=edit'));
		exit;
		break;
    case 'quick_edit_shipping_class':
		printf('<p>%s</p>',TEXT_QUICK_SHIPPING_EDIT_INTRO);
		echo xtc_draw_form('quick_shipping_edit',FILENAME_ORDERS,xtc_get_all_get_params(array('action')).'action=process_quick_edit_shipping_class');
		$order = new order((int)xtc_db_input($_REQUEST['oID']));
		$default_shipping_class = $order->info['shipping_class'];
		$shippings_array = array();
		$shipping_classes = explode(';',MODULE_SHIPPING_INSTALLED);
		foreach($shipping_classes as $sc){
			$sc_code = current(explode('.php',$sc));
			if(stristr($sc_code,'amazon')) continue;
			if(!is_file(DIR_FS_LANGUAGES.$_SESSION['language'].'/modules/shipping/'.$sc))
				die('Missing File: '.DIR_FS_LANGUAGES.$_SESSION['language'].'/modules/shipping/'.$sc);
			require_once(DIR_FS_LANGUAGES.$_SESSION['language'].'/modules/shipping/'.$sc);
			$shippings_array[] = array(
			'id'=>$sc_code,
			'text'=>constant('MODULE_SHIPPING_'.strtoupper($sc_code).'_TEXT_TITLE').' ('.$sc_code.')'
			);
		}
		printf('<b>%s</b>: %s',TEXT_QUICK_SHIPPING_NEW_SHIPPING_CLASS,xtc_draw_pull_down_menu('shipping_class',$shippings_array,$default_shipping_class));
		printf('<input type="submit" class="ui-button ui-corner-all ui-state-default" value="%s" />',IMAGE_SAVE);
		exit;
		break;
	case 'ajax_address_save':	    
		$orders_id = (int)xtc_db_input($_REQUEST['oID']);
		$json_array = array();
		$address_str = array();
		$order = new order($orders_id);
		$prefix = $order->get_update_address_part_prefix($_REQUEST['address_type']);
		foreach($_REQUEST as $key=>$val){
			if(!strstr($key,$prefix) or $key == 'update_customers_name'){
				continue;
			}
			$address_str[] = xtc_db_prepare_input(yes_decode_string($key.': '.$val));
		}
		$address_str = implode(',',$address_str);
		
		$update_sql_array = $order->get_address_part_sql($_REQUEST['address_type'], $_REQUEST,'',false);
		
		$order->update_address_part($update_sql_array);
		$json_array = $update_sql_array;
		if(isset($_REQUEST['update_customers_name']) and $_REQUEST['update_customers_name'] == 1){
		    $lastname = '';
		    $name_parts = explode(' ',$_REQUEST[$prefix.'name']);
		    foreach($name_parts as $np){
			    if(!isset($firstname)){
				    $firstname = $np;
				    continue;
			    }
			    $lastname .= $np .' ';
		    }
		    $lastname = trim($lastname);
		    $update_sql_array = array(
				'customers_firstname'=>yes_decode_string($firstname),
				'customers_lastname'=>yes_decode_string($lastname),
				'customers_last_modified'=>'now()'
		    );
		    xtc_db_perform(TABLE_CUSTOMERS,$update_sql_array,'update',"customers_id='".$order->customer['ID']."'");
		    $new = new \YES4Trade\Model\customers_memo([
				'customers_id'=>(int)$order->customer['ID'],
				'memo_date'=>date('Y-m-d H:i:s'),
				'memo_title'=>TEXT_ADDRESS_UPDATE_TELEPHONE_MEMO_TITLE,
				'memo_text'=>sprintf(TEXT_ADDRESS_UPDATE_CUSTOMERS_MEMO_TEXT,$order->info['id'],$firstname.' '.$lastname),
				'poster_id'=>(int)$_SESSION['customer_id']
		    ]);
		    $new->create();
		    $firstname = '';
		}
		    
		
		if(isset($_REQUEST['copy_customer']) and $_REQUEST['copy_customer'] == 1){
			$update_sql_array = $order->get_address_part_sql($_REQUEST['address_type'], $_REQUEST,'customer');
			$order->update_address_part($update_sql_array);
			$json_array = xtc_array_merge($json_array,$update_sql_array);
		}
		
		if(isset($_REQUEST['copy_shipping']) and $_REQUEST['copy_shipping'] == 1){
			$update_sql_array = $order->get_address_part_sql($_REQUEST['address_type'], $_REQUEST,'shipping');
			$order->update_address_part($update_sql_array);
			$json_array = xtc_array_merge($json_array,$update_sql_array);
		}
		
		if(isset($_REQUEST['copy_invoice']) and $_REQUEST['copy_invoice'] == 1){
			$update_sql_array = $order->get_address_part_sql($_REQUEST['address_type'], $_REQUEST,'invoice');
			$order->update_address_part($update_sql_array);
			$json_array = xtc_array_merge($json_array,$update_sql_array);
		}
		$query = xtc_db_query(sprintf(
			"SELECT entry_gender FROM %s ab LEFT JOIN %s c ON ab.address_book_id=c.customers_default_address_id WHERE c.customers_id='%s' AND ab.customers_id=c.customers_id",
			TABLE_ADDRESS_BOOK,TABLE_CUSTOMERS,$order->customer['ID']
		));
		$record = xtc_db_fetch_array($query);
		$entry_gender = $record['entry_gender'];
		if(isset($_REQUEST['ab_action']) and ($_REQUEST['ab_action'] == 'copy_as' or $_REQUEST['ab_action'] == 'update')){
		    if(isset($_REQUEST['customers_telephone']) and !empty($_REQUEST['customers_telephone'])){
			xtc_db_query(sprintf(
				"UPDATE %s SET customers_telephone='%s',customers_last_modified=now() WHERE customers_id='%s'",
				TABLE_CUSTOMERS,
				xtc_db_input($_REQUEST['customers_telephone']),
				$order->customer['ID']
			));
			$new = new \YES4Trade\Model\customers_memo([
			    'customers_id'=>(int)$order->customer['ID'],
			    'memo_date'=>date('Y-m-d H:i:s'),
			    'memo_title'=>TEXT_ADDRESS_UPDATE_TELEPHONE_MEMO_TITLE,
			    'memo_text'=>TEXT_ADDRESS_UPDATE_TELEPHONE_MEMO_TEXT,
			    'poster_id'=>(int)$_SESSION['customer_id']
			]);
			$new->create();
		    }
		    if(isset($_REQUEST['customers_mobile']) and !empty($_REQUEST['customers_mobile'])){
			xtc_db_query(sprintf(
				"UPDATE %s SET mobile='%s',customers_last_modified=now() WHERE customers_id='%s'",
				TABLE_CUSTOMERS,
				xtc_db_input($_REQUEST['customers_mobile']),
				$order->customer['ID']
			));
			$new = new \YES4Trade\Model\customers_memo([
			    'customers_id'=>(int)$order->customer['ID'],
			    'memo_date'=>date('Y-m-d H:i:s'),
			    'memo_title'=>TEXT_ADDRESS_UPDATE_MOBILE_MEMO_TITLE,
			    'memo_text'=>TEXT_ADDRESS_UPDATE_MOBILE_MEMO_TEXT,
			    'poster_id'=>(int)$_SESSION['customer_id']
			]);
			$new->create();
		    }
		}
		switch($_REQUEST['ab_action']){
			case 'copy_as':
				$ab_address_class = xtc_db_input($_REQUEST['ab_address_class']);
				
				if($ab_address_class != ''){
                    \YES4Trade\Model\address_book::update_address_class_to_empty_by_address_class_and_customers_id($ab_address_class, (int)$order->customer['ID']);
				}
				
				$lastname = '';
				$name_parts = explode(' ',$_REQUEST[$prefix.'name']);
				foreach($name_parts as $np){
					if(!isset($firstname)){
						$firstname = $np;
						continue;
					}
					$lastname .= $np .' ';
				}
				$lastname = trim($lastname);
				$new = new \YES4Trade\Model\address_book([
					'customers_id'=>(int)$order->customer['ID'],
					'entry_gender'=>$entry_gender,
					'entry_company'=>yes_decode_string($_REQUEST[$prefix.'company']),
					'entry_firstname'=>yes_decode_string($firstname),
					'entry_lastname'=>yes_decode_string($lastname),
					'entry_street_address'=>yes_decode_string($_REQUEST[$prefix.'street_address']),
					'entry_suburb'=>yes_decode_string($_REQUEST[$prefix.'suburb']),
					'entry_postcode'=>yes_decode_string($_REQUEST[$prefix.'postcode']),
					'entry_city'=>yes_decode_string($_REQUEST[$prefix.'city']),
					'entry_state'=>yes_decode_string($_REQUEST[$prefix.'state']),
					'entry_country_id'=> (int)$_REQUEST[$prefix.'country'],
					'address_class'=>$ab_address_class,
					'address_date_added'=>date('Y-m-d H:i:s'),
				]);
				$new->create();
				break;
			case 'update':
				$ab_address_book_id = xtc_db_input($_REQUEST['ab_address_book_id']);
				$lastname = '';
				$name_parts = explode(' ',$_REQUEST[$prefix.'name']);
				foreach($name_parts as $np){
					if(!isset($firstname)){
						$firstname = $np;
						continue;
					}
					$lastname .= $np .' ';
				}
				$lastname = trim($lastname);
				$upd = new \YES4Trade\Model\address_book([
					'address_book_id'=>(int)$ab_address_book_id,
					'entry_gender'=>$entry_gender,
					'entry_company'=>yes_decode_string($_REQUEST[$prefix.'company']),
					'entry_firstname'=>yes_decode_string($firstname),
					'entry_lastname'=>yes_decode_string($lastname),
					'entry_street_address'=>yes_decode_string($_REQUEST[$prefix.'street_address']),
					'entry_suburb'=>yes_decode_string($_REQUEST[$prefix.'suburb']),
					'entry_postcode'=>yes_decode_string($_REQUEST[$prefix.'postcode']),
					'entry_city'=>yes_decode_string($_REQUEST[$prefix.'city']),
					'entry_state'=>yes_decode_string($_REQUEST[$prefix.'state']),
					'entry_country_id'=> (int)$_REQUEST[$prefix.'country'],
					'address_last_modified'=>date('Y-m-d H:i:s')
				]);
				$upd->update();
				break;
		}
        // FUER VERSANDABSCHLUSS V2 - 2021/03
		if($prefix == 'delivery_'){
			$order = new order($orders_id);
			$json_array['delivery_country_code'] = $order->delivery['iso_code_2'];
			$address = xtc_address_format(5, $order->delivery, true, "", "<br />");
			if($order->delivery['telephone'] != ''){
				$address .= "<br />&#9742; ".$order->delivery['telephone'];
			}else{
				$address .= "<br />&#9742; ".$order->customer['telephone'];
			}
			if($order->info['mobile'] != ''){
				$address .= "<br />&#9742; ".$order->customer['mobile'];
			}
			if($order->delivery['email_address'] != ''){
				$address .= "<br />&#x1f4e7; ".$order->delivery['email_address'];
			}else{
				$address .= "<br />&#x1f4e7; ".$order->customer['email_address'];
			}
			$json_array['delivery_address_for_shipping'] = $address;
		}
		$json = array();
		foreach($json_array as $k=>$v){
			$json[$k]=xtc_db_prepare_input(yes_encode_string($v));
		}
		$order->add_history($order->info['orders_status'], false, sprintf(HISTORY_ADDRESS_CHANGE,$_REQUEST['address_type'],$address_str));
		die(json_encode(array(
		  'UPDATE_ARRAY'=>$json,
		    'ADDRESS_TYPE'=>$_REQUEST['address_type']
		)));
		exit;
		break;
	case 'delete_comment':
		$oID = (int)xtc_db_input($_REQUEST['oID']);
		xtc_db_query(sprintf(
			"UPDATE orders SET comments='' WHERE orders_id=%s",
			$oID
		));
		$order = new order($oID);
		$order->add_history($order->info['orders_status'], false, COMMENTS_DELETE_MESSAGE);
		$messageStack->add_session(COMMENTS_DELETE_MESSAGE,'success');
		xtc_redirect(xtc_href_link('orders.php',xtc_get_all_get_params(array('action')).'action=edit'));
		break;
  	case 'check_distributors':
		require_once(DIR_WS_CLASSES.'product.php');
		$order = new order((int)xtc_db_input($_REQUEST['oID']));
		if(!sizeOf($order->products)){
			die(TEXT_CHECK_DISTRIBUTORS_NO_PRODUCTS);
		}
		$distributors = array();
		$xtPrice = $order->get_price_instance();
		$country_id = $order->delivery['country_id'];
		$zone_id = $order->delivery['zone_id'];
		// BUGF_CH_OSS
		$xtPrice->setCountryZone($country_id, $zone_id); 
                
		foreach($order->products as $order_product){
			$product = new product($order_product['id']);
			$collies = $product->get_collies();
			if(!sizeOf($collies)){
				$product_distributors = $product->get_distributors(true); // incl prices
				if(!sizeOf($product_distributors)){
					continue;
				}
				foreach($product->distributors as $pdnr=>$dist){
					$no_number = ($dist['distributor_products_number'] == '') ? 1 : 0;
						
					$ek_price_data = xtc_get_price_ek_data($order_product['id'],'MIN',$dist['id']);
					$ek_price = $ek_price_data['price'];
					$default_price = 0;
					foreach($dist['prices'] as $price){
						if($price['is_default'] == 1){
							$default_price = $price['price'];
						}
					}
					$distributors[ $dist['id'] ][$pdnr] = array(
						'products_id'=>$order_product['id'],
						'opID'=>$order_product['opID'],
						'qty'=>$order_product['qty'],
						'name'=>$order_product['name'],
						'ek_price_netto'=>$ek_price,
						'properties'=>$order_product['properties'],
						'price'=>$order_product['price'],
						'vpe'=>(int)$ek_price_data['vpe'],
						'vse'=>(int)$ek_price_data['vse'],
						'distributor_products_number' => $dist['distributor_products_number'],
						'mindestbestellmenge' => $dist['mindestbestellmenge'],
						'default_price'=> $default_price,
						'conditions' => $ek_price_data['conditions'],
						'shippings' => $ek_price_data['shippings'],
						'no_number'=>$no_number
					);
                	$distributors[ $dist['id'] ][$pdnr]['shippingtime'] = xtc_get_shipping_status_name($ek_price_data['shipping_status_id']);
				}
			}
			if(sizeOf($collies)){
				$tax_rate = xtc_get_product_collies_tax_value($collies, $country_id, $zone_id);
				$tax_class = xtc_get_product_collies_tax_class($collies, $country_id, $zone_id);
                                
				foreach($collies as $colli){
					$colli_product = new product($colli['collie_products_id']);
					$product_distributors = $colli_product->get_distributors(true); // incl prices
					if(!sizeOf($product_distributors)){
						continue;
					}
					foreach($product_distributors as $pdnr=>$dist){
						$no_number = ($dist['distributor_products_number'] == '') ? 1 : 0;
						$ek_price_data = xtc_get_price_ek_data($colli['collie_products_id'],'MIN',$dist['id']);
						$ek_price = $ek_price_data['price'];
						$default_price = 0;
						foreach($dist['prices'] as $price){
							if($price['is_default'] == 1){
								$default_price = $price['price'];
							}
						}
						$products_tax_class_id = $tax_class;
						$price = $xtPrice->xtcGetPrice($colli['collie_products_id'], $format = false, 1, $products_tax_class_id, $pPrice = '', $order->customer['ID']);
						$distributors[ $dist['id'] ][$pdnr] = array(
							'products_id'=>$colli['collie_products_id'],
							'qty'=>$order_product['qty']*$colli['quantity'],
							'name'=>xtc_get_products_name($colli['collie_products_id']),
							'ek_price_netto'=>$ek_price,
							'vpe'=>(int)$ek_price_data['vpe'],
							'vse'=>(int)$ek_price_data['vse'],
							'price'=>$price,
							'SET'=>$order_product['id'],
							'distributor_products_number' => $dist['distributor_products_number'],
							'mindestbestellmenge' => $dist['mindestbestellmenge'],
							'conditions' => $ek_price_data['conditions'],
							'shippings' => $ek_price_data['shippings'],
							'default_price'=> $default_price,
							'no_number'=>$no_number
						);
                        $distributors[ $dist['id'] ][$pdnr]['shippingtime'] = xtc_get_shipping_status_name($ek_price_data['shipping_status_id']);
					}
				}
			}
		}
		if(!sizeOf($distributors)){
			die(TEXT_CHECK_DISTRIBUTORS_NO_DISTRIBUTOR_PRODUCTS);
		}
		$checked_set = false;
		$items = array();
		
		$created_do = array();
		$do_array = array();
		$query = xtc_db_query(sprintf(
			"SELECT distributor_orders_id,distributor_name, date_created,orders_status FROM distributor_orders WHERE orders_id='%s'",
			$order->info['id']
		));
		while($record = xtc_db_fetch_array($query)){
			$record['date_created'] = xtc_date_short($record['date_created']);
			$record['orders_status'] = xtc_get_distributor_orders_status_name($record['orders_status']);
			$created_do[] = $record;
		}
		if(sizeOf($created_do)){
			foreach($created_do as $k=>$do){
				$query = xtc_db_query(sprintf(
					"SELECT products_id,products_name,products_quantity FROM distributor_orders_products WHERE distributor_orders_id='%s' AND stuecklisten_id=0",
					$do['distributor_orders_id']
				));
				while($record = xtc_db_fetch_array($query)){
					$created_do[ $k ]['products'][] = $record;
				}
			}
			$smarty->assign('CREATED_DISTRIBUTOR_ORDERS_ARRAY',$created_do);
		}
		
		foreach($distributors as $distributor_id=>$products){
			$checked = (!$checked_set) ? true : false;
			$checked_set = true;
			$products_array = array();
			foreach($products as $product){
				if(isset($product['SET'])){
					$name = 'SET pID '.$product['SET'].' - '.$product['name'];
					$hidden = 'qty_set_'.$product['SET'].'_'.$product['products_id'];
					$qty_field = xtc_draw_hidden_field('qty_set['.$product['SET'].']['.$product['products_id'].']',$product['qty']);
				}else{
					$hidden = 'qty_'.$product['products_id'];
					if(isset($product['properties']) and sizeOf($product['properties'])){
						$qty_field = xtc_draw_hidden_field('qty['.$product['products_id'].'{'.$product['opID'].'}]',$product['qty']);
					}else{
						$qty_field = xtc_draw_hidden_field('qty['.$product['products_id'].']',$product['qty']);
					}
					$name = $product['name'];
				}
				$P = new product($product['products_id']);
				$SQ = new products_quantity($product['products_id']);
				$products_array[] = array(
					'HIDDEN_FIELD_NAME'=>$hidden,
					'NO_NUMBER'=>$product['no_number'],
					'PROPERTIES'=>$product['properties'],
					'QTY'=>$product['qty'],
					'VPE'=>$product['vpe'],
					'VSE'=>$product['vse'],
					'PRODUCTS_ID'=>$product['products_id'],  
					'PRODUCTS_NAME'=>$name,
					'INPUT_QTY'=>$qty_field,
					'EK_PRICE'=>number_format($product['ek_price_netto'],2,',','.'),
					'PRICE'=>number_format($product['price'],2,',','.'),
					'DEFAULT_PRICE'=>(($product['default_price'] > 0) ? number_format($product['default_price'],2,',','.'): ''),
					'CONDITIONS'=>$product['conditions'],
					'SHIPPINGS'=>$product['shippings'],
					'SHIPPINGTIME'=>(int)$product['shippingtime'],
					'MINDESTBESTELLMENGE'=>(int)$product['mindestbestellmenge'],
					'DEFAULT_DISTRIBUTOR'=>  xtc_get_distributor_name($P->get_default_distributor_id()),
					'V1'=>$SQ->get_available1_qty(),
					'PHYS'=>$SQ->get_products_total_qty()
				);
			}
			$items[] = array(
				'FORM'=>xtc_draw_form('distributor_order_create','distributor_orders.php','action=create_from_order&orders_id='.$_REQUEST['oID'],'POST','id="form_'.$distributor_id.'" onsubmit="return false;"'),
				'INPUT_SUBMIT'=>xtc_draw_input_field('save', BUTTON_CREATE_AUTOMATIC_DISTRIBUTOR_ORDER, 'class="ui-button ui-corner-all ui-state-default button_create_distributor" id="dist_'.$distributor_id.'"', false, 'button'),
				'INPUT_DISTRIBUTOR_ID'=>xtc_draw_hidden_field('dID',$distributor_id),
				'DISTRIBUTOR'=>xtc_get_distributor_name($distributor_id),
				'DISTRIBUTOR_ID'=>$distributor_id,
				'PRODUCTS'=>$products_array
			);
		}
		$smarty->assign(array(
			'TEXT_DISTRIBUTOR'=>TEXT_DISTRIBUTOR,
			'FORM_END'=>'</form>',
			'items'=>$items,
			'DELIVERY_ADDRESS'=>  xtc_address_format($order->delivery['format_id'], $order->delivery, true,'','<br />'),
			'TEXT_USE_DELIVERY_ADDRESS'=>TEXT_USE_DELIVERY_ADDRESS,
			'language_path'=>DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf'
		));
		$smarty->display('orders_check_distributors.html');
		exit;
		break;
	  case 'copy':
	      $oID = (int)xtc_db_input($_REQUEST['oID']);
	      $checkQ = xtc_db_query(sprintf(
		      "SELECT orders_id FROM %s WHERE orders_id='%s'",
		      TABLE_ORDERS,$oID
	      ));
	      if(!xtc_db_num_rows($checkQ)){
		  	die('Unknown Orders ID');
	      }
              $order = new order($oID);
	      if(defined('STOCK_CHECK') and STOCK_CHECK == 'true'){
			$products = $order->products;
			$p = array();
			for($i=0;$i<sizeOf($products);$i++){
				if(!isset($p[ $products[$i]['id'] ])){
					$p[ $products[$i]['id'] ] = $products[$i]['qty'];
				}else{
					$p[ $products[$i]['id'] ] += $products[$i]['qty'];
				}
			}
			if(sizeOf($p)){
				foreach($p as $pID => $qty){
					$SQ = new products_quantity($pID);
					if($SQ->get_available2_qty() < $qty){
						$messageStack->add_session(sprintf(MSG_ERROR_ORDER_COPY_QTY,$_REQUEST['oID'],$pID),'error');
						xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action'))));
					}
				}
			}
		}
		if(isset($_REQUEST['admin']) and $_REQUEST['admin'] == 1){
			$created = 0;
			$num = isset($_REQUEST['num']) ? (int)xtc_db_input($_REQUEST['num']) : 1;
			if($num < 1) $num = 1;
			$status = isset($_REQUEST['status']) ? (int)xtc_db_input($_REQUEST['status']) : 1;
			if($status < 1) $status = 1;
			for($i=0;$i<$num;$i++){
				$oID = $order->copy($status);
				$created++;
			}
			$messageStack->add_session(sprintf(
					MSG_SUCCESS_ORDERS_COPIED,
					intval($created), 
					intval($_REQUEST['oID'])
				),'success'
			);
		}else{
			$oID = $order->copy();
			$messageStack->add_session(sprintf(MSG_SUCCESS_ORDER_COPY,$oID),'success');
		}
		xtc_redirect(xtc_href_link(FILENAME_ORDERS,'oID='.$oID.'&action=edit'));
		break;
	case 'upselling_end':
		if($admin_access['orders_edit'] != 1){
			die('Auth required');
		}
		if(!isset($_REQUEST['oID']) or $_REQUEST['oID'] < 0){
			die('Missing Parameter');
		}
		$update_sql_array = array(
			'orders_status'=>1,
			'last_modified'=>'now()'
		);
		xtc_db_perform('orders',$update_sql_array,'update','orders_id='.$_REQUEST['oID']);
		$order = new order($_REQUEST['oID']);
		$order->add_history(1, 0, HISTORY_UPSELLING_END);
		$messageStack->add_session(HISTORY_UPSELLING_END,'success');
		xtc_redirect(xtc_href_link('orders.php',xtc_get_all_get_params(array('action')).'action=edit'));
		break;
	case 'upselling_end_confirm':
		if($admin_access['orders_edit'] != 1){
			die('Auth required');
		}
		echo xtc_draw_form('u_end','orders.php',xtc_get_all_get_params(array('action')).'action=upselling_end');
		echo xtc_draw_hidden_field('oID',$_REQUEST['oID']);
		echo '<p class="main">&nbsp;<img src="images/icons/big_warning.gif" border="0" alt="" />'.INTRO_UPSELLING_END.'</p>';
		echo '<p class="smallText">'.INTRO_UPSELLING_END2.'</p>';
		echo '<input type="submit" value="'.START_UPSELLING_END.'" class="ui-button ui-corner-all ui-state-default" />';
		echo '</form>';
		exit;
		break;
	case 'get_order_total':
		$orders_id_array = $_REQUEST['oID'];
		$ot_total = 0;
		$ot_subtotal = 0;
		$ot_subtotal_nt = 0;
		$ot_shipping = 0;
		$ot_tax = array();
		require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/order_total/ot_total.php');
		require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/order_total/ot_subtotal.php');
		require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/order_total/ot_total.php');
		require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/order_total/ot_shipping.php');
		require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/order_total/ot_tax.php');
		$order_total_titles = [
			'ot_total'=>strip_tags(constant('MODULE_ORDER_TOTAL_TOTAL_TITLE')),
			'ot_subtotal'=>strip_tags(constant('MODULE_ORDER_TOTAL_SUBTOTAL_TITLE')),
			'ot_subtotal_no_tax'=>strip_tags(constant('MODULE_ORDER_TOTAL_SUBTOTAL_NO_TAX_TITLE')),
			'ot_shipping'=>strip_tags(constant('MODULE_ORDER_TOTAL_SHIPPING_TITLE')),
			'ot_tax'=>strip_tags(constant('MODULE_ORDER_TOTAL_TAX_TITLE')),
		];
		for($i=0;$i<sizeOf($_REQUEST['oID']);$i++){
			$order = new order(intval(xtc_db_input($_REQUEST['oID'][$i])));
			foreach($order->totals as $total){
				if($total['class'] == 'ot_total')
					$ot_total += $total['value'];
				if($total['class'] == 'ot_subtotal')
					$ot_subtotal += $total['value'];
				if($total['class'] == 'ot_subtotal_no_tax')
					$ot_subtotal_nt += $total['value'];
				if($total['class'] == 'ot_shipping')
					$ot_shipping += $total['value'];
				if($total['class'] == 'ot_tax')
					$ot_tax[$total['title']] += $total['value'];
			}
		}
		if(sizeOf($ot_tax)){
			$taxes = array();
			foreach($ot_tax as $title=>$value){
				$taxes[] = [
					'text'=>str_replace(':','',$title),
					'value'=>number_format($value,2,',','.')
				];
			}
		}
		$json_array = [
			'total'=>[
				'text'=>$order_total_titles['ot_total'],
				'value'=>number_format($ot_total,2,',','.'),
			],
			'subtotal'=>[
				'text'=>$order_total_titles['ot_subtotal'],
				'value'=>number_format($ot_subtotal,2,',','.'),
			],
			'subtotal_no_tax'=>[
				'text'=>$order_total_titles['ot_subtotal_no_tax'],
				'value'=>number_format($ot_subtotal_nt,2,',','.'),
			],
			'shipping'=>[
				'text'=>$order_total_titles['ot_shipping'],
				'value'=>number_format($ot_shipping,2,',','.')
			],
			'tax'=>$taxes
		];
		die(json_encode($json_array));
		exit;
		break;
	case 'calc_sum':
		$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
		$smarty->assign('FORM',xtc_draw_form('commentsvisible','orders.php',xtc_get_all_get_params(array('action')).'action=save_comments_visible'));
		$smarty->assign('FORM_END','</form>');
		$smarty->assign('action','calc_sum');
		$smarty->display(DIR_FS_ADMIN.'templates/order_listing.html');
		exit;
		break;
	case 'offer_to_order':
		$orders_id = xtc_db_input($_GET['oID']);
		$order = new order($orders_id, '');
		
		if(STOCK_CHECK == "true" and sizeOf($order->products)){
		    $check_products = array();
		    foreach($order->products as $op){
			if(!isset($check_products[ $op['id'] ])) $check_products[ $op['id'] ] = 0;
			$check_products[ $op['id'] ] += $op['qty'];
			$collies = xtc_get_product_collies($op['id']);
			if(sizeOf($collies)){
			    foreach($collies as $col){
				if(!isset($check_products[ $col['collie_products_id'] ])) $check_products[ $col['collie_products_id'] ] = 0;
				$check_products[ $col['collie_products_id'] ] += $col['quantity']*$op['qty'];
			    }
			}
		    }
		    foreach($check_products as $pID=>$qty){
			// CHECK OB JEDER DER ENTHALTENEN ARTIKEL BESTAND HAT
			$SQ = new products_quantity($pID);
			$qty_total = $SQ->get_available1_qty();
			if( ( $qty_total < $qty ) or ( $qty_total< 1 ) ){
				$messageStack->add_session(sprintf(MSG_ERROR_OFFER_TO_ORDER,$pID,$qty_total,$qty),'error');
				xtc_redirect( xtc_href_link('orders.php',xtc_get_all_get_params(array('action')).'action=edit' ) );
			}
		    }
		}
		$update_sql_array = array(
			'date_purchased'=>'now()',
			'last_modified'=>'now()',
			'orders_status'=>1,
			'no_warning'=>0
		);
		xtc_db_perform('orders',$update_sql_array,'update',"orders_id='".$orders_id."'");
		if(defined('EBAY_END_AUCTION_AT_SHOPORDER') and EBAY_END_AUCTION_AT_SHOPORDER == 'True' and sizeOf($order->products)){
			foreach($order->products as $product){
				$collies = xtc_get_product_collies($product['id']);
				$remove = $product['qty'];
				if(!sizeOf($collies)){
					if($remove > 0){
						yes_end_auction_add($product['id'],$remove);
					}
				}else{
					if($remove > 0){
						foreach($collies as $k=>$collie){
							yes_end_auction_add($collie['collie_products_id'],$remove*$collie['quantity']);
						}
					}
				}
			}
		}
		
		$order->add_history($order->info['orders_status'], false, HISTORY_OFFER_TO_ORDER);
		$messageStack->add_session(HISTORY_OFFER_TO_ORDER,'success');
		xtc_redirect(xtc_href_link('orders.php',xtc_get_all_get_params(array('action','tab')).'action=edit'));
		break;
	case 'save_comments_visible':
		$orders_id = xtc_db_input($_GET['oID']);
		$order = new order($orders_id, '');
		$update_sql_array = array(
			'last_modified'=>'now()',
			'comments_visible'=>$_POST['comments_visible']
		);
		xtc_db_perform('orders',$update_sql_array,'update',"orders_id='".$orders_id."'");
		$order->add_history($order->info['orders_status'], false, HISTORY_COMMENTS_VISIBLE_UPDATED);
		$messageStack->add_session(HISTORY_COMMENTS_VISIBLE_UPDATED,'success');
		xtc_redirect(xtc_href_link('orders.php',xtc_get_all_get_params(array('action')).'action=edit'));
		break;
	case 'comments_visible_edit':
		$orders_id = xtc_db_input($_GET['oID']);
		$order = new order($orders_id, '');
		require_once(DIR_WS_CLASSES.'class.textitems.php');
		$TI = new yesTextitems();
		$TI->init('orders_status_comment',$_SESSION['customer_id']);
		if(sizeOf($TI->data)){
		    $smarty->assign('TEXTITEMS',$TI->data);
		}
		$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
		$smarty->assign('FORM',xtc_draw_form('commentsvisible','orders.php',xtc_get_all_get_params(array('action')).'action=save_comments_visible'));
		$smarty->assign('FORM_END','</form>');
		$smarty->assign('COMMENTS_VISIBLE_TITLE',COMMENTS_VISIBLE);
		$smarty->assign('INPUT_COMMENTS_VISIBLE',xtc_draw_textarea_field('comments_visible','wrap',30,3,$order->info['comments_visible'],'style="width:100%;"'));
		header('Content-Type: text/html; charset='.CHARSET);
		echo $smarty->fetch(DIR_FS_ADMIN.'templates/order_comments_visible.html');
		exit;
		break;
	// FIBUNUMBERS ADDON
	case 'add_fibunumber':
		$orders_id = xtc_db_input($_GET['oID']);
		$order = new order($orders_id, '');
		if($admin_access['f_orders_fibunumbers'] != 1
			or MODULE_OTHER_FIBUNUMBERS_STATUS != 'True'
			or $order->get_fibunumber() > 0){
			die('Unauthorized call');
		}
		$number = $order->add_fibunumber();
		$comments = sprintf(HISTORY_ORDER_FIBUNUMBER,$number);
		$order->add_history($order->info['orders_status'], false, $comments);
		$messageStack->add_session($comments,'success');
		xtc_redirect(xtc_href_link('orders.php',xtc_get_all_get_params(array('action')).'action=edit'));
		break;
	case 'set_fibunumber':
		$orders_id = xtc_db_input($_GET['oID']);
		$order = new order($orders_id, '');
		if($admin_access['f_orders_fibunumbers'] != 1
			or MODULE_OTHER_FIBUNUMBERS_STATUS != 'True'
			or $order->get_fibunumber() > 0){
			die('Unauthorized call');
		}
		$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
		$smarty->assign('FORM',xtc_draw_form('fibunumber','orders.php',xtc_get_all_get_params(array('action')).'action=add_fibunumber'));
		$smarty->assign('FORM_END','</form>');
		$smarty->assign('TEXT_ADD_FIBUNUMBER',TEXT_ADD_FIBUNUMBER);
		
		if(defined('MODULE_OTHER_FIBUNUMBERS_STATUS') and MODULE_OTHER_FIBUNUMBERS_STATUS == 'True'){
			$branches = array(
				array('id'=>'','text'=>'Keine Filiale')
			);
			$query = xtc_db_query(
				"SELECT branches_id,title FROM branches WHERE stammlager=0 ORDER BY title"
			);
			while($record = xtc_db_fetch_array($query)){
				$branches[] = array(
					'id'=>$record['branches_id'],
					'text'=>$record['title']
				);
			}
			if(sizeOf($branches)>1)
				$smarty->assign('INPUT_BRANCHES_ID',  xtc_draw_pull_down_menu('branches_id', $branches,0));
		}
		
		$smarty->assign('HEADING_TITLE',HEADING_TITLE_ADD_FIBUNUMBER);
		$smarty->assign('INPUT_SUBMIT',yes_draw_href_button(IMAGE_UPDATE,'','','submit'));
		$smarty->assign('INPUT_CANCEL',yes_draw_href_button(IMAGE_CANCEL,xtc_href_link('orders.php',xtc_get_all_get_params(array('action')).'action=edit')));
		header('Content-Type: text/html; charset='.CHARSET);
		echo $smarty->fetch(DIR_FS_ADMIN.'templates/order_fibunumbers.html');
		exit;
		break;
	case 'save_changed_paydate':
		$orders_id = (int)xtc_db_input($_GET['oID']);
		$date_payment = sprintf("%s-%s-%s 12:00:00",
			xtc_db_input($_POST['new_paydate_y']),
			xtc_db_input($_POST['new_paydate_m']),
			xtc_db_input($_POST['new_paydate_d'])
		);
		$update_sql_array = array(
			'date_purchased'=>$date_payment
		);
		if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_kasse_change_paydate'] == '1')) {
			$order = new order($orders_id);
			if($order->is_kasse()){
				$comments = sprintf(HISTORY_PAYMENT_CHANGED,$date_payment);
				xtc_db_perform('kasse',$update_sql_array,'update',"orders_id='".$orders_id."'");
				$update_sql_array = array(
					'last_modified'=>date('Y-m-d H:i:s')
				);
				xtc_db_perform('orders',$update_sql_array,"update","orders_id='".$orders_id."'");
				$order->add_history($order->info['orders_status'], 0, $comments);
				$messageStack->add_session($comments,'success');
			}
		}
		if(!isset($_REQUEST['from'])){
		    xtc_redirect(xtc_href_link('orders.php',xtc_get_all_get_params(array('action')).'action=edit'));
		}else{
		    xtc_redirect($_REQUEST['from']);
		}
		break;
	case 'change_paydate':
		$orders_id = xtc_db_input($_GET['oID']);
		$order = new order($orders_id, '');
		$lb_smarty = $smarty;
		$lb_smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
		$lb_smarty->assign('CHANGE_FORM',xtc_draw_form('change_paydate','orders.php',xtc_get_all_get_params(array('action')).'action=save_changed_paydate'));
		$lb_smarty->assign('SAVED_PAYDATE',$order->info['date_payment']);
		$lb_smarty->assign('TEXT_SAVED_PAYDATE',TEXT_SAVED_PAYDATE);
		$lb_smarty->assign('TEXT_NEW_PAYDATE',TEXT_NEW_PAYDATE);
		$year_array = array();
		for($i=(date('Y')-5);$i<=(date('Y'));$i++){
			$year_array[] = array('id'=>$i,'text'=>$i);
		}
		$lb_smarty->assign('INPUT_NEW_PAYDATE_Y',xtc_draw_pull_down_menu('new_paydate_y',$year_array,date('Y',strtotime($order->info['date_payment']))));
		$month_array = array();
		for($i=1;$i<=12;$i++){
			$month_array[] = array('id'=>$i,'text'=>$i);
		}
		$lb_smarty->assign('INPUT_NEW_PAYDATE_M',xtc_draw_pull_down_menu('new_paydate_m',$month_array,date('m',strtotime($order->info['date_payment']))));
		$day_array = array();
		for($i=1;$i<=31;$i++){
			$day_array[] = array('id'=>$i,'text'=>$i);
		}
		$lb_smarty->assign('INPUT_NEW_PAYDATE_D',xtc_draw_pull_down_menu('new_paydate_d',$day_array,date('d',strtotime($order->info['date_payment']))));
		$lb_smarty->assign('ORDERS_ID',$orders_id);
		if(isset($_REQUEST['from'])){
		    $lb_smarty->assign('INPUT_FROM',xtc_draw_hidden_field('from',$_REQUEST['from']));
		}
		$lb_content = $lb_smarty->fetch(DIR_FS_ADMIN.'templates/orders_change_paydate.html');
		$smarty->assign(array(
		    'language_path'=>DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
		    'PAGE_TITLE'=>BUTTON_CHANGE_PAYDATE,
		    'LB_CONTENT'=>$lb_content,
		));
		echo $smarty->fetch(DIR_FS_ADMIN.'templates/lightbox_default.html');
		exit;
		break;
	case 'save_changed_branch':
		$orders_id = (int)xtc_db_input($_GET['oID']);
		$new = xtc_db_input($_POST['branches_id']);
		$update_sql_array = array(
			'branches_id'=>$new
		);
		if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_kasse_change_paydate'] == '1')) {
			$order = new order($orders_id);
			if($order->is_kasse()){
				$comments = sprintf(HISTORY_BRANCH_CHANGED,xtc_get_branch_title($new));
				xtc_db_perform('kasse',$update_sql_array,'update',"orders_id='".$orders_id."'");
				$update_sql_array = array(
					'last_modified'=>'now()'
				);
				xtc_db_perform('orders',$update_sql_array,'update',"orders_id='".$orders_id."'");
				$order->add_history($order->info['orders_status'], 0, $comments);
				$messageStack->add_session($comments,'success');
			}
		}
		xtc_redirect(xtc_href_link('orders.php',xtc_get_all_get_params(array('action')).'action=edit'));
		break;
	case 'change_branch':
		$orders_id = xtc_db_input($_GET['oID']);
		$order = new order($orders_id, '');
		$lb_smarty = $smarty;
		$lb_smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
		$lb_smarty->assign('CHANGE_FORM',xtc_draw_form('change_branch','orders.php',xtc_get_all_get_params(array('action')).'action=save_changed_branch'));

		$orig_branch_query = xtc_db_query("SELECT branches_id FROM kasse WHERE orders_id='".xtc_db_input($_GET['oID'])."'");
		$orig_branch = xtc_db_fetch_array($orig_branch_query);
		$orig_branch_title = 'Standard';
		$branches_array = array();
		$branches_query = xtc_db_query("SELECT * FROM branches");
		if(xtc_db_num_rows($branches_query)){
			$branches_array[] = array('id'=>'0','text'=>$orig_branch_title);
		}
		while($branches = xtc_db_fetch_array($branches_query)){
			$branches_array[] = array('id'=>$branches['branches_id'],'text'=>$branches['title']);
			if($branches['branches_id'] == $orig_branch['branches_id']){
				$orig_branch_title = $branches['title'];
			}
		}
		$lb_smarty->assign('INPUT_BRANCH', xtc_draw_pull_down_menu('branches_id',$branches_array,$orig_branch['branches_id']));

		$lb_smarty->assign('SAVED_BRANCH',$orig_branch_title);
		$lb_smarty->assign('TEXT_SAVED_BRANCH',TEXT_SAVED_BRANCH);
		$lb_smarty->assign('TEXT_NEW_BRANCH',TEXT_NEW_BRANCH);
		$lb_content = $lb_smarty->fetch(DIR_FS_ADMIN.'templates/orders_change_branch.html');
		$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
		$smarty->assign('PAGE_TITLE',BUTTON_CHANGE_BRANCH);
		$smarty->assign('LB_CONTENT',$lb_content);
		header('Content-Type: text/html; charset='.CHARSET);
		echo $smarty->fetch(DIR_FS_ADMIN.'templates/lightbox_default.html');
		exit;
		break;
	case 'ext_search':
		require('orders_ext_search.php'); // produkte suchen
		break;
	case 'ext_search2':
		require('orders_ext_search2.php'); // adresse suchen
		break;
	case 'ext_search3':
		require('orders_ext_search3.php'); // kundengruppe anzeigen
		break;
	case 'packingslip_pdf':
		// GENERIERE LIEFERSCHEIN-PDF
		$oID = (int)xtc_db_input($_GET['oID']);
		$order = new order($oID);
		$xtPrice = new xtcPrice($order->info['currency'],$order->info['status']);

		$packingslip_pdf_name = \main::get_exportdata_path().'packingslip_'.$oID.'.pdf';

		$pdf_smarty = new yesSmarty;
		
		// BURAK HAT DRAUF BESTANDEN - BEI RUECKFRAGE MITTELFINGER
		$pdf_packingslip_html=xtc_get_packingslip_html_for_pdf($order,$pdf_smarty,CURRENT_TEMPLATE . '/admin/mail/'.yes_get_language_folder(true).'/pdf_packingslip.html',$lagerplaetze=true,true);
		
		// FUEGE ORDER AN GESAMTPDF AN
		if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
		    $pdf = new yes_pdf();
		    if(DOMPDF_ORDER_LANDSCAPE == 'True'){
				$pdf->set_landscape();
		    }
		    $pdf->set_html($pdf_packingslip_html);
		    $pdf->output('PACKLISTE_'.$oID.'.pdf');
		}else{
		    $packingslip_pdf=new HTML2FPDF();
		    // FUEGE LIEFERSCHEIN AN GESAMTPDF AN
		    $packingslip_pdf->AddPage();
		    $packingslip_pdf->WriteHTML($pdf_packingslip_html);
		    $packingslip_pdf->Output('PACKLISTE_'.$oID.'.pdf','I'); //Read the FPDF.org manual to know the other options
		}
		

		if(BARCODE_PACKINGSLIP_ACTIVE == 'True'){
			// generiertes img loeschen
			@unlink(\main::get_exportdata_path().'BARCODE_'.$order->info['id'].'.jpg');
			@unlink(\main::get_exportdata_path().'BARCODE_'.$order->info['id'].'.png');
		}
		exit;
		break;
	case 'pdf_offer':
		// GENERIERE ANGEBOT-PDF
		$oID = (int)xtc_db_input($_GET['oID']);
		$order = new order($oID);
		$xtPrice = new xtcPrice($order->info['currency'],$order->info['status']);

		$pdf_smarty = new yesSmarty;
		$pdf_order_html=xtc_get_offer_html_for_pdf($order,$pdf_smarty,CURRENT_TEMPLATE . '/admin/mail/'.yes_get_language_folder(true).'/pdf_order.html');

		// FUEGE ORDER AN GESAMTPDF AN
		if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
		    $pdf = new yes_pdf();
		    if(DOMPDF_ORDER_LANDSCAPE == 'True'){
			$pdf->set_landscape();
		    }
		    $pdf->set_html($pdf_order_html);
		    $pdf->output('OFFER_'.$oID.'.pdf');
		}else{
		    $order_pdf=new HTML2FPDF();
		    // FUEGE ORDER AN GESAMTPDF AN
		    $order_pdf->AddPage();
		    $order_pdf->WriteHTML($pdf_order_html);
		    $order_pdf->Output('OFFER_'.$oID.'.pdf','I'); //Read the FPDF.org manual to know the other options
		}
		exit;
		break;
	case 'pdf':
		// GENERIERE ORDER-PDF
		$oID = (int)xtc_db_input($_GET['oID']);
		$order = new order($oID);
		$xtPrice = new xtcPrice($order->info['currency'],$order->info['status']);
		

		$pdf_smarty = new yesSmarty;
		$pdf_order_html=xtc_get_order_html_for_pdf($order,$pdf_smarty,CURRENT_TEMPLATE . '/admin/mail/'.yes_get_language_folder(true).'/pdf_order.html');
		if(isset($_REQUEST['debug']) and $_REQUEST['debug'] == 1){
		    die($pdf_order_html);
		}

		// FUEGE ORDER AN GESAMTPDF AN
		if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
		    $headerandfooter=false;
		    $pdf = new yes_pdf($headerandfooter);
		    if(DOMPDF_ORDER_LANDSCAPE == 'True'){
			$pdf->set_landscape();
		    }
		    $pdf->set_html($pdf_order_html);
		    $pdf->output('ORDER_'.$oID.'.pdf','I');
		}else{
		    $order_pdf=new HTML2FPDF();
		    $order_pdf->AddPage();
		    $order_pdf->WriteHTML($pdf_order_html);
		    $order_pdf->Output('ORDER_'.$oID.'.pdf','I'); //Read the FPDF.org manual to know the other options
		}
		exit;
		break;
  	case 'save_kasse_paymode':
		$oID = xtc_db_input($_GET['oID']);
		$order = new order($oID);
		if(!$_POST['paymode']){
			$messageStack->add_session(MSG_ERROR_NO_PAYMENTMETHOD_SELECTED,'error');
			xtc_redirect(xtc_href_link('orders.php',xtc_get_all_get_params(array('action')).'action=change_kasse_paymode') );
		}
		if(strlen(trim($_POST['comments']) )<2){
			$messageStack->add_session(MSG_ERROR_NO_COMMENTS,'error');
			xtc_redirect(xtc_href_link('orders.php',xtc_get_all_get_params(array('action')).'action=change_kasse_paymode') );
		}
		if($_GET['oID']>0){
			if($_POST['paymode'] != 'bank'){
				xtc_db_query("UPDATE kasse SET paymode='".$_POST['paymode']."' where orders_id='".$_GET['oID']."'");
				$comments = sprintf(HISTORY_KASSE_PAYMENTMETHOD_CHANGE,$_POST['paymode'],xtc_db_input($_POST['comments']));
				$order->add_history($order->info['orders_status'],$notified=0,$comments);
			}else{
				xtc_db_query("DELETE FROM kasse where orders_id='".$_GET['oID']."'");
				if($order->info['orders_status'] != ORDERS_STATUS_STORNIERT){
					$order->update_orders_status(1);
					$comments = sprintf(HISTORY_KASSE_DELETED,$_POST['paymode'],xtc_db_input($_POST['comments']));
					$order->add_history(1,$notified=0,$comments);
				}else{
					$comments = sprintf(HISTORY_KASSE_DELETED,$_POST['paymode'],xtc_db_input($_POST['comments']));
					$order->add_history($order->info['orders_status'],$notified=0,$comments);
				}
			}
		}
		$messageStack->add_session(MSG_KASSE_CHANGED,'success');
		xtc_redirect(xtc_href_link('orders.php',xtc_get_all_get_params(array('action')).'action=edit') );
		break;
	case "ebayfeedback_block":
		$oID = xtc_db_input($_GET['oID']);
		$order = new order($oID);
		$new_status = ($order->info['ebayfeedback_block_status'] == 1) ? 0 : 1;
		xtc_db_query("UPDATE orders SET ebayfeedback_block_status='".$new_status."', last_modified=now() WHERE orders_id='".$oID."'");
		if($new_status == 1)
			$comments = HISTORY_BLOCK_ORDER_FROM_WARNING;
		else
			$comments = HISTORY_ACTIVATE_ORDER_FOR_WARNING;
		$order->add_history($order->info['orders_status'],$notified=0,$comments);
		$messageStack->add_session($comments,'success');
		xtc_redirect( xtc_href_link('orders.php',xtc_get_all_get_params(array('action')).'action=edit'));
		break;

	case "set_rueckstand":
		$oID = xtc_db_input($_GET['oID']);
		$order = new order($oID);
		xtc_db_query("UPDATE orders SET rueckstand='1', last_modified=now() WHERE orders_id='".$oID."'");
		$comments = HISTORY_ORDER_MARK_IN_ARREAR;
		$order->add_history($order->info['orders_status'],$notified=0,$comments);
		$messageStack->add_session($comments,'success');
		xtc_redirect( xtc_href_link('orders.php',xtc_get_all_get_params(array('action')).'action=edit'));
		break;
	case "unset_rueckstand":
		$oID = xtc_db_input($_GET['oID']);
		$order = new order($oID);
		xtc_db_query("UPDATE orders SET rueckstand='0', last_modified=now() WHERE orders_id='".$oID."'");
		$comments = HISTORY_ORDER_UNMARK_IN_ARREAR;
		$order->add_history($order->info['orders_status'],$notified=0,$comments);
		$messageStack->add_session($comments,'success');
		xtc_redirect( xtc_href_link('orders.php',xtc_get_all_get_params(array('action')).'action=edit'));
		break;
	case "set_no_warn_span":
		// ---------------------------------------------------------
		// WIR SCHLIESSEN DIE RECHNUNG FUER X TAGE VOM MAHNWESEN AUS
		// ---------------------------------------------------------
		$oID = xtc_db_input($_GET['oID']);
		$span = xtc_db_input($_GET['span']);
		$order = new order($oID);
		xtc_db_query("UPDATE orders SET no_warning=1,warning_span_date=now(),warning_span='".$span."',last_modified=now() WHERE orders_id='".$oID."'");
		$comments = sprintf(HISTORY_ORDER_SET_BLOCK_WARNING_DAYSPAN,$span);
		$order->add_history($order->info['orders_status'],$notified=0,$comments);
		$messageStack->add_session($comments,'success');
		xtc_redirect( xtc_href_link('orders.php',xtc_get_all_get_params(array('action','span')).'action=edit'));
		break;
	case "unset_no_warn_span":
		// ---------------------------------------------------------
		// WIR INTEGRIEREN DIE RECHNUNG WIEDER INS MAHNWESEN
		// ---------------------------------------------------------
		$oID = xtc_db_input($_GET['oID']);
		$order = new order($oID);
		xtc_db_query("UPDATE orders SET no_warning=0,warning_span_date='',warning_span='',last_modified=now() WHERE orders_id='".$oID."'");
		$comments = HISTORY_ORDER_UNSET_BLOCK_WARNING;
		$order->add_history($order->info['orders_status'],$notified=0,$comments);
		$messageStack->add_session($comments,'success');
		xtc_redirect( xtc_href_link('orders.php',xtc_get_all_get_params(array('action')).'action=edit'));
		break;
	case "set_block_shipping":
		// ---------------------------------------------------------
		// WIR SCHLIESSEN DIE RECHNUNG FUER X TAGE VOM VERSAND AUS
		// ---------------------------------------------------------
		$oID = (int)xtc_db_input($_REQUEST['oID']);
		$text = xtc_db_prepare_input($_REQUEST['text']);
		require_once(DIR_FS_INC.'xtc_checkdate.inc.php');
		require_once(DIR_FS_INC.'xtc_is_leap_year.inc.php');
		$block_shipping_end_date = $_REQUEST['block_shipping_end_date'] ?? '';
                $block_shipping_use_end_date = $_REQUEST['block_shipping_use_end_date'] ?? '';
		if($block_shipping_use_end_date == '1' and !xtc_checkdate($block_shipping_end_date, 'yyyy-mm-dd', $date_array)){
		    $messageStack->add_session('Invalid date: '.$block_shipping_end_date,'error');
		    xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action')).'action=edit'));
		}
		$order = new order($oID);
		$update_sql_array = array(
		    'block_shipping'=>1, 
		    'block_shipping_end_date'=>$block_shipping_end_date,
		    'block_shipping_comment'=>$text,
		    'last_modified'=>'now()'
		);
		xtc_db_perform(TABLE_ORDERS,$update_sql_array,'update',"orders_id='".$oID."'");
		$comments = HISTORY_ORDER_SET_BLOCK_SHIPPING.$text;
		$order->add_history($order->info['orders_status'],$notified=0,$comments);
		$messageStack->add_session(MSG_SUCCESS_ORDER_SET_BLOCK_SHIPPING,'success');
                if(isset($_POST['referrer']) and $_POST['referrer'] != ''){
                    xtc_redirect( urldecode($_POST['referrer']) );
                }
		xtc_redirect( xtc_href_link('orders.php',xtc_get_all_get_params(array('action')).'action=edit'));
		break;
	case "set_unblock_shipping":
                // BOF - VERSANDMODUL - LISTING VERSANDSPERRE, MEHRERE MARKIEREN
                if(isset($_GET['id']) and is_countable($_GET['id'])){
                    $affected = 0;
                    foreach($_GET['id'] as $id){
                        $id = (int)xtc_db_input($id);
                        $order = new order($id);
                        xtc_db_query("UPDATE orders SET block_shipping='0',block_shipping_end_date='', last_modified=now() WHERE orders_id='".$id."'");
                        $comments = HISTORY_ORDER_UNSET_BLOCK_SHIPPING;
                        $order->add_history($order->info['orders_status'],$notified=0,$comments);
                        $affected++;
                    }
                    $messageStack->add_session(HISTORY_ORDER_UNSET_BLOCK_SHIPPING,'success');
                    if(isset($_GET['referrer']) and $_GET['referrer'] != ''){
                        xtc_redirect( urldecode($_GET['referrer']) );
                    }
                    xtc_redirect( xtc_href_link('orders.php',xtc_get_all_get_params(array('action')).'action=edit'));
                }
                // EOF - VERSANDMODUL - LISTING VERSANDSPERRE, MEHRERE MARKIEREN
                
                 
		// ---------------------------------------------------------
		// WIR INTEGRIEREN DIE RECHNUNG WIEDER IN DEN VERSAND
		// ---------------------------------------------------------
		$oID = xtc_db_input($_GET['oID']);
		$order = new order($oID);
		xtc_db_query("UPDATE orders SET block_shipping='0',block_shipping_end_date='', last_modified=now() WHERE orders_id='".$oID."'");
		$comments = HISTORY_ORDER_UNSET_BLOCK_SHIPPING;
		$order->add_history($order->info['orders_status'],$notified=0,$comments);
		$messageStack->add_session(HISTORY_ORDER_UNSET_BLOCK_SHIPPING,'success');
                if(isset($_GET['referrer']) and $_GET['referrer'] != ''){
                    xtc_redirect( urldecode($_GET['referrer']) );
                }
		xtc_redirect( xtc_href_link('orders.php',xtc_get_all_get_params(array('action')).'action=edit'));
		break;
	case 'change_orders':
		// yes accounting
		if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['orders_edit'] == '1')) {
		}else{
			$messageStack->add_session(MSG_AUTH_ORDERS_EDIT,'error');
			xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action'))));
		}
		
		$order_combine = false;

		switch($_POST['list_action']){
			case 'nosend':
				$gesamt = 0;
				$orders = array();
				if(is_array($_POST['statusOID'])){
					$ordersID = $_POST['statusOID'];
					$cLINK = '';
					$gesamt = sizeOf($ordersID);
					
					foreach($ordersID as $k=>$oID){
						$check_query = xtc_db_query("SELECT orders_status,is_parent FROM orders WHERE orders_id='".xtc_db_input($oID)."'");
						$check = xtc_db_fetch_array($check_query);
						
						// VERSANDSPERRE bedingung
						if( ($check['orders_status'] == 1 or $check['orders_status'] == 2 or $check['orders_status'] == ORDERS_STATUS_UPSELLING or $check['orders_status'] == ORDERS_STATUS_BEZAHLT) and $check['is_parent'] != 'y' ){
							$orders[] = $oID;
						}
					}
					if(sizeOf($orders) == 0){
						$messageStack->add_session(MSG_ERROR_BLOCK_SHIPPING_SELECTED,'error');
						xtc_redirect(xtc_href_link('orders.php',xtc_get_all_get_params(array('action'))));
					}else{
                                            $text = xtc_db_input($_POST['temp_comment']);
                                            if(strlen($text)>0){
                                                foreach($orders as $ko=>$kv) {
                                                    $order = new order($kv);
                                                    xtc_db_query("UPDATE orders SET block_shipping='1',last_modified=now() WHERE orders_id='".$kv."'");
                                                    $messageStack->add_session(sprintf(MSG_SUCCESS_BLOCK_SHIPPING,$kv),'success');
                                                    $comments = HISTORY_ORDER_SET_BLOCK_SHIPPING.$text;
                                                    $order->add_history(
                                                        intval($order->info['orders_status']), 
                                                        0, $comments
                                                    );
                                                }
                                            }else{
                                                $messageStack->add_session(MSG_ERROR_BLOCK_SHIPPING_COMMENT,'error');
                                                xtc_redirect(xtc_href_link('orders.php',xtc_get_all_get_params(array('action'))));
                                            }
					}
					xtc_redirect(xtc_href_link('orders.php',xtc_get_all_get_params(array('action'))));
				}else{
					$messageStack->add_session(MSG_ERROR_ORDER_BLOCK_SHIPPING_PARAMS,'error');
					xtc_redirect(xtc_href_link('orders.php',xtc_get_all_get_params(array('action'))));
				}
				break;
			case 'combine':
				$valide = 0;
				$gesamt = 0;
				if(is_array($_POST['statusOID']) && $_GET['cID']>0){
					$ordersID = $_POST['statusOID'];
					$cLINK = '';
					$cID = xtc_db_prepare_input($_GET['cID']);
					$gesamt = sizeOf($ordersID);
					foreach($ordersID as $k=>$oID){
						$check_query = xtc_db_query("SELECT orders_status,is_parent,customers_id FROM orders WHERE orders_id='".xtc_db_input($oID)."'");
						$check = xtc_db_fetch_array($check_query);
						
						// KOMBINIEREN bedingung
						if( $check['orders_status'] == 1 
								or $check['orders_status'] == 2 
								or $check['orders_status'] == ORDERS_STATUS_UPSELLING  
								or $check['orders_status'] == ORDERS_STATUS_BEZAHLT 
								and $check['is_parent'] != 'y'
								and $check['customers_id'] == $cID ){
							$cLINK .= 'collect_orders_id[]='.$oID.'&';
							$valide++;
						}
					}
					if( $gesamt > 1 and $valide == $gesamt ){
						xtc_redirect(xtc_href_link('combined_orders.php',xtc_get_all_get_params(array('collect_orders_id','action')).$cLINK.'action=edit'));
					}else{
						$messageStack->add_session(MSG_ERROR_ORDER_COMBINE_INVALID,'error');
					}
					xtc_redirect(xtc_href_link('orders.php',xtc_get_all_get_params(array('action'))));
				}else{
					$messageStack->add_session(MSG_ERROR_ORDER_COMBINE_PARAMS,'error');
					xtc_redirect(xtc_href_link('orders.php',xtc_get_all_get_params(array('action'))));
				}
				break;
		}
		break;
	case 'email_offer_confirm':
   		$oID = xtc_db_prepare_input($_GET['oID']);
		$order = new order($oID);
		$smarty = new yesSmarty;
		$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
		$smarty->assign('HEADING_TITLE',HEADING_TITLE_EMAIL_OFFER);
		$smarty->assign('FORM',xtc_draw_form('emailoffer','orders.php',xtc_get_all_get_params(array('action')).'action=email_offer','POST','onsubmit="return check_sendmail();"'));
		$smarty->assign('FORM_END','</form>');
		$smarty->assign('INPUT_RECIPIENT',xtc_draw_input_field('email_address',$order->customer['email_address'],'size="40" maxlength="80"'));
		$smarty->assign('INPUT_SUBJECT',xtc_draw_input_field('subject',sprintf(EMAIL_SUBJECT_OFFER,$oID),'size="40" maxlength="80"'));
		$smarty->assign('TEXT_ADDITIONAL_BODY',TEXT_ADDITIONAL_BODY);
		$smarty->assign('INPUT_BODY',xtc_draw_textarea_field('body','virtual',60,5));
		$smarty->assign('TEXT_SEND_PDF_ORDER',TEXT_SEND_PDF_ORDER);
		$att = new module_attachments('order',$oID);
		$smarty->assign(array(
		    'TEXT_SEND_PDF_TEASER'=>TEXT_SEND_PDF_TEASER,
		    'INPUT_SEND_PDF_ORDER'=>xtc_draw_checkbox_field('send_pdf_order',1,true),
		    'INPUT_SEND_PDF_TEASER'=>xtc_draw_checkbox_field('send_pdf_teaser',1,((PDF_TEASER_IN_OC == 'true')?true:false)),
		    'INPUT_SUBMIT'=>yes_draw_href_button(SEND_EMAIL,'','width:140px;','submit'),
		    'ATTACHMENTS'=>$att->get_attachments(),
		    'TEXT_SEND_EMAIL_WITH_ATTACHMENTS'=>TEXT_SEND_EMAIL_WITH_ATTACHMENTS
		));
		header('Content-Type: text/html; charset='.CHARSET);
		$smarty->display(DIR_FS_ADMIN.'templates/order_email_offer.html');
		exit;
		break;
	case 'email_oc_confirm':
	case 'email_confirm':
        case 'email_packingslip_confirm':
		if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_order_confirm'] == '1')) {
		}else{
			die('UNAUTHORIZED CALL');
		}
   		$oID = xtc_db_prepare_input($_GET['oID']);
		$order = new order($oID);
		$smarty = new yesSmarty;
		$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
       		$fibu_number = $order->get_fibunumber();
                if($fibu_number > 0){
                    $default_subj = TEXT_ORDER_FIBU_EMAIL_SUBJECT.$fibu_number;
                }else{
                    $default_subj = TEXT_ORDER_EMAIL_SUBJECT.$oID;
                }
		if($order->info['source'] == 'amazon'){
		    $ao_array = array();
		    $amz_products = $order->get_amazon_items();
		    foreach($amz_products as $amzp){
			if(!in_array($amzp['orig_amazon_orders_id'],$ao_array))
			    $ao_array[] = $amzp['orig_amazon_orders_id'];
		    }
		    if(sizeOf($ao_array)){
			$default_subj .= ' / AmazonOrder '.implode(', ',$ao_array);
                    }
		}
		if($order->info['source'] == 'ebay'){
		    $ebay_auctions = $order->get_auction_array();
		    if(sizeOf($ebay_auctions)){
			$default_subj .= ' / eBay Auction '.implode(', ',$ebay_auctions);
                    }
		}
                switch($action){
                    case 'email_oc_confirm':
                        $action_param = 'email_oc';
        		$default_subj = sprintf(EMAIL_SUBJECT_OC,$oID);
                        $heading_title = HEADING_TITLE_EMAIL_OC;
                        break;
                    case 'email_packingslip_confirm':
                        $action_param = 'email_packing';
                        $default_subj = TEXT_ORDER_EMAIL_PACKINGSLIP_SUBJECT.$order->info['id'].(($order->info['ebay_id']!='') ? ' ('.$order->info['ebay_id'].')':'');
                        $heading_title = HEADING_TITLE_EMAIL_PACKINGSLIP;
                        break;
                    default:
                        $action_param = 'email';
                        $heading_title = HEADING_TITLE_EMAIL;
                        break;
                }
		$smarty->assign('HEADING_TITLE',$heading_title);
		$smarty->assign('FORM',xtc_draw_form('emailoc','orders.php',xtc_get_all_get_params(array('action')).'action='.$action_param,'POST','onsubmit="return check_sendmail();"'));
		$smarty->assign('FORM_END','</form>');
		$smarty->assign('INPUT_RECIPIENT',xtc_draw_input_field('email_address',$order->customer['email_address'],'size="40" maxlength="80"'));
		$smarty->assign('INPUT_SUBJECT',xtc_draw_input_field('subject',$default_subj,'size="40" maxlength="80"'));
		$smarty->assign('TEXT_ADDITIONAL_BODY',TEXT_ADDITIONAL_BODY);
		if($action == 'email_oc_confirm'){
		    $smarty->assign(array(
			'INPUT_SEND_PDF_TEASER'=>xtc_draw_checkbox_field('send_pdf_teaser',1,((PDF_TEASER_IN_OC == 'true')?true:false)),
			'INPUT_BODY'=>xtc_draw_textarea_field('body','virtual',40,5,'','style="width:100%"'),
			'TEXT_SEND_PDF_ORDER'=>TEXT_SEND_PDF_ORDER,
			'TEXT_SEND_PDF_TEASER'=>TEXT_SEND_PDF_TEASER,
			'INPUT_SEND_PDF_ORDER'=>xtc_draw_checkbox_field('send_pdf_order',1,true),
		    ));
		}
		$email_aliases = yes_get_customers_email_aliases($order->customer['ID']);
		if(sizeOf($email_aliases)){
		    $email_aliases_values = array(array('id'=>'','text'=>TEXT_SELECT));
		    foreach($email_aliases as $em){
			$email_aliases_values[] = array('id'=>$em,'text'=>$em);
		    }
		    $email_aliases_values[] = array('id'=>'ALL','text'=>'--- '.TXT_ALL.' ---');
		    $smarty->assign('INPUT_EMAIL_ALIASES',xtc_draw_pull_down_menu('email_aliases',$email_aliases_values));
		}
		$att = new module_attachments('order',$oID);
                $pcf = $order->get_products_content_files();
                
		$smarty->assign(array(
		    'INPUT_SUBMIT'=>yes_draw_href_button(SEND_EMAIL,'','width:140px;','submit'),
		    'ATTACHMENTS'=>$att->get_attachments(),
		    'TEXT_SEND_EMAIL_WITH_ATTACHMENTS'=>TEXT_SEND_EMAIL_WITH_ATTACHMENTS,
		    'TEXT_EMAIL_ALIASES'=>TEXT_EMAIL_ALIASES,
                    'PRODUCTS_CONTENT'=>$pcf,
                    'PRODUCTS_CONTENT_INTRO'=>(sizeOf($pcf))?sprintf(EMAIL_PRODUCTS_CONTENT_INTRO,sizeOf($pcf)):'',
		));
		header('Content-Type: text/html; charset='.CHARSET);
		$smarty->display(DIR_FS_ADMIN.'templates/order_email_offer.html');
		exit;
		break;
	case 'email_offer':
	case 'email_oc':
		if($_GET['action'] == 'email_offer'){
			$required_auth = 'f_offers';
		}else{
			$required_auth = 'f_order_confirm';
		}
			
		if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access[$required_auth] == '1')) {
		}else{
			die('UNAUTHORIZED_CALL');
		}
   		$oID = (int)xtc_db_prepare_input($_GET['oID']);
   		$cID = (int)xtc_db_prepare_input($_GET['cID']);
   		$email_address = xtc_db_input($_POST['email_address']);
		$subject = xtc_db_prepare_input(yes_encode_string($_POST['subject']));
		$body = nl2br(xtc_db_prepare_input($_POST['body']));

		$order = new order($oID);
		$xtPrice = new xtcPrice($order->info['currency'],$order->info['status']);

		$pdf_smarty = new yesSmarty;

		$pdf_teaser_smarty = new yesSmarty;
		$pdf_teaser_html = '';
		$teaser_pdf_name = '';
		$attachments_array = array();
		if($_GET['action'] == 'email_offer'){
			$pdf_packingslip_html=xtc_get_offer_html_for_pdf($order,$pdf_smarty,CURRENT_TEMPLATE . '/admin/mail/'.yes_get_language_folder(true).'/pdf_order.html');
			$packingslip_pdf_name = \main::get_exportdata_path().TEXT_OFFER.'_'.$oID.'.pdf';

			if($_POST['send_pdf_teaser'] == 1){
				$pdf_teaser_html=yes_get_order_teaser_html_for_pdf($order,$pdf_teaser_smarty,CURRENT_TEMPLATE . '/admin/pdf_ordered_products.html');
				if($pdf_teaser_html != '')
					$teaser_pdf_name = \main::get_exportdata_path().TEXT_OFFER.'_'.$oID.'_ARTIKEL.pdf';
			}
		}else{
		    $conditions_widerruf = true; // ticket 1581
			$pdf_packingslip_html=xtc_get_order_confirm_html_for_pdf($order,$pdf_smarty,CURRENT_TEMPLATE . '/admin/mail/'.yes_get_language_folder(true).'/pdf_order.html',$conditions_widerruf);
			$packingslip_pdf_name = \main::get_exportdata_path().TEXT_ORDER_CONFIRMATION_FILENAME.'_'.$oID.'.pdf';
			if($_POST['send_pdf_teaser'] == 1){
				$pdf_teaser_html=yes_get_order_teaser_html_for_pdf($order,$pdf_teaser_smarty,CURRENT_TEMPLATE . '/admin/pdf_ordered_products.html');
				$teaser_pdf_name = \main::get_exportdata_path().TEXT_ORDER_CONFIRMATION_FILENAME.'_'.$oID.'_ARTIKEL.pdf';
			}
		}
		if($pdf_teaser_html != ''){
		    if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
			$pdf = new yes_pdf();
			if(DOMPDF_ORDER_LANDSCAPE == 'True'){
			    //$pdf->set_landscape();
			}
			$pdf->set_html($pdf_teaser_html);
			$pdf->save($teaser_pdf_name);
		    }else{
			$teaser_pdf=new HTML2FPDF();
			$teaser_pdf->AddPage();
			$teaser_pdf->WriteHTML($pdf_teaser_html);
			$teaser_pdf->Output($teaser_pdf_name,'F'); //Read the FPDF.org manual to know the other options
		    }
		}else{
			$teaser_pdf_name = '';
		}
		if($teaser_pdf_name != ''){
		    $attachments_array[] = $teaser_pdf_name;
		}
		if($_POST['send_pdf_order'] == 1){
		    if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
			$pdf = new yes_pdf();
			if(DOMPDF_ORDER_LANDSCAPE == 'True'){
			    //$pdf->set_landscape();
			}
			$pdf->set_html($pdf_packingslip_html);
			$pdf->save($packingslip_pdf_name);
		    }else{
			$packingslip_pdf=new HTML2FPDF();
			$packingslip_pdf->AddPage();
			$packingslip_pdf->WriteHTML($pdf_packingslip_html);
			$packingslip_pdf->Output($packingslip_pdf_name); //Read the FPDF.org manual to know the other options
		    }
		}else{
			$packingslip_pdf_name = '';
		}
		if($packingslip_pdf_name != ''){
		    $attachments_array[] = $packingslip_pdf_name;
		}
		if(isset($_REQUEST['attachment']) and sizeOf($_REQUEST['attachment'])){
		    $mod_att = new module_attachments('order', $oID);
		    foreach($_REQUEST['attachment'] as $file_att){
			   $att_info = $mod_att->get_attachment_info($file_att);
			   $attachments_array[] = $att_info['path'];
		    }
		}

		// BODY SOLL NICHT INS PDF, DAHER NACH PDF GENERIERUNG
		if($body != ''){
			$pdf_packingslip_html = $body.'<br /><br />'.$pdf_packingslip_html;
		}
                $email_addresses = [$email_address];
                if(isset($_REQUEST['email_address_cc'])){
                    foreach($_REQUEST['email_address_cc'] as $nr=>$cc){
                        if(!isset($_POST['email_mode']) or $_POST['email_mode'][$nr] != 'bcc'){
                            $email_addresses[] = 'cc:'.xtc_db_input($cc);
                        }else{
                            $email_addresses[] = xtc_db_input($cc);
                        }
                    }
                }
		foreach($email_addresses as $ea){
                    $dbMail = new DBmail('0');
		    $dbMail->save_mail($subject,$ea,EMAIL_BILLING_REPLY_ADDRESS_NAME,EMAIL_BILLING_REPLY_ADDRESS,$pdf_packingslip_html,date('Y-m-d H:i:s'), $order->info['ebay_id'],$order->customer['ID'],$order->info['id']);
		    $comments = sprintf(HISTORY_ORDER_EMAIL,$ea);
                    if($_GET['action'] == 'email_offer'){
                            $order->add_history($order->info['orders_status'], true, sprintf(HISTORY_EMAIL_OFFER,$ea));
                    }else{
                            $order->add_history($order->info['orders_status'], true, sprintf(HISTORY_EMAIL_OC,$ea));
                    }
		}
                $email_address = array_shift($email_addresses);
                // nach array_shift ist die erste Emailadresse aus dem array
                // entfernt, alle anderen sind cc oder bcc
                // additional_emails wird als cc oder bcc verwendet
                // wobei cc erkannt wird, wenn cc: vorangestellt ist, also zb
                // cc:mario@yes4trade.de
                $additional_emails = implode(',',$email_addresses);
                xtc_php_mail(EMAIL_BILLING_ADDRESS,
                    EMAIL_BILLING_NAME,
                    $email_address,
                    $order->customer['name'],
                    $additional_emails,
                    EMAIL_BILLING_REPLY_ADDRESS,
                    EMAIL_BILLING_REPLY_ADDRESS_NAME,
                    $attachments_array,
                    '',
                    $subject,
                    $pdf_packingslip_html,
                    ''
                );

		if($_POST['send_pdf_order'] == 1){
			unlink($packingslip_pdf_name);
		}
		if($_POST['send_pdf_teaser'] == 1){
			unlink($teaser_pdf_name);
		}
		if($_GET['action'] == 'email_offer'){
			$messageStack->add_session(HISTORY_EMAIL_OFFER,'success');
		}else{
			$messageStack->add_session(HISTORY_EMAIL_OC,'success');
		}
		xtc_redirect(xtc_href_link('orders.php',xtc_get_all_get_params(array('action','tab')).'action=edit'));
		break;
	case 'email':
            // yes accounting
            if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_orders_email'] == '1')) {
            }else{
                    $messageStack->add_session(MSG_AUTH_ORDER_EMAIL,'error');
                    xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action'))));
            }
            $oID = xtc_db_prepare_input($_GET['oID']);
            $cID = xtc_db_prepare_input($_GET['cID']);
            $email_addresses = [xtc_db_input($_POST['email_address'])];
            if(isset($_REQUEST['email_address_cc'])){
                foreach($_REQUEST['email_address_cc'] as $nr=>$cc){
                    // WENN WIR MAL email_mode EINBAUEN SOLLTEN, ALSO OB DIE
                    // WEITERE EMAIL ADRESSE ALS CC ODER BCC GESENDET WERDEN
                    // SOLL, DANN GREIFT DER email_mode
                    // IN DIESER LOESUNG HIER WIRD BEI FEHLENDEM EMAIL MODE
                    // DIE WEITERE ADRESSE ALS NORMALE CC ADRESSE MITGEGEBEN
                    if(!isset($_POST['email_mode']) or $_POST['email_mode'][$nr] !== 'bcc'){
                        $email_addresses[] = 'cc:'.xtc_db_input($cc);
                    }else{
                        $email_addresses[] = xtc_db_input($cc);
                    }
                }
            }
            $order = new order($oID);
            $subject = (isset($_REQUEST['subject'])) ?  xtc_db_prepare_input(yes_encode_string($_REQUEST['subject'])) : '';
            // NEUES HANDLING: 01/19
            $send_products_file_contents = false;
            if(isset($_POST['send_products_content']) and $_POST['send_products_content'] == 1){
                $send_products_file_contents = true;
            }
            
            // email_addresses_bcc nicht includet
            $comments = $order->email($email_addresses, $_SESSION['languages_id'], $smarty, $subject,$send_products_file_contents);
            $messageStack->add_session($comments,'success');
            xtc_redirect(xtc_href_link('orders.php','oID='.$oID.'&action=edit'));
            break;
	case 'email_packing':
		// yes accounting
		if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_orders_email'] == '1')) {
		}else{
			$messageStack->add_session(MSG_AUTH_ORDER_EMAIL_PACKINGSLIP,'error');
			xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action'))));
		}
                $oID = xtc_db_prepare_input($_GET['oID']);
                $cID = xtc_db_prepare_input($_GET['cID']);
                $email_addresses = [xtc_db_prepare_input($_POST['email_address'])];
                if(isset($_POST['email_address_cc']) and sizeOf($_POST['email_address_cc'])){
                    foreach($_POST['email_address_cc'] as $cc){
                        if(!isset($_POST['email_mode']) or $_POST['email_mode'][$nr] !== 'bcc'){
                            $email_addresses[] = 'cc:'.xtc_db_input($cc);
                        }else{
                            $email_addresses[] = xtc_db_input($cc);
                        }
                    }
                }

		$order = new order($oID);
		$smarty->assign('address_label_customer',xtc_address_format($order->customer['format_id'], $order->customer, 1, '', '<br />'));
		$smarty->assign('address_label_shipping',xtc_address_format($order->delivery['format_id'], $order->delivery, 1, '', '<br />'));
		$smarty->assign('address_label_payment',xtc_address_format($order->billing['format_id'], $order->billing, 1, '', '<br />'));
		$smarty->assign('csID',$order->customer['csID']);
		$smarty->assign('cID',$order->customer['ID']);
		$smarty->assign('COMMENTS_VISIBLE',$order->info['comments_visible']);
		// get products data
		if( $order->info['is_parent'] == 'n') {
			$order_query=xtc_db_query("SELECT
						products_id,
						orders_products_id,
						products_model,
						products_name,
						final_price,
						products_quantity
						FROM ".TABLE_ORDERS_PRODUCTS."
						WHERE orders_id='".$order->info['id']."'");
		}else{
			$order_query=xtc_db_query("SELECT
						op.products_id,
						op.orders_products_id,
						op.products_model,
						op.products_name,
						op.final_price,
						op.products_quantity
						FROM ".TABLE_ORDERS_PRODUCTS." op, orders o 
						WHERE o.parent_orders_id='".$order->info['id']."' && op.orders_id=o.orders_id");
		}
		$order_data=array();
		while ($order_data_values = xtc_db_fetch_array($order_query)) {
			// EAN AUSLESEN
			$ean = '';
			$ean_query = yes_db_query(sprintf("SELECT products_ean FROM products WHERE products_id='%s'",$order_data_values['products_id']),true);
			if($ean_query){
				$result = current($ean_query);
				$ean = $result['products_ean'];
			}
                        $properties = [];
                        foreach($order->products as $op){
                            if($op['opID'] == $order_data_values['orders_products_id']){
                                $properties = $op['properties'];
                            }
                        }
			$order_data[]=array(
				'PRODUCTS_EAN' => $ean,
				'PRODUCTS_MODEL' => $order_data_values['products_model'],
				'PRODUCTS_NAME' => $order_data_values['products_name'],
				'PRODUCTS_PRICE' =>  xtc_format_price_order($order_data_values['final_price'],1,$order->info['currency']),
				'PRODUCTS_QTY' => $order_data_values['products_quantity'],
				'PRODUCTS_WEIGHT'=>  xtc_get_ext_products_weight($order_data_values['products_id'])*$order_data_values['products_quantity'],
                            'PROPERTIES'=>$properties,
			);
		}
		// get order_total data
		$oder_total_query=xtc_db_query("SELECT
				title,
				text,
				class,
				value,
				sort_order
				FROM ".TABLE_ORDERS_TOTAL."
				WHERE orders_id='".$order->info['id']."'
				ORDER BY sort_order ASC");
		
		$order_total=array();
		while ($oder_total_values = xtc_db_fetch_array($oder_total_query)) {
			$order_total[]=array(
				'TITLE' => $oder_total_values['title'],
				'CLASS'=> $oder_total_values['class'],
				'VALUE'=> $oder_total_values['value'],
				'TEXT' => $oder_total_values['text']);
			if ($oder_total_values['class']=='ot_total') {
                            $total=$oder_total_values['value'];
                        }
		}
		
		// assign language to template for caching
		$smarty->assign('STORE', nl2br(STORE_NAME_ADDRESS));
		$smarty->assign('BANK', MODULE_PAYMENT_MONEYORDER_PAYTO);
		$smarty->assign('language', $_SESSION['language']);
		$smarty->assign('logo_path',HTTP_SERVER  . 'templates/'.CURRENT_TEMPLATE.'/img/');
		$smarty->assign('oID',$order->info['id']);

		$ebay_seller = xtc_get_orders_ebay_seller($order->info['id']);
		if($ebay_seller != ''){
			$smarty->assign(array(
				'EBAY_SELLER_DATA'=>xtc_get_ebay_seller_data($ebay_seller),
				'EBAY_ID'=>$order->info['ebay_id'],
				'EBAY_PLUS'=>$order->info['ebay_plus']
			));
		}
		$smarty->assign('PAYMENT_METHOD',xtc_get_payment_method_title($order->info['payment_method']));
		$smarty->assign('DATE',xtc_date_long($order->info['date_purchased']));
	  	if($order->info['date_shipping'] > 0){
            $smarty->assign('DATE_SHIPPING',xtc_date_long($order->info['date_shipping']));
        }
		$smarty->assign('order_data', $order_data);
		$smarty->assign('order_total', $order_total);
		
		$html_mail=$smarty->fetch(CURRENT_TEMPLATE . '/admin/mail/'.yes_get_language_folder(true).'/send_packingslip.html');
                $subject = xtc_db_prepare_input($_POST['subject']);
                foreach($email_addresses as $email_address){
                    // **** EMAILCLIENT - ADDON *****
                    $dbMail = new DBmail('0');
                    $dbMail->save_mail($subject,$email_address,EMAIL_BILLING_REPLY_ADDRESS_NAME,EMAIL_BILLING_REPLY_ADDRESS,$html_mail,date('Y-m-d H:i:s'), $order->info['ebay_id'],$order->customer['ID'],$order->info['id']);

                    $comments = sprintf(HISTORY_EMAIL_PACKINGSLIP,$email_address);
                    $order->add_history($order->info['orders_status'], true, $comments);
                }
                
                $email_address = array_shift($email_addresses);
                // nach array_shift ist die erste Emailadresse aus dem array
                // entfernt, alle anderen sind cc oder bcc
                // additional_emails wird als cc oder bcc verwendet
                // wobei cc erkannt wird, wenn cc: vorangestellt ist, also zb
                // cc:mario@yes4trade.de
                $additional_emails = implode(',',$email_addresses);
                xtc_php_mail(EMAIL_BILLING_REPLY_ADDRESS, 
                    EMAIL_BILLING_REPLY_ADDRESS_NAME, 
                    $email_address, 
                    $email_address, 
                    $additional_emails, 
                    EMAIL_BILLING_REPLY_ADDRESS, 
                    EMAIL_BILLING_REPLY_ADDRESS_NAME, 
                    $path_to_attachement='', 
                    $path_to_more_attachements='', 
                    $subject, 
                    $html_mail,
                    ''
                );
		$messageStack->add_session(sprintf(MSG_SUCCESS_ORDER_EMAIL_PACKINGSLIP,$oID),'success');
		xtc_redirect(xtc_href_link('orders.php','oID='.$oID.'&action=edit'));
		break;

   	case 'edit':
		// yes accounting
		if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_orders_view'] == '1')) {
		}else{
			$messageStack->add_session(MSG_AUTH_ORDERS_EDIT,'error');
			xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action'))));
		}
		break;      		
}
yes_draw_pre_header();
yes_draw_header(TITLE);
?>
<script type="text/javascript" src="minify_js.php?file=includes/general.js"></script>
<script type="text/javascript">
<!--
function check_sendmail(){
	error = false;
	error_string = '';
        if($('form[name="emailoffer"]').length){
            dom = document.forms['emailoffer'];
        }else{
            dom = document.forms['emailoc'];
        }
	email_address = dom.elements['email_address'].value;
	if(!isEmail(email_address)){
		error = true;
		error_string = '<?php echo JS_ALERT_ERROR_EMAIL_ADDRESS; ?> '+email_address;
	}
        var cc_counter = 2;
        $('input[name="email_address_cc[]"]').each(function(){
            var cc = $(this).val();
            if(!isEmail(cc)){
		error = true;
		error_string = '<?php echo JS_ALERT_ERROR_EMAIL_ADDRESS; ?> ('+cc_counter+'. '+cc+')';
            }
            cc_counter++;
        });
        
	subject = dom.elements['subject'].value;
	if(subject.length < 3){
		error = true;
		error_string = '<?php echo JS_ALERT_ERROR_SUBJECT; ?>';
	}
	if(error){
		alert(error_string);
		return false;
	}else{
		return true;
	}
}

function offer_to_order(url){
	var yes = confirm('<?php echo JS_CONFIRM_REALLY_OFFER_TO_ORDER; ?>');
	if(yes){
		window.location.href=url;
	}

}

//-->

</script>

<?php
echo yes_draw_quicknote();
$smarty->assign('orders_status_storniert',ORDERS_STATUS_STORNIERT);
$smarty->assign('orders_status_versendet',ORDERS_STATUS_VERSENDET);
$smarty->assign('orders_status_abgeschlossen',ORDERS_STATUS_ABGESCHLOSSEN);
$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$smarty->assign('FORM_END','</form>');

switch($action){
	default:
		include('order_listing.php');
		break;
	case 'change_kasse_paymode':
		$order = new order($oID);
		if(!$order->is_kasse()){
			die(MSG_ERROR_ORDER_IS_NOT_FROM_COUNTER);
		}
		if( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_switch_kasse_payment'] == '1')){
			$order_array = array(
				'title'=>$order->get_title(),
				'customer'=>$order->customer,
				'info'=>$order->info,
				'products'=>$order->products,
				'totals'=>$order->totals
			);
			$smarty->assign('order',$order_array);
			$smarty->assign('change_kasse_paymode',1);
			$smarty->assign('kasse',$order->get_kasse_data());
			$smarty->assign('change_kasse_paymode_form',xtc_draw_form('kass','orders.php',xtc_get_all_get_params(array('action')).'action=save_kasse_paymode'));

			$kp_query = xtc_db_query("SELECT payment_title,payment_code FROM kasse_payments");
			while($kp_res = xtc_db_fetch_array($kp_query)){
				$kp[] = $kp_res;
			}
			$paymode_array = array();
			foreach($kp as $kpk => $payment){
				if($payment['code'] != 'bank'){
					$paymode_array[$payment['payment_code']] = $payment['payment_title'];
				}
			}
			if( $admin_access['f_kasse_fibu_switch_paymentmethod_moneyorder'] == '1'){
				$paymode_array['bank'] = 'Bank';
			}
            $menus = array(
                array('text'=>IMAGE_BACK,
                	'link'=>xtc_href_link(FILENAME_ORDERS, xtc_get_all_get_params(array('action')).'action=edit'),
                    'lbOn'=>false,
                    'auth'=>true
                )
			);
			$smarty->assign(array(
				'HEADING_TITLE'=>BUTTON_CHANGE_PAYDATE,
				'ADDITIONAL_TITLE'=>$order->get_title().' '.$order->info['id'].' '.TABLE_HEADING_DATE_PURCHASED.' '.yes_date_short($order->info['date_purchased']),
				'PAGE_HEADING_MENU_BUTTONS'=>$menus,
				'STORNIERT_STATUS_NAME'=>xtc_get_orders_status_name(ORDERS_STATUS_STORNIERT),
			));
			$smarty->assign('paymode_array',$paymode_array);
			$smarty->assign('backlink',xtc_href_link('orders.php',xtc_get_all_get_params(array('action')).'action=edit'));
			$html=$smarty->fetch('orders.html');
			echo $html;
		}
		break;
	case 'custom_action':
		include('orders_actions.php');
		break;
	case 'edit':
		if(!$order_exists){
                    die('Unknown Order');
        }
        $oID = (int)xtc_db_prepare_input($_GET['oID']);
		$order = new order($oID);
		$fibu_number = $order->get_fibunumber();
		if(!empty($fibu_number) and strlen($fibu_number)>1){
            $title_order = TEXT_INVOICE;
		}else{
			if($order->info['orders_status'] != ORDERS_STATUS_OFFER){
				$title_order = TEXT_ORDER;
			}else{
				$title_order = TEXT_OFFER;
			}
		}
		$ebay_plus_title = ($order->info['ebay_plus'] == 1) ? '&nbsp;&#10026;&nbsp;[eBay Plus]' : '';
		
		$heading_title = $title_order.' '.$oID.' '.TEXT_FROM_DATE.' '.yes_date_short($order->info['date_purchased']).$ebay_plus_title;
		$order_array = array('info'=>$order->info,
                    'products'=>$order->products,
                    'totals'=>$order->totals,
                    'billing'=>$order->billing,
                    'customer'=>$order->customer,
                    'delivery'=>$order->delivery
		);
		$smarty->assign('order',$order_array);
		
		$ee_list = \YES4Trade\Model\ebay_emails::filter([
			'orders_id'=>intval($oID)
		],['id']);
		$smarty->assign('ALLOCATED_EMAILS',sizeOf($ee_list));
		
		$smarty->assign('ALLOCATED_RUECKERSTATTUNGEN',sizeOf($order->rueckerstattungen));
		$query = xtc_db_query(sprintf(
                    "SELECT COUNT(retoure_id) AS anz FROM retouren WHERE orders_id='%d'",
                    $oID
		));
		$record = xtc_db_fetch_array($query);
		$smarty->assign('ALLOCATED_RETOUREN',$record['anz']);
		
		$query = xtc_db_query(sprintf(
                    "SELECT COUNT(reclamations_id) AS anz FROM reclamations WHERE orders_id='%d'",
                    $oID
		));
		$record = xtc_db_fetch_array($query);
		$smarty->assign('ALLOCATED_RECLAMATIONS',$record['anz']);

		$smarty->assign('tab_link_base','orders.php?'.xtc_get_all_get_params(array('tab')));
		$smarty->assign('select_set_link',xtc_href_link('orders_edit.php',xtc_get_all_get_params(array('edit_action')).'edit_action=select_set'));
                $allow_edit = true;
                if($order->has_current_tax_failure()){
                    $allow_edit = false;
                }
                $button_order_edit = array(
                    'text'=>IMAGE_EDIT,
                    'lbOn'=>false
                );
                $has_discount = false;
                foreach($order->totals as $total){
                    switch($total['class']){
                        case 'ot_discount':
                            $has_discount = true;
                            break;
                    }
                }
		if($order->info['orders_status'] != ORDERS_STATUS_STORNIERT){
                    
			if( ($order->info['orders_status'] != ORDERS_STATUS_VERSENDET and $order->info['orders_status'] != ORDERS_STATUS_ABGESCHLOSSEN) or ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_orders_edit_after_shipping'] == '1')){
				if($order->info['parent_orders_id']>0){
					// yes accounting
					if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['orders_update'] == '1')) {
						$button_order_edit['auth'] = true;
						$button_order_edit['error'] = JS_ALERT_NO_ORDERS_EDIT;
					}
				}else{
					// yes accounting
					if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['orders_edit'] == '1')) {
                                            if($order->info['orders_status'] == ORDERS_STATUS_BEZAHLT and $admin_access['f_change_order_if_status_bezahlt'] != '1'){
                                                    $button_order_edit['auth'] = true;
                                                    $button_order_edit['error'] = JS_ALERT_AUTH_CHANGE_ORDER_IF_STATUS_BEZAHLT;
                                            }else{
                                                if($has_discount){
                                                    $button_order_edit['auth'] = true;
                                                    $button_order_edit['error'] = JS_ALERT_AUTH_CHANGE_ORDER_IF_HAS_DISCOUNT;
                                                }else{
                                                    $button_order_edit['auth'] = true;
                                                    $button_order_edit['link'] = xtc_href_link(FILENAME_ORDERS_EDIT, xtc_get_all_get_params(array('cID')).'cID='.$order->customer['ID']);
                                                }
                                            }
					}
				}
			}else{
				// yes accounting
				if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['orders_edit'] == '1')) {
					$button_order_edit['auth'] = false;
				}
			}
		}else{ // end if not storno
			// yes accounting
			if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['orders_edit'] == '1')) {
				$button_order_edit['auth'] = false;
			}
		}
                if(!$allow_edit){
                    $button_order_edit['auth'] = true;
                    $button_order_edit['error'] = 'MwSt. Abweichungen';
                }
                $button_order_kasse = array(
                    'text'=>BUTTON_PROCESS_KASSE,
                    'lbOn'=>false,
                );
		// yes accounting
		if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['kasse'] == '1')) {
			// BEDINGUNG kasse abwickeln
			$button_order_kasse['auth'] = true;
			if($order->info['orders_status'] == ORDERS_STATUS_UPSELLING or $order->info['orders_status'] == '1' or $order->info['orders_status'] == '2' or $order->info['orders_status'] == ORDERS_STATUS_VERSENDET){
				if($order->info['select_set'] == '1' and $order->info['select_set_products_status'] == 0){
					$button_order_kasse['error'] = JS_ALERT_NO_PROCESS_KASSE_SELECT_SET;
				}else{
                                    $button_order_kasse['link'] = xtc_href_link('kasse.php','action=order_payment&orders_id='.$order->info['id']);
				}
			}else{
			    $button_order_kasse['error'] = JS_ALERT_NO_PROCESS_KASSE_WRONG_STATUS;
			}
		}
                
                $button_order_lb = array(
                    'text'=>BUTTON_CREATE_LB,
                    'lbOn'=>true,
                    'auth'=>false
                );
		if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_distributor_new_order'] == '1')) {
                    $button_order_lb['auth'] = true;
                    $button_order_lb['link'] = xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action')).'&action=check_distributors');
		}
		// BOF - MEMOS AUSLAGERN	
                $anz = \YES4Trade\Model\customers_memo::count_by_customers_id((int)$order->customer['ID']);
		$memo_buttons = array('text'=>sprintf(BUTTON_MEMO_COUNT,$anz),
		    'link'=>xtc_href_link('customers.php',xtc_get_all_get_params(array('action','last_action','cID')).'cID='.$order->customer['ID'].'&action=memo&last_action='.$_REQUEST['action'].'&link_src='.urlencode(FILENAME_ORDERS.'?'.xtc_get_all_get_params())),
		    'auth'=>true,
		    'lbOn'=>true
		);

		// EOF - MEMOS AUSLAGERN	

			$menus = array(
				array('text'=>IMAGE_BACK,
					'link'=>xtc_href_link(FILENAME_ORDERS, xtc_get_all_get_params(array('action','oID','edit_action','cID'))),
					'lbOn'=>false,
					'auth'=>true
				),
				$button_order_edit,
				array('text'=>ADD_QUICKNOTE,
					'link'=>'javascript:void(toggleBox(\'addquicknote\'))',
					'lbOn'=>false,
					'auth'=>true
				),
				$button_order_kasse,
				$button_order_lb,
				array('text'=>TEXT_CREATE_PDF,
					'link'=>xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action')).'action=pdf'),
					'lbOn'=>false,
					'auth'=>true
				),
				array('text'=>ORDER_PALLETS,
					'link'=>xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action')).'action=edit_pallets'),
					'lbOn'=>false,
					'auth'=>true
				),
		array(
		'text' => TEXT_ALL_ORDERS_CUSTOMER, 
		'link'=>xtc_href_link(FILENAME_ORDERS, 'cID=' . $order->customer['ID']),
		'lbOn'=>false,
		'auth'=>true
		),
		$memo_buttons
			);


		$button_convert = array(
			'text'=>TEXT_ORDER_CHANGE_CURRENCY,
			'link'=>xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(['action']).'action=convert'),
			'lbOn'=>true,
			'auth'=>true
		);
		if(\main::isDev(true)){
			define('YES_PAYMODULE_CONVERT_ORDERS','True');
		}
		if(defined('YES_PAYMODULE_CONVERT_ORDERS') and constant('YES_PAYMODULE_CONVERT_ORDERS') == 'True'){
			$menus[] = $button_convert;
		}
                
       		if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_customers_crm'] == '1')) {
			if($order->customer['ID'] != KASSE_USER){
                            $menus[] = array('text'=>'CRM',
                                    'link'=>xtc_href_link(FILENAME_CUSTOMERS, 'cID=' . $order->customer['ID'].'&action=crm'),
                                    'lbOn'=>false,
                                    'auth'=>true
                            );
			}
		}
		if($order->is_otc() and in_array($order->info['orders_status'],array(ORDERS_STATUS_ABGESCHLOSSEN,ORDERS_STATUS_VERSENDET))  and defined('YES_PAYMODULE_PRODUCTS_FAKE_SETS') and YES_PAYMODULE_PRODUCTS_FAKE_SETS == 'True'){
                    $menus[] = array('text'=>'Fakeset Export',
                            'link'=>xtc_href_link(basename(__FILE__), xtc_get_all_get_params(array('action')).'action=products_fake_set_export'),
                            'lbOn'=>false,
                            'auth'=>true
                    );
                }
		if($order->info['orders_status'] == ORDERS_STATUS_UPSELLING and $admin_access['orders_edit'] == 1){
			$menus[] = array('text'=>'Upselling beenden',
				'link'=>'javascript:;',
				'lbOn'=>false,
				'auth'=>true,
			    'id'=>'end_upselling_button'
			);
		}
		$mod_att = new module_attachments('order', $oID);
		$menus[] = array(
		    'text'=>$mod_att->get_button_text(),
		    'link'=>$mod_att->get_button_link(),
		    'add_css_class'=>'module_attachments_button',
		    'lbOn'=>true,
		    'auth'=>true
		);
                $heading_fibu_addon = ($order->get_fibunumber() != '') ? sprintf(' - FiBu Nr: %s',$order->get_fibunumber()) : '';
                $heading_total_sum = ' (0,00 '.DEFAULT_CURRENCY.')';
                foreach($order->totals as $ot){
                    if($ot['class'] == 'ot_total'){
                        $heading_total_sum = ' ('.trim(strip_tags($ot['text'])).')';
                    }
                }
				if(\YES4Trade\Model\ebay_order_reservation::isInstalled()){
					if(intval(constant('EBAY_ORDER_RESERVATION_ORDERS_ID')) == intval($order->info['id'])){
						$menus = [['text'=>'EBAY ORDER RESERVATION - no edit']];
					}
				}

                $smarty->assign(array(
                    'HEADING_TITLE'=>$heading_title,
                    'ADDITIONAL_TITLE'=>TEXT_STATUS.' '.$order->info['orders_status_name'].$heading_fibu_addon.$heading_total_sum,
                    'PAGE_HEADING_MENU_BUTTONS'=>$menus
                ));
                
		// VERSANDSPERRE BEDINGUNG
		if($order->info['block_shipping'] == 0){
			$smarty->assign('set_block_shipping_link',xtc_href_link('orders.php',xtc_get_all_get_params(array('action')).'action=set_block_shipping'));
			$smarty->assign('set_block_shipping_button',"<input type='button' onClick='really_block_shipping(\"".$order->info['id']."\");' value='".BLOCK_SHIPPING."' title='".BLOCK_SHIPPING_WITH_SPAN."' class='ui-button ui-corner-all ui-state-default' style='width:160px'>");
		}else{
			$smarty->assign('set_unblock_shipping_link',xtc_href_link('orders.php',xtc_get_all_get_params(array('action')).'action=set_unblock_shipping'));
			$smarty->assign('set_unblock_shipping_button',"<input type='button' onClick='really_unblock_ship(\"".$order->info['id']."\");' title='".UNBLOCK_SHIPPING."' value='".UNBLOCK_SHIPPING."' class='ui-button ui-corner-all ui-state-default' style='width:160px'>");
		}

		// MAHNSPERRE BEDINGUNG
		if( $order->info['orders_status'] == 1 or $order->info['orders_status'] == 2 or $order->info['orders_status'] == ORDERS_STATUS_UPSELLING or $order->info['orders_status'] == ORDERS_STATUS_VERSENDET){
			$is_warn_query = xtc_db_query("SELECT warning_span FROM orders WHERE orders_id='".$order->info['id']."'");
			$is_warn = xtc_db_fetch_array($is_warn_query);
			if($is_warn['warning_span'] == 0){
				if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['ebayapi_warnings'] == '1')) {
					$smarty->assign('set_no_warn_span_link',xtc_href_link('orders.php',xtc_get_all_get_params(array('action')).'action=set_no_warn_span'));
				}
			}else{
				if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['ebayapi_warnings'] == '1')) {
					$smarty->assign('unset_no_warn_span_link',xtc_href_link('orders.php',xtc_get_all_get_params(array('action')).'action=unset_no_warn_span'));
					$smarty->assign('warning_span',$is_warn['warning_span']);
				}
			}
		}

		$smarty->assign('order_set_rueckstand_link',xtc_href_link( 'orders.php',xtc_get_all_get_params(array('action')).'action=set_rueckstand' ));
		$smarty->assign('order_unset_rueckstand_link',xtc_href_link( 'orders.php',xtc_get_all_get_params(array('action')).'action=unset_rueckstand' ));

		$smarty->assign('order_email_link',xtc_href_link( 'orders.php',xtc_get_all_get_params(array('action')).'action=email&cID='.$order->customer['ID'] ));
		$smarty->assign('offer_email_link',xtc_href_link( 'orders.php',xtc_get_all_get_params(array('action')).'action=email_offer&cID='.$order->customer['ID'] ));
		$smarty->assign('order_email_packing_link',xtc_href_link( 'orders.php',xtc_get_all_get_params(array('action')).'action=email_packing&cID='.$order->customer['ID'] ));

		$smarty->assign([
			'EXT_POPUP_WIDTH'=>EXT_POPUP_WIDTH,
			'EXT_POPUP_HEIGHT'=>EXT_POPUP_HEIGHT,
			'HTML_PARAMS'=>HTML_PARAMS,
			'edit_mode'=>1,

		]);
		
		if(isset($_REQUEST['kasse_payment_code'])){
			$smarty->assign('kasse_payment_code',$_REQUEST['kasse_payment_code']);
		}
		$html=$smarty->fetch('orders.html');
               
		echo $html;
		break;
}
if(defined('MODULE_PAYMENT_AM_APA_STATUS') and MODULE_PAYMENT_AM_APA_STATUS == 'True' && isset($_GET['oID']) and is_file(DIR_FS_CATALOG.'AmazonAdvancedPayment/AlkimAmazonClasses/AlkimAmazonHandler.class.php')){
    require_once(DIR_FS_CATALOG.'AmazonAdvancedPayment/AlkimAmazonClasses/AlkimAmazonHandler.class.php');
}
include('includes/footer.php');
include('includes/application_bottom.php');
