<?php
class yes_export_module
{
    var $id,$text,$values,$params,$product_instance;
    public function get_value_from_array($array){
	if(isset($array[$this->id])) return $array[$this->id];
	if(!isset($array['products_id'])) return 'Missing products_id in '.basename(__FILE__).': '.$this->id;
	return $this->get_value_from_db($array['products_id']);
    }
    
    public function get_value_from_db($id){
	return $this->id.' hat keine  get_value_from_db() Implementierung';
    }
    
    /**
     * @param class product $product
     * @param string $key
     * @return class product part
     */
    public function get_value_from_product_instance($product, $key){
	if(isset($product->info[$this->id])) return $product->info[$this->id];
	return $this->id.' hat keine  get_value_from_product_instance() Implementierung';
    }
    
    public function get_input_field($type,$field,$value,$values){
	$params = $this->params;
	switch($type){
	    case 'select':
		$item = xtc_draw_pull_down_menu($field,$values,$value);
		break;
	    case 'date':
		$value = (!$value) ? date('Y-m-d') : $value;
		$item = xtc_draw_input_field($field,$value,'size="10" maxlength="10" '.$params);
		break;
	    case 'price':
		$value = (!$value) ? '0.00' : number_format($value,2,'.','');
		$item = xtc_draw_input_field($field,$value,'size="16" maxlength="16" '.$params);
		break;
	    case 'int':
		$value = (!$value) ? 0 : (int)$value;
		$item = xtc_draw_input_field($field,$value,'size="8" maxlength="12" '.$params);
		break;
	    case 'bool':
		$value = (!$value) ? false : (bool)$value;
		$item = xtc_draw_checkbox_field($field,'1',false);
		break;
	    case 'text':
		$item = xtc_draw_input_field($field,$value,'size="64" maxlength="255" '.$params);
		break;
	    case 'large_text':
		$item = xtc_draw_textarea_field($field,'virtual',64,6,$value);
		break;
	    case 'image':
		if(sizeOf($values)){
		    $item = xtc_draw_pull_down_menu($field,$values,$value,'class="yep_image_selector"');
		}else{
		    $item = xtc_draw_hidden_field($field,'').'-';
		}
		break;
	    default:
		$item = xtc_draw_input_field($field,$value,'size="32" maxlength="32" '.$params);
		break;
	}
	return $item;
    }
    
    public function get_input_special_edit(){
	return '';
    }
    public function get_input_subtitle($value){
	return '';
    }
}