<?php

class paketliste_pdf_product {
    var $qty;
    var $storages_array;
    var $products_id;
    var $is_stklistenartikel;
    var $image;
    
    public function getQty() {
        return $this->qty;
    }

    public function setQty($qty) {
        $this->qty = $qty;
    }

    public function getStorages_array() {
        return $this->storages_array;
    }

    public function setStorages_array($storages) {
        $this->storages_array = $storages;
    }

    public function getProducts_id() {
        return $this->products_id;
    }

    public function setProducts_id($products_id) {
        $this->products_id = $products_id;
    }
    
    function getIs_stklistenartikel() {
        return $this->is_stklistenartikel;
    }

    function setIs_stklistenartikel($is_stklistenartikel): void {
        $this->is_stklistenartikel = $is_stklistenartikel;
    }
    
    function getImage() {
        return $this->image;
    }

    function setImage($image): void {
        $this->image = $image;
    }

    function __construct( $products_id, $stklistenartikel = false ){
        $this->setProducts_id($products_id);
        $this->storages_array = new paketliste_pdf_product_storages();
        $this->setIs_stklistenartikel($stklistenartikel);
        $this->setImage(self::get_products_image($products_id));
    }
    public function add_quantity($qty){
        $this->qty = $this->qty + $qty;
    }
    
    public function get_transfer_places(){
        $array = array();
        // Mario 01/2024 - vorher sizeOf($this->storages_array)
        if(!sizeOf($this->storages_array->storage)){
            return $array;
        }
        // Mario 01/2024 - vorher foreach($this->storages_array
        foreach($this->storages_array->storage as $storage){
            //foreach($storage_array as $storage){
                $array[] = array(
                    'storage_id'=>$storage->getStorage_id(),
                    'name'=>$storage->getName(),
                    'storage_nummer'=>$this->get_storage_number($storage->getStorage_id()),
                    'storage_place'=>$storage->getStorage_place(),
                    'storage_places_id'=>$storage->getStorage_places_id(),
                    'quantity'=>$storage->getQuantity(),
                    'is_colli'=>$storage->getIs_colli(),
                    'collie_products_id'=>$storage->getCollie_products_id(),
                    'product_place_quantity'=>$this->get_storage_products_quantity($storage->getStorage_id(), $storage->getStorage_places_id())
                );
            //}
        }
        return $array;
    }
    
    public function addStorages_array( $storage_array ){
        foreach($storage_array as $st){
            $unique = $this->storages_array->get_unique_key($st['name'],$st['storage_place']);
            if(!$this->storages_array->exists($unique)){
                $this->storages_array->add( $st );
                // VERSCHOBEN
                $stp = $this->storages_array->get($unique);
                $stp->addQuantity($st['quantity']);
            }
            // VERSCHOBEN
            //$stp = $this->storages_array->get($unique);
            //$stp->addQuantity($st['quantity']);
        }
    }
    
    private function get_collie_set_info($collie_qty,$collie_products_id){
        return sprintf('[Colli pID %s (%s Stk / SET) &raquo;%s&laquo;]<br />',
                $collie_products_id,
                $collie_qty,
                xtc_get_products_name($collie_products_id)
        );
    }
    
    private function get_collie_quantity($collies,$collie_products_id){
        foreach($collies as $colli){
            if($colli['collie_products_id'] == $collie_products_id){
                return $colli['quantity'];
            }
        }
        return 0;
    }
    
    private function get_collie_storage_string($transfer_place,$collies){
        $collie_qty = $this->get_collie_quantity($collies,$transfer_place['collie_products_id']);
        $set_info = $this->get_collie_set_info($collie_qty,$transfer_place['collie_products_id']);
        return sprintf('<br />%s<br />Lager &raquo;%s&laquo; / Lagerplatz &raquo;%s&laquo;: %s Stk.',
                $set_info,$transfer_place['name'],$transfer_place['storage_place'],$transfer_place['quantity']
        );
    }
    
    public function get_storage_string( $transfer_places,$collies = array() ){
        $storage_str = '';
        foreach($transfer_places as $tp){
            if($tp['is_colli']){
                $storage_str .= $this->get_collie_storage_string($tp,$collies);
            }else{
                $storage_str .= sprintf('<br />Lager &raquo;%s&laquo; / Lagerplatz &raquo;%s&laquo;: %s Stk.',
                        $tp['name'],$tp['storage_place'],$tp['quantity']
                );
            }
        }
        return $storage_str;
    }
    
    private function get_collie_storage_allocated_array($transfer_place,$collies){
        $collie_qty = $this->get_collie_quantity($collies,$transfer_place['collie_products_id']);
        $set_info = $this->get_collie_set_info($collie_qty,$transfer_place['collie_products_id']);
        return array(
            'storage_name'=>$transfer_place['name'],
            'storage_place'=>$transfer_place['storage_place'],
            'quantity'=>$transfer_place['quantity'],
            'set_info'=>$set_info
        );
    }

    
    /**
     * Welchen Lagern ist ein Artikel zugewiesen?
     * Wird ermittelt aus storage_products
     * WHERE sp.products_id='%s' ORDER BY priority
     * Das Rueckgabe Array enthaelt jeweils
     * [
     *  storage_id: int,
     *  products_id: int,
     *  is_colli: boolean
     * ]
     * 
     * @param boolean $is_colli
     * @return array
     */
    private function get_default_products_storages_array($is_colli = false){
	$query = xtc_db_query(sprintf(
                "SELECT DISTINCT(sp.storage_id) FROM storage_products sp WHERE sp.products_id='%s' ORDER BY priority",
                $this->getProducts_id()
        ));
	$products_storages_array = array();
	while($defaults = xtc_db_fetch_array($query)){
		$products_storages_array[] = array(
		    'storage_id'=>$defaults['storage_id'],
		    'products_id'=>$this->getProducts_id(),
		    'is_colli'=>$is_colli
		);
	}
	return $products_storages_array;
    }
    
    /**
     * Ermittelt die nummer aus der Tabelle storage_numbers zu einem Artikel 
     * eines bestimmten Lagers
     * @param int $storage_id
     * @return string
     */
    private function get_storage_number($storage_id){
        $query = xtc_db_query(sprintf(
                "SELECT nummer FROM storage_numbers WHERE storage_id='%s' and products_id='%s'",
                $storage_id,$this->getProducts_id()
        ));
        if(!xtc_db_num_rows($query)){
            return '';
        }
        $record = xtc_db_fetch_array($query);
        return xtc_db_prepare_input($record['nummer']);
    }

    /**
     * Welche Lagerplaetze hat ein Artikel in einem bestimmten Lager?
     * Rueckgabe Array jeweils:
     * [
     *  id: int,
     *  storage_id: int,
     *  priority: int
     * ]
     * @param int $storage_id
     * @return array
     */
    private function get_storage_places($storage_id){
        $return = array();
        $places_query = xtc_db_query(sprintf(
            "SELECT sp.id,sp.storage_places_id,sp.quantity as product_place_quantity FROM storage_products sp LEFT JOIN storage_places stp USING(storage_places_id) WHERE sp.products_id='%s' and sp.storage_id='%s' ORDER BY stp.title",
            $this->getProducts_id(),
            $storage_id
        ));
        while($places_res = xtc_db_fetch_array($places_query)){
            $return[] = $places_res;
        }
        return $return;
    }
    
    private function get_storage_numbers_with_places($storage_id){
        $return = array();
        $places = $this->get_storage_places($storage_id);
        foreach($places as $nr => $place){
            if(!isset($return[$nr])){
                $return[$nr] = array();
            }
            $return[$nr] = $place;
            $return[$nr]['storage_nummer'] = $this->get_storage_number($storage_id);
            $return[$nr]['title'] = yes_get_storage_place_title($place['storage_places_id']);
        }
        return $return;
    }
    
    /**
     * Ermittelt den Bestand eines Artikels auf einem bestimmten Lagerplatz
     * eines Lagers
     * @param int $storage_id
     * @param int $storage_places_id
     * @return int
     */
    private function get_storage_products_quantity($storage_id, $storage_places_id){
        $query = xtc_db_query(sprintf(
                "SELECT quantity FROM storage_products WHERE products_id='%s' and storage_id='%s' and storage_places_id='%s'",
                $this->getProducts_id(), $storage_id, $storage_places_id
        ));
        $record = xtc_db_fetch_array($query);
        return (int)$record['quantity'];
    }
    
    public function get_default_storage_data($collies = array()){
	if(sizeOf($collies)){
	    $products_storages_array = array();
	    foreach($collies as $colli){
                $cpdf_product = new paketliste_pdf_product($colli['collie_products_id']);
		$products_storages_array = array_merge($products_storages_array,$cpdf_product->get_default_products_storages_array(true));
	    }
	}else{
	    $products_storages_array = $this->get_default_products_storages_array(false);
	}
        // $products_storages_array = in welchen Lagerplaetzen des Lagers ist 
        // dieser Artikel gespeichert.
        // Wird ermittelt aus Tabelle storage_products 
        // WHERE sp.products_id='%s' ORDER BY priority
        for($i=0;$i<count($products_storages_array);$i++){
            $products_storages_array[$i]['places'] = $this->get_storage_numbers_with_places($products_storages_array[$i]['storage_id']);
            if($products_storages_array[$i]['is_colli']){
                $collie_qty = 0;
                foreach($collies as $colli){
                    if($colli['collie_products_id'] == $products_storages_array[$i]['products_id']){
                        $collie_qty = $colli['quantity'];
                    }
                }
                $products_storages_array[$i]['calculated_colli_quantity'] = $collie_qty;
            }
        }
        return $products_storages_array;
    }
    
    private static function get_products_image($products_id){
        if(!function_exists('xtc_get_products_image')){
            require_once(DIR_FS_INC.'xtc_get_products_image.inc.php');
        }
        $products_image = xtc_get_products_image($products_id);
        if($products_image != '' and ( substr(strtolower($products_image),strlen($products_image)-3) == 'jpg' or substr(strtolower($products_image),strlen($products_image)-3) == 'jpeg') ){
            if(!is_file(DIR_FS_CATALOG_THUMBNAIL_IMAGES.$products_image)){
                return '';
            }
            if(exif_imagetype(DIR_FS_CATALOG_THUMBNAIL_IMAGES.$products_image) == IMAGETYPE_JPEG){
                return HTTP_SERVER.'images/product_images/thumbnail_images/'.$products_image;
            }
        }
        return '';
    }
}