<?php
/**
 * Description of distributor_order_proposal
 *
 * @author Mario Aspeleiter <m.aspeleiter at yes-websolutions.de>
 */
class distributor_order_proposal
{
	var $products_id;
	var $distributors_id;
	var $open_orders;
	var $name;
	var $storage_numbers;
	var $distributors;
	var $meldebestand;
	var $ordered;
	var $physical_qty;
	var $anz;
	var $product_popup_link;
	var $shippingtime;
	var $shipping; // VERSANDDAUER LIEFERANT
	var $language_id;
	var $SQ;

	function __construct($pID,$SQ,$open_orders,$distributors_id = -1,$language_id=-1){
		$this->setProducts_id($pID);
		$this->setOpen_orders($open_orders);
		$this->setSQ($SQ);
		if($distributors_id > 0){
			$this->setDistributors_id($distributors_id);
		}
		if($language_id == -1){
			$this->setLanguage_id($_SESSION['languages_id']);
		}else{
			$this->setLanguage_id($language_id);
		}
	}

	function get_db_values(){
		$query_raw = sprintf(
			"SELECT p.products_shippingtime,p.products_meldebestand,pd.products_name
			 FROM products p LEFT JOIN products_description pd USING(products_id)
			 WHERE p.products_id='%s' and pd.language_id='%s'",
			$this->getProducts_id(),
			$this->getLanguage_id()
		);
		$query = yes_db_query($query_raw,true);
		if(!$query){
			echo '<li><span class="errorText">Unknown pID:'.$this->getProducts_id().'</span>';
			return false;
		}
		$record = current($query);
		$this->setName($record['products_name']);
		$this->setShippingtime( (int)$record['products_shippingtime']);
		$this->setMeldebestand( (int)$record['products_meldebestand']);

		// LIEFERANTENDATEN
		if($this->getDistributors_id() > 0){
			$dnumbers_query = xtc_db_query(sprintf(
				"SELECT pd.distributor_products_number,pd.distributor_products_link,d.name,d.id
				 FROM products_distributors pd LEFT join distributors d ON d.id=pd.distributor_id
				 WHERE pd.products_id='%s' and pd.distributor_id='%s'",
					$this->getProducts_id(),
					$this->getDistributors_id()
			));
		}else{
			$dnumbers_query = xtc_db_query(sprintf(
				"SELECT pd.distributor_products_number,pd.distributor_products_link,d.name,d.id
				 FROM products_distributors pd LEFT join distributors d ON d.id=pd.distributor_id
				 WHERE pd.products_id='%s'",
				$this->getProducts_id()
			));
		}
		$dnumbers = array();
		$p = new product($this->getProducts_id());
		while($dnumber = xtc_db_fetch_array($dnumbers_query)){
			$distributor_products_edit_link = xtc_href_link('distributor.php','action=products&dID='.$dnumber['id']);
			$dprices = $p->get_distributor_prices($dnumber['id']);
			$dprice_array = array();
			for($i=0;$i<sizeOf($dprices);$i++){
				$dprice_array[] = array(
					'price'=>number_format($dprices[$i]['price'],2,',',''),
					'conditions'=>$dprices[$i]['conditions'] );
			}
			$dnumbers[] = array(
				'name'=>$dnumber['name'],
				'number'=>$dnumber['distributor_products_number'],
				'ordered'=>$this->get_products_ordered($dnumber['id']),
				'ordered_2' => $this->get_products_ordered($dnumber['id'],array(2)),
				'distributor_products_link'=>$dnumber['distributor_products_link'],
				'distributor_products_edit_link'=>$distributor_products_edit_link,
				'prices'=>$dprice_array
			);
		}
		$this->setDistributors($dnumbers);
		$SQ = $this->getSQ();
		$pqty = $SQ->get_products_total_qty();
		$qtytotal = $SQ->get_gesamtbestand_qty();
		
                
		$this->setAnz( $pqty );
		// DEN HIER HABEN WIR EIGENTLICH JA SCHON ERMITTELT?
		// $product['orders'] = $SQ->get_not_shipped_qty();

		$this->setProduct_popup_link( xtc_href_link('products.php','action=bestand&pID='.$this->getProducts_id()) );
		// LIEFERZEIT
		$shippings = array();

                $shipping_query = xtc_db_query(sprintf(
                    "SELECT dp.shipping_status_id,d.name FROM distributor_product_prices dp,distributors d
                     WHERE products_id='%s' and dp.distributor_id=d.id and dp.shipping_status_id>0",
                    $this->getProducts_id()
                ));
                while( $shipping_res = xtc_db_fetch_array($shipping_query) ){
                    $shippings[] = array(
                        'name'=>$shipping_res['name'],
                        'time'=> xtc_get_shipping_status_name($shipping_res['shipping_status_id'])
                    );
                }
                
		if(sizeOf($shippings)>0)
			$this->setShipping($shippings);

		// BEREITS BESTELLT
		$ordered_query = xtc_db_query("SELECT (SUM(dop.products_quantity)-SUM(dop.qty_rueckbuch)) as bestellt FROM distributor_orders_products dop, distributor_orders do WHERE do.distributor_orders_id=dop.distributor_orders_id AND do.orders_status = 2 and dop.products_id='".$this->getProducts_id()."' ");
		$ordered = xtc_db_fetch_array($ordered_query);
		$this->setOrdered( (int)$ordered['bestellt'] );
		return true;
	}

	public function get_sales_stats($time){

		// in welchen stuecklistenartikeln ist dieses product enthalten
		$in_collies = xtc_get_product_in_collies($this->getProducts_id());
		if(sizeOf($in_collies)>0){
			$stats_check_array = $in_collies;
		}else{
			$stats_check_array = array(0=>array('products_id'=>$this->getProducts_id(),'quantity'=>1));
		}
		$allowed_orders_status_array = array(ORDERS_STATUS_VERSENDET,ORDERS_STATUS_BEZAHLT,ORDERS_STATUS_ABGESCHLOSSEN);
		$sales = 0;
		foreach($stats_check_array as $pk=>$stat_product){
			$query_raw = sprintf(
				"SELECT sum(products_quantity) as summe FROM orders o, orders_products op
				 WHERE o.orders_id=op.orders_id and o.orders_status IN(%s) and o.date_purchased>'%s' and op.products_id='%d'",
				implode(',',$allowed_orders_status_array),
				$time,
				$stat_product['products_id']
			);
			$query = xtc_db_query($query_raw);
			$result = xtc_db_fetch_array($query);
			$sales += (int)$result['summe']*$stat_product['quantity'];
		}
		return $sales;
	}

	function getProducts_id() {
		return $this->products_id;
	}

	function setProducts_id($products_id) {
		$this->products_id = $products_id;
	}

	function getOpen_orders() {
		return $this->open_orders;
	}

	function setOpen_orders($open_orders) {
		$this->open_orders = $open_orders;
	}

	function getName() {
		return $this->name;
	}

	function setName($name) {
		$this->name = $name;
	}

	function getStorage_numbers() {
		return $this->storage_numbers;
	}

	function setStorage_numbers($storage_numbers) {
		$this->storage_numbers = $storage_numbers;
	}

	function getDistributors() {
		return $this->distributors;
	}

	function setDistributors($distributors) {
		$this->distributors = $distributors;
	}

	function getMeldebestand() {
		return $this->meldebestand;
	}

	function setMeldebestand($meldebestand) {
		$this->meldebestand = $meldebestand;
	}

	function getOrdered() {
		return $this->ordered;
	}

	function setOrdered($ordered) {
		$this->ordered = $ordered;
	}

	function getShippingtime() {
		return $this->shippingtime;
	}

	function setShippingtime($shippingtime) {
		$this->shippingtime = $shippingtime;
	}
	
	function getLanguage_id() {
		return $this->language_id;
	}

	function setLanguage_id($language_id) {
		$this->language_id = $language_id;
	}

	function getDistributors_id() {
		return $this->distributors_id;
	}

	function setDistributors_id($distributors_id) {
		$this->distributors_id = $distributors_id;
	}

	function getSQ() {
		return $this->SQ;
	}

	function setSQ($SQ) {
		$this->SQ = $SQ;
	}

	function getAnz() {
		return $this->anz;
	}

	function setAnz($anz) {
		$this->anz = $anz;
	}

	function getProduct_popup_link() {
		return $this->product_popup_link;
	}

	function setProduct_popup_link($product_popup_link) {
		$this->product_popup_link = $product_popup_link;
	}

	function getShipping() {
		return $this->shipping;
	}

	function setShipping($shipping) {
		$this->shipping = $shipping;
	}

	function get_array(){
		$array = array(
			'products_id'=>$this->getProducts_id(),
			'orders'=>$this->getOpen_orders(),
			'name'=>$this->getName(),
			'storage_numbers'=>$this->getStorage_numbers(),
			'dnumbers'=>$this->getDistributors(),
			'products_meldebestand'=>$this->getMeldebestand(),
			'ordered'=>$this->getOrdered(),
			'anz'=>$this->getAnz(),
			'product_popup_link'=>$this->getProduct_popup_link(),
			'shippingtime'=>$this->getShippingtime(),
			'meldebestand'=>$this->getMeldebestand(),
			'shipping'=>$this->getShipping()
		);
		return $array;
	}
	
	private function get_products_ordered($distributor_id,$valid_lb_status = array(1,2)){
	    $ordered_by_query = xtc_db_query(sprintf(
		"SELECT (SUM(dop.products_quantity)-SUM(dop.qty_rueckbuch)) as bestellt
		 FROM distributor_orders_products dop, distributor_orders do
		 WHERE do.distributor_orders_id=dop.distributor_orders_id AND
		 do.orders_status IN(%s) and dop.products_id='%s'
		 and do.distributor_id='%s'",
		implode(',',$valid_lb_status),
		$this->getProducts_id(),
		$distributor_id
	    ));
	    $ordered_by = xtc_db_fetch_array($ordered_by_query);
	    return $ordered_by['bestellt'];
	}
}
