<?php
use phpFastCache\CacheManager;
require_once(DIR_FS_INC.'xtc_db_affected_rows.inc.php');
class notiz
{
	var $id;
	var $usr; // user created notice
	var $dat; // timestamp created
	var $capt; // title
	var $note; // notice
	var $read_status;
	var $date_termin;
	var $termin_unset = false;
	var $termin_status;
	var $reminder = array();
        var $CACHEOBJ;

	public function __construct($id){
            $this->id = $id;
            if($id > 0){
                $this->unset_termin();
            }
	}
        
        private static function get_cache_obj(){
			global $InstanceCache;
            return $InstanceCache;
        }
        
        /**
         * Loescht ein Notiz Userverzeichnis
         * 
         * @param int $customers_id
         * @param int $folders_id
         */
        public static function delete_folder( int $customers_id, int $folders_id ){
            xtc_db_query(sprintf(
                "DELETE FROM Notice_folders WHERE customers_id='%d' and Notice_folders_id='%d'",
                $customers_id,
                $folders_id
            ));
            $C = self::get_cache_obj();
            $key = "notice_folders_".$customers_id;
            $C->deleteItem($key); // notice_folders_*
        }
        
        /**
         * Hole alle notes_id in einem Verzeichnis des Benutzers 
         * 
         * @param int $customers_id
         * @param int $folders_id
         * @return array gefuńdene messageids
         */
        public static function get_folder_messages( int $customers_id, int $folders_id ){
            $return = [];
            $query = xtc_db_query(sprintf("SELECT notes_id FROM Notice_status WHERE usr='%d' and Notice_folders_id='%d'",
                $customers_id,
                $folders_id
            ));
            while($record = xtc_db_fetch_array($query)){
                $return[] = $record['notes_id'];
            }
            return $return;
        }

        /**
         * prueft ob folder name fuer einen benutzer existiert
         * 
         * @param int $customers_id
         * @param string $name
         * @return int (-1 existiert nicht, sonst die Notice_folders_id)
         */
        public static function get_folder_id_by_name( int $customers_id, string $name ){
            $query = xtc_db_query(sprintf(
                "SELECT Notice_folders_id FROM Notice_folders WHERE customers_id='%d' and folder_title='%s'",
                $customers_id,
                $name
            ));
            if(!xtc_db_num_rows($query)){
                return -1;
            }
            $record = xtc_db_fetch_array($query);
            return $record['Notice_folders_id'];
        }
        
        /**
         * Fuegt einem Benutzer einen neuen Eintrag in Notice_folders hinzu.
         * Es wird geprueft ob der uebergebene folder_name bereits zum user
         * existiert.
         * 
         * @param int $customers_id
         * @param string $folder_name
         * @return int (-1 wenn folder_name existiert sonst die xtc_db_insert_id)
         */
        public static function add_folder( int $customers_id, string $folder_name){
            if(self::get_folder_id_by_name($customers_id, $folder_name)>0){
                return -1;
            }
            $C = self::get_cache_obj();
            $key = "notice_folders_".$customers_id;
            $C->deleteItem($key); // notice_folders_*
            $insert_sql_array = [
                'customers_id'=>$customers_id,
                'folder_title'=>$folder_name,
                'date_created'=>'now()'
            ];
            xtc_db_perform('Notice_folders', $insert_sql_array);
            return xtc_db_insert_id();
        }
        /**
         * Alle Eintraege aus Notice_folders zu einer customers_id
         * 
         * @param int $customers_id
         * @return type array (id, text, date_created)
         */
        public static function get_folders( int $customers_id ){
            $C = self::get_cache_obj();
            $key = "notice_folders_".$customers_id;
            $CachedString = $C->getItem($key);
            $folders = [];
            if (!$CachedString->isHit()) {
                $query = xtc_db_query(sprintf(
                    "SELECT * FROM Notice_folders WHERE customers_id='%d' ORDER BY folder_title",
                    $_SESSION['customer_id']
                ));
                while($folder = xtc_db_fetch_array($query)){
                    $folders[] = [
                        'id'=>$folder['Notice_folders_id'],
                        'text'=>$folder['folder_title'],
                        'date_created'=>$folder['date_created']
                    ];
                }
                $CachedString->set($folders)->expiresAfter(0);//notice_folders_
                $C->save($CachedString); // Save the cache item just like you do with doctrine and entities
            } else {
                $folders = $CachedString->get();
            }
            return $folders;
        }

	public function unset_termin(){
	    $query = xtc_db_query(sprintf(
		    "SELECT r.reminder_interval, r.last_reminder, r.date_added, s.date_termin FROM Notice_reminder r LEFT JOIN Notice_status s ON s.notes_id=r.Notice_notes_id WHERE r.Notice_notes_id='%s' AND s.usr='%s'",
		    $this->id,$_SESSION['customer_id']
	    ));
	    $record = xtc_db_fetch_array($query);
	    if(xtc_db_num_rows($query) and strtotime($record['date_termin']) <= time()) {
		
		switch($record['reminder_interval']){
		    case 'weekly_2':
			$new_termin = date('Y-m-d H:i:s', strtotime("+2 weeks"));
			break;
		    case 'weekly':
			$new_termin = date('Y-m-d H:i:s', strtotime("+1 week"));
			break;
		    case 'monthly':
			$new_termin = date('Y-m-d H:i:s', strtotime("+1 month"));
			break;
		}
		
		$update_sql_array = array(
		    'date_termin'=>$new_termin
		);
		xtc_db_perform('Notice_status',$update_sql_array,'update',sprintf("usr='%s' and notes_id='%s'",
			$_SESSION['customer_id'],
			$this->id
		));
		$update_sql_array = array(
		    'last_reminder'=>'now()'
		);
		xtc_db_perform('Notice_reminder',$update_sql_array,'update',sprintf("Notice_notes_id='%s'",
			$_SESSION['customer_id'],
			$this->id
		));
		$this->termin_unset = true;
	    }else{
		$query_raw = sprintf("UPDATE Notice_status SET termin_status=1 WHERE usr='%s' and notes_id='%s' and date_termin<now() and date_termin>0 AND termin_status=0",
			$_SESSION['customer_id'],
			$this->id
		);
		$result = xtc_db_query($query_raw);
		if(xtc_db_affected_rows($result)){
			$this->termin_unset = true;
		}
	    }
	}

	function get_data(){
		$notice_query_raw = sprintf("select n.capt,n.usr,n.dat,s.read_status,s.date_termin,s.termin_status from Notice_notes n,Notice_status s where n.id='%s' and s.usr='%s' and s.notes_id=n.id",
			$this->id,
			$_SESSION['customer_id']
		);
		$notice_query = xtc_db_query($notice_query_raw);
		$notice = xtc_db_fetch_array($notice_query);

		$this->usr = $notice['usr'];
		$this->dat = $notice['dat'];
		$this->capt = xtc_db_prepare_input($notice['capt']);
		$this->read_status = $notice['read_status'];
		$this->date_termin = $notice['date_termin'];
		$this->termin_status = $notice['termin_status'];
		
		$query = xtc_db_query(sprintf(
			"SELECT reminder_interval, date_added,last_reminder FROM Notice_reminder WHERE Notice_notes_id='%s'",
			$this->id
		));
		if(xtc_db_num_rows($query)){
		    $this->reminder = xtc_db_fetch_array($query);
		    $this->reminder['INTERVAL'] = $this->getIntervalName();
		}
	}

	function set_read_status($status=1){
		$update_query_raw = sprintf("UPDATE Notice_status SET read_status=1 WHERE usr='%s' and notes_id='%s'",$_SESSION['customer_id'],$this->id);
		xtc_db_query($update_query_raw);
	}

	function save_forward($cID){
		$check_query = xtc_db_query(sprintf("SELECT usr FROM Notice_status WHERE usr='%s' and notes_id='%s'",$cID,$this->id));
		if(!xtc_db_num_rows($check_query)>0){
			xtc_db_query(sprintf("INSERT INTO Notice_status SET notes_id='%s',usr='%s'",$this->id,$cID));
		}
	}

	function move_to_folder($folder_id){
		$notice_update_query_raw = sprintf("UPDATE Notice_status SET Notice_folders_id='%s' WHERE notes_id='%s' and usr='%s'",
			$folder_id,
			$this->id,
			$_SESSION['customer_id']
		);
		xtc_db_query($notice_update_query_raw);
	}

	function delete(){
		$delete_sql_raw = sprintf("DELETE FROM Notice_status WHERE notes_id='%s' and usr='%s'",
			$this->id,
			$_SESSION['customer_id']
		);
		xtc_db_query($delete_sql_raw);
		
		$delete_sql_raw = sprintf("DELETE FROM Notice_reminder WHERE Notice_notes_id='%s'",
			$this->id
		);
		xtc_db_query($delete_sql_raw);

		// FALLS KEIN ANDERER DIESE NOTIZ HAT -> loeschen!
		$another_query = xtc_db_query(sprintf("SELECT notes_id FROM Notice_status WHERE notes_id='%s'",$this->id));
		if( xtc_db_num_rows($another_query) < 1){
			xtc_db_query(sprintf("DELETE FROM Notice_status WHERE notes_id='%s'",$this->id));
		}
	}

	function get_note(){
		$query_raw = sprintf("select n.note from Notice_notes n,Notice_status s where n.id='%s' and s.usr='%s' and s.notes_id=n.id",
			$this->id,
			$_SESSION['customer_id']
		);
		$query = xtc_db_query($query_raw);
		$row = xtc_db_fetch_array($query);
		return $row['note'];
	}

	function get_recipients(){
		$array = array();
		$query_raw = sprintf("SELECT usr FROM Notice_status WHERE notes_id='%s' and usr!='%s' and usr!='0'",
			$this->id,
			$_SESSION['customer_id']
		);
		$query = xtc_db_query($query_raw);
		while($row = xtc_db_fetch_array($query) ){
			if($this->usr != $row['usr']){
				$name = xtc_get_editor_name($row['usr']);
				if(xtc_not_null($name))
					$array[] = $name;
			}
		}
		if( sizeOf($array) < 1 ){
			$array[] = '<i>Keine weiteren Empf&auml;nger</i>';
		}
		return $array;
	}

	function get_forward_recipients(){
		$array = array();
		$excl = array(0=>$_SESSION['customer_id'],1=>0);
		$nid_query = xtc_db_query(sprintf("SELECT n.usr FROM Notice_status n WHERE n.notes_id='%s'",$this->id));
		while($nid = xtc_db_fetch_array($nid_query)){
			$excl[] = $nid['usr'];
		}
		
		$excl_strg = '';
		for($i=0;$i<sizeOf($excl);$i++){
			$excl_strg .= " c.customers_id != '".$excl[$i]."' and ";
		}
		$excl_strg = substr($excl_strg,0,(strlen($excl_strg)-4));
		$com = sprintf("SELECT c.customers_firstname,c.customers_lastname,c.customers_id FROM customers c WHERE customers_status=0 and (%s)",$excl_strg);
		$query = xtc_db_query($com);
		while($res = xtc_db_fetch_array($query)){
			$array[] = $res;
		}
		return $array;
	}

	function draw_recipients($default){
		$com='SELECT customers_firstname,customers_lastname,customers_id FROM customers WHERE customers_status=0';
		$query = xtc_db_query($com);
		$counter = 1;
		$array = array();
		$string = '';
		while($row=xtc_db_fetch_array($query)){
			if($_SESSION['customer_id'] != $row['customers_id']){
				$txt = $row['customers_firstname'] . ' ' . $row['customers_lastname'];
				$array[$counter] = array('id'=>$row['customers_id'],'text'=>xtc_db_prepare_input($txt));
				$counter++;
			}else{
				$array[0] = array('id'=>$row['customers_id'],'text'=>'Nur Eigene Notiz');
			}
		}
		ksort($array);
		
		foreach($array as $k=>$v){
			$string .= '<input type="checkbox" value="'.$v['id'].'" name="rec[]"';
			if($default == $v['id']){
				$string .= ' checked="checked"';
			}
			$string .= ' />'.$v['text'].'<br />';
		}
		return $string;
	}

	function save_new($capt,$note,$usr,$termin,$rec_array,$reminder = ''){
		if(!xtc_not_null($capt))
			return false;
		if(!xtc_not_null($note))
			return false;
		if(!is_array($rec_array) or sizeOf($rec_array)==0)
			return false;

		$insert_sql_array = array(
			'dat'=>time(),
			'capt'=>$capt,
			'note'=>$note,
			'usr'=>$usr
		);

		xtc_db_perform('Notice_notes',$insert_sql_array);
		$lid=xtc_db_insert_id();
		

		for($i=0;$i<sizeOf($rec_array);$i++){
			$com='insert Notice_status (notes_id,usr,read_status,date_termin,termin_status) values (\''.$lid.'\',\''.$rec_array[$i].'\',0,\''.$termin.'\',0);';
			xtc_db_query($com);
		}
		
		if($reminder != ''){
		    $insert_sql_array = array(
			'Notice_notes_id'=>$lid,
			'reminder_interval'=>$reminder,
			'date_added'=>'now()'
		    );
		    xtc_db_perform('Notice_reminder',$insert_sql_array);
		}
		return $lid;
	}
	
	static function count_unread_user_messages(){
	    $com= xtc_db_query(sprintf(
		    'select count(n.id) as anzahl from Notice_notes n,Notice_status s where n.usr !=\'%s\' and n.id=s.notes_id and s.usr=\'%s\' and s.read_status=0',
		    $_SESSION['customer_id'],$_SESSION['customer_id']
	    ));
	    $row = xtc_db_fetch_array($com);
	    return $row['anzahl'];
	}
	
	static function count_termin_user_messages(){
	    $com= xtc_db_query(sprintf(
		    'select count(n.id) as anzahl from Notice_notes n,Notice_status s where n.id=s.notes_id and s.date_termin<now() and s.date_termin>0 and s.termin_status=0 and s.usr=\'%s\'',
		    $_SESSION['customer_id']
	    ));
	    $row = xtc_db_fetch_array($com);
	    return $row['anzahl'];
	}
	
	static function get_termin_user_messages(){
	    $array = array();
	    $com= xtc_db_query(sprintf(
		    'select * from Notice_notes n,Notice_status s where n.id=s.notes_id and s.date_termin<now() and s.date_termin>0 and s.usr=\'%s\' and s.termin_status=0 order by n.id desc',
		    $_SESSION['customer_id']
	    ));
	    while($row = xtc_db_fetch_array($com)){
		$array[] = $row;
	    }
	    return $array;
	}
	
	private function getIntervalName(){
	    switch($this->reminder['reminder_interval']){
		case 'weekly':
		    return TEXT_NOTICE_REMINDER_WEEKLY;
		    break;
		case 'weekly_2':
		    return TEXT_NOTICE_REMINDER_WEEKLY_2;
		    break;
		case 'monthly':
		    return TEXT_NOTICE_REMINDER_MONTHLY;
		    break;
	    }
	}
        
        public function isTerminActive():bool{
            $format = 'Y-m-d H:i:s';
            $dateObject = DateTime::createFromFormat($format, $this->date_termin);
            if (!$dateObject || $dateObject->format($format) !== $this->date_termin) {
                return false;
            }
            $now = new DateTime();
            return $dateObject > $now;
        }
        
        public function hasTermin():bool{
            $format = 'Y-m-d H:i:s';
            $dateObject = DateTime::createFromFormat($format, $this->date_termin);
            if (!$dateObject || $dateObject->format($format) !== $this->date_termin) {
                return false;
            }
            return true;
        }
}
