<?php
class ebay_product extends ebay_item{
	var $id;
	var $products_id;
	var $select_set;
	var $select_set_multiple;
	var $status;
	var $sammler_id;
	var $template;
	var $sql_array;
	var $locked;

	function __construct($ebay_products_id){
		$ebay_product_query = xtc_db_query(sprintf(
			"SELECT * FROM ebay_products WHERE id='%d'",
			intval($ebay_products_id)
		));
		
		// greift auf local dev nicht, keine ahnung, ich pruefe nochmal
		// nach xtc_db_fetch_array auf die id
		if(!xtc_db_num_rows($ebay_product_query)){
			return false;
		}
		$ebay_product = xtc_db_fetch_array($ebay_product_query);
		if($ebay_product['id'] < 1){
			return false;
		}

		$this->setSQLArray($ebay_product);

		$this->setId($ebay_products_id);
		$this->setProductsId($ebay_product['products_id']);
		$this->setSelectSet($ebay_product['select_set']);
		$this->setSelectSetMultiple($ebay_product['select_set_multiple']);
		$this->setStatus($ebay_product['STATUS']);
		$this->setSammlerId($ebay_product['ebay_sammler_id']);
		$this->setTemplate($ebay_product['ebay_template']);

		$this->setType($ebay_product['ebay_angebotsformat']);
		$this->setAuctionprice($ebay_product['ebay_preis']);
		$this->setBuyitnowprice($ebay_product['ebay_sofortkauf_preis']);
		$this->setGallery($ebay_product['ebay_gallery']);
		$this->setGalleryPlus($ebay_product['ebay_gallery_plus']);
		$this->setGalleryfeatured($ebay_product['ebay_galleryfeatured']);
		$this->setGalleryfeaturedDuration($ebay_product['ebay_galleryfeaturedduration']);
		$this->setTitle($ebay_product['ebay_titel']);
		$this->setCounter($ebay_product['ebay_counter']);
		$this->setSubtitletext($ebay_product['ebay_untertitel']);
		$this->setDescription($ebay_product['ebay_beschreibung']);
		$this->setPicture($ebay_product['ebay_bild']);
		$this->setCategory($ebay_product['ebay_kategorie']);
		$this->setCategory2($ebay_product['ebay_kategorie2']);
		$this->setDuration($ebay_product['ebay_auktionsdauer']);
		$this->setQuantity($ebay_product['ebay_menge']);
		$this->setShopcat($ebay_product['ebay_shopcat']);
		$this->setShopcatName($ebay_product['ebay_shopcat_name']);
		$this->setShopcat2($ebay_product['ebay_shopcat2']);
		$this->setShopcat2Name($ebay_product['ebay_shopcat2_name']);
		$this->setVat(intval($ebay_product['ebay_vat']));
		$this->setGeldzurueck($ebay_product['ebay_geldzurueck']);
		$this->setSofortneu($ebay_product['ebay_sofortneu']);
		$this->setNew($ebay_product['ebay_new']);
		$this->setBestoffer($ebay_product['ebay_bestoffer']);
		$this->setBestofferPrice($ebay_product['ebay_bestoffer_price']);
		$this->setSite($ebay_product['ebay_site']);
		$this->setCountry($ebay_product['ebay_land']);
		$this->setLocation($ebay_product['ebay_ort']);
		$this->setPaymentinstructions($ebay_product['ebay_paymentinstructions']);
		$this->setBestOfferAutoAcceptPrice($ebay_product['ebay_bestofferautoacceptprice']);
		$this->setUser($ebay_product['ebay_user']);
		$this->setRevise($ebay_product['ebay_revise']);
		$this->setReviseOption($ebay_product['ebay_revise_option']);
		$this->setExternalProductID($ebay_product['ebay_external_product_id']);
		$this->setExternalProductIDType($ebay_product['ebay_external_product_id_type']);
		$this->setPostalcode($ebay_product['ebay_postalcode']);
		$this->setDispatchtimemax($ebay_product['ebay_dispatchtimemax']);
		$this->setLocked($ebay_product['locked']);
		$this->setItemcondition($ebay_product['itemcondition']);
		$this->setSKU($ebay_product['sku']);
		$this->setShippingDiscountProfileID($ebay_product['ShippingDiscountProfileID']);
		$this->setInternationalShippingDiscountProfileID($ebay_product['InternationalShippingDiscountProfileID']);
		$this->setReserveprice($ebay_product['reserveprice']);
		$this->setReturnswithincode($ebay_product['returnswithincode']);
		$this->setShippingcostpaidby($ebay_product['shippingcostpaidby']);
		$this->setEan( $ebay_product['ean']);
		$this->setIsbn( $ebay_product['isbn']);
		$this->setEBayPlus($ebay_product['ebay_plus']);
		$this->setSeller_profile_payment_id($ebay_product['seller_profile_payment_id']);
		$this->setSeller_profile_return_policy_id($ebay_product['seller_profile_return_policy_id']);
		$this->setSeller_profile_shipping_id($ebay_product['seller_profile_shipping_id']);
		$this->setProductReferenceID($ebay_product['ProductReferenceID']);
		$this->setScheduleTime($ebay_product['scheduletime']);
	}

	function get_characteristics_saved($category_number){
		$query = xtc_db_query("SELECT ebay_products_characteristics_id FROM ebay_products_characteristics WHERE ebay_products_id='".$this->getId()."' and category_number='".$category_number."'");
		if(xtc_db_num_rows($query)){
			return true;
		}else{
			return false;
		}
	}

	function setId($value){
		$this->id = $value;
	}
	
	function getId(){
		return (int) $this->id;
	}

	function setProductsId($value){
		$this->products_id = $value;
	}
	
	function getProductsId(){
		return (int) $this->products_id;
	}

	function setSelectSet($value){
		$this->select_set = $value;
	}
	
	function getSelectSet(){
		return $this->select_set;
	}

	function setSelectSetMultiple($value){
		$this->select_set_multiple = $value;
	}
	
	function getSelectSetMultiple(){
		return $this->select_set_multiple;
	}

	function setStatus($value){
		$this->status = $value;
	}
	
	function getStatus(){
		return $this->status;
	}

	function setSammlerId($value){
		$this->sammler_id = $value;
	}
	
	function getSammlerId(){
		return $this->sammler_id;
	}

	function setTemplate($value){
		$this->template = $value;
	}
	
	function getTemplate(){
		return $this->template;
	}

	function getLocked() {
		return $this->locked;
	}

	function setLocked($locked) {
		$this->locked = $locked;
	}

	function set_cart_sql($cart){
		if(is_array($cart->copy) and sizeOf($cart->copy) > 0){
			foreach($cart->copy as $ck=>$cv){
				if($cv == 1){
					switch($ck){
						case 'gallery':
							$this->sql_array['ebay_gallery'] = $cart->getGallery();
							break;
						case 'gallery_plus':
							$this->sql_array['ebay_gallery_plus'] = $cart->getGalleryPlus();
							break;
						case 'galleryFeatured':
							$this->sql_array['ebay_galleryfeatured'] = $cart->getGalleryfeatured();
							break;
						case 'galleryFeaturedDuration':
							$this->sql_array['ebay_galleryfeaturedduration'] = $cart->getGalleryfeaturedDuration();
							break;
						case 'type':
							$this->sql_array['ebay_angebotsformat'] = $cart->getType();
							break;
						case 'subtitletext':
							$this->sql_array['ebay_untertitel'] = $cart->getSubtitletext();
							break;
						case 'quantity':
							$this->sql_array['ebay_menge'] = $cart->getQuantity();
							break;
						case 'duration':
							$this->sql_array['ebay_auktionsdauer'] = $cart->getDuration();
							break;
						case 'counter':
							$this->sql_array['ebay_counter'] = $cart->getCounter();
							break;
						case 'vat':
							$this->sql_array['ebay_vat'] = $cart->getVat();
							break;
						case 'geldzurueck':
							$this->sql_array['ebay_geldzurueck'] = $cart->getGeldzurueck();
							break;
						case 'sofortneu':
							$this->sql_array['ebay_sofortneu'] = $cart->getSofortneu();
							break;
						case 'new':
							$this->sql_array['ebay_new'] = $cart->getNew();
							break;
						case 'category':
							$this->sql_array['ebay_kategorie'] = $cart->getCategory();
							break;
						case 'category':
							$this->sql_array['ebay_kategorie'] = $cart->getCategory();
							break;
						case 'category2':
							$this->sql_array['ebay_kategorie2'] = $cart->getCategory2();
							break;
						case 'shopcat':
							$this->sql_array['ebay_shopcat'] = $cart->getShopcat();
							$this->sql_array['ebay_shopcat_name'] = $cart->getShopcatName();
							break;
						case 'shopcat2':
							$this->sql_array['ebay_shopcat2'] = $cart->getShopcat2();
							$this->sql_array['ebay_shopcat2_name'] = $cart->getShopcat2Name();
							break;
						case 'site':
							$this->sql_array['ebay_site'] = $cart->getSite();
							break;
						case 'location':
							$this->sql_array['ebay_ort'] = $cart->getLocation();
							break;
						case 'country':
							$this->sql_array['ebay_land'] = $cart->getCountry();
							break;
						case 'bestoffer':
							$this->sql_array['ebay_bestoffer'] = $cart->getBestoffer();
							break;
						case 'bestoffer_price':
							$this->sql_array['ebay_bestoffer_price'] = $cart->getBestofferPrice();
							break;
						case 'paymentinstructions':
							$this->sql_array['ebay_paymentinstructions'] = $cart->getPaymentinstructions();
							break;
						case 'bestofferautoacceptprice':
							$this->sql_array['ebay_bestofferautoacceptprice'] = $cart->getBestOfferAutoAcceptPrice();
						case 'user':
							$this->sql_array['ebay_user'] = $cart->getUser();
							break;
						case 'template':
							$this->sql_array['ebay_template'] = $cart->getTemplate();
							break;
						case 'revise':
							$this->sql_array['ebay_revise'] = $cart->getRevise();
							break;
						case 'revise_option':
							$this->sql_array['ebay_revise_option'] = $cart->getReviseOption();
							break;
						case 'postalcode':
							$this->sql_array['ebay_postalcode'] = $cart->getPostalcode();
							break;
						case 'dispatchtimemax':
							$this->sql_array['ebay_dispatchtimemax'] = $cart->getDispatchtimemax();
							break;
						case 'itemcondition':
							$this->sql_array['itemcondition'] = $cart->getItemcondition();
							break;
						case 'sku':
							$this->sql_array['sku'] = $cart->getSKU();
							break;
						case 'ShippingDiscountProfileID':
							$this->sql_array['ShippingDiscountProfileID'] = $cart->getShippingDiscountProfileID();
							break;
						case 'InternationalShippingDiscountProfileID':
							$this->sql_array['InternationalShippingDiscountProfileID'] = $cart->getInternationalShippingDiscountProfileID();
							break;
						case 'reserveprice':
							$this->sql_array['reserveprice'] = $cart->getReserveprice();
							break;
                                                case 'returnswithincode':
                                                    $this->sql_array['returnswithincode'] = $cart->getReturnswithincode();
                                                    break;
                                                case 'shippingcostpaidby':
                                                    $this->sql_array['shippingcostpaidby'] = $cart->getShippingcostpaidby();
                                                    break;
						case 'ean':
							$this->sql_array['ean'] = $cart->getEan();
							break;
						case 'isbn':
							$this->sql_array['isbn'] = $cart->getIsbn();
							break;
						case 'ebay_plus':
							$this->sql_array['ebay_plus'] = $cart->getEBayPlus();
							break;
						case 'seller_profile_payment_id':
							$this->sql_array['seller_profile_payment_id'] = $cart->getSeller_profile_payment_id();
							break;
						case 'seller_profile_shipping_id':
							$this->sql_array['seller_profile_shipping_id'] = $cart->getSeller_profile_shipping_id();
							break;
						case 'seller_profile_return_policy_id':
							$this->sql_array['seller_profile_return_policy_id'] = $cart->getSeller_profile_return_policy_id();
							break;
						case 'scheduletime':
							$this->sql_array['scheduletime'] = $cart->getScheduleTime();
							break;
                                                // ProductReferenceID nicht implementieren
                                                // da das nix sammlerspezifisches ist

					}
				}
			}
		}
	}

	function setSQLArray($value){
		$this->sql_array = $value;
	}

	function getSQLArray(){
		return $this->sql_array;
	}

	function get_new_auction_sql_array(){
		$auction_sql_array = array(
			'ebay_products_id' => intval($this->getId()),
			'products_id' => intval($this->getProductsId()),
			'type' => $this->getType(),
			'auctionprice' => (float)$this->getAuctionprice(),
			'buyitnowprice' => (float)$this->getBuyitnowprice(),
			'title' => $this->getTitle(),
			'subtitletext' => $this->getSubtitletext(),
			'description' => $this->getDescription(),
			'picture' => $this->getPicture(),
			'gallery' => $this->getGallery(),
			'gallery_plus' => $this->getGalleryPlus(),
			'galleryfeatured' => $this->getGalleryfeatured(),
			'galleryfeaturedduration' => intval($this->getGalleryfeaturedDuration()),
			'shopcat' => "".$this->getShopcat(),
			'shopcat2' => "".$this->getShopcat2(),
			'category' => "".$this->getCategory(),
			'category2' => "".$this->getCategory2(),
			'duration' => intval($this->getDuration()),
			'quantity' => intval($this->getQuantity()),
			'counter' => $this->getCounter(),
			'vat' => $this->getVat(),
			'geldzurueck' => $this->getGeldzurueck(),
			'sofortneu' => $this->getSofortneu(),
			'new' => $this->getNew(),
			'bestoffer' => $this->getBestoffer(),
			'select_set' => $this->getSelectSet(),
			'select_set_multiple' => $this->getSelectSetMultiple(),
			'site' => $this->getSite(),
			'paymentinstructions' => $this->getPaymentinstructions(),
			'bestoffer_price' => (float)$this->getBestofferPrice(),
			'country'=>$this->getCountry(),
			'location'=>$this->getLocation(),
			'bestofferautoacceptprice'=>(float)$this->getBestOfferAutoAcceptPrice(),
			'revise'=>$this->getRevise(),
			'revise_option'=>$this->getReviseOption(),
			'user'=>$this->getUser(),
			'external_product_id'=>$this->getExternalProductID(),
			'external_product_id_type'=>$this->getExternalProductIDType(),
			'postalcode'=>$this->getPostalcode(),
			'dispatchtimemax'=>$this->getDispatchtimemax(),
			'itemcondition'=>$this->getItemcondition(),
			'ShippingDiscountProfileID'=>$this->getShippingDiscountProfileID(),
			'InternationalShippingDiscountProfileID'=>$this->getInternationalShippingDiscountProfileID(),
			'reserveprice'=>(float)$this->getReserveprice(),
			'returnswithincode' => $this->getReturnswithincode(),
			'shippingcostpaidby' => $this->getShippingcostpaidby(),
		    'sku'=>$this->getSKU(),
		    'isbn'=>$this->getIsbn(),
		    'ean'=>$this->getEan(),
		    'ebay_plus'=>$this->getEBayPlus(),
		    'seller_profile_payment_id'=>$this->getSeller_profile_payment_id(),
		    'seller_profile_return_policy_id'=>$this->getSeller_profile_return_policy_id(),
		    'seller_profile_shipping_id'=>$this->getSeller_profile_shipping_id(),
			'ProductReferenceID'=>$this->getProductReferenceID(),
			'scheduletime'=>$this->getScheduleTime()
		);
		return $auction_sql_array;
	}

	function getSmartyListArray($SQ,$actions,$checked=false){
		global $_YES_auction_types,$EA;
		if(!is_object($EA)){
			$EA = new EbayAPI;
		}
		$auction = array();

		$EA->get_shippingcosts_value('ebay_products',$item_shippingcosts,$this->getId());
		$anzahl_shippingmethods = $EA->get_shippingcosts_count($item_shippingcosts);
		$auction['shippingmethods_link'] = sprintf(
			'<a href="javascript:;" id="%s" title="%s" class="ep_ship"><u>%s</u></a>',
			/*xtc_href_link('ebayapi_shippingcosts.php',xtc_get_all_get_params(array('source','id','action')).'source=ebay_products&id='.$this->getId()),*/
			$this->getId(),
			TEXT_SELECT_SHIPPINGMETHODS,
			sprintf(TEXT_NUMBER_OF_SHIPPINGMETHODS_LINK,$anzahl_shippingmethods)
		);


		if($this->getProductsId() > 0){
		    $auction['products_id_link'] = '<a title="Info pID '.$this->getProductsId().'" href="javascript:;" class="yes_dynamic_tooltip" rel="products.php?action=ajax_view&pID='.$this->getProductsId().'">';
		    $auction['products_id'] = $this->getProductsId();
		}

		$auction['sammler_titel'] = $EA->getSammlerTitel($this->getSammlerId());
		$auction['sammler_id'] = (int)$this->getSammlerId();
		$auction['ebay_products_id'] = (int)$this->getId();
		$auction['products_at_ebay'] = $SQ->get_auction_qty();

		$collies = xtc_get_product_collies($this->getProductsId());
		if(sizeOf($collies)>0){
			$avqty = xtc_get_product_collie_qty($this->getProductsId());
			$auction['products_at_ebay'] = $SQ->get_set_auction_qty();
		}else{			
			$avqty = $SQ->get_available2_qty();
		}
		$auction['products_bestand'] = "<a href='javascript:openb(".$this->getProductsId().");'><u>". $avqty.'</u></a>';
		$auction['v1'] = $SQ->get_available1_qty();

		if(!strstr($this->getPicture(),'http:' )){
		    if($this->getPicture() != ''){
			if(is_file(DIR_WS_CATALOG.'images/product_images/thumbnail_images/'.$this->getPicture())){
			    $auction['products_image_src'] = DIR_WS_CATALOG.'images/product_images/thumbnail_images/'.$this->getPicture();
			}else{
			    $auction['products_image_src_error'] = true;
			}
		    }
		}else{
			$auction['products_image_src'] = $this->getPicture();
		}
		$auction['products_image_alt'] = str_replace('"',"'",$this->getTitle());
		$auction['checkbox'] = xtc_draw_checkbox_field("id[]", $this->getId(), $checked);
		$auction['template'] = (xtc_not_null($this->getTemplate())) ? $this->getTemplate() : '<font color="#FF0000"><i>Kein Template</i></font>';
		$auction['startprice'] = number_format($this->getAuctionprice(),2,',','');
		$auction['binprice'] = number_format($this->getBuyitnowprice(),2,',','');
		$auction['reserveprice'] = number_format($this->getReserveprice(),2,',','');
			
		$css_class = ( $this->getShopcat() == 0 ) ? 'container' : 'container_active';
		$auction['shopcat'] = '<a style="padding:0px;" id="'.xtc_href_link('ebayapi_cart.php','action=quick_edit_shopcategory&nr=1&id='.$this->getId()).'" href="javascript:;" class="lbOn" title="Ebayshopkategorie &auml;ndern"><div class="'.$css_class.'" style="text-decoration:underline;" id="ebay_shopcat_container_'.$this->getId().'">Shop</div></a>';

		$css_class = ( $this->getShopcat2() == 0 ) ? 'container' : 'container_active';
		$auction['shopcat2'] = '<a style="padding:0px;" id="'.xtc_href_link('ebayapi_cart.php','action=quick_edit_shopcategory&nr=2&id='.$this->getId()).'" href="javascript:;" class="lbOn" title="2. Ebayshopkategorie &auml;ndern"><div class="'.$css_class.'" style="text-decoration:underline;" id="ebay_shopcat2_container_'.$this->getId().'">Shop&nbsp;2</div></a>';
					
		$css_class = ( $this->getCategory() == 0 ) ? 'container' : 'container_active';
		$auction['cat1'] = '<a style="padding:0px;" id="'.xtc_href_link('ebayapi_cart.php','action=quick_edit_category&nr=1&id='.$this->getId()).'" href="javascript:;" class="lbOn" title="Ebaykategorie &auml;ndern"><div class="'.$css_class.'" style="text-decoration:underline;" id="ebay_kategorie_container_'.$this->getId().'">Kategorie</div></a>';
		$auction['categories_id'] = $this->getCategory();
				
		$css_class = ( $this->getCategory2() == 0 ) ? 'container' : 'container_active';
		$auction['cat2'] = '<a style="padding:0px;" id="'.xtc_href_link('ebayapi_cart.php','action=quick_edit_category&nr=2&id='.$this->getId()).'" href="javascript:;" class="lbOn" title="2. Ebaykategorie &auml;ndern"><div class="'.$css_class.'" style="text-decoration:underline;" id="ebay_kategorie2_container_'.$this->getId().'">Kateg.&nbsp;2</div></a>';
				
		$auction['site'] = $this->getSite();
		$auction['bestofferautoacceptprice'] = ($this->getBestoffer() == 1) ? $this->getBestOfferAutoAcceptPrice() : 0;
		$auction['bestoffer_price'] = ($this->getBestoffer() == 1) ? $this->getBestOfferPrice() : 0;

		$auction['format'] = $_YES_auction_types[$this->getType()];
				
		$auction['title'] = $this->getTitle();
		$auction['subtitle'] = $this->getSubtitletext();
		$auction['duration'] = $this->getDurationTitle();
		$auction['duration_link'] = xtc_href_link('ebayapi_cart.php','action=quick_edit_duration&id='.$this->getId());
		$auction['qty'] = $this->getQuantity();
		$auction['qty_link'] = xtc_href_link('ebayapi_cart.php','action=quick_edit_quantity&id='.$this->getId());
		$auction['gallery'] = $this->getGallery();
		$auction['gallery_plus'] = $this->getGalleryPlus();
		$auction['galleryfeatured'] = $this->getGalleryfeatured();
		$auction['galleryfeaturedduration'] = $this->getGalleryfeaturedDuration();

		$format_counter_text = 'Besucherzaehler';
		$auction['counter'] = ($this->getCounter()!='NoHitCounter')?xtc_image('images/ebay_img/counter.gif',$format_counter_text):xtc_image('images/ebay_img/counter_no.gif',$format_counter_text);
				
		$format_vat_text = 'MwSt. in Auktion ausweisen';
		$auction['vat'] = ($this->getVat()>0)?xtc_image('images/ebay_img/mwst.gif',$format_vat_text):xtc_image('images/ebay_img/mwst_no.gif',$format_vat_text);
				
		$format_moneyback_text = '14 Tage Rueckgaberecht';
		$auction['moneyback'] = ($this->getGeldzurueck()>0)?xtc_image('images/ebay_img/rueckgabe.gif',$format_moneyback_text):xtc_image('images/ebay_img/rueckgabe_no.gif',$format_moneyback_text);
				
		$format_sofortneu_text = 'Sofort + Neu';
		$auction['sofortneu'] = ($this->getSofortneu()>0)?xtc_image('images/ebay_img/sofortneu.gif',$format_sofortneu_text):xtc_image('images/ebay_img/sofortneu_no.gif',$format_sofortneu_text);
				
		$format_neu_text = 'Neu';
		$auction['neu'] = ($this->getNew()>0)?xtc_image('images/ebay_img/neu.gif',$format_neu_text):xtc_image('images/ebay_img/neu_no.gif',$format_neu_text);
				
		$auction['id'] = $this->getId();
	
		$auction['select_set'] = $this->getSelectSet();
		$auction['select_set_multiple'] = $this->getSelectSetMultiple();
		$auction['user'] = $this->getUser();
		$auction['popup_products_at_ebay_link'] = '<a href="javascript:opene( '.$this->getProductsId().' );">';
		if($this->getCategory() != 0){
			$characteristics_saved = ($this->get_characteristics_saved(1) == true) ? true:false;
			if($characteristics_saved)
				$auction['edit_characteristics_saved'] = 1;
		}

		$auction['revise'] = $this->getRevise();
		$auction['revise_option'] = $this->getReviseOption();
		$auction['revise_text'] = sprintf(TEXT_REVISE_AUTOMATIC,$this->getReviseOption());
		$auction['external_product_id_type'] = $this->getExternalProductIDType();
		$auction['external_product_id'] = $this->getExternalProductID();
		$auction['postalcode'] = $this->getPostalcode();
		$auction['dispatchtimemax'] = $this->getDispatchtimemax();
		$auction['locked'] = $this->getLocked();

		// ifilter
		$auction['ifilter_format_link'] = xtc_href_link('ebayapi_cart.php',xtc_get_all_get_params(array('action','ifilter','ifilter_value')).'action=set_ifilter&ifilter=ebay_angebotsformat');
		$auction['ifilter_counter_link'] = xtc_href_link('ebayapi_cart.php',xtc_get_all_get_params(array('action','ifilter','ifilter_value')).'action=set_ifilter&ifilter=ebay_counter');
		$auction['ifilter_template_link'] = xtc_href_link('ebayapi_cart.php',xtc_get_all_get_params(array('action','ifilter','ifilter_value')).'action=set_ifilter&ifilter=ebay_template');
		$auction['ifilter_user_link'] = xtc_href_link('ebayapi_cart.php',xtc_get_all_get_params(array('action','ifilter','ifilter_value')).'action=set_ifilter&ifilter=ebay_user');
		$auction['itemcondition'] = $this->getItemcondition();
		$auction['itemcondition_link'] = xtc_href_link('ebayapi_cart.php','action=quick_edit_itemcondition&id='.$this->getId());
		$auction['sku'] = $this->getSKU();
		$auction['variations_sets_id'] = $this->get_variations_sets_id_from_ebay_products_id($this->getId());
		$auction['ShippingDiscountProfileID'] = $this->getShippingDiscountProfileID();
		$auction['InternationalShippingDiscountProfileID'] = $this->getInternationalShippingDiscountProfileID();
		$cID = xtc_get_site_country_id($this->getSite());
                if((int)$cID < 1){  // wenn kein default country im sammlerprodukt hinterlegt ist
                    $cID = 2;
                }
		$lID = xtc_is_language_installed($cID);
		if(!$lID){
			$lID = '2';
		}
		$auction['properties'] = $this->get_properties_from_id('ebay_products',$this->getId(),$lID);
		$auction['products_properties'] = $this->get_properties_from_id('products',$this->getProductsId(),$lID);
                $auction['returnswithincode'] = $this->getReturnswithincode();
                $auction['shippingcostpaidby'] = $this->getShippingcostpaidby();
		$auction['runnings'] = $this->get_running_auctions_num();
		
		if($this->get_properties_count_from_id('ebay_products',$this->getId())){
		    $auction['has_properties'] = true;
		}
		
		$auction['auctions_link'] = xtc_href_link('ebayapi_cart.php?page_type=runnings&searchword='.$this->getId().'&searchmode=epid');
		$auction['link_quantity_edit'] = 1;
		if($auction['variations_sets_id'] <= 0){
		    $variation_sets = array();
		    $query = xtc_db_query(sprintf(
			    "SELECT DISTINCT(ebay_products_id) FROM ebay_variations_sets evs LEFT JOIN ebay_variations USING(ebay_variations_sets_id) WHERE products_id='%s'",
			    $this->getProductsId()
		    ));
		    while($record = xtc_db_fetch_array($query)){
			$variation_sets[] = $record['ebay_products_id'];
		    }
		    if(sizeOf($variation_sets)){
			$auction['variation_sets'] = sizeOf($variation_sets);
		    }
		}
		$auction['isbn'] = $this->getIsbn();
		$auction['ean'] = $this->getEan();
		$auction['ebay_plus'] = $this->getEBayPlus();
		$auction['seller_profile_payment_id'] = $this->getSeller_profile_payment_id();
		$auction['seller_profile_return_policy_id'] = $this->getSeller_profile_return_policy_id();
		$auction['seller_profile_shipping_id'] = $this->getSeller_profile_shipping_id();
		$auction['ProductReferenceID'] = $this->getProductReferenceID();
                
                // BOF - STAFFELPREISE ALS VARIANTEN
                if(strtolower(STOCK_CHECK) != 'true' and defined('MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS') and MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS == 'True'){
                    if(!defined('EBAY_PRODUCTS_PRICE_CUSTOMER_STATUS') or EBAY_PRODUCTS_PRICE_CUSTOMER_STATUS < 0){
                        throw new Exception('Staffelpreise als Varianten Fehler: EBAY_PRODUCTS_PRICE_CUSTOMER_STATUS ist nicht konfiguriert.');
                    }
                    $group_prices_items = \YES4Trade\Model\group_prices::get_items_by_products_id(
                        EBAY_PRODUCTS_PRICE_CUSTOMER_STATUS,
                        $this->getProductsId()
                    );
                    $gpi_ok = false;
                    foreach($group_prices_items as $GPI){
                        if($GPI->quantity > 1){
                            $gpi_ok = true;
                        }
                    }
                    if($gpi_ok === true){
                        if($this->has_staffelpreise() !== true){
							$evsID = $this->get_variations_sets_id_from_ebay_products_id($this->getId());
							if($evsID < 0){
                            	$auction['add_staffelpreise_as_variation'] = true;
							}
                        }
                    }
                }
                // EOF - STAFFELPREISE ALS VARIANTEN
                $default_date = ($this->getScheduleTime() != '' and $this->getScheduleTime() != '0000-00-00 00:00:00') ? date('Y-m-d',strtotime($this->getScheduleTime())) : '';
                $default_time = ($this->getScheduleTime() != '' and $this->getScheduleTime() != '0000-00-00 00:00:00') ? date('H:i:s',strtotime($this->getScheduleTime())) : '00:00:00';             
                $auction['input_scheduletime'] = xtc_draw_input_field('scheduletime', $default_date, 'size="19" maxlength="19"').'&nbsp;<font size="4">&#128337</font>&nbsp;'.xtc_draw_input_field('scheduletime_time',$default_time,'maxlength="8" size="8"');
                
		return $auction;
	}
	
	public function get_running_auctions_num(){
		return \YES4Trade\Model\ebay_auctions::count_runnings_by_ebay_products_id(intval($this->getId()));
	}
	
	public function get_db_field($column){
	   switch($column){
	       case 'status': return 'STATUS'; break;
	       case 'sammler_id': return 'ebay_sammler_id';break;
	       case 'template': return 'ebay_template'; break;
	       case 'seller': 
	       case 'user':
		   return 'ebay_user'; break;
	       case 'type': return 'ebay_angebotsformat'; break;
	       case 'auctionprice': return 'ebay_preis'; break;
	       case 'buyitnowprice': return 'ebay_sofortkauf_preis'; break;
	       case 'gallery': return 'ebay_gallery'; break;
	       case 'gallery_plus': return 'ebay_gallery_plus'; break;
	       case 'galleryfeatured': return 'ebay_galleryfeatured'; break;
	       case 'galleryfeaturedduration': return 'ebay_galleryfeaturedduration'; break;
	       case 'title': return 'ebay_titel'; break;
	       case 'counter': return 'ebay_counter'; break;
	       case 'subtitletext':
	       case 'subtitle':
		    return 'ebay_untertitel';
		    break;
	       case 'description': return 'ebay_beschreibung';break;
	       case 'picture': return 'ebay_bild';break;
	       case 'category': return 'ebay_kategorie'; break;
	       case 'category2': return 'ebay_kategorie2'; break;
	       case 'duration': return 'ebay_auktionsdauer'; break;
	       case 'quantity': return 'ebay_menge';break;
	       case 'shopcat': return 'ebay_shopcat'; break;
	       case 'shopcat2': return 'ebay_shopcat2'; break;
	       case 'shopcat_name': return 'ebay_shopcat_name'; break;
	       case 'shopcat2_name': return 'ebay_shopcat2_name'; break;
	       case 'vat': return 'ebay_vat'; break;
	       case 'geldzurueck': return 'ebay_geldzurueck'; break;
	       case 'sofortneu': return 'ebay_sofortneu'; break;
	       case 'new': return 'ebay_new'; break;
	       case 'bestoffer': return 'ebay_bestoffer'; break;
	       case 'bestoffer_price': return 'ebay_bestoffer_price'; break;
	       case 'site': return 'ebay_site'; break;
	       case 'country': return 'ebay_land'; break;
	       case 'location': return 'ebay_ort'; break;
	       case 'paymentinstructions': return 'ebay_paymentinstructions';break;
	       case 'BestOfferAutoAcceptPrice':
	       case 'bestofferautoacceptprice':
		   return 'ebay_bestofferautoacceptprice';
		   break;
	       case 'revise': return 'ebay_revise';break;
	       case 'revise_option': return 'ebay_revise_option'; break;
	       case 'externalproductid':
	       case 'external_product_id':
		   return 'ebay_external_product_id';
		   break;
	       case 'externalproductidtype':
	       case 'external_product_id_type':
		   return 'ebay_external_product_id_type';
		   break;
	       case 'postalcode': return 'ebay_postalcode'; break;
	       case 'dispatchtimemax': return 'ebay_dispatchtimemax'; break;
	       case 'eBayPlus':  return 'ebay_plus'; break;
	       default:
		    return $column;
		    break;
	   }
	}
	
	public function save_as_auction($res,$fee_val,$uuid,$EBAYAPI){
	    $use_variations = false;
	    // VARIATIONS
	    $variations_set_query = xtc_db_query(sprintf(
		    "SELECT ebay_variations_sets_id FROM ebay_variations_sets WHERE ebay_products_id='%s'",
		    $this->id
	    ));
	    if(xtc_db_num_rows($variations_set_query)){
		    $variations_set = xtc_db_fetch_array($variations_set_query);
		    $use_variations = true;
	    }
	    $insert_sql_array = $this->get_new_auction_sql_array();
	    if($use_variations){
		    $insert_sql_array['products_id'] = 0;
	    }
	    $insert_sql_array['ebay_id'] = (string)$res->ItemID;
		$startdt = new DateTime($res->StartTime);
		$enddt = new DateTime($res->EndTime);
		$insert_sql_array['start_time'] = $startdt->format('Y-m-d H:i:s');
		$insert_sql_array['end_time'] = $enddt->format('Y-m-d H:i:s');
	    $insert_sql_array['revise_counter'] = 0;
	    $insert_sql_array['auction_fees'] = (float)$fee_val;
	    $insert_sql_array['description'] = '';
	    $insert_sql_array['UUID'] = $uuid;
	    $insert_sql_array['status'] = 0;

	    $auctions_id = \YES4Trade\Model\ebay_auctions::create_ebay_auction($insert_sql_array);
	    if($use_variations){
		    $variations_query = xtc_db_query(sprintf(
			    "SELECT quantity,sku,products_id,startprice,ean,isbn,sort_order,ProductReferenceID FROM ebay_variations WHERE ebay_variations_sets_id='%s' ORDER BY sort_order",
			    $variations_set['ebay_variations_sets_id']
		    ));
		    while($record = xtc_db_fetch_array($variations_query)){
			    $create_sql_array = [
			    	'price' => (float)$record['startprice'],
			    	'ebay_auctions_id' => intval($auctions_id),
					'quantity'=>intval($record['quantity']),
					'sku'=>$record['sku'],
					'products_id'=>intval($record['products_id']),
					'ean'=>$record['ean'],
					'isbn'=>$record['isbn'],
					'sort_order'=>intval($record['sort_order']),
					'ProductReferenceID'=>$record['ProductReferenceID']
				];
				\YES4Trade\Model\ebay_auctions_variations::create_ebay_auctions_variations($create_sql_array);
		    }
			ebay_auction::add_history($auctions_id, $record['quantity'], sprintf(
					"[%s:save_as_auction()] eBay Auktion %s Variante %s angelegt",
					basename(__FILE__), $res->ItemID,$record['sku']
			));
	    }else{
                ebay_auction::add_history($auctions_id, $insert_sql_array['quantity'], sprintf(
                        "[%s:save_as_auction()] eBay Auktion %s angelegt",
                        basename(__FILE__), $res->ItemID
                ));
            }

	    // payments kopieren
	    $payments = $EBAYAPI->get_payments('ebay_products_payments','ebay_products_id',$this->id);
	    if(is_array($payments) and sizeOf($payments)>0){
		    foreach($payments as $k=>$v){
			    xtc_db_query("INSERT INTO ebay_auctions_payments SET ebay_auctions_id='".$auctions_id."',payment='".$v."'");
		    }
	    }

	    $item_shippingcosts = array(); // BUGFIX: array muss genullt werden
	    $EBAYAPI->get_shippingcosts_value('ebay_products',$item_shippingcosts,$this->id);
	    if(sizeOf($item_shippingcosts)>0){
                $EBAYAPI->save_ebayshipping_values($item_shippingcosts,'auction',$auctions_id);
            }

	    // BOF - properties
	    $this->copy_properties('ebay_products', $this->getId(), 'ebay_auctions', $auctions_id);
	    // EOF - properties
            
            // bof ebay regulatory
            $ee = \YES4Trade\Model\ebay_products_energy_efficiency::get_by_ebay_products_id($this->getId());
            if($ee != null){
                $data = $ee->toArray();
                unset($data['ebay_products_id']);
                unset($data['ebay_products_energy_efficiency_id']);
                $data['ebay_auctions_id'] = intval($auctions_id);
                $new = new \YES4Trade\Model\ebay_auctions_energy_efficiency($data);
                $new->create();
            }
            
            $emn = \YES4Trade\Model\ebay_products_manufacturer::get_by_ebay_products_id($this->getId());
            if($emn != null){
                $data = $emn->toArray();
                unset($data['ebay_products_id']);
                unset($data['ebay_products_manufacturers_id']);
                $data['ebay_auctions_id'] = intval($auctions_id);
                $new = new \YES4Trade\Model\ebay_auctions_manufacturer($data);
                $new->create();
            }
            
            $ehz = \YES4Trade\Model\ebay_products_regulatory_hazmats::get_by_ebay_products_id($this->getId());
            if($ehz != null){
                $data = $ehz->toArray();
                unset($data['ebay_products_id']);
                unset($data['ebay_products_regulatory_hazmats_id']);
                $data['ebay_auctions_id'] = intval($auctions_id);
                $new = new \YES4Trade\Model\ebay_auctions_regulatory_hazmats($data);
                $new->create();
            }

            $edcs = \YES4Trade\Model\ebay_products_regulatory_documents::get_by_ebay_products_id($this->getId());
            foreach($edcs as $edc){
                $data = $edc->toArray();
                unset($data['ebay_products_id']);
                unset($data['ebay_products_regulatory_documents_id']);
                $data['ebay_auctions_id'] = intval($auctions_id);
                $new = new \YES4Trade\Model\ebay_auctions_regulatory_documents($data);
                $new->create();
            }
            
            $eres = \YES4Trade\Model\ebay_products_responsible_persons::get_by_ebay_products_id($this->getId());
            foreach($eres as $ere){
                $data = $ere->toArray();
                unset($data['ebay_products_id']);
                unset($data['ebay_products_responsible_persons_id']);
                $data['ebay_auctions_id'] = intval($auctions_id);
                $new = new \YES4Trade\Model\ebay_auctions_responsible_persons($data);
                $new->create();
            }
            
            $epsf = \YES4Trade\Model\ebay_products_productsafety::get_by_ebay_products_id($this->getId());
            if($epsf != null){
                $data = $epsf->toArray();
                unset($data['ebay_products_id']);
                unset($data['ebay_products_productsafety_id']);
                $data['ebay_auctions_id'] = intval($auctions_id);
                $new = new \YES4Trade\Model\ebay_auctions_productsafety($data);
                $new->create();
            }
            // eof ebay regulatory
            
            $vide = \YES4Trade\Model\ebay_products_videos::get_by_ebay_products_id($this->getId());
            foreach($vide as $video){
                $data = $video->toArray();
                unset($data['ebay_products_id']);
                unset($data['ebay_products_videos_id']);
                $data['ebay_auctions_id'] = intval($auctions_id);
                $new = new \YES4Trade\Model\ebay_auctions_videos($data);
                $new->create();
            }
	    return $auctions_id;
	}
        
    public function get_saved_itemspecifics_recommendations(){
        $query = yes_db_query(sprintf(
            "SELECT * FROM ebay_products_itemspecifics_recommendations WHERE ebay_products_id='%s'",
            $this->getId()
        ));
        $saved = array();
        foreach($query as $record){
                $saved[ $record['is_name'] ][] = $record['is_value'];
        }
        return $saved;
    }

        
    public function get_recommendations_input_fields(GetItemRecommendationsResponseType $res){
        $saved = $this->get_saved_itemspecifics_recommendations();
        $recR = current($res->getGetRecommendationsResponseContainer());
        $recs = $recR->getRecommendations();
        $input_array = array();
        foreach($recs->getNameRecommendation() as $rec){
            $values = array(0=>array('id'=>'','text'=>TEXT_SELECT));
            $_values = $rec->getValueRecommendation();
            for($i=0;$i<sizeOf($_values);$i++){
                    $values[] = array(
                            'id'=>$_values[$i]->getValue(),
                            'text'=>$_values[$i]->getValue()
                    );
            }
            $rules = $rec->getValidationRules();
            $pflicht = '';
            if($rules->getMinValues() > 0){
                $pflicht = sprintf(' <span title="%s">*</span>',TEXT_ITEMSPECIFIC_PFLICHTFELD);
            }
            if($rules->getMaxValues() == 1){
                $value = '';
                if( isset( $saved[ $rec->getName() ] ) ){
                        $value = current($saved[ $rec->getName() ]);
                }
                $input_array[] = array(
                        'text'=>$rec->getName(),
                        'value'=>$value,
                        'input'=>xtc_draw_input_field( 'INPUT['.urlencode($rec->getName()).']',$value,'id="INPUT_'.urlencode($rec->getName()).'"' ),
                        'recommendations'=>$values,
                    'PFLICHT'=>$pflicht,
                    'SelectionMode'=>$rules->getSelectionMode(),
                );
            }else{
                $rec_input_array = array();
                foreach($values as $valkey=>$val){
                    if($valkey == 0) continue;
                    $checked = (in_array($val['id'], $saved[ $rec->getName() ]))?true:false;
                    $rec_input_array[] = array(
                        'input'=>xtc_draw_checkbox_field( 'INPUT['.urlencode($rec->getName()).'][]',$val['id'], $checked),
                        'value'=>$val['id']
                    );
                }
                $input_array[] = array(
                        'text'=>$rec->getName(),
                        'input_array'=>$rec_input_array,
                        'recommendations'=>$values,
                    'max_values'=>$rules->getMaxValues(),
                    'PFLICHT'=>$pflicht,
                    'SelectionMode'=>$rules->getSelectionMode(),
                );
            }
        }
        return $input_array;
    }
    
    public function get_sdk_recommendations_input_fields( $res ){
        $saved = $this->get_saved_itemspecifics_recommendations();
        foreach($res as $rec){
            $values = array(0=>array('id'=>'','text'=>TEXT_SELECT));
            foreach($rec->aspectValues as $av){
                $values[] = array(
                    'id'=>$av->localizedValue,
                    'text'=>$av->localizedValue,
                );
            }
            $pflicht = '';
            if($rec->aspectConstraint->aspectRequired == 1){
                $pflicht = sprintf(' <span title="%s">*</span>',TEXT_ITEMSPECIFIC_PFLICHTFELD);
            }
            if($rec->aspectConstraint->itemToAspectCardinality == 'SINGLE'){
                $value = '';
                if( isset( $saved[ $rec->localizedAspectName ] ) ){
                        $value = current($saved[ $rec->localizedAspectName ]);
                }
                $input_array[] = array(
                        'text'=>$rec->localizedAspectName,
                        'value'=>$value,
                        'input'=>xtc_draw_input_field( 'INPUT['.urlencode($rec->localizedAspectName).']',$value,'id="INPUT_'.urlencode($rec->localizedAspectName).'"' ),
                        'recommendations'=>$values,
                    'PFLICHT'=>$pflicht,
                    'SelectionMode'=>$rec->aspectConstraint->aspectMode,
                );
            }else{
                $rec_input_array = array();
                foreach($values as $valkey=>$val){
                    if($valkey == 0) continue;
                    $checked = (is_array($saved[ $rec->localizedAspectName ]) and in_array($val['id'], $saved[ $rec->localizedAspectName ]))?true:false;
                    $rec_input_array[] = array(
                        'input'=>xtc_draw_checkbox_field( 'INPUT['.urlencode($rec->localizedAspectName).'][]',$val['id'], $checked),
                        'value'=>$val['id']
                    );
                }
                $input_array[] = array(
                        'text'=>$rec->localizedAspectName,
                        'input_array'=>$rec_input_array,
                        'recommendations'=>$values,
                    'max_values'=>(isset($rec->aspectConstraint->aspectMaxLength))?$rec->aspectConstraint->aspectMaxLength:1,
                    'PFLICHT'=>$pflicht,
                    'SelectionMode'=>$rec->aspectConstraint->aspectMode,
                );
            }
        }
        return $input_array;
    }

    function check_ebay_template(){
        $tpl_path = DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE . '/admin/ebay_templates/';
        if($this->getTemplate() == ''){
            return false;
        }
        if(!is_file($tpl_path.$this->getTemplate()) or !is_readable($tpl_path.$this->getTemplate())){
            return false;
        }
        return true;
    }
    
    public function copy(array $data, int $number_of_copies = 1){
		$orig_payments = $data['payments'];
        $orig_itemspecifics = $data['orig_itemspecifics'];
        $orig_itemspecifics_recommendations = $data['orig_itemspecifics_recommendations'];
        $bestoffer_matrix = $data['orig_bestoffer_matrix'];
        $template_excludes = $data['orig_template_excludes'];
        
        $orig_sql_data = $this->getSQLArray();
        $orig_variations_sets = \YES4Trade\Model\ebay_variations_sets::get_by_ebay_products_id($this->getId());
		$orig_sql_data['id'] = '';
		$ids_created = [];
		for($i=0;$i<$number_of_copies;$i++){
            
            xtc_db_perform('ebay_products',$orig_sql_data);
            $new_ebay_products_id = (int)xtc_db_insert_id();
			$ids_created[] = $new_ebay_products_id;
            if( $bestoffer_matrix['bestoffer_matrixes_num'] > 0){
                foreach($bestoffer_matrix['bestoffer_matrixes'] as $k=>$matrix_sql_array){
                    $matrix_sql_array['ebay_bestoffer_matrix_id'] = '';
                    $matrix_sql_array['ebay_products_id'] = $new_ebay_products_id;
                    xtc_db_perform('ebay_bestoffer_matrix',$matrix_sql_array);
                }
            }
			
            // template excludes kopieren
            if( $template_excludes['template_excludes_num'] > 0){
                foreach($template_excludes['template_excludes'] as $k=>$template_excludes_sql_array){
                    $template_excludes_sql_array['id'] = '';
                    $template_excludes_sql_array['ebay_products_id'] = $new_ebay_products_id;
                    xtc_db_perform('ebay_template_excludes',$template_excludes_sql_array);
                }
            }
			
            // payments kopieren
            if(is_countable($orig_payments) and sizeOf($orig_payments)>0){
                foreach($orig_payments as $k=>$v){
                    $pay_insert_sql_array = [
                        'ebay_products_id'=>$new_ebay_products_id,
                        'payment'=>$v
                    ];
                    xtc_db_perform('ebay_products_payments', $pay_insert_sql_array);
                }
            }

            // itemspecifics kopieren
            if(is_countable($orig_itemspecifics) and sizeOf($orig_itemspecifics)>0){
                foreach($orig_itemspecifics as $k=>$v){
                    $insert_sql_array = array(
                            'is_name'=>$v['name'],
                            'is_value'=>$v['value'],
                            'ebay_products_id'=>$new_ebay_products_id
                    );
                    xtc_db_perform('ebay_products_itemspecifics',$insert_sql_array);
                }
            }

            // itemspecifics_recommendations kopieren
            if(is_countable($orig_itemspecifics_recommendations) and sizeOf($orig_itemspecifics_recommendations)>0){
                foreach($orig_itemspecifics_recommendations as $k=>$v){
                    $insert_sql_array = array(
                        'is_name'=>$v['name'],
                        'is_value'=>$v['value'],
                        'ebay_products_id'=>$new_ebay_products_id
                    );
                    xtc_db_perform('ebay_products_itemspecifics_recommendations',$insert_sql_array);
                }
            }
            
            // BOF - VARIATIONS KOPIEREN
            foreach($orig_variations_sets as $evs){
                $data = $evs->toArray();
                unset($data['ebay_variations_sets_id']);
                $data['ebay_products_id'] = $new_ebay_products_id;
                $new = new \YES4Trade\Model\ebay_variations_sets($data);
                $new_evsID = (int)$new->create();
                foreach($evs->ebay_variationspecificssets as $evss){
                    $evss_data = $evss->toArray();
                    unset($evss_data['ebay_variationspecificssets_id']);
                    $evss_data['ebay_variations_sets_id'] = $new_evsID;
                    $new = new \YES4Trade\Model\ebay_variationspecificssets($evss_data);
                    $new->create();
                }
                foreach($evs->ebay_variations as $ev){
                    $ev_data = $ev->toArray();
                    unset($ev_data['ebay_variations_id']);
                    $ev_data['ebay_variations_sets_id'] = $new_evsID;
                    $new = new \YES4Trade\Model\ebay_variations($ev_data);
                    $new_evID = (int)$new->create();
                    foreach($ev->ebay_variations_variationspecifics as $evvs){
                        $evvs_data = $evvs->toArray();
                        unset($evvs_data['ebay_variations_variationspecifics_id']);
                        $evvs_data['ebay_variations_id'] = $new_evID;
                        $new = new \YES4Trade\Model\ebay_variations_variationspecifics($evvs_data);
                        $new->create();
                    }
                    foreach($ev->ebay_variations_pictures as $evp){
                        $evp_data = $evp->toArray();
                        unset($evp_data['ebay_variations_pictures_id']);
                        $evp_data['ebay_variations_sets_id'] = $new_evsID;
                        $new = new \YES4Trade\Model\ebay_variations_pictures($evp_data);
                        $new_evpID = (int)$new->create();
                        foreach($evp->ebay_variations_pictures_sets as $evps){
                            $evps_data = $evps->toArray();
                            unset($evps_data['ebay_variations_pictures_sets_id']);
                            $evps_data['ebay_variations_pictures_id'] = $new_evpID;
                            $new = new \YES4Trade\Model\ebay_variations_pictures_sets($evps_data);
                            $new_evpsID = (int)$new->create();
                            foreach($evps->ebay_variations_pictures_sets_urls as $evpsu){
                                $evpsu_data = $evpsu->toArray();
                                unset($evpsu_data['ebay_variations_pictures_sets_urls_id']);
                                $evpsu_data['ebay_variations_pictures_sets_id'] = $new_evpsID;
                                $new = new \YES4Trade\Model\ebay_variations_pictures_sets_urls($evpsu_data);
                                $new->create();
                            }
                        }
                    }
                }
                
            }
            // EOF - VARIATIONS KOPIEREN
            
            // BOF ebay regulatory
            $rd = \YES4Trade\Model\ebay_products_regulatory_documents::get_by_ebay_products_id($this->getId());
            foreach($rd as $d){
                $data = $d->toArray();
                unset($data['ebay_products_regulatory_documents_id']);
                $data['ebay_products_id'] = $new_ebay_products_id;
                $new = new  \YES4Trade\Model\ebay_products_regulatory_documents($data);
                $new->create();
            }
            
            $rh = \YES4Trade\Model\ebay_products_regulatory_hazmats::get_by_ebay_products_id($this->getId());
            if($rh != null){
                $data = $rh->toArray();
                unset($data['ebay_products_regulatory_hazmats_id']);
                $data['ebay_products_id'] = $new_ebay_products_id;
                $new = new \YES4Trade\Model\ebay_products_regulatory_hazmats($data);
                $new->create();
            }
            
            $emn = \YES4Trade\Model\ebay_products_manufacturer::get_by_ebay_products_id($this->getId());
            if($emn != null){
                $data = $emn->toArray();
                unset($data['ebay_products_manufacturers_id']);
                $data['ebay_products_id'] = $new_ebay_products_id;
                $new = new \YES4Trade\Model\ebay_products_manufacturer($data);
                $new->create();
            }
            
            $eef = \YES4Trade\Model\ebay_products_energy_efficiency::get_by_ebay_products_id($this->getId());
            if($eef != null){
                $data = $eef->toArray();
                unset($data['ebay_products_energy_efficiency_id']);
                $data['ebay_products_id'] = $new_ebay_products_id;
                $new = new \YES4Trade\Model\ebay_products_energy_efficiency($data);
                $new->create();
            }
            
            $eprs = \YES4Trade\Model\ebay_products_responsible_persons::get_by_ebay_products_id($this->getId());
            foreach($eprs as $epr){
                $data = $epr->toArray();
                unset($data['ebay_products_responsible_persons_id']);
                $data['ebay_products_id'] = $new_ebay_products_id;
                $new = new \YES4Trade\Model\ebay_products_responsible_persons($data);
                $new->create();
            }
            
            $epsf = \YES4Trade\Model\ebay_products_productsafety::get_by_ebay_products_id($this->getId());
            if($epsf != null){
                $data = $epsf->toArray();
                unset($data['ebay_products_productsafety_id']);
                $data['ebay_products_id'] = $new_ebay_products_id;
                $new = new \YES4Trade\Model\ebay_products_productsafety($data);
                $new->create();
            }
            // EOF ebay regulatory
            
            // BOF ebay_videos
            $vide = \YES4Trade\Model\ebay_products_videos::get_by_ebay_products_id($this->getId());
            foreach($vide as $video){
                $data = $video->toArray();
                unset($data['ebay_products_videos_id']);
                $data['ebay_products_id'] = $new_ebay_products_id;
                $new = new \YES4Trade\Model\ebay_products_videos($data);
                $new->create();
            }
            // EOF ebay_videos
            
            
            // die shippingcosts werden direkt nach dem Aufruf ueber die 
            // klasse ebayapi kopiert - zb in der ebayapi_cart.php?action=copy
            
            // die characteristics werden direkt nach dem Aufruf ueber die 
            // klasse ebayapi kopiert - zb in der ebayapi_cart.php?action=copy
        }
		return $ids_created;
    } // eof function copy
    
    public function delete(){
        xtc_db_query(sprintf(
            "DELETE FROM %s WHERE id='%d'",
            TABLE_EBAY_PRODUCTS,
            $this->getId()
        ));
        $autos = [];
	$auto_query = xtc_db_query(sprintf(
            "SELECT ebay_automatics_id FROM ebay_automatics WHERE ebay_products_id='%d'",
            $this->getId()
        ));
        while($auto = xtc_db_fetch_array($auto_query)){
            $autos[] = $auto;
        }
        foreach($autos as $auto){
            xtc_db_query(sprintf(
                "DELETE FROM ebay_automatics_daily WHERE ebay_automatics_id='%d'",
                $auto['ebay_automatics_id']
            ));
	}
        xtc_db_query("DELETE FROM ebay_template_excludes WHERE ebay_products_id='".$this->getId()."'");
        xtc_db_query("DELETE FROM ebay_automatics WHERE ebay_products_id='".$this->getId()."'");
        xtc_db_query("DELETE FROM ebay_bestoffer_matrix WHERE ebay_products_id='".$this->getId()."'");
        xtc_db_query("DELETE FROM ebay_products_payments WHERE ebay_products_id='".$this->getId()."'");
        xtc_db_query("DELETE FROM ebay_products_itemspecifics WHERE ebay_products_id='".$this->getId()."'");
        xtc_db_query("DELETE FROM ebay_products_itemspecifics_recommendations WHERE ebay_products_id='".$this->getId()."'");

        $shipm = [];
        $shippingmethods_query = xtc_db_query(sprintf(
            "SELECT ebay_products_shippings_id FROM ebay_products_shippings WHERE ebay_products_id='%d'",
            $this->getId()
        ));
        while($shippingmethods = xtc_db_fetch_array($shippingmethods_query)){
            $shipm[] = $shippingmethods;
        }
        foreach($shipm as $shippingmethods){
            xtc_db_query(sprintf(
                "DELETE FROM ebay_products_shippings_locations WHERE ebay_products_shippings_id='%d'",
                $shippingmethods['ebay_products_shippings_id']
            ));
        }
        xtc_db_query("DELETE FROM ebay_products_shippings WHERE ebay_products_id='".$this->getId()."'");
        xtc_db_query("DELETE FROM ebay_products_characteristics WHERE ebay_products_id='".$this->getId()."'");
        xtc_db_query("DELETE FROM ebay_products_history WHERE ebay_products_id='".$this->getId()."'");


        // BOF PROPERTIES
        $properties_data_array = [];
        $properties_query = xtc_db_query(sprintf(
            "SELECT ebay_products_properties_id FROM ebay_products_properties WHERE ebay_products_id='%d'",
            $this->getId()
        ));
        while($properties = xtc_db_fetch_array($properties_query)){
            $properties_data_array[] = $properties;
        }
        foreach($properties_data_array as $properties){
            $properties_values_data_array = [];
            $properties_values_query = xtc_db_query(sprintf(
                "SELECT ebay_products_properties_values_id FROM ebay_products_properties_values WHERE ebay_products_properties_id='%d'",
                $properties['ebay_products_properties_id']
            ));
            while($properties_values = xtc_db_fetch_array($properties_values_query)){
                $properties_values_data_array[] = $properties_values;
            }
            foreach($properties_values_data_array as $properties_values){
                xtc_db_query(sprintf(
                    "DELETE FROM ebay_products_properties_values_description WHERE ebay_products_properties_values_id='%d'",
                    $properties_values['ebay_products_properties_values_id']
                ));
	    }
            xtc_db_query(sprintf(
                    "DELETE FROM ebay_products_properties_values WHERE ebay_products_properties_id='%d'",
                    $properties['ebay_products_properties_id']
            ));
            xtc_db_query(sprintf(
                    "DELETE FROM ebay_products_properties_description WHERE ebay_products_properties_id='%d'",
                    $properties['ebay_products_properties_id']
            ));
	}
        xtc_db_query(sprintf(
            "DELETE FROM ebay_products_properties WHERE ebay_products_id='%d'",
            $this->getId()
        ));
	// EOF PROPERTIES
        $variations_array = \YES4Trade\Model\ebay_variations_sets::get_by_ebay_products_id($this->getId());
        foreach($variations_array as $evs){
            \YES4Trade\Model\ebay_variations_sets::delete($evs->ebay_variations_sets_id);
        }
        
        $ee = \YES4Trade\Model\ebay_products_energy_efficiency::get_by_ebay_products_id($this->getId());
        if($ee != null){
            \YES4Trade\Model\ebay_products_energy_efficiency::delete($ee->ebay_products_energy_efficiency_id);
        }
        $ma = \YES4Trade\Model\ebay_products_manufacturer::get_by_ebay_products_id($this->getId());
        if($ma != null){
            \YES4Trade\Model\ebay_products_manufacturer::delete($ma->ebay_products_manufacturers_id);
        }
        $ps = \YES4Trade\Model\ebay_products_productsafety::get_by_ebay_products_id($this->getId());
        if($ps != null){
            \YES4Trade\Model\ebay_products_productsafety::delete($ps->ebay_products_productsafety_id);
        }
        $rds = \YES4Trade\Model\ebay_products_regulatory_documents::get_by_ebay_products_id($this->getId());
        foreach($rds as $rd){
            \YES4Trade\Model\ebay_products_regulatory_documents::delete($rd->ebay_products_regulatory_documents_id);
        }
        $hz = \YES4Trade\Model\ebay_products_regulatory_hazmats::get_by_ebay_products_id($this->getId());
        if($hz != null){
            \YES4Trade\Model\ebay_products_regulatory_hazmats::delete($hz->ebay_products_regulatory_hazmats_id);
        }
        $rps = \YES4Trade\Model\ebay_products_responsible_persons::get_by_ebay_products_id($this->getId());
        foreach($rps as $rp){
            \YES4Trade\Model\ebay_products_responsible_persons::delete($rp->ebay_products_responsible_persons_id);
        }
        $vide = \YES4Trade\Model\ebay_products_videos::get_by_ebay_products_id($this->getId());
        foreach($vide as $video){
            \YES4Trade\Model\ebay_products_videos::delete($video->ebay_products_videos_id);
        }
        
        
    }// eof function delete

	public function convert_product_staffelpreise_to_variations(xtcPrice $xtPrice):bool{
		$variations_create = [];
		$staffelungen = yes_query(sprintf(
			"SELECT * FROM %s WHERE products_id=:pid ORDER BY quantity",
			'personal_offers_by_customers_status_'.$xtPrice->cStatus['customers_status_id']
		),[
			'pid'=>$this->getProductsId()
		]);
		$country_id = yes_get_country_id_from_iso2($this->getCountry());
		$tax_id= yes_eu_oss_get_products_tax_class_id($this->getProductsId(),$country_id, 0);
		$nvl_array = [];
		$nvl_value_staffel_1 = ($this->getCountry()=='DE') ? 'Stk' : 'pc';
		$nvl_value_staffel = ($this->getCountry()=='DE') ? 'Stk' : 'pcs';
		foreach($staffelungen as $nr=>$staffelung){
			if($staffelung['quantity'] == 1){
				$price = $this->getAuctionprice();
				if($this->getCountry()=='DE'){
					$nvl_array[] = sprintf(
						'Auswahl;1 %s (%s %s/%s)',
						$nvl_value_staffel_1,
						$price,
						$xtPrice->actualCurr,
						$nvl_value_staffel_1
					);
				}else{
					$nvl_array[] = sprintf('Selection;1 %s (%s %s)',
						$nvl_value_staffel_1,
						$xtPrice->actualCurr,
						$price
					);
				}
			}else{
				$price = $xtPrice->xtcGetPrice($this->getProductsId(),
					false,
					intval($staffelung['quantity']),
					$tax_id
				);
				if($this->getCountry()=='DE'){
					$nvl_array[] = $staffelung['quantity'].' Stk ('.$price.' '.$xtPrice->actualCurr.'/Stk)';
				}else{
					$nvl_array[] = $staffelung['quantity'].' pcs ('.$xtPrice->actualCurr.' '.$price.' each)';
				}
			}
			$variations_create[] = [
				'quantity'=>intval($staffelung['quantity']),
				'price'=>$price,
				'sort_order'=>intval($nr),
			];
		}
		$new = new \YES4Trade\Model\ebay_variations_sets([
			'ebay_products_id'=>intval($this->getId()),
			'title'=>$this->getTitle(),
			'date_added'=>date('Y-m-d H:i:s')
		]);
		$evsID = $new->create();
		$nvl_name = ($this->getCountry()=='DE')?'Menge':'Quantity';
		$new = new \YES4Trade\Model\ebay_variationspecificssets([
			'nvl_name'=>$nvl_name,
			'nvl_value'=>implode(';',$nvl_array),
			'ebay_variations_sets_id'=>intval($evsID),
		]);
		$evssID = $new->create();
		
		foreach($variations_create as $variation){
			$new_sql = [
				'quantity'=>intval($variation['quantity']),
				'sku'=>sprintf('%d-STFLPRS_%s',
					$this->getProductsId(),
					$variation['quantity']
				),
				'startprice'=>floatval($variation['price']),
				'ebay_variations_sets_id'=>intval($evsID),
				'products_id'=>intval($this->getProductsId()),
				'sort_order'=>intval($variation['sort_order']),
			];
			$new = new \YES4Trade\Model\ebay_variations($new_sql);
			$evID = $new->create();
			$nvl_value_str = $variation['quantity'].' ';
			$nvl_value_str .= (intval($variation['quantity']) == 1)?$nvl_value_staffel_1:$nvl_value_staffel;
			$new = new \YES4Trade\Model\ebay_variations_variationspecifics([
				'ebay_variations_id'=>intval($evID),
				'nvl_name'=>$nvl_name,
				'nvl_value'=>$nvl_value_str
			]);
			$evvsID = $new->create();
		}
		return true;
	}
}
