<?php
namespace YES4Trade\Model;
class products_to_categories extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'products_to_categories';

    private static $propertyTypes = [
        'products_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'products_id'
        ],
        'categories_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'categories_id'
        ],
    ];


    public function __construct(array $values = []) {
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);
        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }
        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }
        $this->setValues(__CLASS__, $childValues);
    }


    public function create() {
        $data = $this->toArray();
        yes_db_perform(self::TABLE_NAME, self::convert_values($data,self::$propertyTypes));
        self::clear_category_cache();
        return xtc_db_insert_id();
    }


    public function update() {
        throw new Exception('Update for products_to_categories not available');
    }


    /**
     * Loeschen von Produkt/Kategorie Zuweisungen
     * 
     * Werden beide Werte uebergeben findet ein AND statt
     * Wird nur ein Wert von beiden uebergeben, dann gilt der uebergebene wert
     * Um Kategoriebasiert zu loeschen, den products_id Wert mit -1 angeben
     * Um Produktbasiert zu loeschen, den categories_id Wert weglassen oder -1
     * 
     * @param int $products_id
     * @param int $categories_id
     */
    public static function delete(int $products_id = -1, int $categories_id = -1) {
        if($products_id > -1 and $categories_id > -1){
            yes_query(sprintf(
                "DELETE FROM %s WHERE products_id=:products_id AND categories_id=:categories_id",
                    self::TABLE_NAME
                ),['products_id'=>$products_id,'categories_id'=>$categories_id]
            );
        }elseif($products_id > -1 and $categories_id < 0){
            yes_query(sprintf(
                "DELETE FROM %s WHERE products_id=:products_id",
                    self::TABLE_NAME
                ),['products_id'=>$products_id]
            );
        }elseif($products_id < 0 and $categories_id > -1){
            yes_query(sprintf(
                "DELETE FROM %s WHERE categories_id=:categories_id",
                    self::TABLE_NAME
                ),['categories_id'=>$categories_id]
            );
        }
        self::clear_category_cache();
    }

    public static function get_items(int $products_id,int $categories_id) {
        return yes_query(sprintf(
            "SELECT * FROM %s WHERE products_id=:products_id AND categories_id=:cat_id",
                self::TABLE_NAME
            ),['products_id'=>$products_id, 'cat_id'=>$categories_id]
        );
    }
    
    public static function count_items(int $products_id,int $categories_id = -1) {
        if($categories_id == -1){
            $record = yes_query(sprintf(
                "SELECT count(*) AS anz FROM %s WHERE products_id=:products_id",
                    self::TABLE_NAME
                ),['products_id'=>$products_id],
                true
            );
            return $record['anz'];
        }
        $record = yes_query(sprintf(
            "SELECT count(*) AS anz FROM %s WHERE products_id=:products_id AND categories_id=:cat_id",
                self::TABLE_NAME
            ),['products_id'=>$products_id, 'cat_id'=>$categories_id],
            true
        );
        return $record['anz'];
    }
    
    public static function get_items_by_categories_id(int $categories_id) {
        return yes_query(sprintf(
            "SELECT * FROM %s WHERE categories_id=:id",
                self::TABLE_NAME
            ),['id'=>$categories_id]
        );
    }
    
    public static function get_items_by_products_id(int $products_id, array $query_params = []) {
        $items = [];
        $limit_sql = '';
        if(sizeOf($query_params)){
            if(isset($query_params['limit'])){
                $start = $query_params['start'] ?? 0;
                $limit_sql = sprintf(' LIMIT %d,%d',
                    $start,
                    intval($query_params['limit'])
                );
            }
        }
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE products_id=:id %s",
                self::TABLE_NAME, $limit_sql
            ),['id'=>$products_id]
        );
        foreach($query as $record){
            $items[] = new self(self::convert_values($record,self::$propertyTypes));
        }
        return $items;
    }
    
    public static function clear_category_cache(){
        global $InstanceCache;
        \yescache_helper::cache_bump_generation($InstanceCache, 'categories');
    }
    
    public static function delete_by_products_id_exclude_category(int $products_id, int $categories_id){
        yes_query(sprintf(
            "DELETE FROM %s WHERE products_id=:products_id AND categories_id !=:categories_id",
                self::TABLE_NAME
            ),[
                'products_id'=>$products_id,
                'categories_id'=>$categories_id
           ]
        );
        self::clear_category_cache();
    }
}