<?php
namespace YES4Trade\Model;

/**
 * Da eBay Verkaeufe ohne Bestand nicht mehr eingelesen werden duerfen, werden
 * Tagesaktuelle Verkaeufe, bei denen das zutrifft, in der Tabelle ebay_orders_oos
 * gespeichert. Mit dieser Klasse hat man alle Funktionen um diese markierten
 * eBay Orders zu erfassen und abzuarbeiten.
 */
class ebay_orders_oos{
    public function __construct( int $id = 0 ){
        if($id > 0){
            return self::get( $id );
        }
    }
    public static function get_ebay_orders_oos_id_from_OrderID( string $OrderID, string $seller ){
        $query = xtc_db_query(sprintf(
           "SELECT ebay_orders_oos_id FROM ebay_orders_oos WHERE OrderID='%s' AND seller='%s'",
           $OrderID, $seller
        ));
        if(!xtc_db_num_rows($query)){
            return -1;
        }
        $record = xtc_db_fetch_array($query);
        return $record['ebay_orders_oos_id'];
    }
    
    public static function get( int $id ){
        $query = xtc_db_query(sprintf(
           "SELECT * FROM ebay_orders_oos WHERE ebay_orders_oos_id='%d'",
           $id
        ));
        if(!xtc_db_num_rows($query)){
            throw new Exception('Unknown ebay_orders_oos_id #'.$id);
        }
        return xtc_db_fetch_array($query);
    }
    
    /**
     * Erzeugt Eintrag aus Array(
     *  'OrderID'=>'',
     *  'seller'=>''
     * )
     * 
     * @param array $data
     * @return int
     * @throws Exception
     */
    public static function create( string $ebayOrderID, string $seller ){
        if(self::get_ebay_orders_oos_id_from_OrderID( $ebayOrderID,  $seller) > 0){
            throw new Exception('OrderID #'.$ebayOrderID.' for seller '.$seller.' exists');
        }
        $data = [
            'date_created' => date('Y-m-d H:i:s'),
            'OrderID'=>$ebayOrderID,
            'seller'=>$seller
        ];
        yes_db_perform('ebay_orders_oos', $data);
        return xtc_db_insert_id();
    }
    
    public static function update( int $id, array $data ){
        if(!is_countable($data) or !sizeOf($data)){
            throw new Exception('No update data for #'.$id);
        }
        unset($data['ebay_orders_oos_id']);
        xtc_db_perform('ebay_orders_oos', $data, 'update', "ebay_orders_oos_id='".$id."'");
    }
    
    public static function delete( int $id ){
        xtc_db_query(sprintf(
            "DELETE FROM ebay_orders_oos WHERE ebay_orders_oos_id='%d'",
            $id
        ));
    }
    
    public static function delete_if_exists(string $eBayOrderID, string $seller ){
        $eooos_id = self::get_ebay_orders_oos_id_from_OrderID( $eBayOrderID, $seller );
        if($eooos_id > 0){
            self::delete( $eooos_id );
        }
        return true;
    }
    
    /**
     * Liefert alle Eintraege der Tabelle ebay_orders_oos als Array
     * 
     * @return array
     */
    public static function get_items(){
        $items = [];
        $query = xtc_db_query(
           "SELECT * FROM ebay_orders_oos ORDER BY date_created",
        );
        while($row = xtc_db_fetch_array($query)){
            $items[] = $row;
        }
        return $items;
    }
}
