<?php

namespace YES4Trade\Model;

class address_book extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'address_book';
    const TABLE_INDEX = 'address_book_id';
    public static $integer_properties = [
        'address_book_id',
        'customers_id',
        'entry_country_id',
        'entry_zone_id'
    ];
    private static $propertyTypes = [
        'address_book_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'address_book_id'
        ],
        'customers_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_id'
        ],
        'entry_gender' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'entry_gender'
        ],
        'entry_company' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'entry_company'
        ],
        'entry_firstname' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'entry_firstname'
        ],
        'entry_lastname' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'entry_lastname'
        ],
        'entry_street_address' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'entry_street_address'
        ],
        'entry_suburb' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'entry_suburb'
        ],
        'entry_postcode' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'entry_postcode'
        ],
        'entry_city' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'entry_city'
        ],
        'entry_state' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'entry_state'
        ],
        'entry_country_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'entry_country_id'
        ],
        'entry_zone_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'entry_zone_id'
        ],
        'address_class' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'address_class'
        ],
        'address_date_added' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'address_date_added'
        ],
        'address_last_modified' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'address_last_modified'
        ],
    ];


    public function __construct(array $values = []) {
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);
        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }
        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }
        $this->setValues(__CLASS__, $childValues);
    }


    public function create() {
        $data = $this->toArray();
        foreach($data as $k=>$v){
            if(in_array($k, self::$integer_properties)){
                $data[$k] = (int)$data[$k];
            }
        }
        yes_db_perform(self::TABLE_NAME, $data);
        return xtc_db_insert_id();
    }


    public function update() {
        $data = $this->toArray();
        foreach($data as $k=>$v){
            if(in_array($k, self::$integer_properties)){
                $data[$k] = (int)$data[$k];
            }
        }
        unset($data[self::TABLE_INDEX]);
        $index = self::TABLE_INDEX;
        yes_db_perform(self::TABLE_NAME, $data,'update',
            [$index=>$this->$index]
        );
    }


    public static function delete(int $index) {
        yes_query(sprintf(
            "DELETE FROM %s WHERE %s=:index_field",
                self::TABLE_NAME,self::TABLE_INDEX
            ),['index_field'=>$index]
        );
    }


    public static function get_by_address_book_id(int $address_book_id, array $select_fields = []) {
        $select_str = (!sizeOf($select_fields))?'*':implode(',',$select_fields);
        $query = yes_query(sprintf(
            "SELECT %s FROM %s WHERE %s=:index_field",
                $select_str,self::TABLE_NAME, self::TABLE_INDEX
            ),['index_field'=>$address_book_id]
        );
        if(!sizeOf($query)){
            return null;
        }
        $record = current($query);
        foreach($record as $k=>$v){
            if(in_array($k, self::$integer_properties)){
                $record[$k] = (int)$record[$k];
            }
        }
        return new self($record);
    }

    public static function count_by_customers_id_and_address_book_id( int $customers_id, int $address_book_id ){
        $record = yes_query(sprintf(
            "select count(*) AS total FROM %s WHERE customers_id=:customers_id AND %s =:index_field",
                self::TABLE_NAME, self::TABLE_INDEX
            ),['customers_id'=>$customers_id,'index_field'=>$address_book_id],
            true
        );
        return $record['total'];
    }
    
    public static function get_by_customers_id_and_address_book_id(int $customers_id, int $address_book_id){
        $query = yes_query(sprintf(
            "select * from %s where customers_id =:customers_id and %s =:index_field",
                self::TABLE_NAME, self::TABLE_INDEX
            ),['customers_id'=>$customers_id,'index_field'=>$address_book_id]
        );
        if(!sizeOf($query)){
            return null;
        }
        $record = current($query);
        foreach($record as $k=>$v){
            if(in_array($k, self::$integer_properties)){
                $record[$k] = (int)$record[$k];
            }
        }
        return new self($record);
    }
    
    public static function get_by_customers_id( int $customers_id, array $where_params = [], string $order_by = '' ){
        $items = [];
        $where = '';
        $parameters = [
            'customers_id'=>$customers_id
        ];
        if(sizeOf($where_params)){
            $where_parts = [];
            $where = ' AND ';
            foreach($where_params as $k=>$v){
                $kparam = 'where_'.$k;
                $parameters[$kparam] = $v;
                $where_parts[] = sprintf(' %s=:%s ',
                    $k, $kparam
                );
            }
            $where .= implode(' AND ', $where_parts );
        }
        
        $order_by_sql = '';
        if(!empty($order_by)) {
            $parameters['order_by'] = $order_by;
            $order_by_sql = ' ORDER BY :order_by';
        }
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE customers_id =:customers_id %s %s",
                self::TABLE_NAME, $where, $order_by_sql
            ),$parameters
        );
        foreach($query as $record){
            foreach($record as $k=>$v){
                if(in_array($k, self::$integer_properties)){
                    $record[$k] = (int)$record[$k];
                }
            }
            $items[] = new self($record);
        }
        return $items;
    }

    /**
     * Vorkommen in der reclamations.php
     * @param string $address_class
     * @param int $customers_id
     */
    public static function update_address_class_to_empty_by_address_class_and_customers_id(string $address_class, int $customers_id ){
        $update_sql_array = [
            'address_class'=>''
        ];
        yes_db_perform(self::TABLE_NAME,$update_sql_array,'update',[
            'address_class'=>$address_class,
            'customers_id'=>(int)$customers_id
        ]);
    }
    
    public static function count_by_customers_id( int $customers_id ){
        $record = yes_query(sprintf(
            "SELECT COUNT(%s) AS anz FROM %s WHERE customers_id=:customers_id",
                self::TABLE_INDEX,self::TABLE_NAME
            ),['customers_id'=>$customers_id],
            true
        );
        return (int)$record['anz'];
    }
}

