<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                             Author M. ASPELEITER <dazze@gmx.de>
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/
   
require('includes/application_top.php');
require_once(DIR_WS_CLASSES.'branches_transfer.php');
require_once(DIR_WS_CLASSES.'class.basics.php');
require_once(DIR_WS_CLASSES.'product.php');
require_once(DIR_FS_INC.'yes_get_branches_transfer_status_title.inc.php');
require_once(DIR_FS_INC.'xtc_get_product_path.inc.php');
require_once(DIR_FS_INC.'xtc_get_storage_name.inc.php');
require_once(DIR_FS_INC.'xtc_get_parent_categories.inc.php');

$basics = new basics;

$admin_access = main::get_admin_access();

$smarty = new yesSmarty;
$smarty->assign('lang_img_path',DIR_WS_LANGUAGES.$_SESSION['language'].'/admin/images/buttons/');
$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');

if (isset($_GET['action'])) {
    switch ($_GET['action']) {
	  case 'inventur_comments':
		$bID = (int)xtc_db_input($_GET['bID']);
		$add_comments = xtc_db_input($_POST['comments']);
		$query = xtc_db_query(sprintf(
				"SELECT p.products_id,bp.products_quantity,bp.branches_products_id
				FROM products p,branches_products bp
				WHERE bp.products_id=p.products_id AND bp.branches_id='%s'",
			$bID
		));
		$branch_title = xtc_get_branch_title($bID);
		$histories = 0;
	    while($records = xtc_db_fetch_array($query)){
			$P = new product($records['products_id']);
			$comments = sprintf(HISTORY_INVENTUR_COMMENTS,
				$branch_title,$records['products_quantity'],$add_comments
			);
			$P->add_history($comments);
			$histories++;
		}
		$messageStack->add_session(sprintf(MSG_SUCCESS_INVENTUR_COMMENTS,$branch_title,$histories),'success');
		xtc_redirect(xtc_href_link('branch.php',xtc_get_all_get_params(array('action'))));
		break;
	  case 'csv_export':
		$bID = (int)xtc_db_input($_GET['bID']);
		$query = xtc_db_query(sprintf(
				"SELECT p.products_id,p.products_price,bp.products_quantity,bp.branches_products_id
				FROM products p,branches_products bp
				WHERE bp.products_id=p.products_id AND bp.branches_id='%s'",
			$bID
		));
		$separator = "\t";
		$list_separator = ";";
		$line_end = "\r\n";

		$storages_array = array();
		$storage_query = xtc_db_query("SELECT id,name FROM storages ORDER BY name");
		while($storage = xtc_db_fetch_array($storage_query)){
			$storages_array[$storage['id']] = '"'.$storage['name'].'"';
		}

		$csv_header = array(
			'"'.CSV_HEADER_PID.'"',
			'"'.CSV_HEADER_STAMMLAGER.'"',
			'"'.CSV_HEADER_NAME.'"',
			'"'.CSV_HEADER_MODEL.'"',
			'"'.CSV_HEADER_EAN.'"',
			'"'.CSV_HEADER_PRICE.'"',
			'"'.CSV_HEADER_DISTRIBUTOR_PRICE.'"',
			'"'.CSV_HEADER_DISTRIBUTORS.'"',
			'"'.CSV_HEADER_BRANCH_QTY.'"',
                    
		);
		$csv_header = array_merge($csv_header,$storages_array);
		$schema = implode($separator,$csv_header).$line_end;
		while($records = xtc_db_fetch_array($query)){
			$P = new product($records['products_id']);
			$distributors = '';
			$dist_query = xtc_db_query(sprintf(
				"SELECT DISTINCT(dpp.distributor_id), d.name,d.kundennummer FROM distributors d LEFT JOIN distributor_product_prices dpp ON d.id=dpp.distributor_id WHERE dpp.products_id='%s'",
				$P->info['products_id']
			));
			while($dist = xtc_db_fetch_array($dist_query)){
				$distributors .= $dist['name'];
				if($dist['kundennummer'] != ''){
					$distributors .= ' (KdNr: '.$dist['kundennummer'].')';
				}
				$distributors .= ';';
			}
			$distributors = substr($distributors,0,strlen($distributors)-1);

			$dprice = 0;
			$distributor_price_query = xtc_db_query(sprintf(
				"SELECT price FROM distributor_product_prices WHERE products_id='%d' ORDER BY date_saved DESC LIMIT 1",
				$P->info['products_id']
			));
			if(xtc_db_num_rows($distributor_price_query)){
				$distributor_price = xtc_db_fetch_array($distributor_price_query);
				$dprice = $distributor_price['price'];
			}
                        $SQ = new products_quantity($P->info['products_id']);
			$csv_line_array = array(
				$P->info['products_id'],
                                $SQ->get_stammlager_qty(),
				sprintf('"%s"', str_replace('"','',$P->info['products_name']) ),
				sprintf('"%s"', str_replace('"','',$P->info['products_model']) ),
				sprintf('"%s"', str_replace('"','',$P->info['products_ean']) ),
				$records['products_price'],
				$dprice,
				$distributors,
				$records['products_quantity'],
			);
			// LAGERPLAETZE
			$storages = $P->get_storages();
			if(sizeOf($storages_array)>0 and is_array($storages) and sizeOf($storages)>0){
				foreach($storages_array as $storage_id=>$storage_name){
					$storage_places = array();
					foreach($storages as $storage){
						if($storage['storage_id'] == $storage_id){
							for($si=0;$si<sizeOf($storage['places']);$si++){
								$storage_places[] = sprintf("[%s] %s",$storage['nummer'],$storage['places'][$si]['storage_place']);
							}
						}
					}
					$storage_places = implode($list_separator,$storage_places);
					$csv_line_array[] = sprintf('"%s"',$storage_places);
				}
			}
			$schema .= implode($separator,$csv_line_array).$line_end;
		}
		header('Content-type: application/x-octet-stream');
		$file = sprintf('YES_BRANCHPRODUCTS_EXPORT_%s_%s.csv',$bID,date('Ymdhis'));
		header('Content-disposition: attachment; filename=' . $file);
		echo $schema;
		exit;
		break;
    case 'report':
		$bID = (int)xtc_db_input($_GET['bID']);
		$filiale = xtc_get_branch_title($bID);
		$from_dummy = new DateTime('-1 Week');
		$from_param = $_GET['from']?? $from_dummy->format('Y-m-d');
		$date_from = $from_param.' 00:00:00';
		$to_dummy = new DateTime();
		$to_param = $_GET['to']??$to_dummy->format('Y-m-d');
		$date_to = $to_param.' 23:59:59';
?>
<!DOCTYPE html>
<html <?php echo HTML_PARAMS; ?>>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=<?php echo $_SESSION['language_charset']; ?>">
	<title><?php echo sprintf(HEADING_TITLE_REPORT,$filiale,$_GET['from'],$_GET['to']); ?></title>
	<link rel="stylesheet" type="text/css" href="includes/stylesheet.css.php">
	<script type="text/javascript">
<!--
var ONLOADFUNC = '';
//-->
</script>
</head>
<body marginwidth="0" marginheight="0" topmargin="0" bottommargin="0" leftmargin="0" rightmargin="0" bgcolor="#FFFFFF">
<table width="100%">
<tr>
	<td class="main"><b><?php echo sprintf(HEADING_TITLE_REPORT,$filiale,$_GET['from'],$_GET['to']); ?></b><br><br></td>
</tr>
<tr>
	<td class="main">
		<table border="0" width="100%" cellspacing="3">
		<tr>
			<td class="main"><b><?php echo TABLE_HEADING_DATE; ?></b></td>
			<td class="main"><b><?php echo TABLE_HEADING_EVENT; ?></b></td>
			<td class="main"><b><?php echo TABLE_HEADING_EDITOR; ?></b></td>
		</tr>
		<?php
		$history_query = xtc_db_query("SELECT * FROM branches_history WHERE branches_id='".$bID."' and date_created>'".$date_from."' and date_created<'".$date_to."' ORDER BY date_created DESC");
      		while($history = xtc_db_fetch_array($history_query)){
		?>
		
		<tr>
			<td class="main" valign="top"><?php echo xtc_date_short($history['date_created']); ?></td>
			<td class="main" valign="top"><?php echo $history['comments']; ?></td>
			<td class="main" valign="top"><?php echo xtc_get_editor_name($history['editor_id']); ?></td>
		</tr>
		
		<?php
		}
		?>
		</table>
		<?php echo xtc_draw_separator('pixel_black.gif'); ?>
		<p><div align="center"><a href="javascript:window.close();" title="<?php echo IMAGE_CLOSE; ?>"><u><?php echo IMAGE_CLOSE; ?></u></a></div></p>
	</td>
</tr>
</table>
</body>
</html>
  
<?php
  	exit;
	break;
      case 'save_transfer':
        $bID = xtc_db_input($_POST['branches_id']);
        $tbID = xtc_db_input($_POST['target_branches_id']);
	if($bID != $tbID){
		$insert_sql_array = array(
			'branches_id'=>$bID,
			'target_branches_id'=>$tbID,
			'date_created'=>'now()',
			'transfer_status'=>3,
			'editor_id'=>$_SESSION['customer_id']
		);
		xtc_db_perform('branches_transfer',$insert_sql_array);

		$bt = new branches_transfer(xtc_db_insert_id());
		$bt->insert_history('3',HISTORY_TRANSFER_ADDED,$_SESSION['customer_id']);

		// history filiale
		$branch_title = ($tbID > 0) ? xtc_get_branch_title($tbID) : TEXT_MAIN_STORAGE;
	        $sql_insert_array = array('branches_id'=>$bID,
			'date_created'=>"now()",
			'comments'=>sprintf(HISTORY_TRANSFER_FOR_BRANCH_ADDED,$branch_title),
			'editor_id'=>$_SESSION['customer_id']
		);
		xtc_db_perform('branches_history',$sql_insert_array);

		// history target filiale
		$branch_title = ($bID > 0) ? xtc_get_branch_title($bID) : 'Stammlager';
	        $sql_insert_array = array('branches_id'=>$bt->info['id'],
			'date_created'=>"now()",
			'comments'=>sprintf(HISTORY_TRANSFER_FROM_BRANCH_ADDED,xtc_get_branch_title($bID)),
			'editor_id'=>$_SESSION['customer_id']
		);
		xtc_db_perform('branches_history',$sql_insert_array);
		$messageStack->add_session(HISTORY_TRANSFER_ADDED,'success');
	    xtc_redirect(xtc_href_link('branches_transfer.php', 'bID=' . $bID . '&btID='.$bt->info['id'].'&action=edit'));
	}else{
		$messageStack->add_session(MSG_ERROR_TRANSFER_IN_SAME_BRANCH,'error');
	}
        xtc_redirect(xtc_href_link('branch.php', 'bID=' . $bID));
	break;
      case 'save':
        $bID = xtc_db_prepare_input($_GET['bID']);
	$update_sql_array = array(
		'title' => $_POST['title'],
		'stammlager' => $_POST['stammlager'],
		'storekeeper_id' => $_POST['storekeeper_id'],
		'template_filename' => $_POST['template_filename'],
		'branch_company'=>$_REQUEST['branch_company'],
		'branch_name'=>$_REQUEST['branch_name'],
		'branch_suburb'=>$_REQUEST['branch_suburb'],
		'branch_street_address'=>$_REQUEST['branch_street_address'],
		'branch_city'=>$_REQUEST['branch_city'],
		'branch_postcode'=>$_REQUEST['branch_postcode'],
		'branch_country'=>$_REQUEST['branch_country'],
		'branch_telephone'=>$_REQUEST['branch_telephone']
	);
	if(MODULE_OTHER_FIBUNUMBERS_STATUS == 'True'){
		$update_sql_array['fibunumber_prefix'] = $_POST['fibunumber_prefix'];
		$update_sql_array['fibunumber_length'] = $_POST['fibunumber_length'];
		$update_sql_array['fibunumber_start'] = $_POST['fibunumber_start'];
		$update_sql_array['fibunumber_status'] = $_POST['fibunumber_status'];
		$update_sql_array['fibunumber_automatic'] = $_POST['fibunumber_automatic'];
	}
        xtc_db_perform('branches',$update_sql_array,'update',"branches_id='".$bID."'");
	// history
	$comments = sprintf(HISTORY_BRANCH_TITLE_UPDATED,$title,$stammlager);
        $sql_insert_array = array('branches_id'=>$bID,
		'date_created'=>"now()",
		'comments'=>$comments,
		'editor_id'=>$_SESSION['customer_id']
	);
	xtc_db_perform('branches_history',$sql_insert_array);
	
	$messageStack->add_session(MSG_SUCCESS_BRANCH_UPDATE,'success');
	
        xtc_redirect(xtc_href_link('branch.php', 'bID=' . $bID));
        break;
      case 'insert':
      	$number_of_branches_query = xtc_db_query("SELECT branches_id FROM branches");
      	$number_of_branches = xtc_db_num_rows($number_of_branches_query);
      	if($number_of_branches <= YES_BRANCHES_COUNT){
		
			$insert_sql_array = array(
				'title' => $_POST['title'],
				'stammlager' => $_POST['stammlager'],
				'storekeeper_id' => $_POST['storekeeper_id'],
				'template_filename' => $_POST['template_filename'],
				'branch_company'=>$_REQUEST['branch_company'],
				'branch_name'=>$_REQUEST['branch_name'],
				'branch_suburb'=>$_REQUEST['branch_suburb'],
				'branch_street_address'=>$_REQUEST['branch_street_address'],
				'branch_city'=>$_REQUEST['branch_city'],
				'branch_postcode'=>$_REQUEST['branch_postcode'],
				'branch_country'=>$_REQUEST['branch_country'],
				'branch_telephone'=>$_REQUEST['branch_telephone']
			);
			if(MODULE_OTHER_FIBUNUMBERS_STATUS == 'True'){
				$insert_sql_array['fibunumber_prefix'] = $_POST['fibunumber_prefix'];
				$insert_sql_array['fibunumber_length'] = $_POST['fibunumber_length'];
				$insert_sql_array['fibunumber_start'] = $_POST['fibunumber_start'];
				$insert_sql_array['fibunumber_status'] = $_POST['fibunumber_status'];
				$insert_sql_array['fibunumber_automatic'] = $_POST['fibunumber_automatic'];
			}
			xtc_db_perform('branches',$insert_sql_array);
	        $bID = xtc_db_insert_id();
			
			// history
			$comments = sprintf(HISTORY_BRANCH_ADDED,$title,$stammlager);
			$sql_insert_array = array('branches_id'=>$bID,
				'date_created'=>"now()",
				'comments'=>$comments,
				'editor_id'=>$_SESSION['customer_id']
			);
			xtc_db_perform('branches_history',$sql_insert_array);
			
			$messageStack->add_session(MSG_SUCCESS_BRANCH_ADDED,'success');
      	}else{
			$messageStack->add_session(sprintf(MSG_ERROR_BRANCH_LIMIT,YES_BRANCHES_COUNT),'error');
      	}
        
	xtc_redirect(xtc_href_link('branch.php', 'bID=' . $bID));
        break;
    case 'nulldelete':
        $bID = xtc_db_prepare_input($_GET['bID']);
		$null_bestand_query = xtc_db_query("SELECT products_id FROM branches_products WHERE branches_id='".$bID."' and products_quantity<1");
		while($null_bestand_res = xtc_db_fetch_array($null_bestand_query)){
			xtc_db_query("DELETE FROM branches_products WHERE branches_id='".$bID."' and products_quantity<1 and products_id='".$null_bestand_res['products_id']."'");
			// history
			$comments = sprintf(HISTORY_BRANCH_PRODUCT_NULLDELETE,xtc_get_products_name($null_bestand_res['products_id']),$null_bestand_res['products_id']);
	        $sql_insert_array = array('branches_id'=>$bID,
				'date_created'=>"now()",
				'comments'=>$comments,
				'editor_id'=>$_SESSION['customer_id']
			);
			xtc_db_perform('branches_history',$sql_insert_array);
		}
		$messageStack->add_session(MSG_SUCCESS_NULLDELETE,'success');
		xtc_redirect(xtc_href_link('branch.php', 'bID=' . $bID));
		break;
	case 'null':
        $bID = xtc_db_prepare_input($_GET['bID']);
		$products_query = xtc_db_query("SELECT products_id FROM branches_products WHERE branches_id='".$bID."' AND products_quantity>1");
		while($null_bestand_res = xtc_db_fetch_array($null_bestand_query)){
			xtc_db_query("UPDATE branches_products SET quantity=0 WHERE branches_id='".$bID."' and products_quantity>1 and products_id='".$null_bestand_res['products_id']."'");
			// history
			$comments = sprintf(HISTORY_BRANCH_PRODUCT_NULLDELETE,xtc_get_products_name($null_bestand_res['products_id']),$null_bestand_res['products_id']);
	        $sql_insert_array = array('branches_id'=>$bID,
				'date_created'=>"now()",
				'comments'=>$comments,
				'editor_id'=>$_SESSION['customer_id']
			);
			//xtc_db_perform('branches_history',$sql_insert_array);
		}
		$messageStack->add_session(MSG_SUCCESS_PRODUCTS_NULL,'success');
		xtc_redirect(xtc_href_link('branch.php', 'bID=' . $bID));
		break;
    case 'delete':
        $bID = xtc_db_prepare_input($_GET['bID']);
        if($admin_access['f_branch_delete'] == 1){
			$products_query = xtc_db_query("SELECT SUM(products_quantity) as anzahl FROM branches_products WHERE branches_id='".$bID."'");
			$products = xtc_db_fetch_array($products_query);
		if( $products['anzahl'] > 0){
			$messageStack->add_session(MSG_ERROR_BRANCH_DELETE,'error');
		}else{
			xtc_db_query("DELETE FROM branches WHERE branches_id='".$bID."'");
			xtc_db_query("DELETE FROM branches_products WHERE branches_id='".$bID."'");

			// BRANCHES_TRANSFERS LOESCHEN
			
			//xtc_db_query("DELETE FROM branches_transfer_products WHERE branches_id='".$bID."'");
			//xtc_db_query("DELETE FROM branches_transfer_history WHERE branches_id='".$bID."'");
			xtc_db_query("DELETE FROM branches_to_customers WHERE branches_id='".$bID."'");
			$target_branches_query = xtc_db_query("SELECT branches_transfer_id FROM branches_transfer WHERE target_branches_id='".$bID."'");
			while($target_branches = xtc_db_fetch_array($target_branches_query)){
				xtc_db_query("DELETE FROM branches_transfer WHERE branches_transfer_id='".$target_branches['branches_transfer_id']."'");
				xtc_db_query("DELETE FROM branches_transfer_products WHERE branches_transfer_id='".$target_branches['branches_transfer_id']."'");
				xtc_db_query("DELETE FROM branches_transfer_history WHERE branches_transfer_id='".$target_branches['branches_transfer_id']."'");
			}
			xtc_db_query("DELETE FROM branches_transfer WHERE branches_id='".$bID."'");
			
			// history
			$comments = sprintf(HISTORY_BRANCH_DELETE,$bID);
			$sql_insert_array = array('branches_id'=>$bID,
				'date_created'=>"now()",
				'comments'=>$comments,
				'editor_id'=>$_SESSION['customer_id']
			);
			xtc_db_perform('branches_history',$sql_insert_array);
			$messageStack->add_session(MSG_SUCCESS_BRANCH_DELETE,'success');
		}	
	}
	xtc_redirect(xtc_href_link('branch.php','bID='.$bID));
	break;
    }
}
$branches_query = xtc_db_query("select * from branches ORDER by title");
yes_draw_pre_header();
yes_draw_header(TITLE);
$number_of_branches = xtc_db_num_rows($branches_query);
$buttons = array();
$back_button = array('text'=>BUTTON_NEW_BRANCH,
	'link'=>xtc_href_link('branch.php','action=new'),
	'lbOn'=>false,
	'auth'=>true
);
if($number_of_branches >= YES_BRANCHES_COUNT){
    $back_button['error'] = TEXT_MORE_BRANCHES_INTRO;
}
$buttons[] = $back_button;
$buttons[] = array('text'=>BUTTON_BRANCH_ALLOCATION,
    'link'=>xtc_href_link('branches_to_customers.php'),
    'auth'=>($admin_access['branches_to_customers'] == 1) ? true : false,
    'lbOn'=>false
);
$smarty->assign(array(
    'HEADING_TITLE'=>HEADING_TITLE,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons
));
$smarty->display('branch.html');
?>
<table border="0" width="100%" cellspacing="0" cellpadding="0">
      <tr>
        <td><br clear="all" /><table border="0" width="100%" cellspacing="2" cellpadding="0">
          <tr>
            <td valign="top" class="ui-widget-content">
				<table border="0" width="100%" class="yesListTable">
					<thead>
						<tr class="ui-widget-header">
							<th><?php echo TABLE_HEADING_BRANCH; ?></th>
							<th><?php echo TABLE_HEADING_STOREKEEPER; ?></th>
							<th><?php echo TABLE_HEADING_MAIN_STORAGE; ?></th>
							<th>&nbsp;</th>
						</tr>
					</thead>
					<tfoot>
					</tfoot>
					<tbody>
<?php
  while ($branch = xtc_db_fetch_array($branches_query)) {
    if (((!isset($_GET['bID'])) || (@$_GET['bID'] == $branch['branches_id'])) && (!isset($bInfo)) && (!isset($_GET['action']	) or substr($_GET['action'], 0, 3) != 'new')) {
      $branch_extra_query = xtc_db_query("select * from branches where branches_id = '" . $branch['branches_id'] . "'");
      $branch_extra = xtc_db_fetch_array($branch_extra_query);
      $bInfo_array = xtc_array_merge($branch, $branch_extra);
      $bInfo = new objectInfo($bInfo_array);
    }

    if ( (isset($bInfo) and is_object($bInfo)) && ($branch['branches_id'] == $bInfo->branches_id) ) {
      echo '                  <tr onmouseover="this.style.cursor=\'hand\'" onclick="document.location.href=\'' . xtc_href_link('branch.php', 'bID=' . $bInfo->branches_id . '&action=edit') . '\'" class="ui-state-highlight">' . "\n";
    } else {
      echo '                  <tr onmouseover="this.style.cursor=\'hand\'" onclick="document.location.href=\'' . xtc_href_link('branch.php', 'bID=' . $branch['branches_id']) . '\'">' . "\n";
    }
?>
                <td>
					<?php echo (($branch['stammlager'] == '1') ? xtc_image('images/icons/success.gif',TEXT_DEFAULT) : '' ); ?>&nbsp;
					<font size=1><?php echo $branch['title']; ?>&nbsp;</font>
				</td>
                <td><?php if($branch['storekeeper_id'] > 0){ echo xtc_get_editor_name($branch['storekeeper_id']);}else{ echo TEXT_NOT_SET; } ?>&nbsp;</td>
                <td><?php if($branch['stammlager'] > 0){ echo YES; }else{ echo NO; } ?>&nbsp;</td>
                <td align="right"><?php if ( (isset($bInfo) and is_object($bInfo)) && ($branch['branches_id'] == $bInfo->branches_id) ) { echo xtc_image(DIR_WS_IMAGES . 'icon_arrow_right.gif', ''); } else {		    echo '<a href="' . xtc_href_link('branch.php', 'bID=' . $branch['branches_id']) . '">' . xtc_image(DIR_WS_IMAGES . 'icon_info.gif', IMAGE_ICON_INFO) . '</a>'; } ?>&nbsp;</td>
              </tr>
<?php
  }
?>
				</tbody>
            </table></td>
            <script type="text/javascript">
            <!--
            function really_delete(bid) {
	            ok = confirm('<?php echo JS_ALERT_REALLY_DELETE_BRANCH; ?>');
	            if(ok){
		            if(bid>0){
	            		window.location.href='<?php echo xtc_href_link('branch.php','action=delete'); ?>&bID='+bid;
            		}else{
						var alert_str = '<?php echo JS_ALERT_CANNOT_DELETE_BRANCH; ?>';
	            		alert(String.sprintf(alert_str,bid));
	            	}
            	}
	        }
            //-->
            </script>

<?php
$heading = array();
$contents = array();
$storekeeper_array = main::get_notice_recipients('branch');
$storekeeper_array_options = [['id'=>'','text'=>TEXT_SELECT]];
foreach($storekeeper_array as $stkID){
	$customer_name = \YES4Trade\Model\customers::get_by_customers_id($stkID,['customers_firstname','customers_lastname']);
	$cname = $customer_name->customers_firstname.' '.$customer_name->customers_lastname;
	$storekeeper_array_options[] = ['id'=>$stkID,'text'=>$cname];
}
$action = (isset($_GET['action'])) ? $_GET['action'] : '';
switch ($action) {
    case 'inventur_comments_confirm':
      $heading[] = array('text' => '<b>'.TEXT_SET_INVENTUR_COMMENTS.'</b>');
      $contents = array('form' => xtc_draw_form('inventur_comments', 'branch.php', xtc_get_all_get_params(array('action')).'action=inventur_comments'));
      $contents[] = array('text' => TEXT_SET_INVENTUR_COMMENTS_INTRO);
      $contents[] = array('text' => '<br /><b>'.TEXT_INVENTUR_COMMENTS.'</b><br />' . 
		xtc_draw_input_field(
			'comments',
			sprintf(TEXT_INVENTUR_DATE,date('Y-m-d'),$bInfo->title),
			'size="30" maxlength="64"'
		)
	  );
      $contents[] = array('align' => 'center', 'text' =>
        '<br />' . yes_draw_href_button(IMAGE_UPDATE,'','width:130px;','submit') .
		' '.yes_draw_href_button(IMAGE_CANCEL,xtc_href_link('branch.php', xtc_get_all_get_params(array('action'))),'width:130px;')
	  );
      break;
    case 'new_transfer':
      $heading[] = array('text' => '<b>'.TEXT_ADD_TRANSFER.'</b>');

      $branches_array = array(0=>array('id'=>0,'text'=>TEXT_MAIN_STORAGE));
      $branches_query = xtc_db_query("SELECT branches_id,title FROM branches WHERE stammlager=0 ORDER BY title");
      while($branches = xtc_db_fetch_array($branches_query)){
		$branches_array[] = array('id'=>$branches['branches_id'],'text'=>$branches['title']);
      }

      $contents = array('form' => xtc_draw_form('branches_transfer', 'branch.php', 'bID=' . $bInfo->branches_id . '&action=save_transfer'));
      $contents[] = array('text' => TEXT_TRANSFER_INTRO);
      $contents[] = array('text' => '<br /><b>'.TEXT_FROM_BRANCH.'</b><br />' . xtc_draw_pull_down_menu('branches_id',$branches_array,$_GET['bID']));
      $contents[] = array('text' => '<br /><b>'.TEXT_TO_BRANCH.'</b><br />' . xtc_draw_pull_down_menu('target_branches_id',$branches_array,0));
      $contents[] = array('align' => 'center', 'text' =>
        '<br />' . yes_draw_href_button(IMAGE_UPDATE,'','width:130px;','submit') .
		' '.yes_draw_href_button(IMAGE_CANCEL,xtc_href_link('branch.php', 'bID=' . $bInfo->branches_id),'width:130px;')
	  );
      break;
    case 'edit':
	$heading[] = array('text' => '<b>'.sprintf(TEXT_BRANCH_EDIT,$bInfo->title).'</b>');
	$contents = array('form' => xtc_draw_form('branch', 'branch.php', 'bID=' . $bInfo->branches_id . '&action=save'));
	$contents[] = array('text' => TEXT_BRANCH_EDIT_INTRO);
	$contents[] = array('text' => '<br /><b>'.TEXT_BRANCH_NAME.'</b><br />' . xtc_draw_input_field('title',$bInfo->title));
	$contents[] = array('text' => '<br /><b>'.TEXT_BRANCH_STOREKEEPER.'</b><br />' . xtc_draw_pull_down_menu('storekeeper_id',$storekeeper_array_options,$bInfo->storekeeper_id));
	$contents[] = array('text' => '<br /><b>'.TEXT_MAIN_STORAGE.'</b><br />' . xtc_draw_checkbox_field('stammlager','1',$bInfo->stammlager));
	$contents[] = array('text' => '<b>'.CATEGORY_COMPANY.':</b><br />'.xtc_draw_input_field('branch_company',$bInfo->branch_company,'size="32" maxlength="64"'));
	$contents[] = array('text' => '<b>'.CATEGORY_ADDRESS.':</b><br />'.xtc_draw_input_field('branch_name',$bInfo->branch_name,'size="32" maxlength="64"'));
	$contents[] = array('text' => '<b>'.ENTRY_SUBURB.'</b><br />'.xtc_draw_input_field('branch_suburb',$bInfo->branch_suburb,'size="32" maxlength="64"'));
	$contents[] = array('text' => '<b>'.ENTRY_STREET_ADDRESS.'</b><br />'.xtc_draw_input_field('branch_street_address',$bInfo->branch_street_address,'size="32" maxlength="64"'));
	$contents[] = array('text' => '<b>'.ENTRY_CITY.'</b><br />'.xtc_draw_input_field('branch_city',$bInfo->branch_city,'size="32" maxlength="32"'));
	$contents[] = array('text' => '<b>'.ENTRY_POST_CODE.'</b><br />'.xtc_draw_input_field('branch_postcode',$bInfo->branch_postcode,'size="10" maxlength="10"'));
	if(empty($bInfo->branch_country)) $bInfo->branch_country = xtc_get_country_name(STORE_COUNTRY);
	$contents[] = array('text' => '<b>'.ENTRY_COUNTRY.'</b><br />'.
	    xtc_draw_pull_down_menu('branch_country',  xtc_get_countries(),$bInfo->branch_country));
	$contents[] = array('text' => '<b>'.ENTRY_TELEPHONE_NUMBER.'</b><br />'.xtc_draw_input_field('branch_telephone',$bInfo->branch_telephone,'size="32" maxlength="32"'));
	if(MODULE_OTHER_FIBUNUMBERS_STATUS == 'True'){
	    $contents[]	= array('text' => '<br />'.TEXT_FIBUNUMBER_INTRO.'<br /><b>'.TEXT_FIBUNUMBER_PREFIX.'</b><br />'.
		    xtc_draw_input_field('fibunumber_prefix',$bInfo->fibunumber_prefix,
			    'size="16" maxlength="16"'
		    )
	    );
	    $contents[]	= array('text' => '<br /><b>'.TEXT_FIBUNUMBER_LENGTH.'</b><br />'.
		    xtc_draw_input_field('fibunumber_length',$bInfo->fibunumber_length,
			    'size="3" maxlength="2"'
		    )
	    );
	    $contents[]	= array('text' => '<br /><b>'.TEXT_FIBUNUMBER_START.'</b><br />'.
		    xtc_draw_input_field('fibunumber_start',$bInfo->fibunumber_start,
			    'size="5" maxlength="8"'
		    )
	    );
	}
	$admin_templates_array = $basics->get_template_values(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/');
	$contents[] = array('text' => TEXT_BRANCH_TEMPLATE_SELECT_INTRO.'<br />'.xtc_draw_pull_down_menu('template_filename',$admin_templates_array,$bInfo->template_filename));
	$contents[] = array('align' => 'center', 'text' =>
	  '<br />' . yes_draw_href_button(IMAGE_UPDATE,'','width:130px;','submit') .
		  ' '.yes_draw_href_button(IMAGE_CANCEL,xtc_href_link('branch.php', 'bID=' . $bInfo->branches_id),'width:130px;')
	);
	break;
    case 'new':
	$heading[] = array('text' => '<b>'.TEXT_BRANCH_ADD.'</b>');

	$contents = array('form' => xtc_draw_form('branch', 'branch.php', 'action=insert'));
	$contents[] = array('text' => TEXT_BRANCH_EDIT_INTRO);
	$contents[] = array('text' => '<br /><b>'.TEXT_BRANCH_NAME.'</b><br>' . xtc_draw_input_field('title',''));
	
	$contents[] = array('text' => '<br /><b>'.TEXT_BRANCH_STOREKEEPER.'</b><br />' . xtc_draw_pull_down_menu('storekeeper_id',$storekeeper_array_options,''));
	$contents[] = array('text' => '<br /><b>'.TEXT_MAIN_STORAGE.'</b><br />' . xtc_draw_checkbox_field('stammlager','1',false));
	$contents[] = array('text' => '<b>'.CATEGORY_COMPANY.':</b><br />'.xtc_draw_input_field('branch_company','','size="32" maxlength="64"'));
	$contents[] = array('text' => '<b>'.CATEGORY_ADDRESS.':</b><br />'.xtc_draw_input_field('branch_name','','size="32" maxlength="64"'));
	$contents[] = array('text' => '<b>'.ENTRY_SUBURB.'</b><br />'.xtc_draw_input_field('branch_suburb','','size="32" maxlength="64"'));
	$contents[] = array('text' => '<b>'.ENTRY_STREET_ADDRESS.'</b><br />'.xtc_draw_input_field('branch_street_address','','size="32" maxlength="64"'));
	$contents[] = array('text' => '<b>'.ENTRY_CITY.'</b><br />'.xtc_draw_input_field('branch_city','','size="32" maxlength="32"'));
	$contents[] = array('text' => '<b>'.ENTRY_POST_CODE.'</b><br />'.xtc_draw_input_field('branch_postcode','','size="10" maxlength="10"'));
	$contents[] = array('text' => '<b>'.ENTRY_COUNTRY.'</b><br />'.
	    xtc_draw_pull_down_menu('branch_country',  xtc_get_countries(),STORE_COUNTRY));
	$contents[] = array('text' => '<b>'.ENTRY_TELEPHONE_NUMBER.'</b><br />'.xtc_draw_input_field('branch_telephone','','size="32" maxlength="32"'));
	if(MODULE_OTHER_FIBUNUMBERS_STATUS == 'True'){
	      $contents[]	= array('text' => '<br />'.TEXT_FIBUNUMBER_INTRO.'<br /><b>'.TEXT_FIBUNUMBER_PREFIX.'</b><br />'.
		      xtc_draw_input_field('fibunumber_prefix','',
			      'size="16" maxlength="16"'
		      )
	      );
	      $contents[]	= array('text' => '<br /><b>'.TEXT_FIBUNUMBER_LENGTH.'</b><br />'.
		      xtc_draw_input_field('fibunumber_length',5,
			      'size="3" maxlength="2"'
		      )
	      );
	      $contents[]	= array('text' => '<br /><b>'.TEXT_FIBUNUMBER_START.'</b><br />'.
		      xtc_draw_input_field('fibunumber_start',0,
			      'size="5" maxlength="8"'
		      )
	      );
	}

	$admin_templates_array = $basics->get_template_values(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/');
	$contents[] = array('text' => TEXT_BRANCH_TEMPLATE_SELECT_INTRO.'<br />'.xtc_draw_pull_down_menu('template_filename',$admin_templates_array,'print_order.html'));
	$contents[] = array('align' => 'center', 'text' =>
	    '<br />' . yes_draw_href_button(IMAGE_UPDATE,'','width:130px;','submit') .
	      ' '.yes_draw_href_button(IMAGE_CANCEL,xtc_href_link('branch.php', 'bID=' . $bInfo->branches_id),'width:130px;')
	);
      break;
    case 'nulldelete_confirm':
      $heading[] = array('text' => '<b>'.TEXT_NULLDELETE.'</b>');
      $null_bestand_query = xtc_db_query("SELECT count(products_id) as anz FROM branches_products WHERE branches_id='".((int)$_GET['bID'])."' and products_quantity<1");
      $null_bestand_res = xtc_db_fetch_array($null_bestand_query);
      $null_bestand = (int)$null_bestand_res['anz'];
      $contents = array('form' => xtc_draw_form('branch', 'branch.php', 'action=nulldelete&bID='.$_GET['bID']));
      $contents[] = array('text' => TEXT_NULLDELETE_INTRO);
      $contents[] = array('text' => '<br /><b>'.TEXT_BRANCH_NAME.':</b>: ' . $bInfo->title);
      $contents[] = array('text' => '<br /><b>'.TEXT_PRODUCTS_WITH_NO_QTY.':</b> ' . $null_bestand);
      $contents[] = array('align' => 'center', 'text' =>
        '<br />' . yes_draw_href_button(IMAGE_DELETE,'','width:130px;','submit') .
		' '.yes_draw_href_button(IMAGE_CANCEL,xtc_href_link('branch.php', 'bID=' . $bInfo->branches_id),'width:130px;')
	  );
      break;
    case 'null_confirm':
      $heading[] = array('text' => '<b>'.sprintf(TEXT_PRODUCTS_NULL,$bInfo->title).'</b>');
      $null_bestand_query = xtc_db_query("SELECT count(products_id) as anz FROM branches_products WHERE branches_id='".((int)$_GET['bID'])."' AND products_quantity<1");
      $null_bestand_res = xtc_db_fetch_array($null_bestand_query);
      $null_bestand = (int)$null_bestand_res['anz'];
      $contents = array('form' => xtc_draw_form('branch', 'branch.php', 'action=null&bID='.$_GET['bID']));
      $contents[] = array('text' => TEXT_PRODUCTS_NULL_INTRO);
      $contents[] = array('text' => '<br /><b>'.TEXT_BRANCH_NAME.':</b>: ' . $bInfo->title);
      $contents[] = array('text' => '<br /><b>'.TEXT_PRODUCTS_IN_BRANCH.':</b> ' . $null_bestand);
      $contents[] = array('align' => 'center', 'text' =>
        '<br />' . yes_draw_href_button(BUTTON_PRODUCTS_NULL,'','width:130px;','submit') .
		' '.yes_draw_href_button(IMAGE_CANCEL,xtc_href_link('branch.php', 'bID=' . $bInfo->branches_id),'width:130px;')
	  );
      break;
    case 'history_select':
      $heading[] = array('text' => '<b>'.TEXT_BRANCH_HISTORY.'</b>');

      $contents = array('form' => xtc_draw_form('branch', 'branch.php', 'action=history&bID='.$_GET['bID'],'POST','id="branch"' ));
      $contents[] = array('text' => TEXT_BRANCH_HISTORY_INTRO);
      $contents[] = array('text' => TEXT_STARTDATE.'<input type="date" name="products_date_available_from" id="products_date_available_from" value="'.date('Y-m-d',time()-(60*60*24) ).'" />');
      $contents[] = array('text' => TEXT_ENDDATE.'<input type="date" name="products_date_available_to" id="products_date_available_to" value="'.date('Y-m-d').'" />');

      $contents[] = array('align' => 'center', 'text' =>
        '<br />' . yes_draw_href_button(IMAGE_UPDATE,'','width:130px;','submit') .
		' '.yes_draw_href_button(IMAGE_CANCEL,xtc_href_link('branch.php', 'bID=' . $bInfo->branches_id),'width:130px;')
	  );
	  break;
    case 'history':
      $heading[] = array('text' => '<b>'.TEXT_BRANCH_HISTORY.'</b>');
      $contents[] = array('text' => TEXT_BRANCH_HISTORY_SELECT_INTRO);
      $contents[] = array('text' => '<br /><b>'.TEXT_STARTDATE.'</b> '.$_POST['products_date_available_from']);
      $contents[] = array('text' => '<br /><b>'.TEXT_ENDDATE.'</b> '.$_POST['products_date_available_to']);
      
      $date_from = xtc_db_input($_POST['products_date_available_from']).' 00:00:00';
      $date_to = xtc_db_input($_POST['products_date_available_to']).' 23:59:59';
      $bID = xtc_db_input($_GET['bID']);
      
      $check_query = xtc_db_query("SELECT count(1) as anz FROM branches_history WHERE branches_id='".$bID."' and date_created>'".$date_from."' and date_created<'".$date_to."'");
      $check = xtc_db_fetch_array($check_query);
      if($check['anz']>0){
	      $contents[] = array('text' => '<br /><a href="#" onClick="window.open(\'branch.php?bID='.$bID.'&from='.$_POST['products_date_available_from'].'&to='.$_POST['products_date_available_to'].'&action=report\',\'popup\',\'width='.EXT_POPUP_WIDTH.',height='.EXT_POPUP_HEIGHT.',scrollbars=yes,resizable=yes\');"><u>'.BUTTON_VIEW_BRANCHHISTORY.'</u></a>');
      }else{
	      $contents[] = array('text' => '<br />'.TEXT_NO_BRANCH_HISTORY);
      }
      $contents[] = array('align' => 'center', 'text' =>
			yes_draw_href_button(IMAGE_CANCEL,xtc_href_link('branch.php', 'bID=' . $bInfo->branches_id),'width:130px;')
	  );

      break;
    default:
      if (isset($bInfo) and is_object($bInfo)) {
        $heading[] = array('text' => '<b>'.sprintf(TEXT_BRANCH_EDIT,$bInfo->title).'</b>');
		$contents[] = ['align'=>'center','text'=>yes_draw_href_button(
			IMAGE_EDIT,
			xtc_href_link('branch.php','bID=' . $bInfo->branches_id . '&action=edit'),
			'width:180px;'
		)];
        $contents[] = array('align' => 'center', 'text' => 
			yes_draw_href_button(BUTTON_BRANCH_PRODUCTS,
				xtc_href_link('branch_products.php','bID=' . $bInfo->branches_id),
				"width:180px;"
			)
		);
		$contents[] = array('align' => 'center', 'text' => 
			yes_draw_href_button(BUTTON_VIEW_TRANSFERS,
				xtc_href_link('branches_transfer.php','bID=' . $bInfo->branches_id ),
				"width:180px;"
			)
		);
		if($bInfo->stammlager == 0){
			$contents[] = array('align' => 'center', 'text' => 
				yes_draw_href_button(BUTTON_ADD_TRANSFER,
					xtc_href_link('branch.php','bID=' . $bInfo->branches_id . '&action=new_transfer'),
					"width:180px;"
				)
			);
		}
        $contents[] = array('align' => 'center', 'text' => 
			yes_draw_href_button(BUTTON_VIEW_BRANCHHISTORY,
				xtc_href_link('branch.php','bID=' . $bInfo->branches_id.'&action=history_select'),
				"width:180px;"
			)
		);
        $contents[] = array('align' => 'center', 'text' => 
			yes_draw_href_button(BUTTON_NULLDELETE,
				xtc_href_link('branch.php','bID=' . $bInfo->branches_id.'&action=nulldelete_confirm'),
				"width:180px;"
			)
		);
		$contents[] = array('align' => 'center','text'=>yes_draw_href_button(
			BUTTON_EXPORT_BRANCH_PRODUCTS,
			xtc_href_link('branch.php',xtc_get_all_get_params(array('action','bID') ).'action=csv_export&bID='.$bInfo->branches_id ),
			'width:180px'
		) );
		$contents[] = array('align' => 'center','text'=>yes_draw_href_button(
			BUTTON_SET_INVENTUR_COMMENTS,
			xtc_href_link('branch.php',xtc_get_all_get_params(array('action','bID') ).'action=inventur_comments_confirm&bID='.$bInfo->branches_id ),
			'width:180px'
		) );
		if($admin_access['f_branch_delete'] == 1){
	        $contents[] = array('align' => 'center', 'text' => 
				yes_draw_href_button(IMAGE_DELETE,
					'javascript:really_delete(\''.$bInfo->branches_id.'\')',
					"width:180px;",'button','ui-button ui-corner-all ui-state-error'
				)
				.'<br />'.TEXT_BRANCH_DELETE_INTRO
			);
		}
        
		$contents[] = array('text' => '<br /><b>'.$bInfo->title."</b>");
		$contents[] = array('text' => '<br /><b>'.TEXT_BRANCH_STOREKEEPER.':</b> ' . xtc_get_editor_name($bInfo->storekeeper_id));
		$contents[] = array('text' => '<br /><b>'.TEXT_MAIN_STORAGE.':</b> '.(($bInfo->stammlager==1)?'Ja':'Nein'));
		$contents[] = array('text' => '<br /><b>'.TEXT_BRANCH_TEMPLATE.':</b> '.$bInfo->template_filename);

      }
      break;
  }

  if ( (xtc_not_null($heading)) && (xtc_not_null($contents)) ) {
    echo '            <td width="25%" valign="top" class="ui-widget-content">' . "\n";

    $box = new box;
    echo $box->infoBox($heading, $contents);

    echo '            </td>' . "\n";
  }
?>
		</tr>
	    </table>
	</td>
    </tr>
</table>
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
