<?php
/**
 * InboundShipmentPlan
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Fulfillment Inbound
 *
 * The Selling Partner API for Fulfillment Inbound lets you create applications that create and update inbound shipments of inventory to Amazon's fulfillment network.
 *
 * The version of the OpenAPI document: v0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\FbaInboundV0;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;

/**
 * InboundShipmentPlan Class Doc Comment
 *
 * @category Class
 * @description Inbound shipment information used to create an inbound shipment. Returned by the createInboundShipmentPlan operation.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class InboundShipmentPlan extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'InboundShipmentPlan';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'shipment_id' => 'string',
        'destination_fulfillment_center_id' => 'string',
        'ship_to_address' => '\SellingPartnerApi\Model\FbaInboundV0\Address',
        'label_prep_type' => '\SellingPartnerApi\Model\FbaInboundV0\LabelPrepType',
        'items' => '\SellingPartnerApi\Model\FbaInboundV0\InboundShipmentPlanItem[]',
        'estimated_box_contents_fee' => '\SellingPartnerApi\Model\FbaInboundV0\BoxContentsFeeDetails'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'shipment_id' => null,
        'destination_fulfillment_center_id' => null,
        'ship_to_address' => null,
        'label_prep_type' => null,
        'items' => null,
        'estimated_box_contents_fee' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'shipment_id' => 'ShipmentId',
        'destination_fulfillment_center_id' => 'DestinationFulfillmentCenterId',
        'ship_to_address' => 'ShipToAddress',
        'label_prep_type' => 'LabelPrepType',
        'items' => 'Items',
        'estimated_box_contents_fee' => 'EstimatedBoxContentsFee'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'shipment_id' => 'setShipmentId',
        'destination_fulfillment_center_id' => 'setDestinationFulfillmentCenterId',
        'ship_to_address' => 'setShipToAddress',
        'label_prep_type' => 'setLabelPrepType',
        'items' => 'setItems',
        'estimated_box_contents_fee' => 'setEstimatedBoxContentsFee'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'shipment_id' => 'getShipmentId',
        'destination_fulfillment_center_id' => 'getDestinationFulfillmentCenterId',
        'ship_to_address' => 'getShipToAddress',
        'label_prep_type' => 'getLabelPrepType',
        'items' => 'getItems',
        'estimated_box_contents_fee' => 'getEstimatedBoxContentsFee'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['shipment_id'] = $data['shipment_id'] ?? null;
        $this->container['destination_fulfillment_center_id'] = $data['destination_fulfillment_center_id'] ?? null;
        $this->container['ship_to_address'] = $data['ship_to_address'] ?? null;
        $this->container['label_prep_type'] = $data['label_prep_type'] ?? null;
        $this->container['items'] = $data['items'] ?? null;
        $this->container['estimated_box_contents_fee'] = $data['estimated_box_contents_fee'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['shipment_id'] === null) {
            $invalidProperties[] = "'shipment_id' can't be null";
        }
        if ($this->container['destination_fulfillment_center_id'] === null) {
            $invalidProperties[] = "'destination_fulfillment_center_id' can't be null";
        }
        if ($this->container['ship_to_address'] === null) {
            $invalidProperties[] = "'ship_to_address' can't be null";
        }
        if ($this->container['label_prep_type'] === null) {
            $invalidProperties[] = "'label_prep_type' can't be null";
        }
        if ($this->container['items'] === null) {
            $invalidProperties[] = "'items' can't be null";
        }
        return $invalidProperties;
    }


    /**
     * Gets shipment_id
     *
     * @return string
     */
    public function getShipmentId()
    {
        return $this->container['shipment_id'];
    }

    /**
     * Sets shipment_id
     *
     * @param string $shipment_id A shipment identifier originally returned by the createInboundShipmentPlan operation.
     *
     * @return self
     */
    public function setShipmentId($shipment_id)
    {
        $this->container['shipment_id'] = $shipment_id;

        return $this;
    }
    /**
     * Gets destination_fulfillment_center_id
     *
     * @return string
     */
    public function getDestinationFulfillmentCenterId()
    {
        return $this->container['destination_fulfillment_center_id'];
    }

    /**
     * Sets destination_fulfillment_center_id
     *
     * @param string $destination_fulfillment_center_id An Amazon fulfillment center identifier created by Amazon.
     *
     * @return self
     */
    public function setDestinationFulfillmentCenterId($destination_fulfillment_center_id)
    {
        $this->container['destination_fulfillment_center_id'] = $destination_fulfillment_center_id;

        return $this;
    }
    /**
     * Gets ship_to_address
     *
     * @return \SellingPartnerApi\Model\FbaInboundV0\Address
     */
    public function getShipToAddress()
    {
        return $this->container['ship_to_address'];
    }

    /**
     * Sets ship_to_address
     *
     * @param \SellingPartnerApi\Model\FbaInboundV0\Address $ship_to_address ship_to_address
     *
     * @return self
     */
    public function setShipToAddress($ship_to_address)
    {
        $this->container['ship_to_address'] = $ship_to_address;

        return $this;
    }
    /**
     * Gets label_prep_type
     *
     * @return \SellingPartnerApi\Model\FbaInboundV0\LabelPrepType
     */
    public function getLabelPrepType()
    {
        return $this->container['label_prep_type'];
    }

    /**
     * Sets label_prep_type
     *
     * @param \SellingPartnerApi\Model\FbaInboundV0\LabelPrepType $label_prep_type label_prep_type
     *
     * @return self
     */
    public function setLabelPrepType($label_prep_type)
    {
        $this->container['label_prep_type'] = $label_prep_type;

        return $this;
    }
    /**
     * Gets items
     *
     * @return \SellingPartnerApi\Model\FbaInboundV0\InboundShipmentPlanItem[]
     */
    public function getItems()
    {
        return $this->container['items'];
    }

    /**
     * Sets items
     *
     * @param \SellingPartnerApi\Model\FbaInboundV0\InboundShipmentPlanItem[] $items A list of inbound shipment plan item information.
     *
     * @return self
     */
    public function setItems($items)
    {
        $this->container['items'] = $items;

        return $this;
    }
    /**
     * Gets estimated_box_contents_fee
     *
     * @return \SellingPartnerApi\Model\FbaInboundV0\BoxContentsFeeDetails|null
     */
    public function getEstimatedBoxContentsFee()
    {
        return $this->container['estimated_box_contents_fee'];
    }

    /**
     * Sets estimated_box_contents_fee
     *
     * @param \SellingPartnerApi\Model\FbaInboundV0\BoxContentsFeeDetails|null $estimated_box_contents_fee estimated_box_contents_fee
     *
     * @return self
     */
    public function setEstimatedBoxContentsFee($estimated_box_contents_fee)
    {
        $this->container['estimated_box_contents_fee'] = $estimated_box_contents_fee;

        return $this;
    }
}


